/*
 * Decompiled with CFR 0.152.
 */
package sax;

import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.ParserFactory;

public class SAXCount
extends HandlerBase {
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private static boolean warmup = false;
    private long elements;
    private long attributes;
    private long characters;
    private long ignorableWhitespace;

    public void characters(char[] cArray, int n, int n2) {
        if (warmup) {
            return;
        }
        this.characters += (long)n2;
    }

    public void error(SAXParseException sAXParseException) {
        if (warmup) {
            return;
        }
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (warmup) {
            return;
        }
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        if (warmup) {
            return;
        }
        this.ignorableWhitespace += (long)n2;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length == 0) {
            SAXCount.printUsage();
            System.exit(1);
        }
        var1_1 = "org.apache.xerces.parsers.SAXParser";
        var2_2 = false;
        var3_3 = 0;
        while (var3_3 < var0.length) {
            var4_4 = var0[var3_3];
            if (!var4_4.startsWith("-")) ** GOTO lbl25
            if (var4_4.equals("-p")) {
                if (var3_3 == var0.length - 1) {
                    System.err.println("error: missing parser name");
                    System.exit(1);
                }
                var1_1 = var0[++var3_3];
            } else if (var4_4.equals("-w")) {
                SAXCount.warmup = true;
            } else if (var4_4.equals("-v")) {
                var2_2 = true;
            } else {
                if (var4_4.equals("-h")) {
                    SAXCount.printUsage();
                    System.exit(1);
                }
lbl25:
                // 4 sources

                SAXCount.print(var1_1, var4_4, var2_2);
            }
            ++var3_3;
        }
    }

    public static void print(String string, String string2, boolean bl) {
        try {
            SAXCount sAXCount = new SAXCount();
            Parser parser = ParserFactory.makeParser(string);
            parser.setDocumentHandler(sAXCount);
            parser.setErrorHandler(sAXCount);
            try {
                if (bl && parser instanceof XMLReader) {
                    ((XMLReader)((Object)parser)).setFeature("http://xml.org/sax/features/validation", true);
                }
            }
            catch (Exception exception) {}
            if (warmup) {
                if (parser instanceof XMLReader) {
                    ((XMLReader)((Object)parser)).setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
                }
                parser.parse(string2);
                warmup = false;
            }
            long l = System.currentTimeMillis();
            parser.parse(string2);
            long l2 = System.currentTimeMillis();
            sAXCount.printResults(string2, l2 - l);
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace(System.err);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                sAXException.getException().printStackTrace(System.err);
            } else {
                sAXException.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void printResults(String string, long l) {
        System.out.print(string);
        System.out.print(": ");
        System.out.print(l);
        System.out.print(" ms (");
        System.out.print(this.elements);
        System.out.print(" elems, ");
        System.out.print(this.attributes);
        System.out.print(" attrs, ");
        System.out.print(this.ignorableWhitespace);
        System.out.print(" spaces, ");
        System.out.print(this.characters);
        System.out.print(" chars)");
        System.out.println();
    }

    private static void printUsage() {
        System.err.println("usage: java sax.SAXCount (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name  Specify SAX parser by name.");
        System.err.println("           Default parser: org.apache.xerces.parsers.SAXParser");
        System.err.println("  -v       Turn on validation.");
        System.err.println("  -w       Warmup the parser before timing.");
        System.err.println("  -h       This help screen.");
    }

    public void startDocument() {
        if (warmup) {
            return;
        }
        this.elements = 0L;
        this.attributes = 0L;
        this.characters = 0L;
        this.ignorableWhitespace = 0L;
    }

    public void startElement(String string, AttributeList attributeList) {
        if (warmup) {
            return;
        }
        ++this.elements;
        if (attributeList != null) {
            this.attributes += (long)attributeList.getLength();
        }
    }

    public void warning(SAXParseException sAXParseException) {
        if (warmup) {
            return;
        }
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }
}

