/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public abstract class SAXParser {
    protected SAXParser() {
    }

    public abstract Parser getParser() throws SAXException;

    public abstract boolean isNamespaceAware();

    public abstract boolean isValidating();

    public void parse(File file, HandlerBase handlerBase) throws SAXException, IOException, IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.parse(new InputSource(file.toURL().toString()), handlerBase);
    }

    public void parse(InputStream inputStream, HandlerBase handlerBase) throws SAXException, IOException, IllegalArgumentException {
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        this.parse(new InputSource(inputStream), handlerBase);
    }

    public void parse(String string, HandlerBase handlerBase) throws SAXException, IOException, IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.parse(new InputSource(string), handlerBase);
    }

    public void parse(InputSource inputSource, HandlerBase handlerBase) throws SAXException, IOException, IllegalArgumentException {
        if (inputSource == null) {
            throw new IllegalArgumentException();
        }
        Parser parser = this.getParser();
        if (handlerBase != null) {
            parser.setDocumentHandler(handlerBase);
            parser.setDTDHandler(handlerBase);
            parser.setEntityResolver(handlerBase);
            parser.setErrorHandler(handlerBase);
        }
        parser.parse(inputSource);
    }
}

