/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils.regex;

import java.text.CharacterIterator;
import org.apache.xerces.utils.regex.REUtil;

public class Match
implements Cloneable {
    int[] beginpos = null;
    int[] endpos = null;
    int nofgroups = 0;
    CharacterIterator ciSource = null;
    String strSource = null;
    char[] charSource = null;

    public synchronized Object clone() {
        Match match = new Match();
        if (this.nofgroups > 0) {
            match.setNumberOfGroups(this.nofgroups);
            if (this.ciSource != null) {
                match.setSource(this.ciSource);
            }
            if (this.strSource != null) {
                match.setSource(this.strSource);
            }
            int n = 0;
            while (n < this.nofgroups) {
                match.setBeginning(n, this.getBeginning(n));
                match.setEnd(n, this.getEnd(n));
                ++n;
            }
        }
        return match;
    }

    public int getBeginning(int n) {
        if (this.beginpos == null) {
            throw new IllegalStateException("A result is not set.");
        }
        if (n < 0 || this.nofgroups <= n) {
            throw new IllegalArgumentException("The parameter must be less than " + this.nofgroups + ": " + n);
        }
        return this.beginpos[n];
    }

    public String getCapturedText(int n) {
        String string;
        if (this.beginpos == null) {
            throw new IllegalStateException("match() has never been called.");
        }
        if (n < 0 || this.nofgroups <= n) {
            throw new IllegalArgumentException("The parameter must be less than " + this.nofgroups + ": " + n);
        }
        if (this.ciSource != null) {
            string = REUtil.substring(this.ciSource, this.beginpos[n], this.endpos[n]);
        } else if (this.strSource != null) {
            string = this.strSource.substring(this.beginpos[n], this.endpos[n]);
        } else {
            int n2 = this.beginpos[n];
            string = new String(this.charSource, n2, this.endpos[n] - n2);
        }
        return string;
    }

    public int getEnd(int n) {
        if (this.endpos == null) {
            throw new IllegalStateException("A result is not set.");
        }
        if (n < 0 || this.nofgroups <= n) {
            throw new IllegalArgumentException("The parameter must be less than " + this.nofgroups + ": " + n);
        }
        return this.endpos[n];
    }

    public int getNumberOfGroups() {
        if (this.nofgroups <= 0) {
            throw new IllegalStateException("A result is not set.");
        }
        return this.nofgroups;
    }

    protected void setBeginning(int n, int n2) {
        this.beginpos[n] = n2;
    }

    protected void setEnd(int n, int n2) {
        this.endpos[n] = n2;
    }

    protected void setNumberOfGroups(int n) {
        int n2 = this.nofgroups;
        this.nofgroups = n;
        if (n2 <= 0 || n2 < n || n * 2 < n2) {
            this.beginpos = new int[n];
            this.endpos = new int[n];
        }
        int n3 = 0;
        while (n3 < n) {
            this.beginpos[n3] = -1;
            this.endpos[n3] = -1;
            ++n3;
        }
    }

    protected void setSource(String string) {
        this.ciSource = null;
        this.strSource = string;
        this.charSource = null;
    }

    protected void setSource(CharacterIterator characterIterator) {
        this.ciSource = characterIterator;
        this.strSource = null;
        this.charSource = null;
    }

    protected void setSource(char[] cArray) {
        this.ciSource = null;
        this.strSource = null;
        this.charSource = cArray;
    }
}

