/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils.regex;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.utils.regex.REUtil;
import org.apache.xerces.utils.regex.RangeToken;

class Token
implements Serializable {
    static final boolean COUNTTOKENS = true;
    static int tokens = 0;
    static final int CHAR = 0;
    static final int DOT = 11;
    static final int CONCAT = 1;
    static final int UNION = 2;
    static final int CLOSURE = 3;
    static final int RANGE = 4;
    static final int NRANGE = 5;
    static final int PAREN = 6;
    static final int EMPTY = 7;
    static final int ANCHOR = 8;
    static final int NONGREEDYCLOSURE = 9;
    static final int STRING = 10;
    static final int BACKREFERENCE = 12;
    static final int LOOKAHEAD = 20;
    static final int NEGATIVELOOKAHEAD = 21;
    static final int LOOKBEHIND = 22;
    static final int NEGATIVELOOKBEHIND = 23;
    static final int INDEPENDENT = 24;
    static final int MODIFIERGROUP = 25;
    static final int CONDITION = 26;
    static final int UTF16_MAX = 0x10FFFF;
    int type;
    protected static Token token_dot;
    protected static Token token_0to9;
    protected static Token token_wordchars;
    protected static Token token_not_0to9;
    protected static Token token_not_wordchars;
    protected static Token token_spaces;
    protected static Token token_not_spaces;
    protected static Token token_empty;
    protected static Token token_linebeginning;
    protected static Token token_linebeginning2;
    protected static Token token_lineend;
    protected static Token token_stringbeginning;
    protected static Token token_stringend;
    protected static Token token_stringend2;
    protected static Token token_wordedge;
    protected static Token token_not_wordedge;
    protected static Token token_wordbeginning;
    protected static Token token_wordend;
    static final int FC_CONTINUE = 0;
    static final int FC_TERMINAL = 1;
    static final int FC_ANY = 2;
    protected static Hashtable categories;
    protected static Hashtable categories2;
    static final String[] categoryNames;
    static final int CHAR_LETTER = 29;
    static final int CHAR_MARK = 30;
    static final int CHAR_NUMBER = 31;
    static final int CHAR_SEPARATOR = 32;
    static final int CHAR_OTHER = 33;
    static final int CHAR_PUNCTUATION = 34;
    static final int CHAR_SYMBOL = 35;
    static final String[] blockNames;
    static final String blockRanges = "\u0000\u007f\u0080\u00ff\u0100\u017f\u0180\u024f\u0250\u02af\u02b0\u02ff\u0300\u036f\u0370\u03ff\u0400\u04ff\u0530\u058f\u0590\u05ff\u0600\u06ff\u0900\u097f\u0980\u09ff\u0a00\u0a7f\u0a80\u0aff\u0b00\u0b7f\u0b80\u0bff\u0c00\u0c7f\u0c80\u0cff\u0d00\u0d7f\u0e00\u0e7f\u0e80\u0eff\u0f00\u0fbf\u10a0\u10ff\u1100\u11ff\u1e00\u1eff\u1f00\u1fff\u2000\u206f\u2070\u209f\u20a0\u20cf\u20d0\u20ff\u2100\u214f\u2150\u218f\u2190\u21ff\u2200\u22ff\u2300\u23ff\u2400\u243f\u2440\u245f\u2460\u24ff\u2500\u257f\u2580\u259f\u25a0\u25ff\u2600\u26ff\u2700\u27bf\u3000\u303f\u3040\u309f\u30a0\u30ff\u3100\u312f\u3130\u318f\u3190\u319f\u3200\u32ff\u3300\u33ff\u4e00\u9fff\uac00\ud7a3\ud800\udb7f\udb80\udbff\udc00\udfff\ue000\uf8ff\uf900\ufaff\ufb00\ufb4f\ufb50\ufdff\ufe20\ufe2f\ufe30\ufe4f\ufe50\ufe6f\ufe70\ufefe\ufeff\ufeff\uff00\uffef";
    static final String viramaString = "\u094d\u09cd\u0a4d\u0acd\u0b4d\u0bcd\u0c4d\u0ccd\u0d4d\u0e3a\u0f84";
    private static Token token_grapheme;

    static {
        token_empty = new Token(7);
        token_linebeginning = Token.createAnchor(94);
        token_linebeginning2 = Token.createAnchor(64);
        token_lineend = Token.createAnchor(36);
        token_stringbeginning = Token.createAnchor(65);
        token_stringend = Token.createAnchor(122);
        token_stringend2 = Token.createAnchor(90);
        token_wordedge = Token.createAnchor(98);
        token_not_wordedge = Token.createAnchor(66);
        token_wordbeginning = Token.createAnchor(60);
        token_wordend = Token.createAnchor(62);
        token_dot = new Token(11);
        token_0to9 = Token.createRange();
        token_0to9.addRange(48, 57);
        token_wordchars = Token.createRange();
        token_wordchars.addRange(48, 57);
        token_wordchars.addRange(65, 90);
        token_wordchars.addRange(95, 95);
        token_wordchars.addRange(97, 122);
        token_spaces = Token.createRange();
        token_spaces.addRange(9, 9);
        token_spaces.addRange(10, 10);
        token_spaces.addRange(12, 12);
        token_spaces.addRange(13, 13);
        token_spaces.addRange(32, 32);
        token_not_0to9 = Token.complementRanges(token_0to9);
        token_not_wordchars = Token.complementRanges(token_wordchars);
        token_not_spaces = Token.complementRanges(token_spaces);
        categories = new Hashtable();
        categories2 = null;
        categoryNames = new String[]{"Cn", "Lu", "Ll", "Lt", "Lm", "Lo", "Mn", "Me", "Mc", "Nd", "Nl", "No", "Zs", "Zl", "Zp", "Cc", "Cf", null, "Co", "Cs", "Pd", "Ps", "Pe", "Pc", "Po", "Sm", "Sc", "Sk", "So", "L", "M", "N", "Z", "C", "P", "S"};
        blockNames = new String[]{"Basic Latin", "Latin-1 Supplement", "Latin Extended-A", "Latin Extended-B", "IPA Extensions", "Spacing Modifier Letters", "Combining Diacritical Marks", "Greek", "Cyrillic", "Armenian", "Hebrew", "Arabic", "Devanagari", "Bengali", "Gurmukhi", "Gujarati", "Oriya", "Tamil", "Telugu", "Kannada", "Malayalam", "Thai", "Lao", "Tibetan", "Georgian", "Hangul Jamo", "Latin Extended Additional", "Greek Extended", "General Punctuation", "Superscripts and Subscripts", "Currency Symbols", "Combining Marks for Symbols", "Letterlike Symbols", "Number Forms", "Arrows", "Mathematical Operators", "Miscellaneous Technical", "Control Pictures", "Optical Character Recognition", "Enclosed Alphanumerics", "Box Drawing", "Block Elements", "Geometric Shapes", "Miscellaneous Symbols", "Dingbats", "CJK Symbols and Punctuation", "Hiragana", "Katakana", "Bopomofo", "Hangul Compatibility Jamo", "Kanbun", "Enclosed CJK Letters and Months", "CJK Compatibility", "CJK Unified Ideographs", "Hangul Syllables", "High Surrogates", "High Private Use Surrogates", "Low Surrogates", "Private Use", "CJK Compatibility Ideographs", "Alphabetic Presentation Forms", "Arabic Presentation Forms-A", "Combining Half Marks", "CJK Compatibility Forms", "Small Form Variants", "Arabic Presentation Forms-B", "Specials", "Halfwidth and Fullwidth Forms"};
        token_grapheme = null;
    }

    protected Token(int n) {
        this.type = n;
    }

    void addChild(Token token) {
        throw new RuntimeException("Not supported.");
    }

    protected void addRange(int n, int n2) {
        throw new RuntimeException("Not supported.");
    }

    final int analyzeFirstCharacter(RangeToken rangeToken, int n) {
        switch (this.type) {
            case 1: {
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.size()) {
                    n2 = this.getChild(n3).analyzeFirstCharacter(rangeToken, n);
                    if (n2 != 0) break;
                    ++n3;
                }
                return n2;
            }
            case 2: {
                if (this.size() == 0) {
                    return 0;
                }
                int n4 = 0;
                boolean bl = false;
                int n5 = 0;
                while (n5 < this.size()) {
                    n4 = this.getChild(n5).analyzeFirstCharacter(rangeToken, n);
                    if (n4 == 2) break;
                    if (n4 == 0) {
                        bl = true;
                    }
                    ++n5;
                }
                return bl ? 0 : n4;
            }
            case 26: {
                int n6 = this.getChild(0).analyzeFirstCharacter(rangeToken, n);
                if (this.size() == 1) {
                    return 0;
                }
                if (n6 == 2) {
                    return n6;
                }
                int n7 = this.getChild(1).analyzeFirstCharacter(rangeToken, n);
                if (n7 == 2) {
                    return n7;
                }
                return n6 == 0 || n7 == 0 ? 0 : 1;
            }
            case 3: 
            case 9: {
                this.getChild(0).analyzeFirstCharacter(rangeToken, n);
                return 0;
            }
            case 7: 
            case 8: {
                return 0;
            }
            case 0: {
                int n8 = this.getChar();
                rangeToken.addRange(n8, n8);
                if (n8 < 65536 && Token.isSet(n, 2)) {
                    n8 = Character.toUpperCase((char)n8);
                    rangeToken.addRange(n8, n8);
                    n8 = Character.toLowerCase((char)n8);
                    rangeToken.addRange(n8, n8);
                }
                return 1;
            }
            case 11: {
                if (Token.isSet(n, 4)) {
                    return 0;
                }
                return 0;
            }
            case 4: {
                if (Token.isSet(n, 2)) {
                    rangeToken.mergeRanges(((RangeToken)this).getCaseInsensitiveToken());
                } else {
                    rangeToken.mergeRanges(this);
                }
                return 1;
            }
            case 5: {
                if (Token.isSet(n, 2)) {
                    rangeToken.mergeRanges(Token.complementRanges(((RangeToken)this).getCaseInsensitiveToken()));
                } else {
                    rangeToken.mergeRanges(Token.complementRanges(this));
                }
                return 1;
            }
            case 6: 
            case 24: {
                return this.getChild(0).analyzeFirstCharacter(rangeToken, n);
            }
            case 25: {
                n |= ((ModifierToken)this).getOptions();
                return this.getChild(0).analyzeFirstCharacter(rangeToken, n &= ~((ModifierToken)this).getOptionsMask());
            }
            case 12: {
                rangeToken.addRange(0, 0x10FFFF);
                return 2;
            }
            case 10: {
                char c;
                int n9 = this.getString().charAt(0);
                if (REUtil.isHighSurrogate(n9) && this.getString().length() >= 2 && REUtil.isLowSurrogate(c = this.getString().charAt(1))) {
                    n9 = REUtil.composeFromSurrogates(n9, c);
                }
                rangeToken.addRange(n9, n9);
                if (n9 < 65536 && Token.isSet(n, 2)) {
                    n9 = Character.toUpperCase((char)n9);
                    rangeToken.addRange(n9, n9);
                    n9 = Character.toLowerCase((char)n9);
                    rangeToken.addRange(n9, n9);
                }
                return 1;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return 0;
            }
        }
        throw new RuntimeException("Token#analyzeHeadCharacter(): Invalid Type: " + this.type);
    }

    protected void compactRanges() {
        throw new RuntimeException("Not supported.");
    }

    static Token complementRanges(Token token) {
        return RangeToken.complementRanges(token);
    }

    private static CharToken createAnchor(int n) {
        ++tokens;
        return new CharToken(8, n);
    }

    static StringToken createBackReference(int n) {
        ++tokens;
        return new StringToken(12, null, n);
    }

    static CharToken createChar(int n) {
        ++tokens;
        return new CharToken(0, n);
    }

    static ClosureToken createClosure(Token token) {
        ++tokens;
        return new ClosureToken(3, token);
    }

    static UnionToken createConcat() {
        ++tokens;
        return new UnionToken(1);
    }

    static ConcatToken createConcat(Token token, Token token2) {
        ++tokens;
        return new ConcatToken(token, token2);
    }

    static ConditionToken createCondition(int n, Token token, Token token2, Token token3) {
        ++tokens;
        return new ConditionToken(n, token, token2, token3);
    }

    static Token createEmpty() {
        return token_empty;
    }

    static ParenToken createLook(int n, Token token) {
        ++tokens;
        return new ParenToken(n, token, 0);
    }

    static ModifierToken createModifierGroup(Token token, int n, int n2) {
        ++tokens;
        return new ModifierToken(token, n, n2);
    }

    static ClosureToken createNGClosure(Token token) {
        ++tokens;
        return new ClosureToken(9, token);
    }

    static RangeToken createNRange() {
        ++tokens;
        return new RangeToken(5);
    }

    static ParenToken createParen(Token token, int n) {
        ++tokens;
        return new ParenToken(6, token, n);
    }

    static RangeToken createRange() {
        ++tokens;
        return new RangeToken(4);
    }

    static StringToken createString(String string) {
        ++tokens;
        return new StringToken(10, string, 0);
    }

    static UnionToken createUnion() {
        ++tokens;
        return new UnionToken(2);
    }

    final void findFixedString(FixedStringContainer fixedStringContainer, int n) {
        switch (this.type) {
            case 1: {
                Token token = null;
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.size()) {
                    this.getChild(n3).findFixedString(fixedStringContainer, n);
                    if (token == null || token.isShorterThan(fixedStringContainer.token)) {
                        token = fixedStringContainer.token;
                        n2 = fixedStringContainer.options;
                    }
                    ++n3;
                }
                fixedStringContainer.token = token;
                fixedStringContainer.options = n2;
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                fixedStringContainer.token = null;
                return;
            }
            case 0: {
                fixedStringContainer.token = null;
                return;
            }
            case 10: {
                fixedStringContainer.token = this;
                fixedStringContainer.options = n;
                return;
            }
            case 6: 
            case 24: {
                this.getChild(0).findFixedString(fixedStringContainer, n);
                return;
            }
            case 25: {
                n |= ((ModifierToken)this).getOptions();
                this.getChild(0).findFixedString(fixedStringContainer, n &= ~((ModifierToken)this).getOptionsMask());
                return;
            }
        }
        throw new RuntimeException("Token#findFixedString(): Invalid Type: " + this.type);
    }

    int getChar() {
        return -1;
    }

    Token getChild(int n) {
        return null;
    }

    protected static synchronized Token getGraphemePattern() {
        if (token_grapheme != null) {
            return token_grapheme;
        }
        RangeToken rangeToken = Token.createRange();
        ((Token)rangeToken).mergeRanges(Token.getRange("ASSIGNED", true));
        ((Token)rangeToken).subtractRanges(Token.getRange("M", true));
        ((Token)rangeToken).subtractRanges(Token.getRange("C", true));
        RangeToken rangeToken2 = Token.createRange();
        int n = 0;
        while (n < viramaString.length()) {
            char c = viramaString.charAt(n);
            ((Token)rangeToken2).addRange(n, n);
            ++n;
        }
        RangeToken rangeToken3 = Token.createRange();
        ((Token)rangeToken3).mergeRanges(Token.getRange("M", true));
        ((Token)rangeToken3).addRange(4448, 4607);
        ((Token)rangeToken3).addRange(65438, 65439);
        UnionToken unionToken = Token.createUnion();
        ((Token)unionToken).addChild(rangeToken);
        ((Token)unionToken).addChild(token_empty);
        Token token = Token.createUnion();
        ((Token)token).addChild(Token.createConcat(rangeToken2, Token.getRange("L", true)));
        ((Token)token).addChild(rangeToken3);
        token = Token.createClosure(token);
        token = Token.createConcat(unionToken, token);
        token_grapheme = token;
        return token_grapheme;
    }

    int getMax() {
        return -1;
    }

    final int getMaxLength() {
        switch (this.type) {
            case 1: {
                int n = 0;
                int n2 = 0;
                while (n2 < this.size()) {
                    int n3 = this.getChild(n2).getMaxLength();
                    if (n3 < 0) {
                        return -1;
                    }
                    n += n3;
                    ++n2;
                }
                return n;
            }
            case 2: 
            case 26: {
                if (this.size() == 0) {
                    return 0;
                }
                int n = this.getChild(0).getMaxLength();
                int n4 = 1;
                while (n >= 0 && n4 < this.size()) {
                    int n5 = this.getChild(n4).getMaxLength();
                    if (n5 < 0) {
                        n = -1;
                        break;
                    }
                    if (n5 > n) {
                        n = n5;
                    }
                    ++n4;
                }
                return n;
            }
            case 3: 
            case 9: {
                if (this.getMax() >= 0) {
                    return this.getMax() * this.getChild(0).getMaxLength();
                }
                return -1;
            }
            case 7: 
            case 8: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 4: 
            case 5: 
            case 11: {
                return 2;
            }
            case 6: 
            case 24: 
            case 25: {
                return this.getChild(0).getMaxLength();
            }
            case 12: {
                return -1;
            }
            case 10: {
                return this.getString().length();
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return 0;
            }
        }
        throw new RuntimeException("Token#getMaxLength(): Invalid Type: " + this.type);
    }

    int getMin() {
        return -1;
    }

    final int getMinLength() {
        switch (this.type) {
            case 1: {
                int n = 0;
                int n2 = 0;
                while (n2 < this.size()) {
                    n += this.getChild(n2).getMinLength();
                    ++n2;
                }
                return n;
            }
            case 2: 
            case 26: {
                if (this.size() == 0) {
                    return 0;
                }
                int n = this.getChild(0).getMinLength();
                int n3 = 1;
                while (n3 < this.size()) {
                    int n4 = this.getChild(n3).getMinLength();
                    if (n4 < n) {
                        n = n4;
                    }
                    ++n3;
                }
                return n;
            }
            case 3: 
            case 9: {
                if (this.getMin() >= 0) {
                    return this.getMin() * this.getChild(0).getMinLength();
                }
                return 0;
            }
            case 7: 
            case 8: {
                return 0;
            }
            case 0: 
            case 4: 
            case 5: 
            case 11: {
                return 1;
            }
            case 6: 
            case 24: 
            case 25: {
                return this.getChild(0).getMinLength();
            }
            case 12: {
                return 0;
            }
            case 10: {
                return this.getString().length();
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return 0;
            }
        }
        throw new RuntimeException("Token#getMinLength(): Invalid Type: " + this.type);
    }

    int getParenNumber() {
        return 0;
    }

    protected static RangeToken getRange(String string, boolean bl) {
        Serializable serializable;
        if (categories.size() == 0) {
            serializable = categories;
            synchronized (serializable) {
                Serializable serializable2;
                Object object;
                RangeToken rangeToken;
                int n;
                Token[] tokenArray = new Token[categoryNames.length];
                int n2 = 0;
                while (n2 < tokenArray.length) {
                    tokenArray[n2] = Token.createRange();
                    ++n2;
                }
                int n3 = 0;
                while (n3 < 65536) {
                    n = Character.getType((char)n3);
                    tokenArray[n].addRange(n3, n3);
                    switch (n) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            n = 29;
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            n = 30;
                            break;
                        }
                        case 9: 
                        case 10: 
                        case 11: {
                            n = 31;
                            break;
                        }
                        case 12: 
                        case 13: 
                        case 14: {
                            n = 32;
                            break;
                        }
                        case 0: 
                        case 15: 
                        case 16: 
                        case 18: 
                        case 19: {
                            n = 33;
                            break;
                        }
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: {
                            n = 34;
                            break;
                        }
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: {
                            n = 35;
                            break;
                        }
                        default: {
                            throw new RuntimeException("org.apache.xerces.utils.regex.Token#getRange(): Unknown Unicode category: " + n);
                        }
                    }
                    tokenArray[n].addRange(n3, n3);
                    ++n3;
                }
                tokenArray[0].addRange(65536, 0x10FFFF);
                categories2 = new Hashtable();
                n = 0;
                while (n < tokenArray.length) {
                    if (categoryNames[n] != null) {
                        if (n == 0) {
                            tokenArray[n].addRange(65536, 0x10FFFF);
                        }
                        categories.put(categoryNames[n], tokenArray[n]);
                        categories2.put(categoryNames[n], Token.complementRanges(tokenArray[n]));
                    }
                    ++n;
                }
                int n4 = 0;
                while (n4 < blockNames.length) {
                    rangeToken = Token.createRange();
                    char c = blockRanges.charAt(n4 * 2);
                    char c2 = blockRanges.charAt(n4 * 2 + 1);
                    object = blockNames[n4];
                    ((Token)rangeToken).addRange(c, c2);
                    if (((String)object).equals("Specials")) {
                        ((Token)rangeToken).addRange(65520, 65533);
                    }
                    categories.put(object, rangeToken);
                    categories2.put(object, Token.complementRanges(rangeToken));
                    if (((String)object).indexOf(32) >= 0) {
                        serializable2 = new StringBuffer(((String)object).length());
                        int n5 = 0;
                        while (n5 < ((String)object).length()) {
                            if (((String)object).charAt(n5) != ' ') {
                                ((StringBuffer)serializable2).append(((String)object).charAt(n5));
                            }
                            ++n5;
                        }
                        Token.setAlias(((StringBuffer)serializable2).toString(), (String)object, true);
                    }
                    ++n4;
                }
                Token.setAlias("ASSIGNED", "Cn", false);
                Token.setAlias("UNASSIGNED", "Cn", true);
                rangeToken = Token.createRange();
                ((Token)rangeToken).addRange(0, 0x10FFFF);
                categories.put("ALL", rangeToken);
                categories2.put("ALL", Token.complementRanges(rangeToken));
                RangeToken rangeToken2 = Token.createRange();
                ((Token)rangeToken2).mergeRanges(tokenArray[1]);
                ((Token)rangeToken2).mergeRanges(tokenArray[2]);
                ((Token)rangeToken2).mergeRanges(tokenArray[5]);
                categories.put("IsAlpha", rangeToken2);
                categories2.put("IsAlpha", Token.complementRanges(rangeToken2));
                RangeToken rangeToken3 = Token.createRange();
                ((Token)rangeToken3).mergeRanges(rangeToken2);
                ((Token)rangeToken3).mergeRanges(tokenArray[9]);
                categories.put("IsAlnum", rangeToken3);
                categories2.put("IsAlnum", Token.complementRanges(rangeToken3));
                object = Token.createRange();
                ((Token)object).mergeRanges(token_spaces);
                ((Token)object).mergeRanges(tokenArray[32]);
                categories.put("IsSpace", object);
                categories2.put("IsSpace", Token.complementRanges((Token)object));
                serializable2 = Token.createRange();
                ((Token)serializable2).mergeRanges(rangeToken3);
                ((Token)serializable2).addRange(95, 95);
                categories.put("IsWord", serializable2);
                categories2.put("IsWord", Token.complementRanges((Token)serializable2));
                RangeToken rangeToken4 = Token.createRange();
                ((Token)rangeToken4).addRange(0, 127);
                categories.put("IsASCII", rangeToken4);
                categories2.put("IsASCII", Token.complementRanges(rangeToken4));
                RangeToken rangeToken5 = Token.createRange();
                ((Token)rangeToken5).mergeRanges(tokenArray[33]);
                ((Token)rangeToken5).addRange(32, 32);
                categories.put("IsGraph", Token.complementRanges(rangeToken5));
                categories2.put("IsGraph", rangeToken5);
                RangeToken rangeToken6 = Token.createRange();
                ((Token)rangeToken6).addRange(48, 57);
                ((Token)rangeToken6).addRange(65, 70);
                ((Token)rangeToken6).addRange(97, 102);
                categories.put("IsXDigit", Token.complementRanges(rangeToken6));
                categories2.put("IsXDigit", rangeToken6);
                Token.setAlias("IsDigit", "Nd", true);
                Token.setAlias("IsUpper", "Lu", true);
                Token.setAlias("IsLower", "Ll", true);
                Token.setAlias("IsCntrl", "C", true);
                Token.setAlias("IsPrint", "C", false);
                Token.setAlias("IsPunct", "P", true);
                Token.setAlias("alpha", "IsAlpha", true);
                Token.setAlias("alnum", "IsAlnum", true);
                Token.setAlias("ascii", "IsASCII", true);
                Token.setAlias("cntrl", "IsCntrl", true);
                Token.setAlias("digit", "IsDigit", true);
                Token.setAlias("graph", "IsGraph", true);
                Token.setAlias("lower", "IsLower", true);
                Token.setAlias("print", "IsPrint", true);
                Token.setAlias("punct", "IsPunct", true);
                Token.setAlias("space", "IsSpace", true);
                Token.setAlias("upper", "IsUpper", true);
                Token.setAlias("word", "IsWord", true);
                Token.setAlias("xdigit", "IsXDigit", true);
            }
        }
        serializable = bl ? (RangeToken)categories.get(string) : (RangeToken)categories2.get(string);
        return serializable;
    }

    int getReferenceNumber() {
        return 0;
    }

    String getString() {
        return null;
    }

    protected void intersectRanges(Token token) {
        throw new RuntimeException("Not supported.");
    }

    private static final boolean isSet(int n, int n2) {
        return (n & n2) == n2;
    }

    private final boolean isShorterThan(Token token) {
        if (token == null) {
            return false;
        }
        if (this.type != 10) {
            throw new RuntimeException("Internal Error: Illegal type: " + this.type);
        }
        int n = this.getString().length();
        if (token.type != 10) {
            throw new RuntimeException("Internal Error: Illegal type: " + token.type);
        }
        int n2 = token.getString().length();
        return n < n2;
    }

    boolean match(int n) {
        throw new RuntimeException("NFAArrow#match(): Internal error: " + this.type);
    }

    protected void mergeRanges(Token token) {
        throw new RuntimeException("Not supported.");
    }

    private static void setAlias(String string, String string2, boolean bl) {
        Token token = (Token)categories.get(string2);
        Token token2 = (Token)categories2.get(string2);
        if (bl) {
            categories.put(string, token);
            categories2.put(string, token2);
        } else {
            categories2.put(string, token);
            categories.put(string, token2);
        }
    }

    void setMax(int n) {
    }

    void setMin(int n) {
    }

    int size() {
        return 0;
    }

    protected void sortRanges() {
        throw new RuntimeException("Not supported.");
    }

    protected void subtractRanges(Token token) {
        throw new RuntimeException("Not supported.");
    }

    public String toString() {
        return this.type == 11 ? "." : "";
    }

    static class FixedStringContainer {
        Token token = null;
        int options = 0;

        FixedStringContainer() {
        }
    }

    static class StringToken
    extends Token
    implements Serializable {
        String string;
        int refNumber;

        StringToken(int n, String string, int n2) {
            super(n);
            this.string = string;
            this.refNumber = n2;
        }

        int getReferenceNumber() {
            return this.refNumber;
        }

        String getString() {
            return this.string;
        }

        public String toString() {
            if (this.type == 12) {
                return "\\" + this.refNumber;
            }
            return REUtil.quoteMeta(this.string);
        }
    }

    static class ConcatToken
    extends Token
    implements Serializable {
        Token child;
        Token child2;

        ConcatToken(Token token, Token token2) {
            super(1);
            this.child = token;
            this.child2 = token2;
        }

        Token getChild(int n) {
            return n == 0 ? this.child : this.child2;
        }

        int size() {
            return 2;
        }

        public String toString() {
            String string = this.child2.type == 3 && this.child2.getChild(0) == this.child ? String.valueOf(this.child.toString()) + "+" : (this.child2.type == 9 && this.child2.getChild(0) == this.child ? String.valueOf(this.child.toString()) + "+?" : String.valueOf(this.child.toString()) + this.child2.toString());
            return string;
        }
    }

    static class CharToken
    extends Token
    implements Serializable {
        int chardata;

        CharToken(int n, int n2) {
            super(n);
            this.chardata = n2;
        }

        int getChar() {
            return this.chardata;
        }

        boolean match(int n) {
            if (this.type == 0) {
                return n == this.chardata;
            }
            throw new RuntimeException("NFAArrow#match(): Internal error: " + this.type);
        }

        public String toString() {
            String string;
            block0 : switch (this.type) {
                case 0: {
                    switch (this.chardata) {
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 46: 
                        case 63: 
                        case 91: 
                        case 92: 
                        case 123: 
                        case 124: {
                            string = "\\" + (char)this.chardata;
                            break block0;
                        }
                        case 12: {
                            string = "\\f";
                            break block0;
                        }
                        case 10: {
                            string = "\\n";
                            break block0;
                        }
                        case 13: {
                            string = "\\r";
                            break block0;
                        }
                        case 9: {
                            string = "\\t";
                            break block0;
                        }
                        case 27: {
                            string = "\\e";
                            break block0;
                        }
                    }
                    if (this.chardata >= 65536) {
                        String string2 = "0" + Integer.toHexString(this.chardata);
                        string = "\\v" + string2.substring(string2.length() - 6, string2.length());
                        break;
                    }
                    string = String.valueOf((char)this.chardata);
                    break;
                }
                case 8: {
                    if (this == token_linebeginning || this == token_lineend) {
                        string = String.valueOf((char)this.chardata);
                        break;
                    }
                    string = "\\" + (char)this.chardata;
                    break;
                }
                default: {
                    string = null;
                }
            }
            return string;
        }
    }

    static class ClosureToken
    extends Token
    implements Serializable {
        int min;
        int max;
        Token child;

        ClosureToken(int n, Token token) {
            super(n);
            this.child = token;
            this.setMin(-1);
            this.setMax(-1);
        }

        Token getChild(int n) {
            return this.child;
        }

        final int getMax() {
            return this.max;
        }

        final int getMin() {
            return this.min;
        }

        final void setMax(int n) {
            this.max = n;
        }

        final void setMin(int n) {
            this.min = n;
        }

        int size() {
            return 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String toString() {
            if (this.type == 3) {
                if (this.getMin() < 0 && this.getMax() < 0) {
                    return String.valueOf(this.child.toString()) + "*";
                }
                if (this.getMin() == this.getMax()) {
                    return String.valueOf(this.child.toString()) + "{" + this.getMin() + "}";
                }
                if (this.getMin() >= 0 && this.getMax() >= 0) {
                    return String.valueOf(this.child.toString()) + "{" + this.getMin() + "," + this.getMax() + "}";
                }
                if (this.getMin() < 0) throw new RuntimeException("Token#toString(): CLOSURE " + this.getMin() + ", " + this.getMax());
                if (this.getMax() >= 0) throw new RuntimeException("Token#toString(): CLOSURE " + this.getMin() + ", " + this.getMax());
                return String.valueOf(this.child.toString()) + "{" + this.getMin() + ",}";
            }
            if (this.getMin() < 0 && this.getMax() < 0) {
                return String.valueOf(this.child.toString()) + "*?";
            }
            if (this.getMin() == this.getMax()) {
                return String.valueOf(this.child.toString()) + "{" + this.getMin() + "}?";
            }
            if (this.getMin() >= 0 && this.getMax() >= 0) {
                return String.valueOf(this.child.toString()) + "{" + this.getMin() + "," + this.getMax() + "}?";
            }
            if (this.getMin() < 0) throw new RuntimeException("Token#toString(): NONGREEDYCLOSURE " + this.getMin() + ", " + this.getMax());
            if (this.getMax() >= 0) throw new RuntimeException("Token#toString(): NONGREEDYCLOSURE " + this.getMin() + ", " + this.getMax());
            return String.valueOf(this.child.toString()) + "{" + this.getMin() + ",}?";
        }
    }

    static class ParenToken
    extends Token
    implements Serializable {
        Token child;
        int parennumber;

        ParenToken(int n, Token token, int n2) {
            super(n);
            this.child = token;
            this.parennumber = n2;
        }

        Token getChild(int n) {
            return this.child;
        }

        int getParenNumber() {
            return this.parennumber;
        }

        int size() {
            return 1;
        }

        public String toString() {
            String string = null;
            switch (this.type) {
                case 6: {
                    if (this.parennumber == 0) {
                        string = "(?:" + this.child.toString() + ")";
                        break;
                    }
                    string = "(" + this.child.toString() + ")";
                    break;
                }
                case 20: {
                    string = "(?=" + this.child.toString() + ")";
                    break;
                }
                case 21: {
                    string = "(?!" + this.child.toString() + ")";
                    break;
                }
                case 22: {
                    string = "(?<=" + this.child.toString() + ")";
                    break;
                }
                case 23: {
                    string = "(?<!" + this.child.toString() + ")";
                    break;
                }
                case 24: {
                    string = "(?>" + this.child.toString() + ")";
                    break;
                }
            }
            return string;
        }
    }

    static class ConditionToken
    extends Token
    implements Serializable {
        int refNumber;
        Token condition;
        Token yes;
        Token no;

        ConditionToken(int n, Token token, Token token2, Token token3) {
            super(26);
            this.refNumber = n;
            this.condition = token;
            this.yes = token2;
            this.no = token3;
        }

        Token getChild(int n) {
            if (n == 0) {
                return this.yes;
            }
            if (n == 1) {
                return this.no;
            }
            throw new RuntimeException("Internal Error: " + n);
        }

        int size() {
            return this.no == null ? 1 : 2;
        }

        public String toString() {
            String string = this.refNumber > 0 ? "(?(" + this.refNumber + ")" : (this.condition.type == 8 ? "(?(" + this.condition + ")" : "(?" + this.condition);
            string = this.no == null ? String.valueOf(string) + this.yes + ")" : String.valueOf(string) + this.yes + "|" + this.no + ")";
            return string;
        }
    }

    static class ModifierToken
    extends Token
    implements Serializable {
        Token child;
        int add;
        int mask;

        ModifierToken(Token token, int n, int n2) {
            super(25);
            this.child = token;
            this.add = n;
            this.mask = n2;
        }

        Token getChild(int n) {
            return this.child;
        }

        int getOptions() {
            return this.add;
        }

        int getOptionsMask() {
            return this.mask;
        }

        int size() {
            return 1;
        }

        public String toString() {
            return "(?" + (this.add == 0 ? "" : REUtil.createOptionString(this.add)) + (this.mask == 0 ? "" : REUtil.createOptionString(this.mask)) + ":" + this.child.toString() + ")";
        }
    }

    static class UnionToken
    extends Token
    implements Serializable {
        Vector children;

        UnionToken(int n) {
            super(n);
        }

        void addChild(Token token) {
            int n;
            StringBuffer stringBuffer;
            int n2;
            if (token == null) {
                return;
            }
            if (this.children == null) {
                this.children = new Vector();
            }
            if (this.type == 2) {
                this.children.addElement(token);
                return;
            }
            if (token.type == 1) {
                int n3 = 0;
                while (n3 < token.size()) {
                    this.addChild(token.getChild(n3));
                    ++n3;
                }
                return;
            }
            int n4 = this.children.size();
            if (n4 == 0) {
                this.children.addElement(token);
                return;
            }
            Token token2 = (Token)this.children.elementAt(n4 - 1);
            if (token2.type != 0 && token2.type != 10 || token.type != 0 && token.type != 10) {
                this.children.addElement(token);
                return;
            }
            int n5 = n2 = token.type == 0 ? 2 : token.getString().length();
            if (token2.type == 0) {
                stringBuffer = new StringBuffer(2 + n2);
                n = token2.getChar();
                if (n >= 65536) {
                    stringBuffer.append(REUtil.decomposeToSurrogates(n));
                } else {
                    stringBuffer.append((char)n);
                }
                token2 = Token.createString(null);
                this.children.setElementAt(token2, n4 - 1);
            } else {
                stringBuffer = new StringBuffer(token2.getString().length() + n2);
                stringBuffer.append(token2.getString());
            }
            if (token.type == 0) {
                n = token.getChar();
                if (n >= 65536) {
                    stringBuffer.append(REUtil.decomposeToSurrogates(n));
                } else {
                    stringBuffer.append((char)n);
                }
            } else {
                stringBuffer.append(token.getString());
            }
            ((StringToken)token2).string = stringBuffer.toString();
        }

        Token getChild(int n) {
            return (Token)this.children.elementAt(n);
        }

        int size() {
            return this.children == null ? 0 : this.children.size();
        }

        public String toString() {
            String string;
            if (this.type == 1) {
                String string2;
                if (this.children.size() == 2) {
                    Token token = this.getChild(0);
                    Token token2 = this.getChild(1);
                    string2 = token2.type == 3 && token2.getChild(0) == token ? String.valueOf(token.toString()) + "+" : (token2.type == 9 && token2.getChild(0) == token ? String.valueOf(token.toString()) + "+?" : String.valueOf(token.toString()) + token2.toString());
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = 0;
                    while (n < this.children.size()) {
                        stringBuffer.append(this.children.elementAt(n).toString());
                        ++n;
                    }
                    string2 = stringBuffer.toString();
                }
                return string2;
            }
            if (this.children.size() == 2 && this.getChild((int)1).type == 7) {
                string = String.valueOf(this.getChild(0).toString()) + "?";
            } else if (this.children.size() == 2 && this.getChild((int)0).type == 7) {
                string = String.valueOf(this.getChild(1).toString()) + "??";
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.children.elementAt(0).toString());
                int n = 1;
                while (n < this.children.size()) {
                    stringBuffer.append('|');
                    stringBuffer.append(this.children.elementAt(n).toString());
                    ++n;
                }
                string = stringBuffer.toString();
            }
            return string;
        }
    }
}

