/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import org.apache.xerces.utils.QName;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.InsertableElementsInfo;
import org.apache.xerces.validators.common.XMLContentModel;

public class MixedContentModel
implements XMLContentModel {
    private int fCount;
    private QName[] fChildren;
    private boolean fOrdered;

    public MixedContentModel(int n, QName[] qNameArray) throws CMException {
        this(n, qNameArray, false);
    }

    public MixedContentModel(int n, QName[] qNameArray, boolean bl) throws CMException {
        this.fCount = n;
        this.fChildren = new QName[this.fCount];
        int n2 = 0;
        while (n2 < this.fCount) {
            this.fChildren[n2] = new QName(qNameArray[n2]);
            ++n2;
        }
    }

    public int validateContent(QName[] qNameArray, int n, int n2) throws Exception {
        if (this.fOrdered) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                QName qName = qNameArray[n + n4];
                if (qName.localpart != -1) {
                    if (this.fChildren[n3].uri != qNameArray[n + n4].uri && this.fChildren[n3].localpart != qNameArray[n + n4].localpart) {
                        return n4;
                    }
                    ++n3;
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n2) {
                QName qName = qNameArray[n + n5];
                if (qName.localpart != -1) {
                    int n6 = 0;
                    while (n6 < this.fCount) {
                        if (qName.uri == this.fChildren[n6].uri && qName.localpart == this.fChildren[n6].localpart) break;
                        ++n6;
                    }
                    if (n6 == this.fCount) {
                        return n5;
                    }
                }
                ++n5;
            }
        }
        return -1;
    }

    public int whatCanGoHere(boolean bl, InsertableElementsInfo insertableElementsInfo) throws Exception {
        int n;
        int n2 = insertableElementsInfo.insertAt;
        while (n2 < insertableElementsInfo.childCount) {
            insertableElementsInfo.curChildren[n2] = insertableElementsInfo.curChildren[n2 + 1];
            ++n2;
        }
        --insertableElementsInfo.childCount;
        int n3 = this.validateContent(insertableElementsInfo.curChildren, 0, insertableElementsInfo.childCount);
        if (n3 != -1 && n3 < insertableElementsInfo.insertAt) {
            return n3;
        }
        insertableElementsInfo.canHoldPCData = true;
        insertableElementsInfo.isValidEOC = true;
        insertableElementsInfo.resultsCount = this.fCount;
        if (insertableElementsInfo.results == null || insertableElementsInfo.results.length < insertableElementsInfo.resultsCount) {
            insertableElementsInfo.results = new boolean[insertableElementsInfo.resultsCount];
        }
        if (insertableElementsInfo.possibleChildren == null || insertableElementsInfo.possibleChildren.length < insertableElementsInfo.resultsCount) {
            insertableElementsInfo.possibleChildren = new QName[insertableElementsInfo.resultsCount];
            n = 0;
            while (n < insertableElementsInfo.possibleChildren.length) {
                insertableElementsInfo.possibleChildren[n] = new QName();
                ++n;
            }
        }
        n = 1;
        if (bl && n3 < insertableElementsInfo.childCount) {
            n = 0;
        }
        int n4 = 0;
        while (n4 < this.fCount) {
            insertableElementsInfo.possibleChildren[n4].setValues(this.fChildren[n4]);
            insertableElementsInfo.results[n4] = n;
            ++n4;
        }
        return -1;
    }
}

