/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import org.apache.xerces.utils.QName;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.InsertableElementsInfo;
import org.apache.xerces.validators.common.XMLContentModel;

public class SimpleContentModel
implements XMLContentModel {
    private QName fFirstChild = new QName();
    private QName fSecondChild = new QName();
    private int fOp;

    public SimpleContentModel(QName qName, QName qName2, int n) {
        this.fFirstChild.setValues(qName);
        if (qName2 != null) {
            this.fSecondChild.setValues(qName2);
        } else {
            this.fSecondChild.clear();
        }
        this.fOp = n;
    }

    public int validateContent(QName[] qNameArray, int n, int n2) throws Exception {
        switch (this.fOp) {
            case 0: {
                if (n2 == 0) {
                    return 0;
                }
                if (qNameArray[n].uri != this.fFirstChild.uri && qNameArray[n].localpart != this.fFirstChild.localpart) {
                    return 0;
                }
                if (n2 <= 1) break;
                return 1;
            }
            case 1: {
                if (n2 == 1 && qNameArray[n].uri != this.fFirstChild.uri && qNameArray[n].localpart != this.fFirstChild.localpart) {
                    return 0;
                }
                if (n2 <= 1) break;
                return 1;
            }
            case 2: {
                if (n2 <= 0) break;
                int n3 = 0;
                while (n3 < n2) {
                    if (qNameArray[n + n3].uri != this.fFirstChild.uri && qNameArray[n + n3].localpart != this.fFirstChild.localpart) {
                        return n3;
                    }
                    ++n3;
                }
                break;
            }
            case 3: {
                if (n2 == 0) {
                    return 0;
                }
                int n4 = 0;
                while (n4 < n2) {
                    if (qNameArray[n + n4].uri != this.fFirstChild.uri && qNameArray[n + n4].localpart != this.fFirstChild.localpart) {
                        return n4;
                    }
                    ++n4;
                }
                break;
            }
            case 4: {
                if (n2 == 0) {
                    return 0;
                }
                if (qNameArray[n].uri != this.fFirstChild.uri && qNameArray[n].localpart != this.fFirstChild.localpart && qNameArray[n].uri != this.fSecondChild.uri && qNameArray[n].localpart != this.fSecondChild.localpart) {
                    return 0;
                }
                if (n2 <= 1) break;
                return 1;
            }
            case 5: {
                if (n2 == 2) {
                    if (qNameArray[n].uri != this.fFirstChild.uri && qNameArray[n].localpart != this.fFirstChild.localpart) {
                        return 0;
                    }
                    if (qNameArray[n + 1].uri == this.fSecondChild.uri || qNameArray[n + 1].localpart == this.fSecondChild.localpart) break;
                    return 1;
                }
                if (n2 > 2) {
                    return 2;
                }
                return n2;
            }
            default: {
                throw new CMException(8);
            }
        }
        return -1;
    }

    public int whatCanGoHere(boolean bl, InsertableElementsInfo insertableElementsInfo) throws Exception {
        int n = insertableElementsInfo.insertAt;
        while (n < insertableElementsInfo.childCount) {
            insertableElementsInfo.curChildren[n].setValues(insertableElementsInfo.curChildren[n + 1]);
            ++n;
        }
        --insertableElementsInfo.childCount;
        int n2 = this.validateContent(insertableElementsInfo.curChildren, 0, insertableElementsInfo.childCount);
        if (n2 != -1 && n2 < insertableElementsInfo.insertAt) {
            return n2;
        }
        insertableElementsInfo.canHoldPCData = false;
        if (this.fOp == 0 || this.fOp == 1 || this.fOp == 2 || this.fOp == 3) {
            insertableElementsInfo.resultsCount = 1;
        } else if (this.fOp == 4 || this.fOp == 5) {
            insertableElementsInfo.resultsCount = 2;
        } else {
            throw new CMException(8);
        }
        if (insertableElementsInfo.results == null || insertableElementsInfo.results.length < insertableElementsInfo.resultsCount) {
            insertableElementsInfo.results = new boolean[insertableElementsInfo.resultsCount];
        }
        if (insertableElementsInfo.possibleChildren == null || insertableElementsInfo.possibleChildren.length < insertableElementsInfo.resultsCount) {
            insertableElementsInfo.possibleChildren = new QName[insertableElementsInfo.resultsCount];
            int n3 = 0;
            while (n3 < insertableElementsInfo.possibleChildren.length) {
                insertableElementsInfo.possibleChildren[n3] = new QName();
                ++n3;
            }
        }
        insertableElementsInfo.possibleChildren[0].setValues(this.fFirstChild);
        insertableElementsInfo.results[0] = false;
        if (insertableElementsInfo.resultsCount == 2) {
            insertableElementsInfo.possibleChildren[1].setValues(this.fSecondChild);
            insertableElementsInfo.results[1] = false;
        }
        insertableElementsInfo.isValidEOC = false;
        switch (this.fOp) {
            case 0: 
            case 1: {
                if (insertableElementsInfo.childCount == 0) {
                    insertableElementsInfo.results[0] = true;
                } else if (insertableElementsInfo.childCount > 0 && !bl && insertableElementsInfo.insertAt == 0) {
                    insertableElementsInfo.results[0] = true;
                }
                if (this.fOp == 0) {
                    if (insertableElementsInfo.insertAt != 0) break;
                    insertableElementsInfo.isValidEOC = true;
                    break;
                }
                insertableElementsInfo.isValidEOC = true;
                break;
            }
            case 2: 
            case 3: {
                insertableElementsInfo.results[0] = true;
                if (this.fOp != 2 && insertableElementsInfo.insertAt <= 0) break;
                insertableElementsInfo.isValidEOC = true;
                break;
            }
            case 4: {
                if (insertableElementsInfo.insertAt == 0 && !bl && insertableElementsInfo.childCount == 0) {
                    insertableElementsInfo.results[0] = true;
                    insertableElementsInfo.results[1] = true;
                }
                if (insertableElementsInfo.insertAt != 1) break;
                insertableElementsInfo.isValidEOC = true;
                break;
            }
            case 5: {
                if (insertableElementsInfo.insertAt == 0) {
                    if (bl) {
                        if (insertableElementsInfo.childCount == 1) {
                            insertableElementsInfo.results[0] = insertableElementsInfo.curChildren[0].uri == this.fSecondChild.uri && insertableElementsInfo.curChildren[0].localpart == this.fSecondChild.localpart;
                        }
                    } else {
                        insertableElementsInfo.results[0] = true;
                    }
                } else if (!(insertableElementsInfo.insertAt != 1 || bl && insertableElementsInfo.childCount != 1)) {
                    insertableElementsInfo.results[1] = true;
                }
                if (insertableElementsInfo.insertAt != 2) break;
                insertableElementsInfo.isValidEOC = true;
                break;
            }
            default: {
                throw new CMException(8);
            }
        }
        return -1;
    }
}

