/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class DoubleDatatypeValidator
extends AbstractDatatypeValidator {
    private Locale fLocale = null;
    private DatatypeValidator fBaseValidator = null;
    private boolean fDerivationByList = false;
    private double[] fEnumDoubles = null;
    private String fPattern = null;
    private double fMaxInclusive = Double.MAX_VALUE;
    private double fMaxExclusive = Double.MAX_VALUE;
    private double fMinInclusive = Double.MIN_VALUE;
    private double fMinExclusive = Double.MIN_VALUE;
    private int fFacetsDefined = 0;
    private boolean isMaxExclusiveDefined = false;
    private boolean isMaxInclusiveDefined = false;
    private boolean isMinExclusiveDefined = false;
    private boolean isMinInclusiveDefined = false;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();

    public DoubleDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public DoubleDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        if (datatypeValidator != null) {
            this.setBasetype(datatypeValidator);
        }
        if (hashtable != null) {
            if (!bl) {
                Object object;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string;
                    object = (String)enumeration.nextElement();
                    if (((String)object).equals("pattern")) {
                        this.fFacetsDefined += 8;
                        this.fPattern = (String)hashtable.get(object);
                        continue;
                    }
                    if (((String)object).equals("enumeration")) {
                        this.fFacetsDefined += 16;
                        continue;
                    }
                    if (((String)object).equals("maxInclusive")) {
                        this.fFacetsDefined += 32;
                        string = null;
                        try {
                            string = (String)hashtable.get(object);
                            this.fMaxInclusive = Double.valueOf(string);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                        }
                    }
                    if (((String)object).equals("maxExclusive")) {
                        this.fFacetsDefined += 64;
                        string = null;
                        try {
                            string = (String)hashtable.get(object);
                            this.fMaxExclusive = Double.valueOf(string);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                        }
                    }
                    if (((String)object).equals("minInclusive")) {
                        this.fFacetsDefined += 128;
                        string = null;
                        try {
                            string = (String)hashtable.get(object);
                            this.fMinInclusive = Double.valueOf(string);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                        }
                    }
                    if (((String)object).equals("minExclusive")) {
                        this.fFacetsDefined += 128;
                        string = null;
                        try {
                            string = (String)hashtable.get(object);
                            this.fMinExclusive = Double.valueOf(string);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                        }
                    }
                    throw new InvalidDatatypeFacetException(this.getErrorString(1, 0, null));
                }
                this.isMaxExclusiveDefined = (this.fFacetsDefined & 0x40) != 0;
                this.isMaxInclusiveDefined = (this.fFacetsDefined & 0x20) != 0;
                this.isMinExclusiveDefined = (this.fFacetsDefined & 0x100) != 0;
                boolean bl2 = this.isMinInclusiveDefined = (this.fFacetsDefined & 0x80) != 0;
                if (this.isMaxExclusiveDefined && this.isMaxInclusiveDefined) {
                    throw new InvalidDatatypeFacetException("It is an error for both maxInclusive and maxExclusive to be specified for the same datatype.");
                }
                if (this.isMinExclusiveDefined && this.isMinInclusiveDefined) {
                    throw new InvalidDatatypeFacetException("It is an error for both minInclusive and minExclusive to be specified for the same datatype.");
                }
                if ((this.fFacetsDefined & 0x10) != 0 && (object = (Vector)hashtable.get("enumeration")) != null) {
                    this.fEnumDoubles = new double[((Vector)object).size()];
                    int n = 0;
                    while (n < ((Vector)object).size()) {
                        try {
                            this.fEnumDoubles[n] = Double.valueOf((String)((Vector)object).elementAt(n));
                            this.boundsCheck(this.fEnumDoubles[n]);
                        }
                        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                            throw new InvalidDatatypeFacetException(this.getErrorString(8, 0, new Object[]{((Vector)object).elementAt(n)}));
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Internal Error parsing enumerated values for real type");
                        }
                        ++n;
                    }
                }
            } else {
                this.fDerivationByList = true;
            }
        }
    }

    private void boundsCheck(double d) throws InvalidDatatypeValueException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.isMaxInclusiveDefined) {
            bl = d <= this.fMaxInclusive;
        } else if (this.isMaxExclusiveDefined) {
            boolean bl3 = bl = d < this.fMaxExclusive;
        }
        if (this.isMinInclusiveDefined) {
            bl2 = d >= this.fMinInclusive;
        } else if (this.isMinExclusiveDefined) {
            boolean bl4 = bl2 = d > this.fMinExclusive;
        }
        if (!bl || !bl2) {
            this.getErrorString(9, 0, new Object[]{new Double(d)});
        }
    }

    public int compare(String string, String string2) {
        return 0;
    }

    private void enumCheck(double d) throws InvalidDatatypeValueException {
        int n = 0;
        while (n < this.fEnumDoubles.length) {
            if (d == this.fEnumDoubles[n]) {
                return;
            }
            ++n;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(10, 0, new Object[]{new Double(d)}));
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        try {
            return this.fMessageProvider.createMessage(this.fLocale, n, n2, objectArray);
        }
        catch (Exception exception) {
            return "Illegal Errorcode " + n2;
        }
    }

    public Hashtable getFacets() {
        return null;
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        if (!this.fDerivationByList) {
            double d = 0.0;
            try {
                d = Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidDatatypeValueException(this.getErrorString(13, 0, new Object[]{string}));
            }
            this.boundsCheck(d);
            if ((this.fFacetsDefined & 0x10) != 0) {
                this.enumCheck(d);
            }
        }
        return null;
    }
}

