/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class FloatDatatypeValidator
extends AbstractDatatypeValidator {
    private Locale fLocale = null;
    private DatatypeValidator fBaseValidator = null;
    private float[] fEnumFloats = null;
    private String fPattern = null;
    private boolean fDerivationByList = false;
    private float fMaxInclusive = Float.MAX_VALUE;
    private float fMaxExclusive = Float.MAX_VALUE;
    private float fMinInclusive = Float.MIN_VALUE;
    private float fMinExclusive = Float.MIN_VALUE;
    private int fFacetsDefined = 0;
    private boolean isMaxExclusiveDefined = false;
    private boolean isMaxInclusiveDefined = false;
    private boolean isMinExclusiveDefined = false;
    private boolean isMinInclusiveDefined = false;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();

    public FloatDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public FloatDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        if (datatypeValidator != null) {
            this.setBasetype(datatypeValidator);
        }
        if (hashtable != null) {
            if (!bl) {
                Object object;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string;
                    object = (String)enumeration.nextElement();
                    if (((String)object).equals("pattern")) {
                        this.fFacetsDefined += 8;
                        this.fPattern = (String)hashtable.get(object);
                        continue;
                    }
                    if (((String)object).equals("enumeration")) {
                        this.fFacetsDefined += 16;
                        continue;
                    }
                    if (((String)object).equals("maxInclusive")) {
                        this.fFacetsDefined += 32;
                        string = null;
                        try {
                            string = (String)hashtable.get(object);
                            this.fMaxInclusive = Float.valueOf(string).floatValue();
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                        }
                    }
                    if (((String)object).equals("maxExclusive")) {
                        this.fFacetsDefined += 64;
                        string = null;
                        try {
                            string = (String)hashtable.get(object);
                            this.fMaxExclusive = Float.valueOf(string).floatValue();
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                        }
                    }
                    if (((String)object).equals("minInclusive")) {
                        this.fFacetsDefined += 128;
                        string = null;
                        try {
                            string = (String)hashtable.get(object);
                            this.fMinInclusive = Float.valueOf(string).floatValue();
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                        }
                    }
                    if (((String)object).equals("minExclusive")) {
                        this.fFacetsDefined += 128;
                        string = null;
                        try {
                            string = (String)hashtable.get(object);
                            this.fMinExclusive = Float.valueOf(string).floatValue();
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                        }
                    }
                    throw new InvalidDatatypeFacetException(this.getErrorString(1, 0, null));
                }
                this.isMaxExclusiveDefined = (this.fFacetsDefined & 0x40) != 0;
                this.isMaxInclusiveDefined = (this.fFacetsDefined & 0x20) != 0;
                this.isMinExclusiveDefined = (this.fFacetsDefined & 0x100) != 0;
                boolean bl2 = this.isMinInclusiveDefined = (this.fFacetsDefined & 0x80) != 0;
                if (this.isMaxExclusiveDefined && this.isMaxInclusiveDefined) {
                    throw new InvalidDatatypeFacetException("It is an error for both maxInclusive and maxExclusive to be specified for the same datatype.");
                }
                if (this.isMinExclusiveDefined && this.isMinInclusiveDefined) {
                    throw new InvalidDatatypeFacetException("It is an error for both minInclusive and minExclusive to be specified for the same datatype.");
                }
                if ((this.fFacetsDefined & 0x10) != 0 && (object = (Vector)hashtable.get("enumeration")) != null) {
                    this.fEnumFloats = new float[((Vector)object).size()];
                    int n = 0;
                    while (n < ((Vector)object).size()) {
                        try {
                            this.fEnumFloats[n] = Float.valueOf((String)((Vector)object).elementAt(n)).floatValue();
                            this.boundsCheck(this.fEnumFloats[n]);
                        }
                        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                            throw new InvalidDatatypeFacetException(this.getErrorString(8, 0, new Object[]{((Vector)object).elementAt(n)}));
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Internal Error parsing enumerated values for real type");
                        }
                        ++n;
                    }
                }
            } else {
                this.fDerivationByList = true;
            }
        }
    }

    private void boundsCheck(float f) throws InvalidDatatypeValueException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.isMaxInclusiveDefined) {
            bl = f <= this.fMaxInclusive;
        } else if (this.isMaxExclusiveDefined) {
            boolean bl3 = bl = f < this.fMaxExclusive;
        }
        if (this.isMinInclusiveDefined) {
            bl2 = f >= this.fMinInclusive;
        } else if (this.isMinExclusiveDefined) {
            boolean bl4 = bl2 = f > this.fMinExclusive;
        }
        if (!bl || !bl2) {
            this.getErrorString(9, 0, new Object[]{new Float(f)});
        }
    }

    public int compare(String string, String string2) {
        return 0;
    }

    private void enumCheck(float f) throws InvalidDatatypeValueException {
        int n = 0;
        while (n < this.fEnumFloats.length) {
            if (f == this.fEnumFloats[n]) {
                return;
            }
            ++n;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(10, 0, new Object[]{new Float(f)}));
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        try {
            return this.fMessageProvider.createMessage(this.fLocale, n, n2, objectArray);
        }
        catch (Exception exception) {
            return "Illegal Errorcode " + n2;
        }
    }

    public Hashtable getFacets() {
        return null;
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        if (!this.fDerivationByList) {
            float f = 0.0f;
            try {
                f = Float.valueOf(string).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidDatatypeValueException(this.getErrorString(13, 0, new Object[]{string}));
            }
            this.boundsCheck(f);
            if ((this.fFacetsDefined & 0x10) != 0) {
                this.enumCheck(f);
            }
        }
        return null;
    }
}

