/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class StringDatatypeValidator
extends AbstractDatatypeValidator {
    private Locale fLocale = null;
    DatatypeValidator fBaseValidator = null;
    private int fLength = 0;
    private int fMaxLength = 0;
    private int fMinLength = 0;
    private String fPattern = null;
    private Vector fEnumeration = null;
    private String fMaxInclusive = null;
    private String fMaxExclusive = null;
    private String fMinInclusive = null;
    private String fMinExclusive = null;
    private int fFacetsDefined = 0;
    private boolean fDerivedByList = false;
    private boolean isMaxExclusiveDefined = false;
    private boolean isMaxInclusiveDefined = false;
    private boolean isMinExclusiveDefined = false;
    private boolean isMinInclusiveDefined = false;

    public StringDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public StringDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.setBasetype(datatypeValidator);
        if (hashtable != null) {
            if (!bl) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string;
                    String string2 = (String)enumeration.nextElement();
                    if (string2.equals("length")) {
                        ++this.fFacetsDefined;
                        string = (String)hashtable.get(string2);
                        try {
                            this.fLength = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidDatatypeFacetException("Length value '" + string + "' is invalid.");
                        }
                        if (this.fLength >= 0) continue;
                        throw new InvalidDatatypeFacetException("Length value '" + string + "'  must be a nonNegativeInteger.");
                    }
                    if (string2.equals("minLength")) {
                        this.fFacetsDefined += 2;
                        string = (String)hashtable.get(string2);
                        try {
                            this.fMinLength = Integer.parseInt(string);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidDatatypeFacetException("maxLength value '" + string + "' is invalid.");
                        }
                    }
                    if (string2.equals("maxLength")) {
                        this.fFacetsDefined += 4;
                        string = (String)hashtable.get(string2);
                        try {
                            this.fMaxLength = Integer.parseInt(string);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidDatatypeFacetException("maxLength value '" + string + "' is invalid.");
                        }
                    }
                    if (string2.equals("pattern")) {
                        this.fFacetsDefined += 8;
                        this.fPattern = (String)hashtable.get(string2);
                        continue;
                    }
                    if (string2.equals("enumeration")) {
                        this.fFacetsDefined += 16;
                        this.fEnumeration = (Vector)hashtable.get(string2);
                        continue;
                    }
                    if (string2.equals("maxInclusive")) {
                        this.fFacetsDefined += 32;
                        this.fMaxInclusive = (String)hashtable.get(string2);
                        continue;
                    }
                    if (string2.equals("maxExclusive")) {
                        this.fFacetsDefined += 64;
                        this.fMaxExclusive = (String)hashtable.get(string2);
                        continue;
                    }
                    if (string2.equals("minInclusive")) {
                        this.fFacetsDefined += 128;
                        this.fMinInclusive = (String)hashtable.get(string2);
                        continue;
                    }
                    if (string2.equals("minExclusive")) {
                        this.fFacetsDefined += 128;
                        this.fMinExclusive = (String)hashtable.get(string2);
                        continue;
                    }
                    throw new InvalidDatatypeFacetException();
                }
                if ((this.fFacetsDefined & 1) != 0) {
                    if ((this.fFacetsDefined & 4) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                    }
                    if ((this.fFacetsDefined & 2) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                    }
                }
                if ((this.fFacetsDefined & 6) != 0 && this.fMinLength < this.fMaxLength) {
                    throw new InvalidDatatypeFacetException("Value of minLength = " + this.fMinLength + "must be greater that the value of maxLength" + this.fMaxLength);
                }
                this.isMaxExclusiveDefined = (this.fFacetsDefined & 0x40) != 0;
                this.isMaxInclusiveDefined = (this.fFacetsDefined & 0x20) != 0;
                this.isMinExclusiveDefined = (this.fFacetsDefined & 0x100) != 0;
                boolean bl2 = this.isMinInclusiveDefined = (this.fFacetsDefined & 0x80) != 0;
                if (this.isMaxExclusiveDefined && this.isMaxInclusiveDefined) {
                    throw new InvalidDatatypeFacetException("It is an error for both maxInclusive and maxExclusive to be specified for the same datatype.");
                }
                if (this.isMinExclusiveDefined && this.isMinInclusiveDefined) {
                    throw new InvalidDatatypeFacetException("It is an error for both minInclusive and minExclusive to be specified for the same datatype.");
                }
            } else {
                this.fDerivedByList = true;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string;
                    String string3 = (String)enumeration.nextElement();
                    if (string3.equals("length")) {
                        ++this.fFacetsDefined;
                        string = (String)hashtable.get(string3);
                        try {
                            this.fLength = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidDatatypeFacetException("Length value '" + string + "' is invalid.");
                        }
                        if (this.fLength >= 0) continue;
                        throw new InvalidDatatypeFacetException("Length value '" + string + "'  must be a nonNegativeInteger.");
                    }
                    if (string3.equals("minLength")) {
                        this.fFacetsDefined += 2;
                        string = (String)hashtable.get(string3);
                        try {
                            this.fMinLength = Integer.parseInt(string);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidDatatypeFacetException("maxLength value '" + string + "' is invalid.");
                        }
                    }
                    if (string3.equals("maxLength")) {
                        this.fFacetsDefined += 4;
                        string = (String)hashtable.get(string3);
                        try {
                            this.fMaxLength = Integer.parseInt(string);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidDatatypeFacetException("maxLength value '" + string + "' is invalid.");
                        }
                    }
                    if (string3.equals("enumeration")) {
                        this.fFacetsDefined += 16;
                        this.fEnumeration = (Vector)hashtable.get(string3);
                        continue;
                    }
                    throw new InvalidDatatypeFacetException();
                }
                if ((this.fFacetsDefined & 1) != 0) {
                    if ((this.fFacetsDefined & 4) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                    }
                    if ((this.fFacetsDefined & 2) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                    }
                }
                if ((this.fFacetsDefined & 6) != 0 && this.fMinLength < this.fMaxLength) {
                    throw new InvalidDatatypeFacetException("Value of minLength = " + this.fMinLength + "must be greater that the value of maxLength" + this.fMaxLength);
                }
            }
        }
    }

    private void checkContent(String string) throws InvalidDatatypeValueException {
        RegularExpression regularExpression;
        int n;
        if ((this.fFacetsDefined & 4) != 0 && string.length() > this.fMaxLength) {
            throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + string.length() + "' exceeds maximum length of " + this.fMaxLength + ".");
        }
        if ((this.fFacetsDefined & 0x10) != 0 && !this.fEnumeration.contains(string)) {
            throw new InvalidDatatypeValueException("Value '" + string + "' must be one of " + this.fEnumeration);
        }
        if (this.isMaxExclusiveDefined && (n = this.compare(string, this.fMaxExclusive)) > 0) {
            throw new InvalidDatatypeValueException("Value '" + string + "'  must be" + "lexicographically less than" + this.fMaxExclusive);
        }
        if (this.isMaxInclusiveDefined && (n = this.compare(string, this.fMaxInclusive)) >= 0) {
            throw new InvalidDatatypeValueException("Value '" + string + "' must be" + "lexicographically less or equal than" + this.fMaxInclusive);
        }
        if (this.isMinExclusiveDefined && (n = this.compare(string, this.fMinExclusive)) < 0) {
            throw new InvalidDatatypeValueException("Value '" + string + "' must be" + "lexicographically greater than" + this.fMinExclusive);
        }
        if (this.isMinInclusiveDefined && (n = this.compare(string, this.fMinInclusive)) <= 0) {
            throw new InvalidDatatypeValueException("Value '" + string + "' must be" + "lexicographically greater or equal than" + this.fMinInclusive);
        }
        if ((this.fFacetsDefined & 8) != 0 && !(regularExpression = new RegularExpression(this.fPattern, "X")).matches(string)) {
            throw new InvalidDatatypeValueException("Value'" + string + "does not match regular expression facet" + this.fPattern);
        }
    }

    private void checkContentList(String string) throws InvalidDatatypeValueException {
    }

    public int compare(String string, String string2) {
        Locale locale = Locale.getDefault();
        Collator collator = Collator.getInstance(locale);
        return collator.compare(string, string2);
    }

    public Hashtable getFacets() {
        return null;
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        if (this.fFacetsDefined == 0) {
            return null;
        }
        if (!this.fDerivedByList) {
            this.checkContent(string);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    this.checkContentList(stringTokenizer.nextToken());
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
        }
        return null;
    }
}

