/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.GrammarResolverImpl;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactoryImpl;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SchemaMessageProvider;
import org.apache.xerces.validators.schema.XUtil;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class TraverseSchema
implements NamespacesScope.NamespacesHandler {
    private static final int TOP_LEVEL_SCOPE = -1;
    private static boolean DEBUGGING = false;
    private XMLErrorReporter fErrorReporter = null;
    private StringPool fStringPool = null;
    private GrammarResolver fGrammarResolver = null;
    private SchemaGrammar fSchemaGrammar = null;
    private Element fSchemaRootElement;
    private DatatypeValidatorFactoryImpl fDatatypeRegistry = DatatypeValidatorFactoryImpl.getDatatypeRegistry();
    private Hashtable fComplexTypeRegistry = new Hashtable();
    private Hashtable fAttributeDeclRegistry = new Hashtable();
    private Vector fIncludeLocations = new Vector();
    private Vector fImportLocations = new Vector();
    private int fAnonTypeCount = 0;
    private int fScopeCount = 0;
    private int fCurrentScope = -1;
    private int fSimpleTypeAnonCount = 0;
    private Stack fCurrentTypeNameStack = new Stack();
    private Hashtable fElementRecurseComplex = new Hashtable();
    private boolean fDefaultQualified = false;
    private int fTargetNSURI;
    private String fTargetNSURIString = "";
    private NamespacesScope fNamespacesScope = null;
    private String fCurrentSchemaURL = "";
    private XMLAttributeDecl fTempAttributeDecl = new XMLAttributeDecl();
    public static final String SchemaForSchemaURI = "http://www.w3.org/TR-1/Schema";

    private TraverseSchema() {
    }

    public TraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver) throws Exception {
        this.doTraverseSchema(element, stringPool, schemaGrammar, grammarResolver);
    }

    public TraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver, XMLErrorReporter xMLErrorReporter, String string) throws Exception {
        this.fErrorReporter = xMLErrorReporter;
        this.fCurrentSchemaURL = string;
        this.doTraverseSchema(element, stringPool, schemaGrammar, grammarResolver);
    }

    private int addAttributeDeclFromAnotherSchema(String string, String string2, ComplexTypeInfo complexTypeInfo) throws Exception {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found : " + string2);
            return -1;
        }
        Hashtable hashtable = schemaGrammar.getAttirubteDeclRegistry();
        if (hashtable == null) {
            this.reportGenericSchemaError("no attribute was defined in schema : " + string2);
            return -1;
        }
        XMLAttributeDecl xMLAttributeDecl = (XMLAttributeDecl)hashtable.get(string);
        if (xMLAttributeDecl == null) {
            this.reportGenericSchemaError("no attribute named \"" + string + "\" was defined in schema : " + string2);
            return -1;
        }
        this.fSchemaGrammar.addAttDef(complexTypeInfo.templateElementIndex, xMLAttributeDecl.name, xMLAttributeDecl.type, -1, xMLAttributeDecl.defaultType, xMLAttributeDecl.defaultValue, xMLAttributeDecl.datatypeValidator);
        return 0;
    }

    private int buildAllModel(int[] nArray, int n) throws Exception {
        if (n > 1) {
            XMLContentSpec xMLContentSpec = new XMLContentSpec();
            xMLContentSpec.type = 4;
            xMLContentSpec.value = -1;
            xMLContentSpec.otherValue = -1;
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            this.sort(nArray2, 0, n);
            int n2 = this.buildAllModel(nArray2, 0, xMLContentSpec);
            return n2;
        }
        if (n > 0) {
            return nArray[0];
        }
        return -1;
    }

    private int buildAllModel(int[] nArray, int n, XMLContentSpec xMLContentSpec) throws Exception {
        if (nArray.length - n == 2) {
            int n2 = this.createSeq(nArray);
            if (xMLContentSpec.value == -1) {
                xMLContentSpec.value = n2;
            } else {
                if (xMLContentSpec.otherValue != -1) {
                    xMLContentSpec.value = this.fSchemaGrammar.addContentSpecNode(xMLContentSpec.type, xMLContentSpec.value, xMLContentSpec.otherValue, false);
                }
                xMLContentSpec.otherValue = n2;
            }
            this.swap(nArray, n, n + 1);
            n2 = this.createSeq(nArray);
            if (xMLContentSpec.value == -1) {
                xMLContentSpec.value = n2;
            } else {
                if (xMLContentSpec.otherValue != -1) {
                    xMLContentSpec.value = this.fSchemaGrammar.addContentSpecNode(xMLContentSpec.type, xMLContentSpec.value, xMLContentSpec.otherValue, false);
                }
                xMLContentSpec.otherValue = n2;
            }
            return this.fSchemaGrammar.addContentSpecNode(xMLContentSpec.type, xMLContentSpec.value, xMLContentSpec.otherValue, false);
        }
        int n3 = n;
        while (n3 < nArray.length - 1) {
            xMLContentSpec.value = this.buildAllModel(nArray, n + 1, xMLContentSpec);
            xMLContentSpec.otherValue = -1;
            this.sort(nArray, n, nArray.length - n);
            this.shift(nArray, n, n3 + 1);
            ++n3;
        }
        int n4 = this.buildAllModel(nArray, n + 1, xMLContentSpec);
        this.sort(nArray, n, nArray.length - n);
        return n4;
    }

    private void checkEquivClassOK(Element element, Element element2) {
    }

    private void checkParticleDerivationOK(Element element, Element element2) {
    }

    private void checkRecursingComplexType() throws Exception {
        if (this.fCurrentTypeNameStack.empty() && !this.fElementRecurseComplex.isEmpty()) {
            Enumeration enumeration = this.fElementRecurseComplex.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.fElementRecurseComplex.get(string);
                int n = string.indexOf(",");
                String string3 = string.substring(0, n);
                int n2 = Integer.parseInt(string.substring(n + 1));
                ComplexTypeInfo complexTypeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(String.valueOf(this.fTargetNSURIString) + "," + string2);
                if (complexTypeInfo == null) {
                    throw new Exception("Internal Error in void checkRecursingComplexType(). ");
                }
                int n3 = this.fStringPool.addSymbol(string3);
                int n4 = this.fSchemaGrammar.addElementDecl(new QName(-1, n3, n3, -1), n2, complexTypeInfo.scopeDefined, complexTypeInfo.contentType, complexTypeInfo.contentSpecHandle, complexTypeInfo.attlistHead, complexTypeInfo.datatypeValidator);
                this.fSchemaGrammar.setElementComplexTypeInfo(n4, complexTypeInfo);
            }
            this.fElementRecurseComplex.clear();
        }
    }

    private void checkTopLevelDuplicateNames(Element element) {
    }

    private int createSeq(int[] nArray) throws Exception {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = 2;
        while (n3 < nArray.length) {
            n = this.fSchemaGrammar.addContentSpecNode(5, n, n2, false);
            n2 = nArray[n3];
            ++n3;
        }
        return this.fSchemaGrammar.addContentSpecNode(5, n, n2, false);
    }

    public void doTraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver) throws Exception {
        String string;
        Object object;
        this.fNamespacesScope = new NamespacesScope(this);
        this.fSchemaRootElement = element;
        this.fStringPool = stringPool;
        this.fSchemaGrammar = schemaGrammar;
        this.fGrammarResolver = grammarResolver;
        if (element == null) {
            return;
        }
        this.fTargetNSURIString = element.getAttribute("targetNamespace");
        if (this.fTargetNSURIString == null) {
            this.fTargetNSURIString = "";
        }
        this.fTargetNSURI = this.fStringPool.addSymbol(this.fTargetNSURIString);
        if (this.fGrammarResolver == null) {
            this.reportGenericSchemaError("Internal error: don't have a GrammarResolver for TraverseSchema");
        } else {
            this.fSchemaGrammar.setComplexTypeRegistry(this.fComplexTypeRegistry);
            this.fSchemaGrammar.setDatatypeRegistry(this.fDatatypeRegistry);
            this.fSchemaGrammar.setAttributeDeclRegistry(this.fAttributeDeclRegistry);
            this.fGrammarResolver.putGrammar(this.fTargetNSURIString, this.fSchemaGrammar);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        Attr attr = null;
        boolean bl = false;
        while ((attr = (Attr)namedNodeMap.item(n++)) != null) {
            object = attr.getName();
            if (((String)object).startsWith("xmlns:")) {
                string = attr.getValue();
                String string2 = ((String)object).substring(((String)object).indexOf(":") + 1);
                this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(string2), this.fStringPool.addSymbol(string));
            }
            if (!((String)object).equals("xmlns")) continue;
            string = attr.getValue();
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(string));
            bl = true;
        }
        if (!bl && this.fTargetNSURIString.length() == 0) {
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(""));
        }
        this.fDefaultQualified = element.getAttribute("elementFormDefault").equals("qualified");
        this.fCurrentScope = -1;
        this.checkTopLevelDuplicateNames(element);
        this.extractTopLevel3Components(element);
        object = XUtil.getFirstChildElement(element);
        while (object != null) {
            string = object.getNodeName();
            if (string.equals("annotation")) {
                this.traverseAnnotationDecl((Element)object);
            } else if (string.equals("simpleType")) {
                this.traverseSimpleTypeDecl((Element)object);
            } else if (string.equals("complexType")) {
                this.traverseComplexTypeDecl((Element)object);
            } else if (string.equals("element")) {
                this.traverseElementDecl((Element)object);
            } else if (!string.equals("attributeGroup") && !string.equals("attribute")) {
                if (string.equals("any")) {
                    this.traverseWildcardDecl((Element)object);
                } else if (!(string.equals("group") && object.getAttribute("ref").equals("") || string.equals("notation"))) {
                    if (string.equals("include")) {
                        this.traverseInclude((Element)object);
                    } else if (string.equals("import")) {
                        this.traverseImport((Element)object);
                    }
                }
            }
            object = XUtil.getNextSiblingElement((Node)object);
        }
    }

    public void endNamespaceDeclScope(int n) {
    }

    private int expandContentModel(int n, Element element) throws Exception {
        block9: {
            int n2;
            int n3;
            int n4;
            String string;
            String string2;
            block13: {
                block12: {
                    block11: {
                        block10: {
                            string2 = element.getAttribute("minOccurs");
                            string = element.getAttribute("maxOccurs");
                            n4 = 1;
                            n3 = 1;
                            if (string2.equals("")) {
                                string2 = "1";
                            }
                            if (string.equals("")) {
                                string = string2.equals("0") ? "1" : string2;
                            }
                            n2 = n;
                            if (string2.equals("1") && string.equals("1")) break block9;
                            if (!string2.equals("0") || !string.equals("1")) break block10;
                            n = this.fSchemaGrammar.addContentSpecNode(1, n, -1, false);
                            break block9;
                        }
                        if (!string2.equals("0") || !string.equals("unbounded")) break block11;
                        n = this.fSchemaGrammar.addContentSpecNode(2, n, -1, false);
                        break block9;
                    }
                    if (!string2.equals("1") || !string.equals("unbounded")) break block12;
                    n = this.fSchemaGrammar.addContentSpecNode(3, n, -1, false);
                    break block9;
                }
                if (!string.equals("unbounded")) break block13;
                try {
                    n4 = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    this.reportSchemaError(23, new Object[]{"illegal value for minOccurs : '" + exception.getMessage() + "' "});
                }
                n = this.fSchemaGrammar.addContentSpecNode(3, n, -1, false);
                int n5 = 0;
                while (n5 < n4 - 1) {
                    n = this.fSchemaGrammar.addContentSpecNode(5, n2, n, false);
                    ++n5;
                }
                break block9;
            }
            try {
                n4 = Integer.parseInt(string2);
                n3 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.reportSchemaError(23, new Object[]{"illegal value for minOccurs or maxOccurs : '" + exception.getMessage() + "' "});
            }
            int n6 = 0;
            while (n6 < n4 - 1) {
                n = this.fSchemaGrammar.addContentSpecNode(5, n, n2, false);
                ++n6;
            }
            if (n3 <= n4) break block9;
            int n7 = this.fSchemaGrammar.addContentSpecNode(2, n2, -1, false);
            int n8 = 0;
            while (n8 < n3 - n4) {
                n = this.fSchemaGrammar.addContentSpecNode(5, n, n7, false);
                ++n8;
            }
        }
        return n;
    }

    private String expandSystemId(String string, String string2) throws Exception {
        URL uRL;
        String string3 = string;
        if (string3 == null || string3.length() == 0) {
            return string;
        }
        try {
            uRL = new URL(string3);
            if (uRL != null) {
                return string;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        string3 = TraverseSchema.fixURI(string3);
        uRL = null;
        URL uRL2 = null;
        try {
            if (string2 == null) {
                String string4;
                try {
                    string4 = TraverseSchema.fixURI(System.getProperty("user.dir"));
                }
                catch (SecurityException securityException) {
                    string4 = "";
                }
                if (!string4.endsWith("/")) {
                    string4 = String.valueOf(string4) + "/";
                }
                uRL = new URL("file", "", string4);
            } else {
                uRL = new URL(string2);
            }
            uRL2 = new URL(uRL, string3);
        }
        catch (Exception exception) {}
        if (uRL2 == null) {
            return string;
        }
        return uRL2.toString();
    }

    private void extractTopLevel3Components(Element element) {
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string = element2.getNodeName();
            if (string.equals("attributeGroup")) {
                this.fSchemaGrammar.topLevelAttrGrpDecls.put(string, element2);
            } else if (string.equals("attribute")) {
                this.fSchemaGrammar.topLevelAttrDecls.put(string, element2);
            } else if (string.equals("group") && element2.getAttribute("ref").equals("")) {
                this.fSchemaGrammar.topLevelGroupDecls.put(string, element2);
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
    }

    private static String fixURI(String string) {
        char c;
        char c2;
        if ((string = string.replace(File.separatorChar, '/')).length() >= 2 && (c2 = string.charAt(1)) == ':' && (c = Character.toUpperCase(string.charAt(0))) >= 'A' && c <= 'Z') {
            string = "/" + string;
        }
        return string;
    }

    String getLocalPart(String string) {
        int n = string.indexOf(":");
        String string2 = string;
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    int getLocalPartIndex(String string) {
        int n = string.indexOf(":");
        String string2 = string;
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        return this.fStringPool.addSymbol(string2);
    }

    /*
     * Unable to fully structure code
     */
    private Element getTopLevelComponentByName(String var1_1, String var2_2) throws Exception {
        var3_3 = XUtil.getFirstChildElement(this.fSchemaRootElement);
        if (var3_3 != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            if (var3_3.getNodeName().equals(var1_1) && var3_3.getAttribute("name").equals(var2_2)) {
                return var3_3;
            }
            var3_3 = XUtil.getNextSiblingElement(var3_3);
lbl7:
            // 2 sources

            ** while (var3_3 != null)
        }
lbl8:
        // 1 sources

        return null;
    }

    ComplexTypeInfo getTypeInfoFromNS(String string, String string2) {
        Grammar grammar = this.fGrammarResolver.getGrammar(string);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar schemaGrammar = (SchemaGrammar)grammar;
            ComplexTypeInfo complexTypeInfo = (ComplexTypeInfo)this.fSchemaGrammar.getComplexTypeRegistry().get(String.valueOf(string) + "," + string2);
            return complexTypeInfo;
        }
        System.out.println("could not resolver URI : " + string + " to a SchemaGrammar in getTypeInfoFromNS");
        return null;
    }

    DatatypeValidator getTypeValidatorFromNS(String string, String string2) {
        Grammar grammar = this.fGrammarResolver.getGrammar(string);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar schemaGrammar = (SchemaGrammar)grammar;
            DatatypeValidator datatypeValidator = this.fSchemaGrammar.getDatatypeRegistry().getDatatypeValidator(string2);
            return datatypeValidator;
        }
        System.out.println("could not resolver URI : " + string + " to a SchemaGrammar in getTypeValidatorFromNS");
        return null;
    }

    private boolean isTopLevel(Element element) {
        return element.getParentNode().getNodeName().endsWith("schema");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Error: Usage java TraverseSchema yourFile.xsd");
            System.exit(0);
        }
        DOMParser dOMParser = new DOMParser(){

            public void ignorableWhitespace(int n) {
            }

            public void ignorableWhitespace(char[] cArray, int n, int n2) {
            }
        };
        dOMParser.setEntityResolver(new Resolver());
        dOMParser.setErrorHandler(new ErrorHandler());
        try {
            dOMParser.setFeature("http://xml.org/sax/features/validation", false);
            dOMParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        try {
            dOMParser.parse(stringArray[0]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        Document document = dOMParser.getDocument();
        OutputFormat outputFormat = new OutputFormat(document);
        StringWriter stringWriter = new StringWriter();
        XMLSerializer xMLSerializer = new XMLSerializer(stringWriter, outputFormat);
        TraverseSchema traverseSchema = null;
        try {
            Element element = document.getDocumentElement();
            traverseSchema = new TraverseSchema(element, new StringPool(), new SchemaGrammar(), new GrammarResolverImpl());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        dOMParser.getDocument();
    }

    private int parseBlockSet(String string) throws Exception {
        if (string.equals("#all")) {
            return 47;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("equivclass")) {
                if (n == 0) {
                    n = 32;
                    continue;
                }
                this.reportGenericSchemaError("'equivClass' already in set");
                continue;
            }
            if (string2.equals("extension")) {
                if (n == 0) {
                    n = 1;
                    continue;
                }
                this.reportGenericSchemaError("extension already in set");
                continue;
            }
            if (string2.equals("list")) {
                if (n == 0) {
                    n = 8;
                    continue;
                }
                this.reportGenericSchemaError("'list' already in set");
                continue;
            }
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction already in set");
                continue;
            }
            this.reportGenericSchemaError("Invalid final value (" + string + ")");
        }
        return n + n2 + n3;
    }

    private int parseComplexContent(String string) throws Exception {
        if (string.equals("empty")) {
            return 0;
        }
        if (string.equals("elementOnly")) {
            return 3;
        }
        if (string.equals("textOnly")) {
            return 4;
        }
        if (string.equals("mixed")) {
            return 2;
        }
        this.reportGenericSchemaError("Invalid value for content");
        return -1;
    }

    private int parseComplexDerivedBy(String string) throws Exception {
        if (string.equals("extension")) {
            return 1;
        }
        if (string.equals("restriction")) {
            return 2;
        }
        this.reportGenericSchemaError("ComplexType: Invalid value for 'derivedBy'");
        return -1;
    }

    private int parseDerivationSet(String string) throws Exception {
        if (string.equals("#all")) {
            return 7;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("extension")) {
                if (n == 0) {
                    n = 1;
                    continue;
                }
                this.reportGenericSchemaError("extension already in set");
                continue;
            }
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction already in set");
                continue;
            }
            this.reportGenericSchemaError("Invalid final value (" + string + ")");
        }
        return n + n2 + n3;
    }

    private int parseFinalSet(String string) throws Exception {
        if (string.equals("#all")) {
            return 47;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("equivclass")) {
                if (n == 0) {
                    n = 32;
                    continue;
                }
                this.reportGenericSchemaError("'equivClass' already in set");
                continue;
            }
            if (string2.equals("extension")) {
                if (n == 0) {
                    n = 1;
                    continue;
                }
                this.reportGenericSchemaError("extension already in set");
                continue;
            }
            if (string2.equals("list")) {
                if (n == 0) {
                    n = 8;
                    continue;
                }
                this.reportGenericSchemaError("'list' already in set");
                continue;
            }
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction already in set");
                continue;
            }
            this.reportGenericSchemaError("Invalid final value (" + string + ")");
        }
        return n + n2 + n3;
    }

    private int parseInt(String string) throws Exception {
        if (string.equals("*")) {
            return -1;
        }
        return Integer.parseInt(string);
    }

    private int parseSimpleDerivedBy(String string) throws Exception {
        if (string.equals("list")) {
            return 8;
        }
        if (string.equals("restriction")) {
            return 2;
        }
        this.reportGenericSchemaError("SimpleType: Invalid value for 'derivedBy'");
        return -1;
    }

    private int parseSimpleFinal(String string) throws Exception {
        if (string.equals("#all")) {
            return 30;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction in set twice");
                continue;
            }
            if (string2.equals("list")) {
                if (n3 == 0) {
                    n3 = 8;
                    continue;
                }
                this.reportGenericSchemaError("list in set twice");
                continue;
            }
            this.reportGenericSchemaError("Invalid value (" + string + ")");
        }
        return n + n2 + n3 + n4;
    }

    private void reportGenericSchemaError(String string) throws Exception {
        if (this.fErrorReporter == null) {
            System.err.println("__TraverseSchemaError__ : " + string);
        } else {
            this.reportSchemaError(23, new Object[]{string});
        }
    }

    private void reportSchemaError(int n, Object[] objectArray) throws Exception {
        if (this.fErrorReporter == null) {
            System.out.println("__TraverseSchemaError__ : " + SchemaMessageProvider.fgMessageKeys[n]);
            int n2 = 0;
            while (n2 < objectArray.length) {
                System.out.println((String)objectArray[n2]);
                ++n2;
            }
        } else {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", n, 0, objectArray, 1);
        }
    }

    private String resolvePrefixToURI(String string) throws Exception {
        String string2 = this.fStringPool.toString(this.fNamespacesScope.getNamespaceForPrefix(this.fStringPool.addSymbol(string)));
        if (string2 == null) {
            this.reportGenericSchemaError("prefix : [" + string + "] can not be resolved to a URI");
        }
        return string2;
    }

    public void setGrammarResolver(GrammarResolver grammarResolver) {
        this.fGrammarResolver = grammarResolver;
    }

    private void shift(int[] nArray, int n, int n2) {
        int n3 = nArray[n2];
        int n4 = n2;
        while (n4 > n) {
            nArray[n4] = nArray[n4 - 1];
            --n4;
        }
        nArray[n] = n3;
    }

    private void sort(int[] nArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2 - 1) {
            int n4 = n3;
            int n5 = n3 + 1;
            while (n5 < n + n2) {
                if (nArray[n5] < nArray[n4]) {
                    n4 = n5;
                }
                ++n5;
            }
            if (n4 != n3) {
                int n6 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n6;
            }
            ++n3;
        }
    }

    public void startNamespaceDeclScope(int n, int n2) {
    }

    private void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    int traverseAll(Element element) throws Exception {
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null && element2.getNodeName().equals("annotation")) {
            element2 = XUtil.getNextSiblingElement(element2);
        }
        int[] nArray = null;
        int n = 0;
        int n2 = -2;
        while (element2 != null) {
            Object object;
            int n3 = -2;
            boolean bl = false;
            String string = element2.getNodeName();
            if (string.equals("element")) {
                object = this.traverseElementDecl(element2);
                n3 = this.fSchemaGrammar.addContentSpecNode(0, ((QName)object).localpart, ((QName)object).uri, false);
                bl = true;
            } else if (string.equals("group")) {
                n3 = this.traverseGroupDecl(element2);
                bl = true;
            } else if (string.equals("choice")) {
                n3 = this.traverseChoice(element2);
                bl = true;
            } else if (string.equals("sequence")) {
                n3 = this.traverseSequence(element2);
                bl = true;
            } else {
                this.reportSchemaError(14, new Object[]{"group", string});
            }
            if (bl) {
                n3 = this.expandContentModel(n3, element2);
            }
            try {
                nArray[n] = n3;
            }
            catch (NullPointerException nullPointerException) {
                nArray = new int[32];
                nArray[n] = n3;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                object = new int[nArray.length * 2];
                System.arraycopy(nArray, 0, object, 0, nArray.length);
                nArray[n] = n3;
            }
            ++n;
            element2 = XUtil.getNextSiblingElement(element2);
        }
        n2 = this.buildAllModel(nArray, n);
        return n2;
    }

    private void traverseAnnotationDecl(Element element) {
    }

    private int traverseAttributeDecl(Element element, ComplexTypeInfo complexTypeInfo) throws Exception {
        Object object;
        int n = this.fStringPool.addSymbol(element.getAttribute("form"));
        int n2 = this.fStringPool.addSymbol(element.getAttribute("ID"));
        int n3 = this.fStringPool.addSymbol(element.getAttribute("name"));
        int n4 = this.fStringPool.addSymbol(element.getAttribute("ref"));
        int n5 = this.fStringPool.addSymbol(element.getAttribute("type"));
        int n6 = this.fStringPool.addSymbol(element.getAttribute("use"));
        int n7 = this.fStringPool.addSymbol(element.getAttribute("value"));
        String string = element.getAttribute("name");
        int n8 = this.fStringPool.addSymbol(string);
        String string2 = element.getAttribute("equivClass");
        DatatypeValidator datatypeValidator = null;
        int n9 = -1;
        boolean bl = false;
        int n10 = -1;
        String string3 = element.getAttribute("ref");
        String string4 = element.getAttribute("type");
        if (!string3.equals("")) {
            String string5;
            if (XUtil.getFirstChildElement(element) != null) {
                this.reportSchemaError(17, null);
            }
            String string6 = "";
            String string7 = string3;
            int n11 = string3.indexOf(":");
            if (n11 > 0) {
                string6 = string3.substring(0, n11);
                string7 = string3.substring(n11 + 1);
            }
            if (!(string5 = this.resolvePrefixToURI(string6)).equals(this.fTargetNSURIString)) {
                this.addAttributeDeclFromAnotherSchema(string7, string5, complexTypeInfo);
                return -1;
            }
            Element element2 = this.getTopLevelComponentByName("attribute", string7);
            if (element2 != null) {
                this.traverseAttributeDecl(element2, complexTypeInfo);
            } else {
                this.reportGenericSchemaError("Couldn't find top level attribute " + string3);
            }
            return -1;
        }
        if (string4.equals("")) {
            object = XUtil.getFirstChildElement(element);
            while (object != null && !object.getNodeName().equals("simpleType")) {
                object = XUtil.getNextSiblingElement((Node)object);
            }
            if (object != null && object.getNodeName().equals("simpleType")) {
                n9 = 7;
                n10 = this.traverseSimpleTypeDecl((Element)object);
            } else {
                n9 = 7;
                n10 = this.fStringPool.addSymbol("string");
            }
        } else {
            object = "";
            String string8 = string4;
            int n12 = string4.indexOf(":");
            if (n12 > 0) {
                object = string4.substring(0, n12);
                string8 = string4.substring(n12 + 1);
            }
            String string9 = this.resolvePrefixToURI((String)object);
            n10 = this.fStringPool.addSymbol(string8);
            if (string9.equals("http://www.w3.org/1999/XMLSchema")) {
                if (string8.equals("ID")) {
                    n9 = 3;
                } else if (string8.equals("IDREF")) {
                    n9 = 4;
                } else if (string8.equals("IDREFS")) {
                    n9 = 4;
                    bl = true;
                } else if (string8.equals("ENTITY")) {
                    n9 = 1;
                } else if (string8.equals("ENTITIES")) {
                    n9 = 1;
                    bl = true;
                } else if (string8.equals("NMTOKEN")) {
                    n9 = 5;
                } else if (string8.equals("NMTOKENS")) {
                    n9 = 5;
                    bl = true;
                } else {
                    n9 = string8.equals("notation") ? 6 : 7;
                }
            } else {
                if (!string9.equals(this.fTargetNSURIString)) {
                    datatypeValidator = this.getTypeValidatorFromNS(string9, string8);
                    if (datatypeValidator == null) {
                        System.out.println("Counld not find base type " + string8 + " in schema " + string9);
                    }
                } else {
                    datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(string8);
                }
                n9 = 7;
            }
        }
        int n13 = -1;
        int n14 = -1;
        String string10 = element.getAttribute("use");
        boolean bl2 = string10.equals("required");
        if (datatypeValidator == null) {
            datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(n10));
        }
        if (datatypeValidator == null) {
            this.reportGenericSchemaError("null validator for datatype : " + this.fStringPool.toString(n10));
        }
        if (bl2) {
            n13 = 2;
        } else {
            String string11;
            if (string10.equals("fixed")) {
                string11 = element.getAttribute("value");
                if (!string11.equals("")) {
                    n13 = 1;
                    n14 = this.fStringPool.addString(string11);
                }
            } else if (string10.equals("default")) {
                string11 = element.getAttribute("value");
                if (!string11.equals("")) {
                    n13 = 3;
                    n14 = this.fStringPool.addString(string11);
                }
            } else if (string10.equals("prohibited")) {
                n13 = this.fStringPool.addSymbol("#PROHIBITED");
                n14 = this.fStringPool.addString("");
            } else {
                n13 = 0;
            }
            if (n9 == 7 && n14 != -1) {
                try {
                    datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(string4);
                    if (datatypeValidator != null) {
                        datatypeValidator.validate(this.fStringPool.toString(n14), null);
                    } else {
                        this.reportSchemaError(2, new Object[]{string4});
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("Internal error in attribute datatype validation");
                }
            }
        }
        int n15 = -1;
        if (string2.equals("qualified") || this.fDefaultQualified || this.isTopLevel(element)) {
            n15 = this.fTargetNSURI;
        }
        QName qName = new QName(-1, n8, n8, n15);
        if (DEBUGGING) {
            System.out.println(" the dataType Validator for " + this.fStringPool.toString(n8) + " is " + datatypeValidator);
        }
        if (this.isTopLevel(element)) {
            this.fTempAttributeDecl.datatypeValidator = datatypeValidator;
            this.fTempAttributeDecl.name.setValues(qName);
            this.fTempAttributeDecl.type = n9;
            this.fTempAttributeDecl.defaultType = n13;
            if (n14 != -1) {
                this.fTempAttributeDecl.defaultValue = new String(this.fStringPool.toString(n14));
            }
            this.fAttributeDeclRegistry.put(string, new XMLAttributeDecl(this.fTempAttributeDecl));
        }
        this.fSchemaGrammar.addAttDef(complexTypeInfo.templateElementIndex, qName, n9, n10, n13, this.fStringPool.toString(n14), datatypeValidator);
        return -1;
    }

    private int traverseAttributeGroupDecl(Element element, ComplexTypeInfo complexTypeInfo) throws Exception {
        int n = this.fStringPool.addSymbol(element.getAttribute("name"));
        String string = element.getAttribute("ref");
        int n2 = -1;
        int n3 = -1;
        if (!string.equals("")) {
            String string2;
            if (XUtil.getFirstChildElement(element) != null) {
                this.reportSchemaError(17, null);
            }
            String string3 = "";
            String string4 = string;
            int n4 = string.indexOf(":");
            if (n4 > 0) {
                string3 = string.substring(0, n4);
                string4 = string.substring(n4 + 1);
            }
            if (!(string2 = this.resolvePrefixToURI(string3)).equals(this.fTargetNSURIString)) {
                this.traverseAttributeGroupDeclFromAnotherSchema(string4, string2, complexTypeInfo);
                return -1;
            }
            Element element2 = this.getTopLevelComponentByName("attributeGroup", string4);
            if (element2 != null) {
                this.traverseAttributeGroupDecl(element2, complexTypeInfo);
            } else {
                this.reportGenericSchemaError("Couldn't find top level attributegroup " + string);
            }
            return -1;
        }
        Element element3 = XUtil.getFirstChildElement(element);
        while (element3 != null) {
            if (element3.getNodeName().equals("attribute")) {
                this.traverseAttributeDecl(element3, complexTypeInfo);
            } else if (element3.getNodeName().equals("attributeGroup")) {
                this.traverseAttributeGroupDecl(element3, complexTypeInfo);
            } else {
                element3.getNodeName().equals("annotation");
            }
            element3 = XUtil.getNextSiblingElement(element3);
        }
        return -1;
    }

    private int traverseAttributeGroupDeclFromAnotherSchema(String string, String string2, ComplexTypeInfo complexTypeInfo) throws Exception {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found : " + string2);
            return -1;
        }
        Element element = (Element)schemaGrammar.topLevelAttrGrpDecls.get(string);
        if (element == null) {
            this.reportGenericSchemaError("no attribute group named \"" + string + "\" was defined in schema : " + string2);
            return -1;
        }
        int n = -1;
        int n2 = -1;
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            if (element2.getNodeName().equals("attribute")) {
                String string3 = element2.getAttribute("name");
                if (string3.length() > 0) {
                    Hashtable hashtable = schemaGrammar.getAttirubteDeclRegistry();
                    if (hashtable != null && hashtable.get(string3) != null) {
                        this.addAttributeDeclFromAnotherSchema(string3, string2, complexTypeInfo);
                        return -1;
                    }
                } else {
                    this.traverseAttributeDecl(element2, complexTypeInfo);
                }
            } else if (element2.getNodeName().equals("attributeGroup")) {
                this.traverseAttributeGroupDecl(element2, complexTypeInfo);
            } else {
                element2.getNodeName().equals("annotation");
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        return -1;
    }

    int traverseChoice(Element element) throws Exception {
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null && element2.getNodeName().equals("annotation")) {
            element2 = XUtil.getNextSiblingElement(element2);
        }
        int n = 0;
        int n2 = 0;
        n2 = 4;
        n = 3;
        int n3 = -2;
        int n4 = -2;
        boolean bl = false;
        while (element2 != null) {
            int n5 = -2;
            bl = true;
            boolean bl2 = false;
            String string = element2.getNodeName();
            if (string.equals("element")) {
                QName qName = this.traverseElementDecl(element2);
                n5 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                bl2 = true;
            } else if (string.equals("group")) {
                n5 = this.traverseGroupDecl(element2);
                bl2 = true;
            } else if (string.equals("choice")) {
                n5 = this.traverseChoice(element2);
                bl2 = true;
            } else if (string.equals("sequence")) {
                n5 = this.traverseSequence(element2);
                bl2 = true;
            } else {
                this.reportSchemaError(14, new Object[]{"group", string});
            }
            if (bl2) {
                n5 = this.expandContentModel(n5, element2);
            }
            if (n3 == -2) {
                n3 = n5;
            } else if (n4 == -2) {
                n4 = n5;
            } else {
                n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
                n4 = n5;
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (bl && n4 != -2) {
            n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
        }
        return n3;
    }

    private int traverseComplexTypeDecl(Element element) throws Exception {
        Object object;
        int n;
        int n2;
        int n3 = this.fStringPool.addSymbol(element.getAttribute("abstract"));
        String string = element.getAttribute("abstract");
        int n4 = this.fStringPool.addSymbol(element.getAttribute("base"));
        String string2 = element.getAttribute("base");
        int n5 = this.fStringPool.addSymbol(element.getAttribute("block"));
        String string3 = element.getAttribute("block");
        int n6 = this.fStringPool.addSymbol(element.getAttribute("content"));
        String string4 = element.getAttribute("content");
        int n7 = this.fStringPool.addSymbol(element.getAttribute("derivedBy"));
        String string5 = element.getAttribute("derivedBy");
        int n8 = this.fStringPool.addSymbol(element.getAttribute("final"));
        String string6 = element.getAttribute("final");
        int n9 = this.fStringPool.addSymbol(element.getAttribute("ID"));
        String string7 = element.getAttribute("ID");
        int n10 = this.fStringPool.addSymbol(element.getAttribute("name"));
        String string8 = element.getAttribute("name");
        boolean bl = false;
        if (DEBUGGING) {
            System.out.println("traversing complex Type : " + string8 + "," + string2 + "," + string4 + ".");
        }
        if (string8.equals("")) {
            string8 = "#" + this.fAnonTypeCount++;
        } else {
            this.fCurrentTypeNameStack.push(string8);
            bl = true;
        }
        int n11 = this.fScopeCount++;
        int n12 = this.fCurrentScope;
        this.fCurrentScope = n11;
        Element element2 = null;
        int n13 = -1;
        int n14 = 0;
        int n15 = -2;
        int n16 = -2;
        ComplexTypeInfo complexTypeInfo = null;
        DatatypeValidator datatypeValidator = null;
        DatatypeValidator datatypeValidator2 = null;
        int n17 = -1;
        String string9 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = false;
        int n18 = -1;
        Element element3 = null;
        if (string2.length() > 0) {
            if (string5.length() == 0) {
                this.reportGenericSchemaError("derivedBy must be present when base is present in complexType " + string8);
            } else {
                if (string5.equals("extension")) {
                    bl4 = false;
                }
                String string10 = "";
                String string11 = string2;
                n2 = string2.indexOf(":");
                if (n2 > 0) {
                    string10 = string2.substring(0, n2);
                    string11 = string2.substring(n2 + 1);
                }
                n = this.fStringPool.addSymbol(string11);
                object = this.resolvePrefixToURI(string10);
                if (!((String)object).equals(this.fTargetNSURIString) && !((String)object).equals("http://www.w3.org/1999/XMLSchema")) {
                    complexTypeInfo = this.getTypeInfoFromNS((String)object, string11);
                    if (complexTypeInfo == null) {
                        datatypeValidator = this.getTypeValidatorFromNS((String)object, string11);
                        if (datatypeValidator == null) {
                            System.out.println("Counld not find base type " + string11 + " in schema " + (String)object);
                        } else {
                            bl2 = true;
                        }
                    }
                } else {
                    string9 = String.valueOf(object) + "," + string11;
                    complexTypeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(string9);
                    if (complexTypeInfo == null) {
                        datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(string11);
                        if (datatypeValidator == null) {
                            element3 = this.getTopLevelComponentByName("complexType", string11);
                            if (element3 != null) {
                                n17 = this.traverseComplexTypeDecl(element3);
                                complexTypeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(n17));
                            } else {
                                element3 = this.getTopLevelComponentByName("simpleType", string11);
                                if (element3 != null) {
                                    n17 = this.traverseSimpleTypeDecl(element3);
                                    datatypeValidator2 = datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(string11);
                                    bl2 = true;
                                } else {
                                    this.reportGenericSchemaError("Base type could not be found : " + string2);
                                }
                            }
                        } else {
                            datatypeValidator2 = datatypeValidator;
                            bl2 = true;
                        }
                    }
                }
                if (bl2 && bl4) {
                    this.reportGenericSchemaError("base is a simpledType, can't derive by restriction in " + string8);
                }
                if (complexTypeInfo != null) {
                    if (complexTypeInfo.contentSpecHandle > -1) {
                        if (bl4) {
                            this.checkParticleDerivationOK(element, element3);
                        }
                        n18 = complexTypeInfo.contentSpecHandle;
                    } else if (complexTypeInfo.datatypeValidator != null) {
                        datatypeValidator = complexTypeInfo.datatypeValidator;
                        bl3 = true;
                    }
                }
                if (bl3 && !bl4) {
                    this.reportGenericSchemaError("base is ComplexSimple, can't derive by extension in " + string8);
                }
            }
        }
        element2 = null;
        if (bl3) {
            n13 = 4;
            int n19 = 0;
            int n20 = 0;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            Vector<String> vector = new Vector<String>();
            element2 = XUtil.getFirstChildElement(element);
            while (element2 != null && (element2.getNodeName().equals("minExclusive") || element2.getNodeName().equals("minInclusive") || element2.getNodeName().equals("maxExclusive") || element2.getNodeName().equals("maxInclusive") || element2.getNodeName().equals("precision") || element2.getNodeName().equals("scale") || element2.getNodeName().equals("length") || element2.getNodeName().equals("minLength") || element2.getNodeName().equals("maxLength") || element2.getNodeName().equals("encoding") || element2.getNodeName().equals("period") || element2.getNodeName().equals("duration") || element2.getNodeName().equals("enumeration") || element2.getNodeName().equals("pattern") || element2.getNodeName().equals("annotation"))) {
                if (element2.getNodeType() == 1) {
                    object = element2;
                    ++n20;
                    if (object.getNodeName().equals("enumeration")) {
                        ++n19;
                        vector.addElement(object.getAttribute("value"));
                        Element element4 = XUtil.getFirstChildElement((Node)object);
                        if (element4 != null && element4.getNodeName().equals("annotation")) {
                            this.traverseAnnotationDecl(element2);
                        }
                    } else {
                        hashtable.put(object.getNodeName(), object.getAttribute("value"));
                    }
                }
                element2 = XUtil.getNextSiblingElement(element2);
            }
            if (n19 > 0) {
                hashtable.put("enumeration", vector);
            }
            datatypeValidator2 = n20 > 0 ? this.fDatatypeRegistry.createDatatypeValidator(string8, datatypeValidator, hashtable, false) : datatypeValidator;
            if (element2 != null) {
                this.reportGenericSchemaError("Invalid child '" + element2.getNodeName() + "' in complexType : '" + string8 + "', because it restricts another complexSimpleType");
            }
        }
        if (string4.equals("textOnly")) {
            if (string2.length() == 0) {
                datatypeValidator2 = datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator("string");
            } else if (this.fDatatypeRegistry.getDatatypeValidator(string2) == null && complexTypeInfo.datatypeValidator == null) {
                this.reportSchemaError(5, new Object[]{string2});
            }
            n13 = 4;
        } else {
            if (!bl3) {
                n13 = 3;
            }
            n14 = 5;
            boolean bl6 = false;
            boolean bl7 = true;
            n2 = 0;
            n = 0;
            n15 = -2;
            n16 = -2;
            boolean bl8 = false;
            if (string4.equals("empty")) {
                n13 = 0;
                n = 1;
                bl7 = false;
                n15 = -1;
            } else if (string4.equals("mixed")) {
                n13 = 2;
                bl6 = true;
                bl7 = false;
                n14 = 4;
            } else if (string4.equals("elementOnly") || string4.equals("")) {
                bl7 = true;
            } else if (string4.equals("textOnly")) {
                n2 = 1;
                bl7 = false;
            }
            if (bl6) {
                n15 = this.fSchemaGrammar.addContentSpecNode(0, -1, -1, false);
                n14 = 4;
            }
            boolean bl9 = false;
            boolean bl10 = false;
            element2 = XUtil.getFirstChildElement(element);
            while (element2 != null) {
                int n21 = -2;
                bl8 = true;
                boolean bl11 = false;
                String string12 = element2.getNodeName();
                if (string12.equals("element")) {
                    if (bl6 || bl7) {
                        if (DEBUGGING) {
                            System.out.println(" child element name " + element2.getAttribute("name"));
                        }
                        QName qName = this.traverseElementDecl(element2);
                        n21 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                        bl11 = true;
                        bl9 = true;
                    } else {
                        this.reportSchemaError(9, null);
                    }
                } else if (string12.equals("group")) {
                    n21 = this.traverseGroupDecl(element2);
                    bl11 = true;
                    bl9 = true;
                } else if (string12.equals("all")) {
                    n21 = this.traverseAll(element2);
                    bl11 = true;
                    bl10 = true;
                } else if (string12.equals("choice")) {
                    n21 = this.traverseChoice(element2);
                    bl11 = true;
                    bl9 = true;
                } else if (string12.equals("sequence")) {
                    n21 = this.traverseSequence(element2);
                    bl11 = true;
                    bl9 = true;
                } else {
                    if (string12.equals("attribute") || string12.equals("attributeGroup")) break;
                    if (string12.equals("any")) {
                        n13 = this.fStringPool.addSymbol("ANY");
                        n15 = -1;
                    } else if (!string12.equals("annotation") && !bl3) {
                        if (string2.equals("")) {
                            this.reportSchemaError(12, null);
                        } else {
                            this.reportSchemaError(13, new Object[]{string12});
                        }
                    }
                }
                if (bl3 && bl11) {
                    this.reportGenericSchemaError("In complexType " + string8 + ", base type is complextype with simpleType content, can't have any particle children at all");
                    bl8 = false;
                    n21 = -2;
                    n15 = -2;
                    n13 = 4;
                    break;
                }
                if (bl11) {
                    n21 = this.expandContentModel(n21, element2);
                }
                if (bl10 && bl9) {
                    this.reportGenericSchemaError(" 'All' group needs to be the only child in Complextype : " + string8);
                }
                if (n15 == -2) {
                    n15 = n21;
                } else if (n16 == -2) {
                    n16 = n21;
                } else {
                    n15 = this.fSchemaGrammar.addContentSpecNode(n14, n15, n16, false);
                    n16 = n21;
                }
                element2 = XUtil.getNextSiblingElement(element2);
            }
            if (bl8 && n16 != -2) {
                n15 = this.fSchemaGrammar.addContentSpecNode(n14, n15, n16, false);
            }
            if (bl6 && bl8) {
                n15 = this.fSchemaGrammar.addContentSpecNode(2, n15, -1, false);
            }
        }
        if (!bl4 && n18 > -1) {
            n15 = this.fSchemaGrammar.addContentSpecNode(5, n18, n15, false);
        }
        if (string4.length() == 0 && string2.length() == 0 && n15 == -2) {
            n13 = 1;
        }
        if (DEBUGGING) {
            System.out.println("!!!!!>>>>>" + string8 + ", " + complexTypeInfo + ", " + n18 + ", " + n15 + ", " + n11);
        }
        ComplexTypeInfo complexTypeInfo2 = new ComplexTypeInfo();
        complexTypeInfo2.baseComplexTypeInfo = complexTypeInfo;
        complexTypeInfo2.baseDataTypeValidator = datatypeValidator;
        int n22 = -1;
        if (string5.length() > 0) {
            n22 = this.parseComplexDerivedBy(string5);
        }
        complexTypeInfo2.derivedBy = n22;
        complexTypeInfo2.scopeDefined = n11;
        complexTypeInfo2.contentSpecHandle = n15;
        complexTypeInfo2.contentType = n13;
        complexTypeInfo2.datatypeValidator = datatypeValidator2;
        complexTypeInfo2.blockSet = this.parseBlockSet(element.getAttribute("block"));
        complexTypeInfo2.finalSet = this.parseFinalSet(element.getAttribute("final"));
        n2 = this.fStringPool.addSymbol(string8);
        n = this.fStringPool.addSymbol("$" + string8);
        complexTypeInfo2.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, n, n2, this.fTargetNSURI), this.fTargetNSURI == -1 ? -1 : this.fCurrentScope, n11, n13, n15, -1, datatypeValidator2);
        complexTypeInfo2.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(complexTypeInfo2.templateElementIndex);
        element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string13 = element2.getNodeName();
            if (string13.equals("attribute")) {
                if ((bl3 || bl2) && bl4) {
                    this.reportGenericSchemaError("In complexType " + string8 + ", base type has simpleType content and derivation method is 'restriction', can't have any attribute children at all");
                    break;
                }
                this.traverseAttributeDecl(element2, complexTypeInfo2);
            } else if (string13.equals("attributeGroup")) {
                if ((bl3 || bl2) && bl4) {
                    this.reportGenericSchemaError("In complexType " + string8 + ", base type has simpleType content and derivation method is 'restriction', can't have any attribute children at all");
                    break;
                }
                this.traverseAttributeGroupDecl(element2, complexTypeInfo2);
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (complexTypeInfo != null && complexTypeInfo.attlistHead > -1) {
            int n23 = complexTypeInfo.attlistHead;
            while (n23 > -1) {
                this.fTempAttributeDecl.clear();
                this.fSchemaGrammar.getAttributeDecl(n23, this.fTempAttributeDecl);
                int n24 = this.fSchemaGrammar.getAttributeDeclIndex(complexTypeInfo2.templateElementIndex, this.fTempAttributeDecl.name);
                if (n24 > -1 && bl4) {
                    n23 = this.fSchemaGrammar.getNextAttributeDeclIndex(n23);
                    continue;
                }
                this.fSchemaGrammar.addAttDef(complexTypeInfo2.templateElementIndex, this.fTempAttributeDecl.name, this.fTempAttributeDecl.type, -1, this.fTempAttributeDecl.defaultType, this.fTempAttributeDecl.defaultValue, this.fTempAttributeDecl.datatypeValidator);
                n23 = this.fSchemaGrammar.getNextAttributeDeclIndex(n23);
            }
        }
        complexTypeInfo2.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(complexTypeInfo2.templateElementIndex);
        if (!string8.startsWith("#")) {
            string8 = String.valueOf(this.fTargetNSURIString) + "," + string8;
        }
        complexTypeInfo2.typeName = new String(string8);
        this.fComplexTypeRegistry.put(string8, complexTypeInfo2);
        this.fCurrentScope = n12;
        if (bl) {
            this.fCurrentTypeNameStack.pop();
            this.checkRecursingComplexType();
        }
        n2 = this.fStringPool.addSymbol(string8);
        return n2;
    }

    private QName traverseElementDecl(Element element) throws Exception {
        int n;
        Object object;
        int n2;
        Object object2;
        String string;
        int n3;
        int n4;
        int n5 = this.fStringPool.addSymbol(element.getAttribute("block"));
        int n6 = this.fStringPool.addSymbol(element.getAttribute("default"));
        int n7 = this.fStringPool.addSymbol(element.getAttribute("equivClass"));
        int n8 = this.fStringPool.addSymbol(element.getAttribute("final"));
        int n9 = this.fStringPool.addSymbol(element.getAttribute("fixed"));
        int n10 = this.fStringPool.addSymbol(element.getAttribute("form"));
        int n11 = this.fStringPool.addSymbol(element.getAttribute("ID"));
        int n12 = this.fStringPool.addSymbol(element.getAttribute("maxOccurs"));
        int n13 = this.fStringPool.addSymbol(element.getAttribute("minOccurs"));
        int n14 = this.fStringPool.addSymbol(element.getAttribute("name"));
        int n15 = this.fStringPool.addSymbol(element.getAttribute("nullable"));
        int n16 = this.fStringPool.addSymbol(element.getAttribute("ref"));
        int n17 = this.fStringPool.addSymbol(element.getAttribute("type"));
        int n18 = -1;
        int n19 = -1;
        int n20 = -1;
        int n21 = -2;
        DatatypeValidator datatypeValidator = null;
        String string2 = element.getAttribute("name");
        if (DEBUGGING) {
            System.out.println("traversing element decl : " + string2);
        }
        String string3 = element.getAttribute("ref");
        String string4 = element.getAttribute("type");
        String string5 = element.getAttribute("minOccurs");
        String string6 = element.getAttribute("maxOccurs");
        String string7 = element.getAttribute("default");
        String string8 = element.getAttribute("fixed");
        String string9 = element.getAttribute("equivClass");
        String string10 = element.getAttribute("equivClass");
        String string11 = null;
        if (this.isTopLevel(element) && (n4 = this.fSchemaGrammar.getElementDeclIndex(n3 = this.fStringPool.addSymbol(string2), -1)) > -1) {
            return new QName(-1, n3, n3, this.fTargetNSURI);
        }
        n3 = 0;
        if (!string3.equals("")) {
            ++n3;
        }
        if (!string4.equals("")) {
            ++n3;
        }
        if (n3 > 1) {
            this.reportSchemaError(16, null);
        }
        if (!string3.equals("")) {
            Element element2;
            if (XUtil.getFirstChildElement(element) != null) {
                this.reportSchemaError(17, null);
            }
            String string12 = "";
            String string13 = string3;
            int n22 = string3.indexOf(":");
            if (n22 > 0) {
                string12 = string3.substring(0, n22);
                string13 = string3.substring(n22 + 1);
            }
            int n23 = this.fStringPool.addSymbol(string13);
            String string14 = this.resolvePrefixToURI(string12);
            QName qName = new QName(this.fStringPool.addSymbol(string12), n23, this.fStringPool.addSymbol(string3), this.fStringPool.addSymbol(string14));
            if (!string14.equals(this.fTargetNSURIString)) {
                return qName;
            }
            int n24 = this.fSchemaGrammar.getElementDeclIndex(n23, -1);
            if (n24 == -1 && (element2 = this.getTopLevelComponentByName("element", string13)) == null) {
                this.reportGenericSchemaError("Element " + string13 + " not found in the Schema");
                return qName;
            }
            return qName;
        }
        Element element3 = null;
        if (string9.length() > 0 && (element3 = this.getTopLevelComponentByName("element", this.getLocalPart(string9))) == null) {
            this.reportGenericSchemaError("Equivclass affiliation element " + string9 + " in element declaration " + string2);
        }
        ComplexTypeInfo complexTypeInfo = null;
        Element element4 = XUtil.getFirstChildElement(element);
        while (element4 != null && element4.getNodeName().equals("annotation")) {
            element4 = XUtil.getNextSiblingElement(element4);
        }
        boolean bl = false;
        if (element4 != null) {
            string = element4.getNodeName();
            if (string.equals("complexType")) {
                if (element4.getAttribute("name").length() > 0) {
                    this.reportGenericSchemaError("anonymous complexType in element '" + string2 + "' has a name attribute");
                } else {
                    n20 = this.traverseComplexTypeDecl(element4);
                }
                if (n20 != -1) {
                    complexTypeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(n20));
                } else {
                    this.reportGenericSchemaError("traverse complexType error in element '" + string2 + "'");
                }
                bl = true;
            } else if (string.equals("simpleType")) {
                if (element4.getAttribute("name").length() > 0) {
                    this.reportGenericSchemaError("anonymous simpleType in element '" + string2 + "' has a name attribute");
                } else {
                    n20 = this.traverseSimpleTypeDecl(element4);
                }
                if (n20 != -1) {
                    datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(n20));
                } else {
                    this.reportGenericSchemaError("traverse simpleType error in element '" + string2 + "'");
                }
                n18 = 4;
                bl = true;
            } else if (string4.equals("")) {
                n18 = 1;
                n19 = -1;
            } else {
                System.out.println("unhandled case in TraverseElementDecl");
            }
        }
        if (bl && string4.length() > 0) {
            this.reportGenericSchemaError("Element '" + string2 + "' have both a type attribute and a annoymous type child");
        } else if (!string4.equals("")) {
            String string15;
            if (element3 != null) {
                this.checkEquivClassOK(element, element3);
            }
            string = "";
            object2 = string4;
            n2 = string4.indexOf(":");
            if (n2 > 0) {
                string = string4.substring(0, n2);
                object2 = string4.substring(n2 + 1);
            }
            if (!(string15 = this.resolvePrefixToURI(string)).equals(this.fTargetNSURIString) && !string15.equals("http://www.w3.org/1999/XMLSchema")) {
                string11 = string15;
                complexTypeInfo = this.getTypeInfoFromNS(string15, (String)object2);
                if (complexTypeInfo == null && (datatypeValidator = this.getTypeValidatorFromNS(string15, (String)object2)) == null) {
                    System.out.println("Counld not find base type " + (String)object2 + " in schema " + string15);
                }
            } else {
                complexTypeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(String.valueOf(string15) + "," + (String)object2);
                if (complexTypeInfo == null && (datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator((String)object2)) == null) {
                    object = this.getTopLevelComponentByName("complexType", (String)object2);
                    if (object != null) {
                        if (this.fCurrentTypeNameStack.search(object2) > -1) {
                            this.fElementRecurseComplex.put(String.valueOf(string2) + "," + this.fCurrentScope, object2);
                            return new QName(-1, this.fStringPool.addSymbol(string2), this.fStringPool.addSymbol(string2), -1);
                        }
                        n20 = this.traverseComplexTypeDecl((Element)object);
                        complexTypeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(n20));
                    } else {
                        object = this.getTopLevelComponentByName("simpleType", (String)object2);
                        if (object != null) {
                            n20 = this.traverseSimpleTypeDecl((Element)object);
                            datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator((String)object2);
                        } else {
                            this.reportGenericSchemaError("type not found : " + (String)object2);
                        }
                    }
                }
            }
        } else if (bl) {
            if (element3 != null) {
                this.checkEquivClassOK(element, element3);
            }
        } else if (element3 != null) {
            int n25 = this.fSchemaGrammar.getElementDeclIndex(this.getLocalPartIndex(string9), -1);
            if (n25 == -1) {
                this.traverseElementDecl(element3);
                n25 = this.fSchemaGrammar.getElementDeclIndex(this.getLocalPartIndex(string9), -1);
            }
            object2 = this.fSchemaGrammar.getElementComplexTypeInfo(n25);
        }
        if (complexTypeInfo == null && datatypeValidator == null) {
            this.reportGenericSchemaError("untyped element : " + string2);
        }
        if (complexTypeInfo != null) {
            n19 = complexTypeInfo.contentSpecHandle;
            n18 = complexTypeInfo.contentType;
            n21 = complexTypeInfo.scopeDefined;
            datatypeValidator = complexTypeInfo.datatypeValidator;
        }
        if (datatypeValidator != null) {
            n18 = 4;
        }
        int n26 = n = this.fStringPool.addSymbol(string2);
        n2 = -1;
        int n27 = this.fCurrentScope;
        if (string10.equals("qualified") || this.fDefaultQualified || this.isTopLevel(element)) {
            n2 = this.fTargetNSURI;
            n27 = -1;
        }
        if (this.fSchemaGrammar.getElementDeclIndex(n26, n27) > -1) {
            this.reportGenericSchemaError("duplicate element decl in the same scope : " + this.fStringPool.toString(n26));
        }
        object = new QName(-1, n26, n, n2);
        int n28 = -1;
        if (complexTypeInfo != null) {
            n28 = complexTypeInfo.attlistHead;
        }
        int n29 = this.fSchemaGrammar.addElementDecl((QName)object, n27, n21, n18, n19, n28, datatypeValidator);
        if (DEBUGGING) {
            System.out.println("########elementIndex:" + n29 + " " + element.getAttribute("name") + " eltType:" + string2 + " contentSpecType:" + n18 + " SpecNodeIndex:" + n19 + " enclosingScope: " + n27 + " scopeDefined: " + n21);
        }
        if (complexTypeInfo != null) {
            this.fSchemaGrammar.setElementComplexTypeInfo(n29, complexTypeInfo);
        } else {
            this.fSchemaGrammar.setElementComplexTypeInfo(n29, complexTypeInfo);
        }
        this.fSchemaGrammar.setElementFromAnotherSchemaURI(n29, string11);
        return object;
    }

    private int traverseGroupDecl(Element element) throws Exception {
        int n = this.fStringPool.addSymbol(element.getAttribute("ID"));
        int n2 = this.fStringPool.addSymbol(element.getAttribute("maxOccurs"));
        int n3 = this.fStringPool.addSymbol(element.getAttribute("minOccurs"));
        int n4 = this.fStringPool.addSymbol(element.getAttribute("ref"));
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("ref");
        if (!string2.equals("")) {
            if (XUtil.getFirstChildElement(element) != null) {
                this.reportSchemaError(17, null);
            }
            String string3 = "";
            String string4 = string2;
            int n5 = string2.indexOf(":");
            if (n5 > 0) {
                string3 = string2.substring(0, n5);
                string4 = string2.substring(n5 + 1);
            }
            int n6 = this.fStringPool.addSymbol(string4);
            String string5 = this.resolvePrefixToURI(string3);
            if (!string5.equals(this.fTargetNSURIString)) {
                return this.traverseGroupDeclFromAnotherSchema(string4, string5);
            }
            int n7 = -1;
            Element element2 = this.getTopLevelComponentByName("group", string4);
            if (element2 == null) {
                this.reportGenericSchemaError("Group " + string4 + " not found in the Schema");
                throw new Exception("Group " + string4 + " not found in the Schema");
            }
            n7 = this.traverseGroupDecl(element2);
            return n7;
        }
        boolean bl = true;
        if (this.fCurrentScope == -1) {
            bl = false;
        }
        Element element3 = XUtil.getFirstChildElement(element);
        while (element3 != null && element3.getNodeName().equals("annotation")) {
            element3 = XUtil.getNextSiblingElement(element3);
        }
        int n8 = 0;
        int n9 = 0;
        Object var12_17 = null;
        boolean bl2 = false;
        n9 = 5;
        n8 = 3;
        int n10 = -2;
        int n11 = -2;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        while (element3 != null) {
            int n12 = -2;
            bl3 = true;
            boolean bl6 = false;
            String string6 = element3.getNodeName();
            if (string6.equals("element")) {
                QName qName = this.traverseElementDecl(element3);
                n12 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                bl5 = true;
            } else if (string6.equals("group")) {
                n12 = this.traverseGroupDecl(element3);
                bl5 = true;
            } else if (string6.equals("all")) {
                n12 = this.traverseAll(element3);
                bl4 = true;
            } else if (string6.equals("choice")) {
                n12 = this.traverseChoice(element3);
                bl5 = true;
            } else if (string6.equals("sequence")) {
                n12 = this.traverseSequence(element3);
                bl5 = true;
            } else {
                bl6 = true;
                this.reportSchemaError(14, new Object[]{"group", string6});
            }
            if (!bl6) {
                n12 = this.expandContentModel(n12, element3);
            }
            if (bl5 && bl4) {
                this.reportSchemaError(14, new Object[]{"'all' needs to be 'the' only Child", string6});
            }
            if (n10 == -2) {
                n10 = n12;
            } else if (n11 == -2) {
                n11 = n12;
            } else {
                n10 = this.fSchemaGrammar.addContentSpecNode(n9, n10, n11, false);
                n11 = n12;
            }
            element3 = XUtil.getNextSiblingElement(element3);
        }
        if (bl3 && n11 != -2) {
            n10 = this.fSchemaGrammar.addContentSpecNode(n9, n10, n11, false);
        }
        return n10;
    }

    private int traverseGroupDeclFromAnotherSchema(String string, String string2) throws Exception {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found : " + string2);
            return -1;
        }
        Element element = (Element)schemaGrammar.topLevelGroupDecls.get(string);
        if (element == null) {
            this.reportGenericSchemaError("no group named \"" + string + "\" was defined in schema : " + string2);
            return -1;
        }
        boolean bl = true;
        if (this.fCurrentScope == -1) {
            bl = false;
        }
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null && element2.getNodeName().equals("annotation")) {
            element2 = XUtil.getNextSiblingElement(element2);
        }
        int n = 0;
        int n2 = 0;
        Object var9_9 = null;
        boolean bl2 = false;
        n2 = 5;
        n = 3;
        int n3 = -2;
        int n4 = -2;
        boolean bl3 = false;
        while (element2 != null) {
            int n5 = -2;
            bl3 = true;
            boolean bl4 = false;
            String string3 = element2.getNodeName();
            int n6 = this.fStringPool.addSymbol(string3);
            String string4 = element2.getAttribute("form");
            if (string3.equals("element")) {
                QName qName = this.traverseElementDecl(element2);
                n5 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                bl4 = true;
            } else if (string3.equals("group")) {
                n5 = this.traverseGroupDecl(element2);
                bl4 = true;
            } else if (string3.equals("all")) {
                n5 = this.traverseAll(element2);
                bl4 = true;
            } else if (string3.equals("choice")) {
                n5 = this.traverseChoice(element2);
                bl4 = true;
            } else if (string3.equals("sequence")) {
                n5 = this.traverseSequence(element2);
                bl4 = true;
            } else {
                this.reportSchemaError(14, new Object[]{"group", string3});
            }
            if (bl4) {
                n5 = this.expandContentModel(n5, element2);
            }
            if (n3 == -2) {
                n3 = n5;
            } else if (n4 == -2) {
                n4 = n5;
            } else {
                n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
                n4 = n5;
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (bl3 && n4 != -2) {
            n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
        }
        return n3;
    }

    private void traverseImport(Element element) throws Exception {
        String string = element.getAttribute("schemaLocation");
        string = this.expandSystemId(string, this.fCurrentSchemaURL);
        String string2 = element.getAttribute("namespace");
        SchemaGrammar schemaGrammar = new SchemaGrammar();
        if (this.fGrammarResolver.getGrammar(string2) != null) {
            schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        }
        if (this.fImportLocations.contains(string)) {
            return;
        }
        this.fImportLocations.addElement(string);
        DOMParser dOMParser = new DOMParser(){

            public void ignorableWhitespace(int n) {
            }

            public void ignorableWhitespace(char[] cArray, int n, int n2) {
            }
        };
        dOMParser.setEntityResolver(new Resolver());
        dOMParser.setErrorHandler(new ErrorHandler());
        try {
            dOMParser.setFeature("http://xml.org/sax/features/validation", false);
            dOMParser.setFeature("http://xml.org/sax/features/namespaces", true);
            dOMParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        try {
            dOMParser.parse(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        Document document = dOMParser.getDocument();
        Element element2 = null;
        if (document != null) {
            element2 = document.getDocumentElement();
        }
        if (element2 != null) {
            String string3 = element2.getAttribute("targetNamespace");
            if (!string3.equals(string2)) {
                this.reportGenericSchemaError("included schema '" + string + "' has a different targetNameSpace '" + string3 + "' from what is declared '" + string2 + "'.");
            } else {
                new TraverseSchema(element2, this.fStringPool, schemaGrammar, this.fGrammarResolver, this.fErrorReporter, string);
            }
        }
    }

    private void traverseInclude(Element element) throws Exception {
        String string = element.getAttribute("schemaLocation");
        if (this.fIncludeLocations.contains(string = this.expandSystemId(string, this.fCurrentSchemaURL))) {
            return;
        }
        this.fIncludeLocations.addElement(string);
        DOMParser dOMParser = new DOMParser(){

            public void ignorableWhitespace(int n) {
            }

            public void ignorableWhitespace(char[] cArray, int n, int n2) {
            }
        };
        dOMParser.setEntityResolver(new Resolver());
        dOMParser.setErrorHandler(new ErrorHandler());
        try {
            dOMParser.setFeature("http://xml.org/sax/features/validation", false);
            dOMParser.setFeature("http://xml.org/sax/features/namespaces", true);
            dOMParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        try {
            dOMParser.parse(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {}
        Document document = dOMParser.getDocument();
        Element element2 = null;
        if (document != null) {
            element2 = document.getDocumentElement();
        }
        if (element2 != null) {
            String string2 = element2.getAttribute("targetNamespace");
            if (string2.length() > 0 && !string2.equals(this.fTargetNSURIString)) {
                this.reportGenericSchemaError("included schema '" + string + "' has a different targetNameSpace '" + string2 + "'");
            } else {
                boolean bl = this.fDefaultQualified;
                int n = this.fCurrentScope;
                String string3 = this.fCurrentSchemaURL;
                this.fCurrentSchemaURL = string;
                this.traverseIncludedSchema(element2);
                this.fCurrentSchemaURL = string3;
                this.fCurrentScope = n;
                this.fDefaultQualified = bl;
            }
        }
    }

    private void traverseIncludedSchema(Element element) throws Exception {
        String string;
        Object object;
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        Attr attr = null;
        boolean bl = false;
        while ((attr = (Attr)namedNodeMap.item(n++)) != null) {
            object = attr.getName();
            if (((String)object).startsWith("xmlns:")) {
                string = attr.getValue();
                String string2 = ((String)object).substring(((String)object).indexOf(":") + 1);
                this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(string2), this.fStringPool.addSymbol(string));
            }
            if (!((String)object).equals("xmlns")) continue;
            string = attr.getValue();
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(string));
            bl = true;
        }
        if (!bl && this.fTargetNSURIString.length() == 0) {
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(""));
        }
        this.fDefaultQualified = element.getAttribute("elementFormDefault").equals("qualified");
        this.fCurrentScope = -1;
        this.checkTopLevelDuplicateNames(element);
        this.extractTopLevel3Components(element);
        object = XUtil.getFirstChildElement(element);
        while (object != null) {
            string = object.getNodeName();
            if (string.equals("annotation")) {
                this.traverseAnnotationDecl((Element)object);
            } else if (string.equals("simpleType")) {
                this.traverseSimpleTypeDecl((Element)object);
            } else if (string.equals("complexType")) {
                this.traverseComplexTypeDecl((Element)object);
            } else if (string.equals("element")) {
                this.traverseElementDecl((Element)object);
            } else if (!string.equals("attributeGroup") && !string.equals("attribute")) {
                if (string.equals("any")) {
                    this.traverseWildcardDecl((Element)object);
                } else if (!(string.equals("group") && object.getAttribute("ref").equals("") || string.equals("notation"))) {
                    if (string.equals("include")) {
                        this.traverseInclude((Element)object);
                    } else if (string.equals("import")) {
                        this.traverseImport((Element)object);
                    }
                }
            }
            object = XUtil.getNextSiblingElement((Node)object);
        }
    }

    int traverseSequence(Element element) throws Exception {
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null && element2.getNodeName().equals("annotation")) {
            element2 = XUtil.getNextSiblingElement(element2);
        }
        int n = 0;
        int n2 = 0;
        n2 = 5;
        n = 3;
        int n3 = -2;
        int n4 = -2;
        boolean bl = false;
        while (element2 != null) {
            int n5 = -2;
            bl = true;
            boolean bl2 = false;
            String string = element2.getNodeName();
            if (string.equals("element")) {
                QName qName = this.traverseElementDecl(element2);
                n5 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                bl2 = true;
            } else if (string.equals("group")) {
                n5 = this.traverseGroupDecl(element2);
                bl2 = true;
            } else if (string.equals("choice")) {
                n5 = this.traverseChoice(element2);
                bl2 = true;
            } else if (string.equals("sequence")) {
                n5 = this.traverseSequence(element2);
                bl2 = true;
            } else {
                this.reportSchemaError(14, new Object[]{"group", string});
            }
            if (bl2) {
                n5 = this.expandContentModel(n5, element2);
            }
            if (n3 == -2) {
                n3 = n5;
            } else if (n4 == -2) {
                n4 = n5;
            } else {
                n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
                n4 = n5;
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (bl && n4 != -2) {
            n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
        }
        return n3;
    }

    private int traverseSimpleTypeDecl(Element element) throws Exception {
        Object object;
        String string = element.getAttribute("derivedBy");
        if (string.length() == 0) {
            string = "restriction";
        }
        String string2 = element.getAttribute("name");
        String string3 = element.getAttribute("base");
        String string4 = element.getAttribute("abstract");
        int n = -1;
        n = string2.equals("") ? this.fStringPool.addSymbol("http://www.apache.org/xml/xerces/internalDatatype" + this.fSimpleTypeAnonCount++) : this.fStringPool.addSymbol(string2);
        DatatypeValidator datatypeValidator = null;
        if (string3 != null) {
            int n2 = this.fStringPool.addSymbol(string3);
            datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(string3);
            if (datatypeValidator == null) {
                this.reportSchemaError(15, new Object[]{element.getAttribute("base"), element.getAttribute("name")});
                return -1;
            }
        }
        Element element2 = XUtil.getFirstChildElement(element);
        int n3 = 0;
        Hashtable<String, Object> hashtable = null;
        if (element2 != null) {
            if (element2.getNodeName().equals("annotation")) {
                this.traverseAnnotationDecl(element2);
                element2 = XUtil.getNextSiblingElement(element2);
            }
            int n4 = 0;
            hashtable = new Hashtable<String, Object>();
            object = new Vector();
            while (element2 != null) {
                if (element2.getNodeType() == 1) {
                    Element element3 = element2;
                    ++n3;
                    if (element3.getNodeName().equals("enumeration")) {
                        ++n4;
                        String string5 = element3.getAttribute("value");
                        ((Vector)object).addElement(string5);
                        Element element4 = XUtil.getFirstChildElement(element3);
                        if (element4 != null && element4 != null && element4.getNodeName().equals("annotation")) {
                            this.traverseAnnotationDecl(element2);
                        }
                    } else {
                        hashtable.put(element3.getNodeName(), element3.getAttribute("value"));
                    }
                }
                element2 = XUtil.getNextSiblingElement(element2);
            }
            if (n4 > 0) {
                hashtable.put("enumeration", object);
            }
        }
        try {
            String string6 = this.fStringPool.toString(n);
            object = this.fDatatypeRegistry.getDatatypeValidator(string6);
            if (object == null) {
                boolean bl = string.equals("list");
                this.fDatatypeRegistry.createDatatypeValidator(string6, datatypeValidator, hashtable, bl);
            }
        }
        catch (Exception exception) {
            this.reportSchemaError(21, new Object[]{exception.getMessage()});
        }
        return n;
    }

    private int traverseWildcardDecl(Element element) throws Exception {
        int n = this.fStringPool.addSymbol(element.getAttribute("ID"));
        int n2 = this.fStringPool.addSymbol(element.getAttribute("maxOccurs"));
        int n3 = this.fStringPool.addSymbol(element.getAttribute("minOccurs"));
        int n4 = this.fStringPool.addSymbol(element.getAttribute("namespace"));
        int n5 = this.fStringPool.addSymbol(element.getAttribute("processContents"));
        int n6 = this.fStringPool.addSymbol(element.getAttribute("content"));
        return -1;
    }

    public class ComplexTypeInfo {
        public String typeName;
        public DatatypeValidator baseDataTypeValidator;
        public ComplexTypeInfo baseComplexTypeInfo;
        public int derivedBy;
        public int blockSet;
        public int finalSet;
        public int scopeDefined = -1;
        public int contentType;
        public int contentSpecHandle = -1;
        public int templateElementIndex = -1;
        public int attlistHead = -1;
        public DatatypeValidator datatypeValidator;
    }

    static class Resolver
    implements EntityResolver {
        private static final String[] SYSTEM = new String[]{"http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/structures.dtd", "http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/datatypes.dtd", "http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/versionInfo.ent"};
        private static final String[] PATH = new String[]{"structures.dtd", "datatypes.dtd", "versionInfo.ent"};

        Resolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws IOException {
            int n = 0;
            while (n < SYSTEM.length) {
                if (string2.equals(SYSTEM[n])) {
                    InputSource inputSource = new InputSource(this.getClass().getResourceAsStream(PATH[n]));
                    inputSource.setPublicId(string);
                    inputSource.setSystemId(string2);
                    return inputSource;
                }
                ++n;
            }
            return null;
        }
    }

    static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        ErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) {
            System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
            throw sAXParseException;
        }

        private String getLocationString(SAXParseException sAXParseException) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = sAXParseException.getSystemId();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getLineNumber());
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getColumnNumber());
            return stringBuffer.toString();
        }

        public void warning(SAXParseException sAXParseException) {
            System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }
    }
}

