/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.DOMExceptionImpl;
import org.apache.xerces.dom.DeepNodeListImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.NamedNodeMapImpl;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ElementImpl
extends NodeImpl
implements Element {
    static final long serialVersionUID = -7202454486126245907L;
    protected NamedNodeMapImpl attributes;
    protected String namespaceURI;
    protected String prefix;
    protected String localName;
    protected boolean enableNamespace = false;

    public ElementImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl, string, null);
        this.localName = string;
        this.syncData = true;
    }

    protected ElementImpl(DocumentImpl documentImpl, String string, String string2) {
        this.ownerDocument = documentImpl;
        this.namespaceURI = string;
        this.name = string2;
        int n = string2.indexOf(58);
        if (n < 0) {
            this.prefix = null;
            this.localName = string2;
        } else {
            this.prefix = string2.substring(0, n);
            this.localName = string2.substring(n + 1);
        }
        this.enableNamespace = true;
        this.syncData = true;
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeValue() {
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
        throw new DOMExceptionImpl(7, "NO_MODIFICATION_ALLOWED_ERR");
    }

    public NamedNodeMap getAttributes() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.attributes;
    }

    public Node cloneNode(boolean bl) {
        if (this.syncData) {
            this.synchronizeData();
        }
        ElementImpl elementImpl = (ElementImpl)super.cloneNode(bl);
        elementImpl.attributes = this.attributes.cloneMap();
        return elementImpl;
    }

    public String getValue() {
        return null;
    }

    public String getAttribute(String string) {
        Attr attr;
        if (this.syncData) {
            this.synchronizeData();
        }
        if ((attr = (Attr)this.attributes.getNamedItem(string)) == null) {
            return "";
        }
        return attr.getValue();
    }

    public Attr getAttributeNode(String string) {
        if (this.syncData) {
            this.synchronizeData();
        }
        return (Attr)this.attributes.getNamedItem(string);
    }

    public NodeList getElementsByTagName(String string) {
        return new DeepNodeListImpl(this, string);
    }

    public String getNamespaceURI() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.namespaceURI;
    }

    public String getPrefix() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.prefix;
    }

    public void setPrefix(String string) throws DOMException {
        if (this.syncData) {
            this.synchronizeData();
        }
        if (!DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, "INVALID_CHARACTER_ERR");
        }
        this.prefix = string;
        this.name = String.valueOf(string) + ":" + this.localName;
    }

    public String getLocalName() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.localName;
    }

    public String getTagName() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.name;
    }

    public void normalize() {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node2 != null && node.getNodeType() == 3 && node2.getNodeType() == 3) {
                ((Text)node).appendData(node2.getNodeValue());
                this.removeChild(node2);
                node2 = node;
            } else if (node.getNodeType() == 1) {
                ((Element)node).normalize();
            }
            node = node2;
        }
    }

    public void removeAttribute(String string) {
        AttrImpl attrImpl;
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "NO_MODIFICATION_ALLOWED_ERR");
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        if ((attrImpl = (AttrImpl)this.attributes.getNamedItem(string)) != null) {
            attrImpl.owned = false;
            this.attributes.removeNamedItem(string);
        }
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        AttrImpl attrImpl;
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "NO_MODIFICATION_ALLOWED_ERR");
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        if ((attrImpl = (AttrImpl)this.attributes.getNamedItem(attr.getName())) == attr) {
            this.attributes.removeNamedItem(attr.getName());
            attrImpl.owned = false;
            return attrImpl;
        }
        throw new DOMExceptionImpl(8, "NOT_FOUND_ERR");
    }

    public void setAttribute(String string, String string2) {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "NO_MODIFICATION_ALLOWED_ERR");
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        AttrImpl attrImpl = (AttrImpl)this.getOwnerDocument().createAttribute(string);
        attrImpl.setNodeValue(string2);
        this.attributes.setNamedItem(attrImpl);
        attrImpl.owned = true;
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "NO_MODIFICATION_ALLOWED_ERR");
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        if (!(attr instanceof AttrImpl)) {
            throw new DOMExceptionImpl(4, "WRONG_DOCUMENT_ERR");
        }
        AttrImpl attrImpl = (AttrImpl)attr;
        AttrImpl attrImpl2 = (AttrImpl)this.attributes.getNamedItem(attr.getName());
        this.attributes.setNamedItem(attrImpl);
        attrImpl.owned = true;
        return attrImpl2;
    }

    public String getAttributeNS(String string, String string2) {
        Attr attr;
        if (this.syncData) {
            this.synchronizeData();
        }
        if ((attr = (Attr)this.attributes.getNamedItemNS(string, string2)) == null) {
            return "";
        }
        return attr.getValue();
    }

    public void setAttributeNS(String string, String string2, String string3) {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "NO_MODIFICATION_ALLOWED_ERR");
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        AttrImpl attrImpl = (AttrImpl)((DocumentImpl)this.getOwnerDocument()).createAttributeNS(string, string2);
        attrImpl.setNodeValue(string3);
        this.attributes.setNamedItem(attrImpl);
        attrImpl.owned = true;
    }

    public void removeAttributeNS(String string, String string2) {
        AttrImpl attrImpl;
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "NO_MODIFICATION_ALLOWED_ERR");
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        if ((attrImpl = (AttrImpl)this.attributes.getNamedItemNS(string, string2)) != null) {
            attrImpl.owned = false;
            this.attributes.removeNamedItemNS(string, string2);
        }
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        if (this.syncData) {
            this.synchronizeData();
        }
        return (Attr)this.attributes.getNamedItemNS(string, string2);
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "NO_MODIFICATION_ALLOWED_ERR");
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        if (!(attr instanceof AttrImpl)) {
            throw new DOMExceptionImpl(4, "WRONG_DOCUMENT_ERR");
        }
        AttrImpl attrImpl = (AttrImpl)attr;
        AttrImpl attrImpl2 = (AttrImpl)this.attributes.getNamedItemNS(attrImpl.getNamespaceURI(), attrImpl.getLocalName());
        this.attributes.setNamedItem(attrImpl);
        attrImpl.owned = true;
        return attrImpl2;
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return new DeepNodeListImpl(this, string, string2);
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        super.setReadOnly(bl, bl2);
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        this.attributes.setReadOnly(bl, true);
    }

    protected void synchronizeData() {
        this.syncData = false;
        this.setupDefaultAttributes();
    }

    protected void setupDefaultAttributes() {
        ElementDefinitionImpl elementDefinitionImpl;
        NamedNodeMapImpl namedNodeMapImpl = null;
        DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)this.ownerDocument.getDoctype();
        if (documentTypeImpl != null && (elementDefinitionImpl = (ElementDefinitionImpl)documentTypeImpl.getElements().getNamedItem(this.getNodeName())) != null) {
            namedNodeMapImpl = (NamedNodeMapImpl)elementDefinitionImpl.getAttributes();
        }
        this.attributes = new NamedNodeMapImpl(this, namedNodeMapImpl);
    }
}

