/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.framework;

import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.StringPool;

public final class XMLDocumentScanner {
    static final char[] cdata_string = new char[]{'[', 'C', 'D', 'A', 'T', 'A', '['};
    static final char[] xml_string = new char[]{'x', 'm', 'l'};
    private static final char[] version_string = new char[]{'v', 'e', 'r', 's', 'i', 'o', 'n'};
    static final char[] doctype_string = new char[]{'D', 'O', 'C', 'T', 'Y', 'P', 'E'};
    private static final char[] standalone_string = new char[]{'s', 't', 'a', 'n', 'd', 'a', 'l', 'o', 'n', 'e'};
    private static final char[] encoding_string = new char[]{'e', 'n', 'c', 'o', 'd', 'i', 'n', 'g'};
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_FAILURE = -1;
    public static final int RESULT_DUPLICATE_ATTR = -2;
    static final int SCANNER_STATE_XML_DECL = 0;
    static final int SCANNER_STATE_START_OF_MARKUP = 1;
    static final int SCANNER_STATE_COMMENT = 2;
    static final int SCANNER_STATE_PI = 3;
    static final int SCANNER_STATE_DOCTYPE = 4;
    static final int SCANNER_STATE_PROLOG = 5;
    static final int SCANNER_STATE_ROOT_ELEMENT = 6;
    static final int SCANNER_STATE_CONTENT = 7;
    static final int SCANNER_STATE_REFERENCE = 8;
    static final int SCANNER_STATE_ATTRIBUTE_LIST = 9;
    static final int SCANNER_STATE_ATTRIBUTE_NAME = 10;
    static final int SCANNER_STATE_ATTRIBUTE_VALUE = 11;
    static final int SCANNER_STATE_TRAILING_MISC = 12;
    static final int SCANNER_STATE_END_OF_INPUT = 13;
    static final int SCANNER_STATE_TERMINATED = 14;
    ScannerDispatcher fDispatcher;
    EventHandler fEventHandler;
    StringPool fStringPool;
    XMLErrorReporter fErrorReporter;
    XMLEntityHandler fEntityHandler;
    XMLEntityHandler.EntityReader fEntityReader;
    XMLEntityHandler.CharBuffer fLiteralData;
    boolean fSeenRootElement = false;
    boolean fSeenDoctypeDecl = false;
    boolean fStandalone = false;
    boolean fParseTextDecl = false;
    int fScannerState = 0;
    int fReaderId = -1;
    int fAttValueReader = -1;
    int fAttValueElementType = -1;
    int fAttValueAttrName = -1;
    int fAttValueOffset = -1;
    int fAttValueMark = -1;
    int fScannerMarkupDepth;

    public XMLDocumentScanner(EventHandler eventHandler, StringPool stringPool, XMLErrorReporter xMLErrorReporter, XMLEntityHandler xMLEntityHandler, XMLEntityHandler.CharBuffer charBuffer) {
        this.fEventHandler = eventHandler;
        this.fStringPool = stringPool;
        this.fErrorReporter = xMLErrorReporter;
        this.fEntityHandler = xMLEntityHandler;
        this.fLiteralData = charBuffer;
        this.fDispatcher = new XMLDeclDispatcher();
    }

    public void reset(StringPool stringPool, XMLEntityHandler.CharBuffer charBuffer) throws Exception {
        this.fStringPool = stringPool;
        this.fLiteralData = charBuffer;
        this.fParseTextDecl = false;
        this.fSeenRootElement = false;
        this.fSeenDoctypeDecl = false;
        this.fStandalone = false;
        this.fDispatcher = new XMLDeclDispatcher();
        this.fScannerState = 0;
        this.fScannerMarkupDepth = 0;
    }

    public boolean parseSome(boolean bl) throws Exception {
        do {
            if (this.fDispatcher.dispatch(bl)) continue;
            return false;
        } while (bl);
        return true;
    }

    public void readerChange(XMLEntityHandler.EntityReader entityReader, int n) throws Exception {
        this.fEntityReader = entityReader;
        this.fReaderId = n;
        if (this.fScannerState == 11) {
            this.fAttValueMark = this.fAttValueOffset = this.fEntityReader.currentOffset();
        }
    }

    public void endOfInput(int n, boolean bl) throws Exception {
        this.fDispatcher.endOfInput(n, bl);
    }

    public boolean atEndOfInput() {
        return this.fScannerState == 13;
    }

    public int scanAttValue(int n, int n2, boolean bl) throws Exception {
        int n3;
        boolean bl2 = this.fEntityReader.lookingAtChar('\'', true);
        if (!bl2 && !this.fEntityReader.lookingAtChar('\"', true)) {
            this.reportFatalXMLError(13, 12, n, n2);
            return -1;
        }
        char c = bl2 ? (char)'\'' : '\"';
        this.fAttValueMark = this.fEntityReader.currentOffset();
        int n4 = this.fEntityReader.scanAttValue(c, bl);
        if (n4 >= 0) {
            return n4;
        }
        int n5 = this.setScannerState(11);
        this.fAttValueReader = this.fReaderId;
        this.fAttValueElementType = n;
        this.fAttValueAttrName = n2;
        this.fAttValueOffset = this.fEntityReader.currentOffset();
        int n6 = this.fLiteralData.length();
        if (this.fAttValueOffset - this.fAttValueMark > 0) {
            this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
        }
        this.fAttValueMark = this.fAttValueOffset;
        boolean bl3 = false;
        while (true) {
            if (this.fEntityReader.lookingAtChar(c, true)) {
                if (this.fReaderId == this.fAttValueReader) {
                    break;
                }
            } else if (!this.fEntityReader.lookingAtChar(' ', true)) {
                boolean bl4 = this.fEntityReader.lookingAtChar('\r', true);
                if (bl4 || this.fEntityReader.lookingAtSpace(true)) {
                    if (this.fAttValueOffset - this.fAttValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
                    }
                    bl3 = true;
                    this.fLiteralData.append(' ');
                } else if (this.fEntityReader.lookingAtChar('&', true)) {
                    if (this.fAttValueOffset - this.fAttValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
                    }
                    bl3 = true;
                    if (this.fEntityReader.lookingAtChar('#', true)) {
                        n3 = this.scanCharRef();
                        if (n3 != -1) {
                            if (n3 < 65536) {
                                this.fLiteralData.append((char)n3);
                            } else {
                                this.fLiteralData.append((char)((n3 - 65536 >> 10) + 55296));
                                this.fLiteralData.append((char)((n3 - 65536 & 0x3FF) + 56320));
                            }
                        }
                    } else {
                        n3 = this.fEntityReader.currentOffset();
                        this.fEntityReader.skipPastName(';');
                        int n7 = this.fEntityReader.currentOffset() - n3;
                        if (n7 == 0) {
                            this.reportFatalXMLError(14, 13);
                        } else if (!this.fEntityReader.lookingAtChar(';', true)) {
                            this.reportFatalXMLError(15, 14, this.fEntityReader.addString(n3, n7));
                        } else {
                            int n8 = this.fEntityReader.addSymbol(n3, n7);
                            this.fEntityHandler.startReadingFromEntity(n8, this.fScannerMarkupDepth, 0);
                        }
                    }
                } else if (this.fEntityReader.lookingAtChar('<', true)) {
                    if (this.fAttValueOffset - this.fAttValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
                    }
                    bl3 = true;
                    this.reportFatalXMLError(2, 11, n, n2);
                } else if (!this.fEntityReader.lookingAtValidChar(true)) {
                    if (this.fAttValueOffset - this.fAttValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
                    }
                    bl3 = true;
                    n3 = this.fEntityReader.scanInvalidChar();
                    if (this.fScannerState == 13) {
                        return -1;
                    }
                    if (n3 >= 0) {
                        this.reportFatalXMLError(12, 10, this.fStringPool.toString(n), this.fStringPool.toString(n2), Integer.toHexString(n3));
                    }
                }
            }
            this.fAttValueOffset = this.fEntityReader.currentOffset();
            if (!bl3) continue;
            this.fAttValueMark = this.fAttValueOffset;
            bl3 = false;
        }
        this.restoreScannerState(n5);
        n3 = this.fLiteralData.length() - n6;
        if (n3 == 0) {
            return this.fEntityReader.addString(this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
        }
        if (this.fAttValueOffset - this.fAttValueMark > 0) {
            this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
            n3 = this.fLiteralData.length() - n6;
        }
        return this.fLiteralData.addString(n6, n3);
    }

    public void checkXMLLangAttributeValue(int n) throws Exception {
        char c;
        String string = this.fStringPool.toString(n);
        int n2 = -1;
        if (string.length() >= 2) {
            c = string.charAt(0);
            if (string.charAt(1) == '-') {
                if (c == 'i' || c == 'I' || c == 'x' || c == 'X') {
                    n2 = 1;
                }
            } else {
                char c2 = string.charAt(1);
                if ((c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                    n2 = 2;
                }
            }
        }
        if (n2 > 0 && string.length() > n2) {
            if ((c = string.charAt(n2++)) != '-') {
                n2 = -1;
            } else {
                while (true) {
                    if (c == '-') {
                        if (string.length() == n2) {
                            n2 = -1;
                            break;
                        }
                        if (!((c = string.charAt(n2++)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                            n2 = -1;
                            break;
                        }
                        if (string.length() == n2) {
                            break;
                        }
                    } else {
                        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                            n2 = -1;
                            break;
                        }
                        if (string.length() == n2) break;
                    }
                    c = string.charAt(n2++);
                }
            }
        }
        if (n2 == -1) {
            this.reportFatalXMLError(65, 65, string);
        }
    }

    void reportFatalXMLError(int n, int n2) throws Exception {
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, null, 2);
    }

    void reportFatalXMLError(int n, int n2, int n3) throws Exception {
        Object[] objectArray = new Object[]{this.fStringPool.toString(n3)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 2);
    }

    void reportFatalXMLError(int n, int n2, String string) throws Exception {
        Object[] objectArray = new Object[]{string};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 2);
    }

    void reportFatalXMLError(int n, int n2, int n3, int n4) throws Exception {
        Object[] objectArray = new Object[]{this.fStringPool.toString(n3), this.fStringPool.toString(n4)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 2);
    }

    void reportFatalXMLError(int n, int n2, String string, String string2) throws Exception {
        Object[] objectArray = new Object[]{string, string2};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 2);
    }

    void reportFatalXMLError(int n, int n2, String string, String string2, String string3) throws Exception {
        Object[] objectArray = new Object[]{string, string2, string3};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 2);
    }

    void abortMarkup(int n, int n2) throws Exception {
        this.reportFatalXMLError(n, n2);
        this.skipPastEndOfCurrentMarkup();
    }

    void abortMarkup(int n, int n2, int n3) throws Exception {
        this.reportFatalXMLError(n, n2, n3);
        this.skipPastEndOfCurrentMarkup();
    }

    void abortMarkup(int n, int n2, String string) throws Exception {
        this.reportFatalXMLError(n, n2, string);
        this.skipPastEndOfCurrentMarkup();
    }

    void abortMarkup(int n, int n2, int n3, int n4) throws Exception {
        this.reportFatalXMLError(n, n2, n3, n4);
        this.skipPastEndOfCurrentMarkup();
    }

    void skipPastEndOfCurrentMarkup() throws Exception {
        this.fEntityReader.skipToChar('>');
        if (this.fEntityReader.lookingAtChar('>', true)) {
            --this.fScannerMarkupDepth;
        }
    }

    int setScannerState(int n) {
        int n2 = this.fScannerState;
        this.fScannerState = n;
        return n2;
    }

    void restoreScannerState(int n) {
        if (this.fScannerState != 13) {
            this.fScannerState = n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void scanXMLDeclOrTextDecl(boolean bl) throws Exception {
        int n;
        int n2;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        int n7 = 1;
        int n8 = 2;
        int n9 = 3;
        int n10 = 4;
        int n11 = n6;
        block9: do {
            int n12;
            this.fEntityReader.skipPastSpaces();
            n2 = this.fEntityReader.currentOffset();
            if (bl) {
                if (n11 == n6 && this.fEntityReader.skippedString(version_string)) {
                    n11 = n7;
                } else {
                    if (!this.fEntityReader.skippedString(encoding_string)) {
                        this.abortMarkup(29, 28);
                        return;
                    }
                    n11 = n8;
                }
            } else if (n11 == n6) {
                if (!this.fEntityReader.skippedString(version_string)) {
                    this.abortMarkup(30, 29);
                    return;
                }
                n11 = n7;
            } else {
                n11 = n11 == n7 ? (this.fEntityReader.skippedString(encoding_string) ? n8 : n9) : n9;
                if (n11 == n9 && !this.fEntityReader.skippedString(standalone_string)) break;
            }
            n = this.fEntityReader.currentOffset() - n2;
            this.fEntityReader.skipPastSpaces();
            if (!this.fEntityReader.lookingAtChar('=', true)) {
                int n13 = n12 = bl ? 32 : 31;
                int n14 = n11 == n7 ? 30 : (n11 == n8 ? 32 : 31);
                this.abortMarkup(n12, n14, this.fEntityReader.addString(n2, n));
                return;
            }
            this.fEntityReader.skipPastSpaces();
            n12 = this.fEntityReader.scanStringLiteral();
            switch (n12) {
                case -1: {
                    int n15;
                    int n16 = n15 = bl ? 34 : 33;
                    int n17 = n11 == n7 ? 33 : (n11 == n8 ? 35 : 34);
                    this.abortMarkup(n15, n17, this.fEntityReader.addString(n2, n));
                    return;
                }
                case -2: {
                    int n18 = this.fEntityReader.scanInvalidChar();
                    if (this.fScannerState != 13) {
                        if (n18 >= 0) {
                            int n19;
                            int n20 = n19 = bl ? 36 : 35;
                            int n21 = n11 == n7 ? 36 : (n11 == n8 ? 38 : 37);
                            this.reportFatalXMLError(n19, n21, Integer.toHexString(n18));
                        }
                        this.skipPastEndOfCurrentMarkup();
                    }
                    return;
                }
            }
            switch (n11) {
                case 1: {
                    Object[] objectArray;
                    n3 = n12;
                    String string = this.fStringPool.toString(n3);
                    if (!"1.0".equals(string)) {
                        if (!this.fEventHandler.validVersionNum(string)) {
                            this.abortMarkup(37, 39, string);
                            return;
                        }
                        objectArray = new Object[]{string};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 38, 40, objectArray, 1);
                    }
                    if (this.fEntityReader.lookingAtSpace(true)) continue block9;
                    if (bl) {
                        this.abortMarkup(39, 41);
                        return;
                    }
                    n11 = n10;
                    break;
                }
                case 2: {
                    n4 = n12;
                    Object[] objectArray = this.fStringPool.toString(n4);
                    if (!this.fEventHandler.validEncName((String)objectArray)) {
                        this.abortMarkup(40, 42, (String)objectArray);
                        return;
                    }
                    if (!this.fEntityReader.lookingAtSpace(true)) {
                        n11 = n10;
                        break;
                    }
                    if (!bl) continue block9;
                    this.fEntityReader.skipPastSpaces();
                    n11 = n10;
                    break;
                }
                case 3: {
                    n5 = n12;
                    String string = this.fStringPool.toString(n5);
                    boolean bl2 = "yes".equals(string);
                    if (!bl2 && !"no".equals(string)) {
                        this.abortMarkup(41, 43, string);
                        return;
                    }
                    this.fStandalone = bl2;
                    this.fEntityReader.skipPastSpaces();
                    n11 = n10;
                    break;
                }
            }
        } while (n11 != n10);
        if (!this.fEntityReader.lookingAtChar('?', true) || !this.fEntityReader.lookingAtChar('>', true)) {
            if (bl) {
                n2 = 43;
                n = 45;
            } else {
                n2 = 42;
                n = 44;
            }
            this.abortMarkup(n2, n);
            return;
        }
        --this.fScannerMarkupDepth;
        if (!bl) {
            this.fEventHandler.callStartDocument(n3, n4, n5);
        }
    }

    boolean scanElement(int n) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        bl = this.fEntityReader.lookingAtChar('>', true);
        if (!bl) {
            if (this.fEntityReader.lookingAtSpace(true)) {
                int n2;
                block13: {
                    n2 = this.setScannerState(9);
                    do {
                        this.fEntityReader.skipPastSpaces();
                        bl = this.fEntityReader.lookingAtChar('>', true);
                        if (bl || (bl2 = this.fEntityReader.lookingAtChar('/', true))) break block13;
                        this.setScannerState(10);
                        int n3 = this.fEventHandler.scanAttributeName(this.fEntityReader, n);
                        if (n3 == -1) break block13;
                        this.fEntityReader.skipPastSpaces();
                        if (!this.fEntityReader.lookingAtChar('=', true)) {
                            if (this.fScannerState != 13) {
                                this.abortMarkup(27, 26, n, n3);
                                this.restoreScannerState(n2);
                            }
                            return false;
                        }
                        this.fEntityReader.skipPastSpaces();
                        int n4 = this.fEventHandler.scanAttValue(n, n3);
                        if (n4 == -1) {
                            if (this.fScannerState != 13) {
                                this.skipPastEndOfCurrentMarkup();
                                this.restoreScannerState(n2);
                            }
                            return false;
                        }
                        if (n4 == -2) {
                            this.reportFatalXMLError(28, 27, n, n3);
                        }
                        this.restoreScannerState(9);
                    } while (this.fEntityReader.lookingAtSpace(true));
                    bl = this.fEntityReader.lookingAtChar('>', true);
                    if (!bl) {
                        bl2 = this.fEntityReader.lookingAtChar('/', true);
                    }
                }
                this.restoreScannerState(n2);
            } else {
                bl2 = this.fEntityReader.lookingAtChar('/', true);
            }
        }
        if (!(bl || bl2 && this.fEntityReader.lookingAtChar('>', true))) {
            if (this.fScannerState != 13) {
                this.abortMarkup(26, 25, n);
            }
            return false;
        }
        this.fEventHandler.callStartElement(n);
        --this.fScannerMarkupDepth;
        if (bl2) {
            this.fEventHandler.callEndElement(this.fReaderId);
            return false;
        }
        return true;
    }

    int scanCharRef() throws Exception {
        int n = this.fEntityReader.currentOffset();
        boolean bl = this.fEntityReader.lookingAtChar('x', true);
        int n2 = this.fEntityReader.scanCharRef(bl);
        if (n2 < 0) {
            switch (n2) {
                case -1: {
                    this.reportFatalXMLError(18, 17);
                    return -1;
                }
                case -2: {
                    int n3 = bl ? 17 : 16;
                    int n4 = bl ? 16 : 15;
                    this.reportFatalXMLError(n3, n4);
                    return -1;
                }
                case -3: {
                    n2 = 0x110000;
                    break;
                }
            }
        }
        if (n2 < 32 ? n2 == 9 || n2 == 10 || n2 == 13 : n2 <= 55295 || n2 >= 57344 && (n2 <= 65533 || n2 >= 65536 && n2 <= 0x10FFFF)) {
            return n2;
        }
        int n5 = this.fEntityReader.currentOffset() - n;
        this.reportFatalXMLError(11, 9, this.fEntityReader.addString(n, n5));
        return -1;
    }

    void scanComment() throws Exception {
        int n = this.fEntityReader.currentOffset();
        boolean bl = false;
        int n2 = this.setScannerState(2);
        while (this.fScannerState == 2) {
            int n3;
            if (this.fEntityReader.lookingAtChar('-', false)) {
                n3 = this.fEntityReader.currentOffset();
                int n4 = 0;
                this.fEntityReader.lookingAtChar('-', true);
                int n5 = this.fEntityReader.currentOffset();
                int n6 = 1;
                while (this.fEntityReader.lookingAtChar('-', true)) {
                    ++n6;
                    n4 = n3;
                    n3 = n5;
                    n5 = this.fEntityReader.currentOffset();
                }
                if (n6 <= 1) continue;
                if (this.fEntityReader.lookingAtChar('>', true)) {
                    if (!bl && n6 > 2) {
                        this.reportFatalXMLError(9, 7);
                        bl = true;
                    }
                    --this.fScannerMarkupDepth;
                    this.fEventHandler.callComment(this.fEntityReader.addString(n, n4 - n));
                    this.restoreScannerState(n2);
                    return;
                }
                if (bl) continue;
                this.reportFatalXMLError(9, 7);
                bl = true;
                continue;
            }
            if (this.fEntityReader.lookingAtValidChar(true)) continue;
            n3 = this.fEntityReader.scanInvalidChar();
            if (this.fScannerState == 13 || n3 < 0) continue;
            this.reportFatalXMLError(10, 8, Integer.toHexString(n3));
        }
        this.restoreScannerState(n2);
    }

    /*
     * Unable to fully structure code
     */
    void scanPI(int var1_1) throws Exception {
        block8: {
            block7: {
                var2_2 = this.fStringPool.toString(var1_1);
                if (!(var2_2.length() != 3 || var2_2.charAt(0) != 'X' && var2_2.charAt(0) != 'x' || var2_2.charAt(1) != 'M' && var2_2.charAt(1) != 'm' || var2_2.charAt(2) != 'L' && var2_2.charAt(2) != 'l')) {
                    this.abortMarkup(6, 4);
                    return;
                }
                var3_3 = this.setScannerState(3);
                var4_4 = -1;
                var5_5 = -1;
                if (this.fEntityReader.lookingAtSpace(true)) break block7;
                if (!this.fEntityReader.lookingAtChar('?', true) || !this.fEntityReader.lookingAtChar('>', true)) {
                    if (this.fScannerState != 13) {
                        this.abortMarkup(7, 5);
                        this.restoreScannerState(var3_3);
                    }
                    return;
                }
                var5_5 = 0;
                break block8;
            }
            this.fEntityReader.skipPastSpaces();
            var4_4 = this.fEntityReader.currentOffset();
            ** GOTO lbl38
            {
                block9: {
                    var6_6 = this.fEntityReader.currentOffset();
                    this.fEntityReader.lookingAtChar('?', true);
                    if (!this.fEntityReader.lookingAtChar('>', true)) break block9;
                    var5_5 = var6_6 - var4_4;
                    ** GOTO lbl29
                }
                do {
                    if (this.fEntityReader.lookingAtChar('?', false)) continue block0;
lbl29:
                    // 2 sources

                    if (var5_5 >= 0) break block0;
                    if (this.fEntityReader.lookingAtValidChar(true)) continue;
                    var6_6 = this.fEntityReader.scanInvalidChar();
                    if (this.fScannerState != 13) {
                        if (var6_6 >= 0) {
                            this.reportFatalXMLError(8, 6, Integer.toHexString(var6_6));
                        }
                        this.skipPastEndOfCurrentMarkup();
                        this.restoreScannerState(var3_3);
                    }
                    return;
lbl38:
                    // 2 sources

                } while (this.fScannerState == 3);
            }
        }
        --this.fScannerMarkupDepth;
        this.restoreScannerState(var3_3);
        var6_6 = var5_5 == 0 ? 0 : this.fEntityReader.addString(var4_4, var5_5);
        this.fEventHandler.callProcessingInstruction(var1_1, var6_6);
    }

    public interface EventHandler {
        public int scanElementType(XMLEntityHandler.EntityReader var1, char var2) throws Exception;

        public boolean scanExpectedElementType(XMLEntityHandler.EntityReader var1, char var2) throws Exception;

        public int scanAttributeName(XMLEntityHandler.EntityReader var1, int var2) throws Exception;

        public void callStartDocument(int var1, int var2, int var3) throws Exception;

        public void callEndDocument() throws Exception;

        public void callStartElement(int var1) throws Exception;

        public boolean callEndElement(int var1) throws Exception;

        public boolean validVersionNum(String var1) throws Exception;

        public boolean validEncName(String var1) throws Exception;

        public void startCDATA() throws Exception;

        public void endCDATA() throws Exception;

        public void callCharacters(int var1) throws Exception;

        public void callProcessingInstruction(int var1, int var2) throws Exception;

        public void callComment(int var1) throws Exception;

        public void scanDoctypeDecl(boolean var1) throws Exception;

        public int scanAttValue(int var1, int var2) throws Exception;
    }

    interface ScannerDispatcher {
        public boolean dispatch(boolean var1) throws Exception;

        public void endOfInput(int var1, boolean var2) throws Exception;
    }

    final class XMLDeclDispatcher
    implements ScannerDispatcher {
        /*
         * Enabled aggressive block sorting
         */
        public boolean dispatch(boolean bl) throws Exception {
            block19: {
                block20: {
                    if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('<', true)) break block20;
                    ++XMLDocumentScanner.this.fScannerMarkupDepth;
                    XMLDocumentScanner.this.setScannerState(1);
                    if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('?', true)) {
                        int n = XMLDocumentScanner.this.fEntityReader.scanName(' ');
                        if (n == -1) {
                            XMLDocumentScanner.this.abortMarkup(131, 105);
                        } else if ("xml".equals(XMLDocumentScanner.this.fStringPool.toString(n))) {
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                                XMLDocumentScanner.this.scanXMLDeclOrTextDecl(false);
                            } else {
                                XMLDocumentScanner.this.abortMarkup(6, 4);
                            }
                        } else {
                            XMLDocumentScanner.this.fEventHandler.callStartDocument(-1, -1, -1);
                            XMLDocumentScanner.this.scanPI(n);
                        }
                        XMLDocumentScanner.this.fEventHandler.callStartDocument(-1, -1, -1);
                        XMLDocumentScanner.this.fDispatcher = new PrologDispatcher();
                        XMLDocumentScanner.this.restoreScannerState(5);
                        return true;
                    }
                    XMLDocumentScanner.this.fEventHandler.callStartDocument(-1, -1, -1);
                    if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('!', true)) {
                        XMLDocumentScanner.this.fDispatcher = new ContentDispatcher();
                        XMLDocumentScanner.this.restoreScannerState(6);
                        return true;
                    }
                    if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                        if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                            XMLDocumentScanner.this.scanComment();
                            break block19;
                        } else {
                            XMLDocumentScanner.this.abortMarkup(129, 108);
                        }
                        break block19;
                    } else {
                        if (XMLDocumentScanner.this.fEntityReader.skippedString(doctype_string)) {
                            XMLDocumentScanner.this.setScannerState(4);
                            XMLDocumentScanner.this.fSeenDoctypeDecl = true;
                            XMLDocumentScanner.this.fEventHandler.scanDoctypeDecl(XMLDocumentScanner.this.fStandalone);
                            --XMLDocumentScanner.this.fScannerMarkupDepth;
                            XMLDocumentScanner.this.fDispatcher = new PrologDispatcher();
                            XMLDocumentScanner.this.restoreScannerState(5);
                            return true;
                        }
                        XMLDocumentScanner.this.abortMarkup(129, 108);
                    }
                    break block19;
                }
                XMLDocumentScanner.this.fEventHandler.callStartDocument(-1, -1, -1);
                if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                    XMLDocumentScanner.this.fEntityReader.skipPastSpaces();
                } else if (!XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(false)) {
                    int n = XMLDocumentScanner.this.fEntityReader.scanInvalidChar();
                    if (XMLDocumentScanner.this.fScannerState != 13 && n >= 0) {
                        String string = Integer.toHexString(n);
                        XMLDocumentScanner.this.reportFatalXMLError(52, 54, string);
                    }
                } else {
                    XMLDocumentScanner.this.reportFatalXMLError(129, 108);
                    XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(true);
                }
            }
            XMLDocumentScanner.this.fDispatcher = new PrologDispatcher();
            XMLDocumentScanner.this.restoreScannerState(5);
            return true;
        }

        public void endOfInput(int n, boolean bl) throws Exception {
            switch (XMLDocumentScanner.this.fScannerState) {
                case 2: {
                    if (!bl) {
                        XMLDocumentScanner.this.reportFatalXMLError(163, 133);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(162, 68);
                    break;
                }
                case 3: {
                    if (!bl) {
                        XMLDocumentScanner.this.reportFatalXMLError(164, 134);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(165, 68);
                    break;
                }
                default: {
                    throw new RuntimeException("1]ScannerState " + XMLDocumentScanner.this.fScannerState);
                }
                case 0: 
                case 1: 
                case 4: 
            }
            if (!bl) {
                XMLDocumentScanner.this.reportFatalXMLError(134, 107);
                XMLDocumentScanner.this.fDispatcher = new EndOfInputDispatcher();
                XMLDocumentScanner.this.setScannerState(13);
            }
        }

        XMLDeclDispatcher() {
            XMLDocumentScanner.this = XMLDocumentScanner.this;
        }
    }

    final class PrologDispatcher
    implements ScannerDispatcher {
        public boolean dispatch(boolean bl) throws Exception {
            do {
                int n;
                if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('<', true)) {
                    ++XMLDocumentScanner.this.fScannerMarkupDepth;
                    XMLDocumentScanner.this.setScannerState(1);
                    if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('?', true)) {
                        n = XMLDocumentScanner.this.fEntityReader.scanName(' ');
                        if (n == -1) {
                            XMLDocumentScanner.this.abortMarkup(131, 105);
                        } else if ("xml".equals(XMLDocumentScanner.this.fStringPool.toString(n))) {
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                                XMLDocumentScanner.this.abortMarkup(104, 137);
                            } else {
                                XMLDocumentScanner.this.abortMarkup(6, 4);
                            }
                        } else {
                            XMLDocumentScanner.this.scanPI(n);
                        }
                    } else if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('!', true)) {
                        if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                                XMLDocumentScanner.this.scanComment();
                            } else {
                                XMLDocumentScanner.this.abortMarkup(129, 108);
                            }
                        } else if (!XMLDocumentScanner.this.fSeenDoctypeDecl && XMLDocumentScanner.this.fEntityReader.skippedString(doctype_string)) {
                            XMLDocumentScanner.this.setScannerState(4);
                            XMLDocumentScanner.this.fSeenDoctypeDecl = true;
                            XMLDocumentScanner.this.fEventHandler.scanDoctypeDecl(XMLDocumentScanner.this.fStandalone);
                            --XMLDocumentScanner.this.fScannerMarkupDepth;
                        } else {
                            XMLDocumentScanner.this.abortMarkup(129, 108);
                        }
                    } else {
                        XMLDocumentScanner.this.fDispatcher = new ContentDispatcher();
                        XMLDocumentScanner.this.restoreScannerState(6);
                        return true;
                    }
                    XMLDocumentScanner.this.restoreScannerState(5);
                    continue;
                }
                if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                    XMLDocumentScanner.this.fEntityReader.skipPastSpaces();
                    continue;
                }
                if (!XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(false)) {
                    n = XMLDocumentScanner.this.fEntityReader.scanInvalidChar();
                    if (XMLDocumentScanner.this.fScannerState == 13 || n < 0) continue;
                    String string = Integer.toHexString(n);
                    XMLDocumentScanner.this.reportFatalXMLError(52, 54, string);
                    continue;
                }
                XMLDocumentScanner.this.reportFatalXMLError(129, 108);
                XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(true);
            } while (XMLDocumentScanner.this.fScannerState != 13 && bl);
            return true;
        }

        public void endOfInput(int n, boolean bl) throws Exception {
            switch (XMLDocumentScanner.this.fScannerState) {
                case 2: {
                    if (!bl) {
                        XMLDocumentScanner.this.reportFatalXMLError(163, 133);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(162, 68);
                    break;
                }
                case 3: {
                    if (!bl) {
                        XMLDocumentScanner.this.reportFatalXMLError(164, 134);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(165, 68);
                    break;
                }
                default: {
                    throw new RuntimeException("2]ScannerState " + XMLDocumentScanner.this.fScannerState);
                }
                case 1: 
                case 4: 
                case 5: 
            }
            if (!bl) {
                XMLDocumentScanner.this.reportFatalXMLError(134, 107);
                XMLDocumentScanner.this.fDispatcher = new EndOfInputDispatcher();
                XMLDocumentScanner.this.setScannerState(13);
            }
        }

        PrologDispatcher() {
            XMLDocumentScanner.this = XMLDocumentScanner.this;
        }
    }

    final class ContentDispatcher
    implements ScannerDispatcher {
        private int fContentReader = -1;
        private int fElementDepth;
        private int fCurrentElementType = -1;
        private int[] fElementTypeStack = new int[8];

        void popElementType() {
            if (this.fElementDepth-- == 0) {
                throw new RuntimeException("popElementType");
            }
            if (this.fElementDepth == 0) {
                this.fCurrentElementType = -1;
                return;
            }
            this.fCurrentElementType = this.fElementTypeStack[this.fElementDepth - 1];
        }

        public boolean dispatch(boolean bl) throws Exception {
            block19: do {
                block0 : switch (XMLDocumentScanner.this.fScannerState) {
                    case 6: {
                        int n = XMLDocumentScanner.this.fEventHandler.scanElementType(XMLDocumentScanner.this.fEntityReader, '>');
                        if (n != -1) {
                            this.fContentReader = XMLDocumentScanner.this.fReaderId;
                            XMLDocumentScanner.this.fSeenRootElement = true;
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                XMLDocumentScanner.this.fEventHandler.callStartElement(n);
                                --XMLDocumentScanner.this.fScannerMarkupDepth;
                                if (this.fElementDepth == this.fElementTypeStack.length) {
                                    int[] nArray = new int[this.fElementDepth * 2];
                                    System.arraycopy(this.fElementTypeStack, 0, nArray, 0, this.fElementDepth);
                                    this.fElementTypeStack = nArray;
                                }
                                this.fCurrentElementType = n;
                                this.fElementTypeStack[this.fElementDepth] = n;
                                ++this.fElementDepth;
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break;
                            }
                            if (XMLDocumentScanner.this.scanElement(n)) {
                                if (this.fElementDepth == this.fElementTypeStack.length) {
                                    int[] nArray = new int[this.fElementDepth * 2];
                                    System.arraycopy(this.fElementTypeStack, 0, nArray, 0, this.fElementDepth);
                                    this.fElementTypeStack = nArray;
                                }
                                this.fCurrentElementType = n;
                                this.fElementTypeStack[this.fElementDepth] = n;
                                ++this.fElementDepth;
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break;
                            }
                            XMLDocumentScanner.this.fDispatcher = new TrailingMiscDispatcher();
                            XMLDocumentScanner.this.restoreScannerState(12);
                            return true;
                        }
                        XMLDocumentScanner.this.reportFatalXMLError(129, 108);
                        XMLDocumentScanner.this.fDispatcher = new PrologDispatcher();
                        XMLDocumentScanner.this.restoreScannerState(5);
                        return true;
                    }
                    case 1: {
                        int n;
                        if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('?', true)) {
                            n = XMLDocumentScanner.this.fEntityReader.scanName(' ');
                            if (n == -1) {
                                XMLDocumentScanner.this.abortMarkup(131, 105);
                            } else if ("xml".equals(XMLDocumentScanner.this.fStringPool.toString(n))) {
                                if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                                    if (XMLDocumentScanner.this.fParseTextDecl) {
                                        XMLDocumentScanner.this.scanXMLDeclOrTextDecl(true);
                                        XMLDocumentScanner.this.fParseTextDecl = false;
                                    } else {
                                        XMLDocumentScanner.this.abortMarkup(105, 138);
                                    }
                                } else {
                                    XMLDocumentScanner.this.abortMarkup(6, 4);
                                }
                            } else {
                                XMLDocumentScanner.this.scanPI(n);
                            }
                            XMLDocumentScanner.this.restoreScannerState(7);
                        } else if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('!', true)) {
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                                if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                                    XMLDocumentScanner.this.scanComment();
                                } else {
                                    XMLDocumentScanner.this.abortMarkup(127, 110);
                                }
                            } else if (XMLDocumentScanner.this.fEntityReader.skippedString(cdata_string)) {
                                XMLDocumentScanner.this.fEntityReader.setInCDSect(true);
                                XMLDocumentScanner.this.fEventHandler.startCDATA();
                            } else {
                                XMLDocumentScanner.this.abortMarkup(127, 110);
                            }
                        } else if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('/', true)) {
                            if (!XMLDocumentScanner.this.fEventHandler.scanExpectedElementType(XMLDocumentScanner.this.fEntityReader, '>')) {
                                XMLDocumentScanner.this.abortMarkup(56, 58, this.fCurrentElementType);
                            } else {
                                if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                    XMLDocumentScanner.this.fEntityReader.skipPastSpaces();
                                    if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                        XMLDocumentScanner.this.reportFatalXMLError(57, 59, this.fCurrentElementType);
                                    }
                                }
                                --XMLDocumentScanner.this.fScannerMarkupDepth;
                                if (XMLDocumentScanner.this.fEventHandler.callEndElement(XMLDocumentScanner.this.fReaderId)) {
                                    XMLDocumentScanner.this.fDispatcher = new TrailingMiscDispatcher();
                                    XMLDocumentScanner.this.restoreScannerState(12);
                                    return true;
                                }
                                if (this.fElementDepth-- == 0) {
                                    throw new RuntimeException("popElementType");
                                }
                                this.fCurrentElementType = this.fElementDepth == 0 ? -1 : this.fElementTypeStack[this.fElementDepth - 1];
                            }
                        } else {
                            n = XMLDocumentScanner.this.fEventHandler.scanElementType(XMLDocumentScanner.this.fEntityReader, '>');
                            if (n != -1) {
                                if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                    XMLDocumentScanner.this.fEventHandler.callStartElement(n);
                                    --XMLDocumentScanner.this.fScannerMarkupDepth;
                                    if (this.fElementDepth == this.fElementTypeStack.length) {
                                        int[] nArray = new int[this.fElementDepth * 2];
                                        System.arraycopy(this.fElementTypeStack, 0, nArray, 0, this.fElementDepth);
                                        this.fElementTypeStack = nArray;
                                    }
                                    this.fCurrentElementType = n;
                                    this.fElementTypeStack[this.fElementDepth] = n;
                                    ++this.fElementDepth;
                                } else if (XMLDocumentScanner.this.scanElement(n)) {
                                    if (this.fElementDepth == this.fElementTypeStack.length) {
                                        int[] nArray = new int[this.fElementDepth * 2];
                                        System.arraycopy(this.fElementTypeStack, 0, nArray, 0, this.fElementDepth);
                                        this.fElementTypeStack = nArray;
                                    }
                                    this.fCurrentElementType = n;
                                    this.fElementTypeStack[this.fElementDepth] = n;
                                    ++this.fElementDepth;
                                }
                            } else {
                                XMLDocumentScanner.this.abortMarkup(127, 110);
                            }
                        }
                        XMLDocumentScanner.this.restoreScannerState(7);
                        break;
                    }
                    case 7: {
                        int n;
                        if (XMLDocumentScanner.this.fParseTextDecl && XMLDocumentScanner.this.fEntityReader.lookingAtChar('<', true)) {
                            ++XMLDocumentScanner.this.fScannerMarkupDepth;
                            XMLDocumentScanner.this.setScannerState(1);
                            break;
                        }
                        switch (XMLDocumentScanner.this.fEntityReader.scanContent(this.fCurrentElementType)) {
                            case 0: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                n = XMLDocumentScanner.this.fEntityReader.scanName(' ');
                                if (n == -1) {
                                    XMLDocumentScanner.this.abortMarkup(131, 105);
                                    break block0;
                                }
                                if ("xml".equals(XMLDocumentScanner.this.fStringPool.toString(n))) {
                                    if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                                        if (XMLDocumentScanner.this.fReaderId == this.fContentReader) {
                                            XMLDocumentScanner.this.abortMarkup(104, 137);
                                            break block0;
                                        }
                                        XMLDocumentScanner.this.abortMarkup(105, 138);
                                        break block0;
                                    }
                                    XMLDocumentScanner.this.abortMarkup(6, 4);
                                    break block0;
                                }
                                XMLDocumentScanner.this.scanPI(n);
                                break block0;
                            }
                            case 1: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.scanComment();
                                break block0;
                            }
                            case 2: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.fEntityReader.setInCDSect(true);
                                XMLDocumentScanner.this.fEventHandler.startCDATA();
                                break block0;
                            }
                            case 4: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                if (!XMLDocumentScanner.this.fEventHandler.scanExpectedElementType(XMLDocumentScanner.this.fEntityReader, '>')) {
                                    XMLDocumentScanner.this.abortMarkup(56, 58, this.fCurrentElementType);
                                } else {
                                    if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                        XMLDocumentScanner.this.fEntityReader.skipPastSpaces();
                                        if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                            XMLDocumentScanner.this.reportFatalXMLError(57, 59, this.fCurrentElementType);
                                        }
                                    }
                                    --XMLDocumentScanner.this.fScannerMarkupDepth;
                                    if (XMLDocumentScanner.this.fEventHandler.callEndElement(XMLDocumentScanner.this.fReaderId)) {
                                        XMLDocumentScanner.this.fDispatcher = new TrailingMiscDispatcher();
                                        XMLDocumentScanner.this.restoreScannerState(12);
                                        return true;
                                    }
                                    if (this.fElementDepth-- == 0) {
                                        throw new RuntimeException("popElementType");
                                    }
                                    this.fCurrentElementType = this.fElementDepth == 0 ? -1 : this.fElementTypeStack[this.fElementDepth - 1];
                                }
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break block0;
                            }
                            case 6: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                int n2 = XMLDocumentScanner.this.fEventHandler.scanElementType(XMLDocumentScanner.this.fEntityReader, '>');
                                if (n2 != -1) {
                                    if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                        XMLDocumentScanner.this.fEventHandler.callStartElement(n2);
                                        --XMLDocumentScanner.this.fScannerMarkupDepth;
                                        if (this.fElementDepth == this.fElementTypeStack.length) {
                                            int[] nArray = new int[this.fElementDepth * 2];
                                            System.arraycopy(this.fElementTypeStack, 0, nArray, 0, this.fElementDepth);
                                            this.fElementTypeStack = nArray;
                                        }
                                        this.fCurrentElementType = n2;
                                        this.fElementTypeStack[this.fElementDepth] = n2;
                                        ++this.fElementDepth;
                                    } else if (XMLDocumentScanner.this.scanElement(n2)) {
                                        if (this.fElementDepth == this.fElementTypeStack.length) {
                                            int[] nArray = new int[this.fElementDepth * 2];
                                            System.arraycopy(this.fElementTypeStack, 0, nArray, 0, this.fElementDepth);
                                            this.fElementTypeStack = nArray;
                                        }
                                        this.fCurrentElementType = n2;
                                        this.fElementTypeStack[this.fElementDepth] = n2;
                                        ++this.fElementDepth;
                                    }
                                } else {
                                    XMLDocumentScanner.this.abortMarkup(127, 110);
                                }
                                if (XMLDocumentScanner.this.fScannerState == 13) continue block19;
                                XMLDocumentScanner.this.fScannerState = 7;
                                break block0;
                            }
                            case 5: {
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                if (XMLDocumentScanner.this.fEventHandler.callEndElement(XMLDocumentScanner.this.fReaderId)) {
                                    if (XMLDocumentScanner.this.fScannerState != 13) {
                                        XMLDocumentScanner.this.fDispatcher = new TrailingMiscDispatcher();
                                        XMLDocumentScanner.this.fScannerState = 12;
                                    }
                                    return true;
                                }
                                if (this.fElementDepth-- == 0) {
                                    throw new RuntimeException("popElementType");
                                }
                                this.fCurrentElementType = this.fElementDepth == 0 ? -1 : this.fElementTypeStack[this.fElementDepth - 1];
                                if (XMLDocumentScanner.this.fScannerState == 13) continue block19;
                                XMLDocumentScanner.this.fScannerState = 7;
                                break block0;
                            }
                            case 7: {
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.setScannerState(8);
                                int n3 = XMLDocumentScanner.this.scanCharRef();
                                if (n3 != -1) {
                                    XMLDocumentScanner.this.fEventHandler.callCharacters(n3);
                                }
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break block0;
                            }
                            case 8: 
                            case 12: {
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.setScannerState(8);
                                int n4 = XMLDocumentScanner.this.fEntityReader.currentOffset();
                                XMLDocumentScanner.this.fEntityReader.skipPastName(';');
                                int n5 = XMLDocumentScanner.this.fEntityReader.currentOffset() - n4;
                                if (n5 == 0) {
                                    XMLDocumentScanner.this.reportFatalXMLError(14, 13);
                                    XMLDocumentScanner.this.restoreScannerState(7);
                                    break block0;
                                }
                                if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar(';', true)) {
                                    XMLDocumentScanner.this.reportFatalXMLError(15, 14, XMLDocumentScanner.this.fEntityReader.addString(n4, n5));
                                    XMLDocumentScanner.this.restoreScannerState(7);
                                    break block0;
                                }
                                XMLDocumentScanner.this.restoreScannerState(7);
                                int n6 = XMLDocumentScanner.this.fEntityReader.addSymbol(n4, n5);
                                XMLDocumentScanner.this.fParseTextDecl = XMLDocumentScanner.this.fEntityHandler.startReadingFromEntity(n6, this.fElementDepth, 2);
                                break block0;
                            }
                            case 3: {
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                if (XMLDocumentScanner.this.fEntityReader.getInCDSect()) {
                                    XMLDocumentScanner.this.fEntityReader.setInCDSect(false);
                                    XMLDocumentScanner.this.fEventHandler.endCDATA();
                                    --XMLDocumentScanner.this.fScannerMarkupDepth;
                                } else {
                                    XMLDocumentScanner.this.reportFatalXMLError(124, 104);
                                }
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break block0;
                            }
                            case 9: {
                                int n6;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                if (XMLDocumentScanner.this.fScannerState == 13) continue block19;
                                if (!XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(false)) {
                                    n6 = XMLDocumentScanner.this.fEntityReader.scanInvalidChar();
                                    if (XMLDocumentScanner.this.fScannerState != 13 && n6 >= 0) {
                                        if (XMLDocumentScanner.this.fEntityReader.getInCDSect()) {
                                            XMLDocumentScanner.this.reportFatalXMLError(54, 56, Integer.toHexString(n6));
                                        } else {
                                            XMLDocumentScanner.this.reportFatalXMLError(55, 57, Integer.toHexString(n6));
                                        }
                                    }
                                }
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break block0;
                            }
                            case 10: {
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.abortMarkup(127, 110);
                                break block0;
                            }
                            case 11: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.fScannerState = 1;
                                break block0;
                            }
                            default: {
                                throw new RuntimeException("3]ScannerState " + XMLDocumentScanner.this.fScannerState);
                            }
                        }
                    }
                    default: {
                        throw new RuntimeException("4]ScannerState " + XMLDocumentScanner.this.fScannerState);
                    }
                }
            } while (XMLDocumentScanner.this.fScannerState != 13 && bl);
            return true;
        }

        public void endOfInput(int n, boolean bl) throws Exception {
            switch (XMLDocumentScanner.this.fScannerState) {
                case 7: {
                    if (!XMLDocumentScanner.this.fEntityReader.getInCDSect()) break;
                    XMLDocumentScanner.this.reportFatalXMLError(66, 66);
                    break;
                }
                case 11: {
                    if (!bl) {
                        XMLDocumentScanner.this.reportFatalXMLError(151, 136, XMLDocumentScanner.this.fAttValueElementType, XMLDocumentScanner.this.fAttValueAttrName);
                        break;
                    }
                    if (XMLDocumentScanner.this.fReaderId == XMLDocumentScanner.this.fAttValueReader) break;
                    XMLDocumentScanner.this.fEntityReader.append(XMLDocumentScanner.this.fLiteralData, XMLDocumentScanner.this.fAttValueMark, XMLDocumentScanner.this.fAttValueOffset - XMLDocumentScanner.this.fAttValueMark);
                    break;
                }
                case 2: {
                    if (!bl) {
                        XMLDocumentScanner.this.reportFatalXMLError(163, 133);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(162, 68);
                    break;
                }
                case 3: {
                    if (!bl) {
                        XMLDocumentScanner.this.reportFatalXMLError(164, 134);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(165, 68);
                    break;
                }
                case 8: {
                    if (!bl) {
                        XMLDocumentScanner.this.reportFatalXMLError(166, 135);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(161, 68);
                    break;
                }
                default: {
                    throw new RuntimeException("5]ScannerState " + XMLDocumentScanner.this.fScannerState);
                }
                case 1: 
                case 6: 
                case 9: 
                case 10: 
            }
            if (!bl) {
                if (this.fElementDepth > 0) {
                    XMLDocumentScanner.this.reportFatalXMLError(56, 58, this.fCurrentElementType);
                }
                XMLDocumentScanner.this.fDispatcher = new EndOfInputDispatcher();
                XMLDocumentScanner.this.setScannerState(13);
            }
        }

        ContentDispatcher() {
            XMLDocumentScanner.this = XMLDocumentScanner.this;
        }
    }

    final class TrailingMiscDispatcher
    implements ScannerDispatcher {
        public boolean dispatch(boolean bl) throws Exception {
            do {
                int n;
                if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('<', true)) {
                    ++XMLDocumentScanner.this.fScannerMarkupDepth;
                    XMLDocumentScanner.this.setScannerState(1);
                    if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('?', true)) {
                        n = XMLDocumentScanner.this.fEntityReader.scanName(' ');
                        if (n == -1) {
                            XMLDocumentScanner.this.abortMarkup(131, 105);
                        } else if ("xml".equals(XMLDocumentScanner.this.fStringPool.toString(n))) {
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                                XMLDocumentScanner.this.abortMarkup(104, 137);
                            } else {
                                XMLDocumentScanner.this.abortMarkup(6, 4);
                            }
                        } else {
                            XMLDocumentScanner.this.scanPI(n);
                        }
                    } else if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('!', true)) {
                        if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true) && XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                            XMLDocumentScanner.this.scanComment();
                        } else {
                            XMLDocumentScanner.this.abortMarkup(128, 109);
                        }
                    } else {
                        XMLDocumentScanner.this.abortMarkup(128, 109);
                    }
                    XMLDocumentScanner.this.restoreScannerState(12);
                    continue;
                }
                if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                    XMLDocumentScanner.this.fEntityReader.skipPastSpaces();
                    continue;
                }
                if (!XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(false)) {
                    n = XMLDocumentScanner.this.fEntityReader.scanInvalidChar();
                    if (XMLDocumentScanner.this.fScannerState == 13 || n < 0) continue;
                    String string = Integer.toHexString(n);
                    XMLDocumentScanner.this.reportFatalXMLError(53, 55, string);
                    continue;
                }
                XMLDocumentScanner.this.reportFatalXMLError(128, 109);
                XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(true);
            } while (XMLDocumentScanner.this.fScannerState != 13 && bl);
            return true;
        }

        public void endOfInput(int n, boolean bl) throws Exception {
            if (bl) {
                throw new RuntimeException("TrailingMiscDispatcher.endOfInput moreToFollow");
            }
            switch (XMLDocumentScanner.this.fScannerState) {
                case 2: {
                    XMLDocumentScanner.this.reportFatalXMLError(163, 133);
                    break;
                }
                case 3: {
                    XMLDocumentScanner.this.reportFatalXMLError(164, 134);
                    break;
                }
                default: {
                    throw new RuntimeException("6]ScannerState " + XMLDocumentScanner.this.fScannerState);
                }
                case 1: 
                case 12: 
            }
            XMLDocumentScanner.this.fDispatcher = new EndOfInputDispatcher();
            XMLDocumentScanner.this.setScannerState(13);
        }

        TrailingMiscDispatcher() {
            XMLDocumentScanner.this = XMLDocumentScanner.this;
        }
    }

    final class EndOfInputDispatcher
    implements ScannerDispatcher {
        public boolean dispatch(boolean bl) throws Exception {
            if (XMLDocumentScanner.this.fScannerState != 14) {
                XMLDocumentScanner.this.fEventHandler.callEndDocument();
            }
            XMLDocumentScanner.this.setScannerState(14);
            return false;
        }

        public void endOfInput(int n, boolean bl) throws Exception {
            throw new RuntimeException("7]ScannerState " + XMLDocumentScanner.this.fScannerState);
        }

        EndOfInputDispatcher() {
            XMLDocumentScanner.this = XMLDocumentScanner.this;
        }
    }
}

