/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.MIME2Java;
import org.apache.xerces.readers.XMLDeclRecognizer;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReader;
import org.apache.xerces.readers.XMLEntityReaderFactory;
import org.apache.xerces.utils.ChunkyByteArray;
import org.apache.xerces.utils.StringPool;

final class UTF8Recognizer
extends XMLDeclRecognizer {
    public XMLEntityHandler.EntityReader recognize(XMLEntityReaderFactory xMLEntityReaderFactory, XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, StringPool stringPool, ChunkyByteArray chunkyByteArray, boolean bl2, boolean bl3) throws Exception {
        byte by;
        byte by2;
        XMLEntityHandler.EntityReader entityReader = null;
        byte by3 = chunkyByteArray.byteAt(0);
        if (by3 == 60 && (by2 = chunkyByteArray.byteAt(1)) == 63 && chunkyByteArray.byteAt(2) == 120 && chunkyByteArray.byteAt(3) == 109 && chunkyByteArray.byteAt(4) == 108 && ((by = chunkyByteArray.byteAt(5)) == 32 || by == 9 || by == 10 || by == 13)) {
            XMLDeclReader xMLDeclReader = new XMLDeclReader(xMLEntityHandler, xMLErrorReporter, bl, chunkyByteArray, stringPool);
            int n = this.prescanXMLDeclOrTextDecl(xMLDeclReader, bl2);
            if (n != -1) {
                String string = stringPool.orphanString(n);
                String string2 = string.toUpperCase();
                if ("ISO-10646-UCS-2".equals(string2)) {
                    throw new UnsupportedEncodingException(string);
                }
                if ("ISO-10646-UCS-4".equals(string2)) {
                    throw new UnsupportedEncodingException(string);
                }
                if ("UTF-16".equals(string2)) {
                    throw new UnsupportedEncodingException(string);
                }
                String string3 = MIME2Java.convert(string2);
                if (string3 == null) {
                    if (bl3) {
                        string3 = string;
                    } else {
                        throw new UnsupportedEncodingException(string);
                    }
                }
                try {
                    chunkyByteArray.rewind();
                    if ("UTF-8".equalsIgnoreCase(string3) || "UTF8".equalsIgnoreCase(string3)) {
                        entityReader = xMLEntityReaderFactory.createUTF8Reader(xMLEntityHandler, xMLErrorReporter, bl, chunkyByteArray, stringPool);
                    }
                    entityReader = xMLEntityReaderFactory.createCharReader(xMLEntityHandler, xMLErrorReporter, bl, new InputStreamReader((InputStream)chunkyByteArray, string3), stringPool);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new UnsupportedEncodingException(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                chunkyByteArray.rewind();
                entityReader = xMLEntityReaderFactory.createUTF8Reader(xMLEntityHandler, xMLErrorReporter, bl, chunkyByteArray, stringPool);
            }
        }
        return entityReader;
    }

    UTF8Recognizer() {
    }

    final class XMLDeclReader
    extends XMLEntityReader {
        private StringPool fStringPool;
        private ChunkyByteArray fData;

        XMLDeclReader(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, ChunkyByteArray chunkyByteArray, StringPool stringPool) {
            super(xMLEntityHandler, xMLErrorReporter, bl);
            UTF8Recognizer.this = UTF8Recognizer.this;
            this.fStringPool = stringPool;
            this.fData = chunkyByteArray;
        }

        public boolean lookingAtChar(char c, boolean bl) throws IOException {
            if (this.fData.byteAt(this.fCurrentOffset) != c) {
                return false;
            }
            if (bl) {
                ++this.fCurrentOffset;
            }
            return true;
        }

        public boolean lookingAtSpace(boolean bl) throws IOException {
            int n = this.fData.byteAt(this.fCurrentOffset) & 0xFF;
            if (n != 32 && n != 9 && n != 10 && n != 13) {
                return false;
            }
            if (bl) {
                ++this.fCurrentOffset;
            }
            return true;
        }

        public void skipPastSpaces() throws IOException {
            int n;
            while ((n = this.fData.byteAt(this.fCurrentOffset) & 0xFF) == 32 || n == 9 || n == 10 || n == 13) {
                ++this.fCurrentOffset;
            }
            return;
        }

        public boolean skippedString(char[] cArray) throws IOException {
            int n = this.fCurrentOffset;
            int n2 = 0;
            while (n2 < cArray.length) {
                if (this.fData.byteAt(n) != cArray[n2]) {
                    return false;
                }
                ++n;
                ++n2;
            }
            this.fCurrentOffset = n;
            return true;
        }

        public int scanStringLiteral() throws Exception {
            int n;
            int n2;
            boolean bl = this.lookingAtChar('\'', true);
            if (!bl && !this.lookingAtChar('\"', true)) {
                return -1;
            }
            int n3 = this.fCurrentOffset;
            int n4 = n2 = bl ? 39 : 34;
            while ((n = this.fData.byteAt(this.fCurrentOffset)) != n2) {
                if (n == -1) {
                    return -1;
                }
                ++this.fCurrentOffset;
            }
            n = this.fCurrentOffset - n3;
            StringBuffer stringBuffer = new StringBuffer(n);
            int n5 = 0;
            while (n5 < n) {
                stringBuffer.append((char)this.fData.byteAt(n3 + n5));
                ++n5;
            }
            int n6 = this.fStringPool.addString(stringBuffer.toString());
            ++this.fCurrentOffset;
            return n6;
        }

        public void append(XMLEntityHandler.CharBuffer charBuffer, int n, int n2) {
            throw new RuntimeException("cannot happen 7");
        }

        public int addString(int n, int n2) {
            throw new RuntimeException("cannot happen 8");
        }

        public int addSymbol(int n, int n2) {
            throw new RuntimeException("cannot happen 9");
        }

        public void skipToChar(char c) throws IOException {
            throw new IOException("cannot happen 10");
        }

        public void skipPastName(char c) throws IOException {
            throw new IOException("cannot happen 11");
        }

        public void skipPastNmtoken(char c) throws IOException {
            throw new IOException("cannot happen 12");
        }

        public boolean lookingAtValidChar(boolean bl) throws IOException {
            throw new IOException("cannot happen 13");
        }

        public int scanInvalidChar() throws IOException {
            throw new IOException("cannot happen 14");
        }

        public int scanCharRef(boolean bl) throws IOException {
            throw new IOException("cannot happen 15");
        }

        public int scanAttValue(char c, boolean bl) throws IOException {
            throw new IOException("cannot happen 15.2");
        }

        public int scanEntityValue(int n, boolean bl) throws IOException {
            throw new IOException("cannot happen 15.3");
        }

        public boolean scanExpectedName(char c, StringPool.CharArrayRange charArrayRange) throws IOException {
            throw new IOException("cannot happen 16.1");
        }

        public int scanQName(char c) throws IOException {
            throw new IOException("cannot happen 16.2");
        }

        public int scanName(char c) throws IOException {
            throw new IOException("cannot happen 16.3");
        }

        public int scanContent(int n) throws IOException {
            throw new IOException("cannot happen 17");
        }
    }
}

