/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.IllegalFacetException;
import org.apache.xerces.validators.datatype.IllegalFacetValueException;
import org.apache.xerces.validators.datatype.InternalDatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.UnknownFacetException;

public class IntegerValidator
implements InternalDatatypeValidator {
    int fMaxInclusive;
    boolean fIsMaxInclusive = false;
    int fMaxExclusive;
    boolean fIsMaxExclusive = false;
    int fMinInclusive;
    boolean fIsMinInclusive = false;
    int fMinExclusive;
    boolean fIsMinExclusive = false;
    int[] fEnumValues;
    boolean fHasEnums = false;
    IntegerValidator fBaseValidator;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();
    private Locale fLocale;

    public void validate(String string) throws InvalidDatatypeValueException {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException(this.getErrorString(11, 0, new Object[]{string}));
        }
        this.boundsCheck(n);
        if (this.fHasEnums) {
            this.enumCheck(n);
        }
    }

    public void validate(int n) throws InvalidDatatypeValueException {
    }

    boolean ensureFacetsAreConsistent(Hashtable hashtable) {
        boolean bl = true;
        Enumeration enumeration = hashtable.keys();
        while (bl && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = null;
            if (string.equals("enumeration")) continue;
            string2 = (String)hashtable.get(string);
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (string.equals("minInclusive") && this.fIsMinInclusive) {
                bl = this.fMinInclusive <= n;
                continue;
            }
            if (string.equals("minExclusive") && this.fIsMinExclusive) {
                bl = this.fMinExclusive < n;
                continue;
            }
            if (string.equals("maxInclusive") && this.fIsMaxInclusive) {
                bl = this.fMaxInclusive >= n;
                continue;
            }
            if (!string.equals("maxExclusive") || !this.fIsMaxExclusive) continue;
            boolean bl2 = bl = this.fMaxExclusive > n;
        }
        return bl;
    }

    public void setFacets(Hashtable hashtable) throws UnknownFacetException, IllegalFacetException, IllegalFacetValueException {
        Object object;
        if (this.fBaseValidator != null && !this.fBaseValidator.ensureFacetsAreConsistent(hashtable)) {
            throw new IllegalFacetValueException(this.getErrorString(4, 0, null));
        }
        this.fHasEnums = false;
        this.fIsMaxExclusive = false;
        this.fIsMaxInclusive = false;
        this.fIsMinExclusive = false;
        this.fIsMinInclusive = false;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = null;
            if (((String)object).equals("enumeration")) continue;
            string = (String)hashtable.get(object);
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalFacetValueException(this.getErrorString(5, 0, new Object[]{string, object}));
            }
            if (((String)object).equals("minInclusive")) {
                this.fIsMinInclusive = true;
                this.fMinInclusive = n;
                continue;
            }
            if (((String)object).equals("minExclusive")) {
                this.fIsMinExclusive = true;
                this.fMinExclusive = n;
                continue;
            }
            if (((String)object).equals("maxInclusive")) {
                this.fIsMaxInclusive = true;
                this.fMaxInclusive = n;
                continue;
            }
            if (((String)object).equals("maxExclusive")) {
                this.fIsMaxExclusive = true;
                this.fMaxExclusive = n;
                continue;
            }
            if (((String)object).equals("enumeration")) continue;
            if (((String)object).equals("precision") || ((String)object).equals("scale") || ((String)object).equals("length") || ((String)object).equals("maxLength") || ((String)object).equals("literal") || ((String)object).equals("lexicalRepresentation") || ((String)object).equals("lexical")) {
                throw new IllegalFacetException(this.getErrorString(12, 0, null));
            }
            throw new UnknownFacetException(this.getErrorString(7, 0, new Object[]{object}));
        }
        object = (Vector)hashtable.get("enumeration");
        if (object != null) {
            this.fHasEnums = true;
            this.fEnumValues = new int[((Vector)object).size()];
            int n = 0;
            while (n < ((Vector)object).size()) {
                try {
                    this.fEnumValues[n] = Integer.parseInt((String)((Vector)object).elementAt(n));
                    this.boundsCheck(this.fEnumValues[n]);
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    throw new IllegalFacetValueException(this.getErrorString(8, 0, new Object[]{((Vector)object).elementAt(n)}));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Internal Error parsing enumerated values for integer type");
                }
                ++n;
            }
        }
    }

    public void setFacets(int[] nArray) throws UnknownFacetException, IllegalFacetException, IllegalFacetValueException {
    }

    public void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = (IntegerValidator)datatypeValidator;
    }

    private void boundsCheck(int n) throws InvalidDatatypeValueException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.fIsMaxInclusive) {
            bl2 = n <= this.fMaxInclusive;
        } else if (this.fIsMaxExclusive) {
            bl2 = n < this.fMaxExclusive;
        } else {
            boolean bl3 = bl2 = !this.fIsMaxInclusive && !this.fIsMaxExclusive;
        }
        if (this.fIsMinInclusive) {
            bl = n >= this.fMinInclusive;
        } else if (this.fIsMinExclusive) {
            bl = n > this.fMinInclusive;
        } else {
            boolean bl4 = bl = !this.fIsMinInclusive && !this.fIsMinExclusive;
        }
        if (!bl || !bl2) {
            throw new InvalidDatatypeValueException(this.getErrorString(9, 0, new Object[]{new Integer(n)}));
        }
    }

    private void enumCheck(int n) throws InvalidDatatypeValueException {
        int n2 = 0;
        while (n2 < this.fEnumValues.length) {
            if (n == this.fEnumValues[n2]) {
                return;
            }
            ++n2;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(10, 0, new Object[]{new Integer(n)}));
    }

    public void setLocale(Locale locale) {
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        try {
            return this.fMessageProvider.createMessage(this.fLocale, n, n2, objectArray);
        }
        catch (Exception exception) {
            return "Illegal Errorcode " + n2;
        }
    }
}

