/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.dtd;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.framework.XMLContentSpecNode;
import org.apache.xerces.framework.XMLDTDScanner;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.framework.XMLValidator;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.ChunkyCharArray;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.apache.xerces.validators.dtd.CMBinOp;
import org.apache.xerces.validators.dtd.CMException;
import org.apache.xerces.validators.dtd.CMLeaf;
import org.apache.xerces.validators.dtd.CMNode;
import org.apache.xerces.validators.dtd.CMUniOp;
import org.apache.xerces.validators.dtd.DFAContentModel;
import org.apache.xerces.validators.dtd.EntityPool;
import org.apache.xerces.validators.dtd.InsertableElementsInfo;
import org.apache.xerces.validators.dtd.MixedContentModel;
import org.apache.xerces.validators.dtd.SimpleContentModel;
import org.apache.xerces.validators.dtd.XMLContentModel;
import org.xml.sax.Locator;

public final class DTDValidator
implements XMLValidator,
XMLDTDScanner.EventHandler,
NamespacesScope.NamespacesHandler {
    private static final boolean PRINT_EXCEPTION_STACK_TRACE = false;
    private static final boolean DEBUG_PRINT_ATTRIBUTES = false;
    private static final boolean DEBUG_PRINT_CONTENT = false;
    private XMLDTDScanner fDTDScanner;
    protected StringPool fStringPool;
    private XMLErrorReporter fErrorReporter;
    private XMLEntityHandler fEntityHandler;
    protected boolean fValidating = false;
    private boolean fValidationEnabled = false;
    private boolean fDynamicValidation = false;
    private boolean fValidationEnabledByDynamic = false;
    private boolean fDynamicDisabledByValidation = false;
    private boolean fWarningOnDuplicateAttDef = false;
    private boolean fWarningOnUndeclaredElements = false;
    private EntityPool fEntityPool;
    private int fStandaloneReader = -1;
    private int[] fElementTypeStack = new int[8];
    private int[] fElementIndexStack = new int[8];
    private int[] fContentSpecTypeStack = new int[8];
    private int[] fElementChildCount = new int[8];
    private int[][] fElementChildren = new int[8][];
    private int fElementDepth = -1;
    private boolean fNamespacesEnabled = false;
    private NamespacesScope fNamespacesScope;
    private int fNamespacesPrefix = -1;
    private int fRootElementType = -1;
    private int fAttrIndex = -1;
    private int fElementDeclCount;
    private int fAttlistDeclCount;
    private int fCurrentElementType = -1;
    private int fCurrentElementIndex = -1;
    private int fCurrentContentSpecType = -1;
    private boolean fSeenDoctypeDecl = false;
    private EventHandler fEventHandler;
    private EntityPool fParameterEntityPool;
    private int fEMPTYSymbol = -1;
    private int fANYSymbol = -1;
    private int fMIXEDSymbol = -1;
    private int fCHILDRENSymbol = -1;
    private int fCDATASymbol = -1;
    private int fIDSymbol = -1;
    private int fIDREFSymbol = -1;
    private int fIDREFSSymbol = -1;
    private int fENTITYSymbol = -1;
    private int fENTITIESSymbol = -1;
    private int fNMTOKENSymbol = -1;
    private int fNMTOKENSSymbol = -1;
    private int fNOTATIONSymbol = -1;
    private int fENUMERATIONSymbol = -1;
    private int fREQUIREDSymbol = -1;
    private int fFIXEDSymbol = -1;
    private int fEpsilonIndex = -1;
    private int fLeafCount;
    private int fCount;
    private int[] fContentList = new int[64];
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private int fElementCount;
    private int[][] fElementType = new int[4][];
    private byte[][] fElementDeclIsExternal = new byte[4][];
    private int[][] fContentSpecType = new int[4][];
    private int[][] fContentSpec = new int[4][];
    private XMLContentModel[][] fContentModel = new XMLContentModel[4][];
    private int[][] fAttlistHead = new int[4][];
    private int[][] fAttlistTail = new int[4][];
    private int fNodeCount;
    private byte[][] fNodeType = new byte[4][];
    private int[][] fNodeValue = new int[4][];
    private int fAttDefCount;
    private int[][] fAttName = new int[4][];
    private int[][] fAttType = new int[4][];
    private AttributeValidator[][] fAttValidator = new AttributeValidator[4][];
    private int[][] fEnumeration = new int[4][];
    private int[][] fAttDefaultType = new int[4][];
    private int[][] fAttValue = new int[4][];
    private byte[][] fAttDefIsExternal = new byte[4][];
    private int[][] fNextAttDef = new int[4][];
    private Hashtable fIdDefs;
    private Hashtable fIdRefs;
    private Object fNullValue;
    private AttributeValidator fAttValidatorCDATA;
    private AttributeValidator fAttValidatorID;
    private AttributeValidator fAttValidatorIDREF;
    private AttributeValidator fAttValidatorIDREFS;
    private AttributeValidator fAttValidatorENTITY;
    private AttributeValidator fAttValidatorENTITIES;
    private AttributeValidator fAttValidatorNMTOKEN;
    private AttributeValidator fAttValidatorNMTOKENS;
    private AttributeValidator fAttValidatorNOTATION;
    private AttributeValidator fAttValidatorENUMERATION;
    ContentSpecImpl fContentSpecImpl;

    public DTDValidator(EventHandler eventHandler, StringPool stringPool, XMLErrorReporter xMLErrorReporter, XMLEntityHandler xMLEntityHandler) {
        this.fEventHandler = eventHandler;
        this.fStringPool = stringPool;
        this.fErrorReporter = xMLErrorReporter;
        this.fEntityHandler = xMLEntityHandler;
        this.fDTDScanner = new XMLDTDScanner(this, this.fStringPool, this.fErrorReporter, this.fEntityHandler, new ChunkyCharArray(this.fStringPool));
        this.fEntityPool = new EntityPool(this.fStringPool, this.fErrorReporter, true);
        this.init();
    }

    public void reset(StringPool stringPool) throws Exception {
        this.fStringPool = stringPool;
        this.fDTDScanner.reset(stringPool, new ChunkyCharArray(this.fStringPool));
        this.setValidating(this.fValidationEnabled);
        this.fValidationEnabledByDynamic = false;
        this.fDynamicDisabledByValidation = false;
        this.fEntityPool.reset(this.fStringPool);
        this.poolReset();
        this.fStandaloneReader = -1;
        this.fElementDepth = -1;
        this.fSeenDoctypeDecl = false;
        this.fParameterEntityPool = null;
        this.fNamespacesScope = null;
        this.fNamespacesPrefix = -1;
        this.fRootElementType = -1;
        this.fAttrIndex = -1;
        this.fElementDeclCount = 0;
        this.fAttlistDeclCount = 0;
        this.init();
    }

    private void init() {
        this.fEMPTYSymbol = this.fStringPool.addSymbol("EMPTY");
        this.fANYSymbol = this.fStringPool.addSymbol("ANY");
        this.fMIXEDSymbol = this.fStringPool.addSymbol("MIXED");
        this.fCHILDRENSymbol = this.fStringPool.addSymbol("CHILDREN");
        this.fCDATASymbol = this.fStringPool.addSymbol("CDATA");
        this.fIDSymbol = this.fStringPool.addSymbol("ID");
        this.fIDREFSymbol = this.fStringPool.addSymbol("IDREF");
        this.fIDREFSSymbol = this.fStringPool.addSymbol("IDREFS");
        this.fENTITYSymbol = this.fStringPool.addSymbol("ENTITY");
        this.fENTITIESSymbol = this.fStringPool.addSymbol("ENTITIES");
        this.fNMTOKENSymbol = this.fStringPool.addSymbol("NMTOKEN");
        this.fNMTOKENSSymbol = this.fStringPool.addSymbol("NMTOKENS");
        this.fNOTATIONSymbol = this.fStringPool.addSymbol("NOTATION");
        this.fENUMERATIONSymbol = this.fStringPool.addSymbol("ENUMERATION");
        this.fREQUIREDSymbol = this.fStringPool.addSymbol("#REQUIRED");
        this.fFIXEDSymbol = this.fStringPool.addSymbol("#FIXED");
        this.fEpsilonIndex = this.fStringPool.addSymbol("<<CMNODE_EPSILON>>");
    }

    public void setValidationEnabled(boolean bl) throws Exception {
        this.fValidationEnabled = bl;
        this.fValidationEnabledByDynamic = false;
        if (this.fValidationEnabled) {
            if (this.fDynamicDisabledByValidation) {
                this.fDynamicValidation = true;
                this.fDynamicDisabledByValidation = false;
            }
        } else if (this.fDynamicValidation) {
            this.fDynamicValidation = false;
            this.fDynamicDisabledByValidation = true;
        }
        this.setValidating(this.fValidationEnabled);
    }

    public boolean getValidationEnabled() {
        return this.fValidationEnabled;
    }

    public void setDynamicValidationEnabled(boolean bl) throws Exception {
        this.fDynamicValidation = bl;
        this.fDynamicDisabledByValidation = false;
        if (!this.fDynamicValidation) {
            if (this.fValidationEnabledByDynamic) {
                this.fValidationEnabled = false;
                this.fValidationEnabledByDynamic = false;
            }
        } else if (!this.fValidationEnabled) {
            this.fValidationEnabled = true;
            this.fValidationEnabledByDynamic = true;
        }
        this.setValidating(this.fValidationEnabled);
    }

    public boolean getDynamicValidationEnabled() {
        return this.fDynamicValidation;
    }

    private void setValidating(boolean bl) throws Exception {
        this.fValidating = bl;
        this.fEventHandler.setValidating(bl);
    }

    public void setNamespacesEnabled(boolean bl) {
        this.fNamespacesEnabled = bl;
    }

    public boolean getNamespacesEnabled() {
        return this.fNamespacesEnabled;
    }

    public void startNamespaceDeclScope(int n, int n2) throws Exception {
        this.fEventHandler.startNamespaceDeclScope(n, n2);
    }

    public void endNamespaceDeclScope(int n) throws Exception {
        this.fEventHandler.endNamespaceDeclScope(n);
    }

    public void setWarningOnDuplicateAttDef(boolean bl) {
        this.fWarningOnDuplicateAttDef = bl;
    }

    public boolean getWarningOnDuplicateAttDef() {
        return this.fWarningOnDuplicateAttDef;
    }

    public void setWarningOnUndeclaredElements(boolean bl) {
        this.fWarningOnUndeclaredElements = bl;
    }

    public boolean getWarningOnUndeclaredElements() {
        return this.fWarningOnUndeclaredElements;
    }

    private boolean usingStandaloneReader() {
        return this.fStandaloneReader == -1 || this.fEntityHandler.getReaderId() == this.fStandaloneReader;
    }

    protected boolean invalidStandaloneAttDef(int n, int n2) {
        if (this.fStandaloneReader == -1) {
            return false;
        }
        if (n == -1) {
            return false;
        }
        int n3 = this.getAttDef(n, n2);
        return this.getAttDefIsExternal(n3);
    }

    public boolean scanDoctypeDecl(boolean bl) throws Exception {
        this.fSeenDoctypeDecl = true;
        int n = this.fStandaloneReader = bl ? this.fEntityHandler.getReaderId() : -1;
        if (!this.fDTDScanner.scanDoctypeDecl()) {
            return false;
        }
        if (this.fDTDScanner.getReadingExternalEntity()) {
            this.fDTDScanner.scanDecls(true);
        }
        if (this.fValidating) {
            if (this.fWarningOnUndeclaredElements) {
                this.checkDeclaredElements();
            }
            this.fEntityPool.checkRequiredNotations();
        }
        this.fEventHandler.endDTD();
        return true;
    }

    public void characters(char[] cArray, int n, int n2) throws Exception {
        if (this.fValidating) {
            this.charDataInContent();
        }
    }

    public void characters(int n) throws Exception {
        if (this.fValidating) {
            this.charDataInContent();
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws Exception {
        int n3;
        if (this.fStandaloneReader != -1 && this.fValidating && this.getElementDeclIsExternal(n3 = this.fCurrentElementIndex)) {
            this.reportRecoverableXMLError(143, 80);
        }
    }

    public void ignorableWhitespace(int n) throws Exception {
        int n2;
        if (this.fStandaloneReader != -1 && this.fValidating && this.getElementDeclIsExternal(n2 = this.fCurrentElementIndex)) {
            this.reportRecoverableXMLError(143, 80);
        }
    }

    public int lookupEntity(int n) {
        int n2 = this.fEntityPool.lookupEntity(n);
        return n2;
    }

    public boolean externalReferenceInContent(int n) throws Exception {
        boolean bl = this.fEntityPool.isExternalEntity(n);
        if (this.fStandaloneReader != -1 && this.fValidating) {
            if (bl) {
                this.reportRecoverableXMLError(102, 80, this.fEntityPool.getEntityName(n));
            } else if (this.fEntityPool.getEntityDeclIsExternal(n)) {
                this.reportRecoverableXMLError(132, 80, this.fEntityPool.getEntityName(n));
            }
        }
        return bl;
    }

    public int valueOfReferenceInAttValue(int n) throws Exception {
        if (this.fStandaloneReader != -1 && this.fValidating && this.fEntityPool.getEntityDeclIsExternal(n)) {
            this.reportRecoverableXMLError(132, 80, this.fEntityPool.getEntityName(n));
        }
        int n2 = this.fEntityPool.getEntityValue(n);
        return n2;
    }

    public boolean isExternalEntity(int n) {
        boolean bl = this.fEntityPool.isExternalEntity(n);
        return bl;
    }

    public boolean isUnparsedEntity(int n) {
        boolean bl = this.fEntityPool.isUnparsedEntity(n);
        return bl;
    }

    public int getEntityValue(int n) {
        int n2 = this.fEntityPool.getEntityValue(n);
        return n2;
    }

    public String getPublicIdOfEntity(int n) {
        int n2 = this.fEntityPool.getPublicId(n);
        return this.fStringPool.toString(n2);
    }

    public String getSystemIdOfEntity(int n) {
        int n2 = this.fEntityPool.getSystemId(n);
        return this.fStringPool.toString(n2);
    }

    public int lookupParameterEntity(int n) throws Exception {
        int n2 = -1;
        if (this.fParameterEntityPool != null) {
            n2 = this.fParameterEntityPool.lookupEntity(n);
        }
        if (n2 == -1 && this.fValidating) {
            this.reportRecoverableXMLError(62, 62, n);
        }
        return n2;
    }

    public boolean isExternalParameterEntity(int n) {
        boolean bl = this.fParameterEntityPool.isExternalEntity(n);
        return bl;
    }

    public int getParameterEntityValue(int n) {
        int n2 = this.fParameterEntityPool.getEntityValue(n);
        return n2;
    }

    public String getPublicIdOfParameterEntity(int n) {
        int n2 = this.fParameterEntityPool.getPublicId(n);
        return this.fStringPool.toString(n2);
    }

    public String getSystemIdOfParameterEntity(int n) {
        int n2 = this.fParameterEntityPool.getSystemId(n);
        return this.fStringPool.toString(n2);
    }

    public void rootElementSpecified(int n) throws Exception {
        if (this.fDynamicValidation && !this.fSeenDoctypeDecl) {
            this.setValidating(false);
        }
        if (this.fValidating && this.fRootElementType != -1 && n != this.fRootElementType) {
            this.reportRecoverableXMLError(3, 1, this.fRootElementType, n);
        }
        if (this.fNamespacesEnabled && this.fNamespacesScope == null) {
            this.fNamespacesScope = new NamespacesScope(this);
            this.fNamespacesPrefix = this.fStringPool.addSymbol("xmlns");
            this.fNamespacesScope.setNamespaceForPrefix(this.fNamespacesPrefix, -1);
            int n2 = this.fStringPool.addSymbol("xml");
            int n3 = this.fStringPool.addSymbol("http://www.w3.org/XML/1998/namespace");
            this.fNamespacesScope.setNamespaceForPrefix(n2, n3);
        }
    }

    public boolean attributeSpecified(int n, XMLAttrList xMLAttrList, int n2, Locator locator, int n3) throws Exception {
        if (!this.fValidating && this.fAttlistDeclCount == 0) {
            int n4 = this.fCDATASymbol;
            if (this.fAttrIndex == -1) {
                this.fAttrIndex = xMLAttrList.startAttrList();
            }
            return xMLAttrList.addAttr(n2, n3, n4, true, true) != -1;
        }
        int n5 = this.getAttDef(n, n2);
        if (n5 == -1) {
            if (this.fValidating) {
                Object[] objectArray = new Object[]{this.fStringPool.toString(n), this.fStringPool.toString(n2)};
                this.fErrorReporter.reportError(locator, "http://www.w3.org/TR/1998/REC-xml-19980210", 82, 78, objectArray, 1);
            }
            int n6 = this.fCDATASymbol;
            if (this.fAttrIndex == -1) {
                this.fAttrIndex = xMLAttrList.startAttrList();
            }
            return xMLAttrList.addAttr(n2, n3, n6, true, true) != -1;
        }
        int n7 = this.getAttType(n5);
        if (n7 != this.fCDATASymbol) {
            AttributeValidator attributeValidator = this.getAttributeValidator(n5);
            int n8 = n7 == this.fNOTATIONSymbol || n7 == this.fENUMERATIONSymbol ? this.getEnumeration(n5) : -1;
            n3 = attributeValidator.normalize(n, n2, n3, n7, n8);
        }
        if (this.fAttrIndex == -1) {
            this.fAttrIndex = xMLAttrList.startAttrList();
        }
        return xMLAttrList.addAttr(n2, n3, n7, true, true) != -1;
    }

    public boolean startElement(int n, XMLAttrList xMLAttrList) throws Exception {
        int n2;
        int n3;
        int n4 = this.fAttrIndex;
        this.fAttrIndex = -1;
        if (this.fElementDeclCount == 0 && this.fAttlistDeclCount == 0 && !this.fValidating && !this.fNamespacesEnabled) {
            return false;
        }
        int n5 = this.fStringPool.getDeclaration(n);
        int n6 = n3 = n5 == -1 ? -1 : this.getContentSpecType(n5);
        if (n3 == -1 && this.fValidating) {
            this.reportRecoverableXMLError(83, 79, n);
        }
        if (this.fAttlistDeclCount != 0 && n5 != -1) {
            n4 = this.addDefaultAttributes(n5, xMLAttrList, n4, this.fValidating, this.fStandaloneReader != -1);
        }
        if (this.fNamespacesEnabled) {
            int n7;
            int n8;
            this.fNamespacesScope.increaseDepth();
            if (n4 != -1) {
                n8 = xMLAttrList.getFirstAttr(n4);
                while (n8 != -1) {
                    int n9;
                    n2 = xMLAttrList.getAttrName(n8);
                    if (this.fStringPool.equalNames(n2, this.fNamespacesPrefix)) {
                        n9 = this.fStringPool.addSymbol(xMLAttrList.getAttValue(n8));
                        this.fNamespacesScope.setNamespaceForPrefix(0, n9);
                    } else {
                        n9 = this.fStringPool.getPrefixForQName(n2);
                        if (n9 == this.fNamespacesPrefix) {
                            n9 = this.fStringPool.getLocalPartForQName(n2);
                            n7 = this.fStringPool.addSymbol(xMLAttrList.getAttValue(n8));
                            this.fNamespacesScope.setNamespaceForPrefix(n9, n7);
                        }
                    }
                    n8 = xMLAttrList.getNextAttr(n8);
                }
            }
            if ((n8 = this.fStringPool.getPrefixForQName(n)) == -1) {
                n2 = this.fNamespacesScope.getNamespaceForPrefix(0);
                if (n2 != -1) {
                    this.fStringPool.setURIForQName(n, n2);
                }
            } else {
                n2 = this.fNamespacesScope.getNamespaceForPrefix(n8);
                if (n2 == -1) {
                    Object[] objectArray = new Object[]{this.fStringPool.toString(n8)};
                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1999/REC-xml-names-19990114", 167, 144, objectArray, 1);
                }
                this.fStringPool.setURIForQName(n, n2);
            }
            if (n4 != -1) {
                int n10 = xMLAttrList.getFirstAttr(n4);
                while (n10 != -1) {
                    int n11;
                    n7 = xMLAttrList.getAttrName(n10);
                    if (!this.fStringPool.equalNames(n7, this.fNamespacesPrefix) && (n11 = this.fStringPool.getPrefixForQName(n7)) != this.fNamespacesPrefix) {
                        if (n11 == -1) {
                            this.fStringPool.setURIForQName(n7, n2);
                        } else {
                            int n12 = this.fNamespacesScope.getNamespaceForPrefix(n11);
                            if (n12 == -1) {
                                Object[] objectArray = new Object[]{this.fStringPool.toString(n11)};
                                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1999/REC-xml-names-19990114", 167, 144, objectArray, 1);
                            }
                            this.fStringPool.setURIForQName(n7, n12);
                        }
                    }
                    n10 = xMLAttrList.getNextAttr(n10);
                }
            }
        }
        if (this.fElementDepth >= 0) {
            int[] nArray = this.fElementChildren[this.fElementDepth];
            n2 = this.fElementChildCount[this.fElementDepth];
            try {
                nArray[n2] = n;
            }
            catch (NullPointerException nullPointerException) {
                this.fElementChildren[this.fElementDepth] = new int[256];
                nArray = this.fElementChildren[this.fElementDepth];
                n2 = 0;
                nArray[n2] = n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int[] nArray2 = new int[n2 * 2];
                System.arraycopy(nArray, 0, nArray2, 0, n2);
                this.fElementChildren[this.fElementDepth] = nArray2;
                nArray = nArray2;
                nArray[n2] = n;
            }
            this.fElementChildCount[this.fElementDepth] = ++n2;
        }
        ++this.fElementDepth;
        if (this.fElementDepth == this.fElementTypeStack.length) {
            int[] nArray = new int[this.fElementDepth * 2];
            System.arraycopy(this.fElementTypeStack, 0, nArray, 0, this.fElementDepth);
            this.fElementTypeStack = nArray;
            nArray = new int[this.fElementDepth * 2];
            System.arraycopy(this.fElementIndexStack, 0, nArray, 0, this.fElementDepth);
            this.fElementIndexStack = nArray;
            nArray = new int[this.fElementDepth * 2];
            System.arraycopy(this.fContentSpecTypeStack, 0, nArray, 0, this.fElementDepth);
            this.fContentSpecTypeStack = nArray;
            nArray = new int[this.fElementDepth * 2];
            System.arraycopy(this.fElementChildCount, 0, nArray, 0, this.fElementDepth);
            this.fElementChildCount = nArray;
            int[][] nArray3 = new int[this.fElementDepth * 2][];
            System.arraycopy(this.fElementChildren, 0, nArray3, 0, this.fElementDepth);
            this.fElementChildren = nArray3;
        }
        this.fCurrentElementType = n;
        this.fCurrentElementIndex = n5;
        this.fCurrentContentSpecType = n3;
        this.fElementTypeStack[this.fElementDepth] = n;
        this.fElementIndexStack[this.fElementDepth] = n5;
        this.fContentSpecTypeStack[this.fElementDepth] = n3;
        this.fElementChildCount[this.fElementDepth] = 0;
        return n3 == this.fCHILDRENSymbol;
    }

    public boolean endElement(int n) throws Exception {
        int n2;
        int n3;
        int n4;
        if (!this.fValidating && !this.fNamespacesEnabled && this.fElementDeclCount == 0 && this.fAttlistDeclCount == 0) {
            return false;
        }
        if (this.fValidating && (n4 = this.fCurrentElementIndex) != -1 && this.fCurrentContentSpecType != -1 && (n3 = this.checkContent(n4, n2 = this.peekChildCount(), this.peekChildren())) != -1) {
            int n5 = n3 != n2 ? 87 : 88;
            this.reportRecoverableXMLError(n5, 0, this.fStringPool.toString(n), this.getContentSpecAsString(n4));
        }
        if (this.fElementDepth-- < 0) {
            throw new RuntimeException("Element stack underflow");
        }
        if (this.fElementDepth < 0) {
            this.fCurrentElementType = -1;
            this.fCurrentElementIndex = -1;
            this.fCurrentContentSpecType = -1;
            if (this.fValidating && this.fIdRefs != null) {
                this.checkIdRefs();
            }
        } else {
            this.fCurrentElementType = this.fElementTypeStack[this.fElementDepth];
            this.fCurrentElementIndex = this.fElementIndexStack[this.fElementDepth];
            this.fCurrentContentSpecType = this.fContentSpecTypeStack[this.fElementDepth];
        }
        if (this.fNamespacesEnabled) {
            this.fNamespacesScope.decreaseDepth();
        }
        return this.fCurrentContentSpecType == this.fCHILDRENSymbol;
    }

    private void charDataInContent() {
        int[] nArray = this.fElementChildren[this.fElementDepth];
        int n = this.fElementChildCount[this.fElementDepth];
        try {
            nArray[n] = -1;
        }
        catch (NullPointerException nullPointerException) {
            this.fElementChildren[this.fElementDepth] = new int[256];
            nArray = this.fElementChildren[this.fElementDepth];
            n = 0;
            nArray[n] = -1;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int[] nArray2 = new int[n * 2];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            this.fElementChildren[this.fElementDepth] = nArray2;
            nArray = nArray2;
            nArray[n] = -1;
        }
        this.fElementChildCount[this.fElementDepth] = ++n;
    }

    private int peekChildCount() {
        return this.fElementChildCount[this.fElementDepth];
    }

    private int[] peekChildren() {
        return this.fElementChildren[this.fElementDepth];
    }

    public int checkContent(int n, int n2, int[] nArray) throws Exception {
        int n3 = this.fCurrentElementType;
        int n4 = this.fCurrentContentSpecType;
        if (n4 == this.fEMPTYSymbol) {
            if (n2 != 0) {
                return 0;
            }
        } else if (n4 != this.fANYSymbol) {
            if (n4 == this.fMIXEDSymbol || n4 == this.fCHILDRENSymbol) {
                XMLContentModel xMLContentModel = null;
                try {
                    xMLContentModel = this.getContentModel(n);
                    return xMLContentModel.validateContent(n2, nArray);
                }
                catch (CMException cMException) {
                    int n5 = cMException.getErrorCode();
                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", n5, 0, null, 2);
                }
            } else if (n4 == -1) {
                this.reportRecoverableXMLError(83, 79, n3);
            } else {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 8, 0, null, 2);
            }
        }
        return -1;
    }

    public int whatCanGoHere(int n, boolean bl, InsertableElementsInfo insertableElementsInfo) throws Exception {
        if (insertableElementsInfo.insertAt > insertableElementsInfo.childCount || insertableElementsInfo.curChildren == null || insertableElementsInfo.childCount < 1 || insertableElementsInfo.childCount > insertableElementsInfo.curChildren.length) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 13, 0, null, 2);
        }
        int n2 = 0;
        try {
            XMLContentModel xMLContentModel = this.getContentModel(n);
            n2 = xMLContentModel.whatCanGoHere(bl, insertableElementsInfo);
        }
        catch (CMException cMException) {
            int n3 = cMException.getErrorCode();
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", n3, 0, null, 2);
        }
        return n2;
    }

    private final XMLContentModel createChildModel(int n) throws CMException {
        Object object;
        XMLContentSpecNode xMLContentSpecNode = new XMLContentSpecNode();
        int n2 = this.getContentSpecHandle(n);
        this.getContentSpecNode(n2, xMLContentSpecNode);
        if (xMLContentSpecNode.value == -1) {
            throw new CMException(11);
        }
        if (xMLContentSpecNode.type == 0) {
            return new SimpleContentModel(xMLContentSpecNode.value, -1, xMLContentSpecNode.type);
        }
        if (xMLContentSpecNode.type == 4 || xMLContentSpecNode.type == 5) {
            object = new XMLContentSpecNode();
            XMLContentSpecNode xMLContentSpecNode2 = new XMLContentSpecNode();
            this.getContentSpecNode(xMLContentSpecNode.value, (XMLContentSpecNode)object);
            this.getContentSpecNode(xMLContentSpecNode.otherValue, xMLContentSpecNode2);
            if (((XMLContentSpecNode)object).type == 0 && xMLContentSpecNode2.type == 0) {
                return new SimpleContentModel(((XMLContentSpecNode)object).value, xMLContentSpecNode2.value, xMLContentSpecNode.type);
            }
        } else if (xMLContentSpecNode.type == 1 || xMLContentSpecNode.type == 2 || xMLContentSpecNode.type == 3) {
            object = new XMLContentSpecNode();
            this.getContentSpecNode(xMLContentSpecNode.value, (XMLContentSpecNode)object);
            if (((XMLContentSpecNode)object).type == 0) {
                return new SimpleContentModel(((XMLContentSpecNode)object).value, -1, xMLContentSpecNode.type);
            }
        } else {
            throw new CMException(8);
        }
        this.fLeafCount = 0;
        object = this.buildSyntaxTree(n2, xMLContentSpecNode);
        return new DFAContentModel(this.fStringPool, (CMNode)object, this.fLeafCount);
    }

    private XMLContentModel getContentModel(int n) throws CMException {
        XMLContentModel xMLContentModel = this.getElementContentModel(n);
        if (xMLContentModel != null) {
            return xMLContentModel;
        }
        int n2 = this.getContentSpecType(n);
        if (n2 == this.fMIXEDSymbol) {
            XMLContentSpecNode xMLContentSpecNode = new XMLContentSpecNode();
            int n3 = this.getContentSpecHandle(n);
            this.makeContentList(n3, xMLContentSpecNode);
            xMLContentModel = new MixedContentModel(this.fCount, this.fContentList);
        } else if (n2 == this.fCHILDRENSymbol) {
            xMLContentModel = this.createChildModel(n);
        } else {
            throw new CMException(8);
        }
        this.setContentModel(n, xMLContentModel);
        return xMLContentModel;
    }

    protected void reportRecoverableXMLError(int n, int n2) throws Exception {
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, null, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, int n3) throws Exception {
        Object[] objectArray = new Object[]{this.fStringPool.toString(n3)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, String string) throws Exception {
        Object[] objectArray = new Object[]{string};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, int n3, int n4) throws Exception {
        Object[] objectArray = new Object[]{this.fStringPool.toString(n3), this.fStringPool.toString(n4)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, String string, String string2) throws Exception {
        Object[] objectArray = new Object[]{string, string2};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, String string, String string2, String string3) throws Exception {
        Object[] objectArray = new Object[]{string, string2, string3};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    public void readerChange(XMLEntityHandler.EntityReader entityReader, int n) throws Exception {
        this.fDTDScanner.readerChange(entityReader, n);
    }

    public void endOfInput(int n, boolean bl) throws Exception {
        if (this.fValidating) {
            int n2 = this.fEntityHandler.getReaderDepth();
            if (this.fDTDScanner.getReadingContentSpec()) {
                int n3 = this.fDTDScanner.parenDepth();
                if (n2 != n3) {
                    this.reportRecoverableXMLError(74, 75, n);
                }
            } else {
                int n4 = this.fDTDScanner.markupDepth();
                if (n2 != n4) {
                    this.reportRecoverableXMLError(73, 74, n);
                }
            }
        }
        this.fDTDScanner.endOfInput(n, bl);
    }

    public int saveCurrentLocation() {
        return -1;
    }

    public boolean validVersionNum(String string) {
        return XMLCharacterProperties.validVersionNum(string);
    }

    public boolean validEncName(String string) {
        return XMLCharacterProperties.validEncName(string);
    }

    public int validPublicId(String string) {
        return XMLCharacterProperties.validPublicId(string);
    }

    public void doctypeDecl(int n, int n2, int n3) throws Exception {
        this.fRootElementType = n;
        this.fEventHandler.startDTD(n, n2, n3);
    }

    public void startReadingFromExternalSubset(int n, int n2) throws Exception {
        this.fEntityHandler.startReadingFromExternalSubset(this.fStringPool.toString(n), this.fStringPool.toString(n2), this.fDTDScanner.markupDepth());
    }

    public void stopReadingFromExternalSubset() throws Exception {
        this.fEntityHandler.stopReadingFromExternalSubset();
    }

    public int addElementDecl(int n) throws Exception {
        int n2 = this.addElement(n);
        return n2;
    }

    public int addElementDecl(int n, int n2, int n3) throws Exception {
        int n4 = this.addElementDecl(n, n2, n3, !this.usingStandaloneReader());
        if (n4 == -1) {
            if (this.fValidating) {
                this.reportRecoverableXMLError(89, 82, n);
            }
        } else {
            this.fEventHandler.elementDecl(n, this.getContentSpec(n4));
            ++this.fElementDeclCount;
        }
        return n4;
    }

    public int addAttDef(int n, int n2, int n3, int n4, int n5, int n6) throws Exception {
        int n7 = this.addAttDef(n, n2, n3, n4, n5, n6, !this.usingStandaloneReader(), this.fValidating, this.fWarningOnDuplicateAttDef);
        if (n7 != -1) {
            String string = n4 == -1 ? null : this.fStringPool.stringListAsString(n4);
            this.fEventHandler.attlistDecl(this.getElementType(n), n2, n3, string, n5, n6);
            ++this.fAttlistDeclCount;
        }
        return n7;
    }

    public int addUniqueLeafNode(int n) throws Exception {
        int n2 = this.addContentSpecNode(0, n, -1, true);
        if (n2 == -1 && this.fValidating) {
            this.reportRecoverableXMLError(67, 67, n);
        }
        return n2;
    }

    public int addContentSpecNode(int n, int n2) throws Exception {
        return this.addContentSpecNode(n, n2, -1, false);
    }

    public int addContentSpecNode(int n, int n2, int n3) throws Exception {
        return this.addContentSpecNode(n, n2, n3, false);
    }

    public int addInternalPEDecl(int n, int n2, int n3) throws Exception {
        if (this.fParameterEntityPool == null) {
            this.fParameterEntityPool = new EntityPool(this.fStringPool, this.fErrorReporter, false);
        }
        int n4 = this.fParameterEntityPool.addEntityDecl(n, n2, n3, -1, -1, -1, !this.usingStandaloneReader());
        this.fEventHandler.internalPEDecl(n, n2);
        return n4;
    }

    public int addExternalPEDecl(int n, int n2, int n3) throws Exception {
        if (this.fParameterEntityPool == null) {
            this.fParameterEntityPool = new EntityPool(this.fStringPool, this.fErrorReporter, false);
        }
        int n4 = this.fParameterEntityPool.addEntityDecl(n, -1, -1, n2, n3, -1, !this.usingStandaloneReader());
        this.fEventHandler.externalPEDecl(n, n2, n3);
        return n4;
    }

    public int addInternalEntityDecl(int n, int n2, int n3) throws Exception {
        int n4 = this.fEntityPool.addEntityDecl(n, n2, n3, -1, -1, -1, !this.usingStandaloneReader());
        this.fEventHandler.internalEntityDecl(n, n2);
        return n4;
    }

    public int addExternalEntityDecl(int n, int n2, int n3) throws Exception {
        int n4 = this.fEntityPool.addEntityDecl(n, -1, -1, n2, n3, -1, !this.usingStandaloneReader());
        this.fEventHandler.externalEntityDecl(n, n2, n3);
        return n4;
    }

    public int addUnparsedEntityDecl(int n, int n2, int n3, int n4) throws Exception {
        int n5 = this.fEntityPool.addEntityDecl(n, -1, -1, n2, n3, n4, !this.usingStandaloneReader());
        this.fEventHandler.unparsedEntityDecl(n, n2, n3, n4);
        if (this.fEntityPool.lookupNotation(n4) == -1) {
            Object[] objectArray = new Object[]{this.fStringPool.toString(n), this.fStringPool.toString(n4)};
            this.fEntityPool.addRequiredNotation(n4, this.fErrorReporter.getLocator(), 114, 89, objectArray);
        }
        return n5;
    }

    public int startEnumeration() {
        return this.fStringPool.startStringList();
    }

    public void addNameToEnumeration(int n, int n2, int n3, int n4, boolean bl) {
        this.fStringPool.addStringToList(n, n4);
        if (bl && this.fEntityPool.lookupNotation(n4) == -1) {
            Object[] objectArray = new Object[]{this.fStringPool.toString(n2), this.fStringPool.toString(n3), this.fStringPool.toString(n4)};
            this.fEntityPool.addRequiredNotation(n4, this.fErrorReporter.getLocator(), 117, 89, objectArray);
        }
    }

    public void endEnumeration(int n) {
        this.fStringPool.finishStringList(n);
    }

    public int addNotationDecl(int n, int n2, int n3) throws Exception {
        int n4 = this.fEntityPool.addNotationDecl(n, n2, n3, !this.usingStandaloneReader());
        if (n4 != -1) {
            this.fEventHandler.notationDecl(n, n2, n3);
        }
        return n4;
    }

    public void callProcessingInstruction(int n, int n2) throws Exception {
        this.fEventHandler.processingInstructionInDTD(n, n2);
    }

    public void callComment(int n) throws Exception {
        this.fEventHandler.commentInDTD(n);
    }

    public int scanElementType(XMLEntityHandler.EntityReader entityReader, char c) throws Exception {
        if (!this.fNamespacesEnabled) {
            return entityReader.scanName(c);
        }
        int n = entityReader.scanQName(c);
        if (entityReader.lookingAtChar(':', false)) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
            entityReader.skipPastNmtoken(' ');
        }
        return n;
    }

    public int checkForElementTypeWithPEReference(XMLEntityHandler.EntityReader entityReader, char c) throws Exception {
        if (!this.fNamespacesEnabled) {
            return entityReader.scanName(c);
        }
        int n = entityReader.scanQName(c);
        if (entityReader.lookingAtChar(':', false)) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
            entityReader.skipPastNmtoken(' ');
        }
        return n;
    }

    public int checkForAttributeNameWithPEReference(XMLEntityHandler.EntityReader entityReader, char c) throws Exception {
        if (!this.fNamespacesEnabled) {
            return entityReader.scanName(c);
        }
        int n = entityReader.scanQName(c);
        if (entityReader.lookingAtChar(':', false)) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
            entityReader.skipPastNmtoken(' ');
        }
        return n;
    }

    public int checkForNameWithPEReference(XMLEntityHandler.EntityReader entityReader, char c) throws Exception {
        int n = entityReader.scanName(c);
        return n;
    }

    public int checkForNmtokenWithPEReference(XMLEntityHandler.EntityReader entityReader, char c) throws Exception {
        int n = entityReader.currentOffset();
        entityReader.skipPastNmtoken(c);
        int n2 = entityReader.currentOffset() - n;
        if (n2 == 0) {
            return -1;
        }
        int n3 = entityReader.addSymbol(n, n2);
        return n3;
    }

    public int scanDefaultAttValue(int n, int n2, int n3, int n4) throws Exception {
        int n5;
        if (this.fValidating && n3 == this.fIDSymbol) {
            this.reportRecoverableXMLError(69, 69, n2);
        }
        if ((n5 = this.fDTDScanner.scanDefaultAttValue(n, n2)) == -1) {
            return -1;
        }
        if (n3 != this.fCDATASymbol) {
            AttributeValidator attributeValidator = this.getValidatorForAttType(n3);
            n5 = attributeValidator.normalize(-1, n2, n5, n3, n4);
        }
        return n5;
    }

    private final CMNode buildSyntaxTree(int n, XMLContentSpecNode xMLContentSpecNode) throws CMException {
        CMNode cMNode = null;
        this.getContentSpecNode(n, xMLContentSpecNode);
        if (xMLContentSpecNode.type == 0) {
            cMNode = new CMLeaf(xMLContentSpecNode.type, xMLContentSpecNode.value, this.fLeafCount++);
        } else {
            int n2 = xMLContentSpecNode.value;
            int n3 = xMLContentSpecNode.otherValue;
            if (xMLContentSpecNode.type == 4 || xMLContentSpecNode.type == 5) {
                cMNode = new CMBinOp(xMLContentSpecNode.type, this.buildSyntaxTree(n2, xMLContentSpecNode), this.buildSyntaxTree(n3, xMLContentSpecNode));
            } else if (xMLContentSpecNode.type == 2) {
                cMNode = new CMUniOp(xMLContentSpecNode.type, this.buildSyntaxTree(n2, xMLContentSpecNode));
            } else if (xMLContentSpecNode.type == 1) {
                cMNode = new CMBinOp(4, this.buildSyntaxTree(n2, xMLContentSpecNode), new CMLeaf(0, this.fEpsilonIndex));
            } else if (xMLContentSpecNode.type == 3) {
                cMNode = new CMBinOp(5, this.buildSyntaxTree(n2, xMLContentSpecNode), new CMUniOp(2, this.buildSyntaxTree(n2, xMLContentSpecNode)));
            } else {
                throw new CMException(8);
            }
        }
        return cMNode;
    }

    private final void makeContentList(int n, XMLContentSpecNode xMLContentSpecNode) throws CMException {
        while (true) {
            this.fCount = 0;
            try {
                this.fCount = this.buildContentList(n, 0, xMLContentSpecNode);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.fContentList = new int[this.fContentList.length * 2];
                this.fCount = 0;
                continue;
            }
            break;
        }
    }

    private final int buildContentList(int n, int n2, XMLContentSpecNode xMLContentSpecNode) throws CMException {
        this.getContentSpecNode(n, xMLContentSpecNode);
        if (xMLContentSpecNode.type == 0) {
            this.fContentList[n2++] = xMLContentSpecNode.value;
            return n2;
        }
        int n3 = xMLContentSpecNode.value;
        int n4 = xMLContentSpecNode.otherValue;
        if (xMLContentSpecNode.type == 4 || xMLContentSpecNode.type == 5) {
            n2 = this.buildContentList(n3, n2, xMLContentSpecNode);
            n2 = this.buildContentList(n4, n2, xMLContentSpecNode);
        } else if (xMLContentSpecNode.type == 1 || xMLContentSpecNode.type == 2 || xMLContentSpecNode.type == 3) {
            n2 = this.buildContentList(n3, n2, xMLContentSpecNode);
        } else {
            throw new CMException(8);
        }
        return n2;
    }

    private void poolReset() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fElementCount) {
            this.fContentModel[n][n2] = null;
            if (++n2 == 256) {
                ++n;
                n2 = 0;
            }
            ++n3;
        }
        this.fElementCount = 0;
        this.fNodeCount = 0;
        this.fAttDefCount = 0;
        if (this.fIdDefs != null) {
            this.fIdDefs.clear();
        }
        if (this.fIdRefs != null) {
            this.fIdRefs.clear();
        }
    }

    private boolean ensureElementCapacity(int n) {
        try {
            return this.fElementType[n][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byte[][] byArray = new byte[n * 2][];
            System.arraycopy(this.fElementDeclIsExternal, 0, byArray, 0, n);
            this.fElementDeclIsExternal = byArray;
            int[][] nArray = new int[n * 2][];
            System.arraycopy(this.fElementType, 0, nArray, 0, n);
            this.fElementType = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fContentSpecType, 0, nArray, 0, n);
            this.fContentSpecType = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fContentSpec, 0, nArray, 0, n);
            this.fContentSpec = nArray;
            XMLContentModel[][] xMLContentModelArray = new XMLContentModel[n * 2][];
            System.arraycopy(this.fContentModel, 0, xMLContentModelArray, 0, n);
            this.fContentModel = xMLContentModelArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fAttlistHead, 0, nArray, 0, n);
            this.fAttlistHead = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fAttlistTail, 0, nArray, 0, n);
            this.fAttlistTail = nArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fElementType[n] = new int[256];
        this.fElementDeclIsExternal[n] = new byte[256];
        this.fContentSpecType[n] = new int[256];
        this.fContentSpec[n] = new int[256];
        this.fContentModel[n] = new XMLContentModel[256];
        this.fAttlistHead[n] = new int[256];
        this.fAttlistTail[n] = new int[256];
        return true;
    }

    private int lookupElement(int n) {
        return this.fStringPool.getDeclaration(n);
    }

    private int addElement(int n) {
        int n2 = this.fStringPool.getDeclaration(n);
        if (n2 != -1) {
            return n2;
        }
        int n3 = this.fElementCount >> 8;
        int n4 = this.fElementCount & 0xFF;
        this.ensureElementCapacity(n3);
        this.fElementType[n3][n4] = n;
        this.fElementDeclIsExternal[n3][n4] = 0;
        this.fContentSpecType[n3][n4] = -1;
        this.fContentSpec[n3][n4] = -1;
        this.fContentModel[n3][n4] = null;
        this.fAttlistHead[n3][n4] = -1;
        this.fAttlistTail[n3][n4] = -1;
        this.fStringPool.setDeclaration(n, this.fElementCount);
        return this.fElementCount++;
    }

    private int addElementDecl(int n, int n2, int n3, boolean bl) {
        int n4 = this.fStringPool.getDeclaration(n);
        if (n4 != -1) {
            int n5 = n4 >> 8;
            int n6 = n4 & 0xFF;
            if (this.fContentSpecType[n5][n6] != -1) {
                return -1;
            }
            this.fElementDeclIsExternal[n5][n6] = (byte)(bl ? 1 : 0);
            this.fContentSpecType[n5][n6] = n2;
            this.fContentSpec[n5][n6] = n3;
            this.fContentModel[n5][n6] = null;
            return n4;
        }
        int n7 = this.fElementCount >> 8;
        int n8 = this.fElementCount & 0xFF;
        this.ensureElementCapacity(n7);
        this.fElementType[n7][n8] = n;
        this.fElementDeclIsExternal[n7][n8] = (byte)(bl ? 1 : 0);
        this.fContentSpecType[n7][n8] = n2;
        this.fContentSpec[n7][n8] = n3;
        this.fContentModel[n7][n8] = null;
        this.fAttlistHead[n7][n8] = -1;
        this.fAttlistTail[n7][n8] = -1;
        this.fStringPool.setDeclaration(n, this.fElementCount);
        return this.fElementCount++;
    }

    private int getElementType(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return -1;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementType[n2][n3];
    }

    private boolean getElementDeclIsExternal(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclIsExternal[n2][n3] != 0;
    }

    private int getContentSpecType(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return -1;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fContentSpecType[n2][n3];
    }

    private XMLValidator.ContentSpec getContentSpec(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return null;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        if (this.fContentSpecImpl == null) {
            this.fContentSpecImpl = new ContentSpecImpl();
        }
        this.fContentSpecImpl.fStringPool = this.fStringPool;
        this.fContentSpecImpl.fHandle = this.fContentSpec[n2][n3];
        this.fContentSpecImpl.fType = this.fContentSpecType[n2][n3];
        return this.fContentSpecImpl;
    }

    private int getContentSpecHandle(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return -1;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fContentSpec[n2][n3];
    }

    public String getContentSpecAsString(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return null;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        int n4 = this.fContentSpecType[n2][n3];
        if (n4 == this.fMIXEDSymbol || n4 == this.fCHILDRENSymbol) {
            return this.getContentSpecNodeAsString(this.fContentSpec[n2][n3]);
        }
        return this.fStringPool.toString(n4);
    }

    private XMLContentModel getElementContentModel(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return null;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fContentModel[n2][n3];
    }

    private void setContentModel(int n, XMLContentModel xMLContentModel) {
        if (n < 0 || n >= this.fElementCount) {
            return;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        this.fContentModel[n2][n3] = xMLContentModel;
    }

    private boolean ensureNodeCapacity(int n) {
        try {
            return this.fNodeType[n][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byte[][] byArray = new byte[n * 2][];
            System.arraycopy(this.fNodeType, 0, byArray, 0, n);
            this.fNodeType = byArray;
            int[][] nArray = new int[n * 2][];
            System.arraycopy(this.fNodeValue, 0, nArray, 0, n);
            this.fNodeValue = nArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fNodeType[n] = new byte[256];
        this.fNodeValue[n] = new int[256];
        return true;
    }

    private int addContentSpecLeafNode(int n) throws Exception {
        int n2;
        int n3;
        block3: {
            if (n != -1) {
                n3 = this.fNodeCount >> 8;
                n2 = this.fNodeCount & 0xFF;
                while (true) {
                    byte by;
                    if (n2-- == 0) {
                        n2 = 255;
                        --n3;
                    }
                    if ((by = this.fNodeType[n3][n2]) != 0) continue;
                    int n4 = this.fNodeValue[n3][n2];
                    if (n4 == -1) break block3;
                    if (n4 == n) break;
                }
                return -1;
            }
        }
        n3 = this.fNodeCount >> 8;
        n2 = this.fNodeCount & 0xFF;
        this.ensureNodeCapacity(n3);
        this.fNodeType[n3][n2] = 0;
        this.fNodeValue[n3][n2] = n;
        return this.fNodeCount++;
    }

    private int addContentSpecNode(int n, int n2, int n3, boolean bl) throws Exception {
        if (bl) {
            return this.addContentSpecLeafNode(n2);
        }
        int n4 = this.fNodeCount >> 8;
        int n5 = this.fNodeCount & 0xFF;
        this.ensureNodeCapacity(n4);
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.fNodeType[n4][n5] = (byte)n;
                this.fNodeValue[n4][n5] = n2;
                return this.fNodeCount++;
            }
            case 4: 
            case 5: {
                this.fNodeType[n4][n5] = (byte)n;
                this.fNodeValue[n4][n5] = n2;
                int n6 = this.fNodeCount++;
                if (++n5 == 256) {
                    this.ensureNodeCapacity(++n4);
                    n5 = 0;
                }
                this.fNodeType[n4][n5] = (byte)(n | 0x40);
                this.fNodeValue[n4][n5] = n3;
                ++this.fNodeCount;
                return n6;
            }
        }
        return -1;
    }

    protected void getContentSpecNode(int n, XMLContentSpecNode xMLContentSpecNode) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        xMLContentSpecNode.type = this.fNodeType[n2][n3];
        xMLContentSpecNode.value = this.fNodeValue[n2][n3];
        if (xMLContentSpecNode.type == 4 || xMLContentSpecNode.type == 5) {
            if (++n3 == 256) {
                ++n2;
                n3 = 0;
            }
            xMLContentSpecNode.otherValue = this.fNodeValue[n2][n3];
            return;
        }
        xMLContentSpecNode.otherValue = -1;
    }

    private void appendContentSpecNode(int n, StringBuffer stringBuffer, boolean bl) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        byte by = this.fNodeType[n2][n3];
        int n4 = this.fNodeValue[n2][n3];
        switch (by) {
            case 0: {
                stringBuffer.append(n4 == -1 ? "#PCDATA" : this.fStringPool.toString(n4));
                return;
            }
            case 1: {
                this.appendContentSpecNode(n4, stringBuffer, false);
                stringBuffer.append('?');
                return;
            }
            case 2: {
                this.appendContentSpecNode(n4, stringBuffer, false);
                stringBuffer.append('*');
                return;
            }
            case 3: {
                this.appendContentSpecNode(n4, stringBuffer, false);
                stringBuffer.append('+');
                return;
            }
            case 4: 
            case 5: {
                int n5;
                int n6;
                byte by2;
                if (!bl) {
                    stringBuffer.append('(');
                }
                this.appendContentSpecNode(n4, stringBuffer, (by2 = this.fNodeType[n6 = n4 >> 8][n5 = n4 & 0xFF]) == by);
                stringBuffer.append(by == 4 ? (char)'|' : ',');
                if (++n3 == 256) {
                    ++n2;
                    n3 = 0;
                }
                this.appendContentSpecNode(this.fNodeValue[n2][n3], stringBuffer, false);
                if (!bl) {
                    stringBuffer.append(')');
                }
                return;
            }
        }
    }

    public String getContentSpecNodeAsString(int n) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        byte by = this.fNodeType[n2][n3];
        int n4 = this.fNodeValue[n2][n3];
        StringBuffer stringBuffer = new StringBuffer();
        switch (by) {
            case 0: {
                stringBuffer.append("(" + (n4 == -1 ? "#PCDATA" : this.fStringPool.toString(n4)) + ")");
                break;
            }
            case 1: {
                n2 = n4 >> 8;
                n3 = n4 & 0xFF;
                if (this.fNodeType[n2][n3] == 0) {
                    n4 = this.fNodeValue[n2][n3];
                    stringBuffer.append("(" + (n4 == -1 ? "#PCDATA" : this.fStringPool.toString(n4)) + ")?");
                    break;
                }
                this.appendContentSpecNode(n, stringBuffer, false);
                break;
            }
            case 2: {
                n2 = n4 >> 8;
                n3 = n4 & 0xFF;
                if (this.fNodeType[n2][n3] == 0) {
                    n4 = this.fNodeValue[n2][n3];
                    stringBuffer.append("(" + (n4 == -1 ? "#PCDATA" : this.fStringPool.toString(n4)) + ")*");
                    break;
                }
                this.appendContentSpecNode(n, stringBuffer, false);
                break;
            }
            case 3: {
                n2 = n4 >> 8;
                n3 = n4 & 0xFF;
                if (this.fNodeType[n2][n3] == 0) {
                    n4 = this.fNodeValue[n2][n3];
                    stringBuffer.append("(" + (n4 == -1 ? "#PCDATA" : this.fStringPool.toString(n4)) + ")+");
                    break;
                }
                this.appendContentSpecNode(n, stringBuffer, false);
                break;
            }
            case 4: 
            case 5: {
                this.appendContentSpecNode(n, stringBuffer, false);
                break;
            }
            default: {
                return null;
            }
        }
        return stringBuffer.toString();
    }

    private boolean ensureAttrCapacity(int n) {
        try {
            return this.fAttName[n][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byte[][] byArray = new byte[n * 2][];
            System.arraycopy(this.fAttDefIsExternal, 0, byArray, 0, n);
            this.fAttDefIsExternal = byArray;
            int[][] nArray = new int[n * 2][];
            System.arraycopy(this.fAttName, 0, nArray, 0, n);
            this.fAttName = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fAttType, 0, nArray, 0, n);
            this.fAttType = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fEnumeration, 0, nArray, 0, n);
            this.fEnumeration = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fAttDefaultType, 0, nArray, 0, n);
            this.fAttDefaultType = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fAttValue, 0, nArray, 0, n);
            this.fAttValue = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fNextAttDef, 0, nArray, 0, n);
            this.fNextAttDef = nArray;
            AttributeValidator[][] attributeValidatorArray = new AttributeValidator[n * 2][];
            System.arraycopy(this.fAttValidator, 0, attributeValidatorArray, 0, n);
            this.fAttValidator = attributeValidatorArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fAttDefIsExternal[n] = new byte[256];
        this.fAttName[n] = new int[256];
        this.fAttType[n] = new int[256];
        this.fAttValidator[n] = new AttributeValidator[256];
        this.fEnumeration[n] = new int[256];
        this.fAttDefaultType[n] = new int[256];
        this.fAttValue[n] = new int[256];
        this.fNextAttDef[n] = new int[256];
        return true;
    }

    private int addAttDef(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3) throws Exception {
        int n7;
        int n8;
        int n9 = n >> 8;
        int n10 = n & 0xFF;
        int n11 = this.fAttlistHead[n9][n10];
        int n12 = -1;
        int n13 = -1;
        while (n11 != -1) {
            n8 = n11 >> 8;
            n7 = n11 & 0xFF;
            if (this.fStringPool.equalNames(this.fAttName[n8][n7], n2)) {
                if (bl3) {
                    Object[] objectArray = new Object[]{this.fStringPool.toString(this.fElementType[n9][n10]), this.fStringPool.toString(n2)};
                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 85, 85, objectArray, 0);
                }
                return -1;
            }
            if (bl2) {
                if (n3 == this.fIDSymbol && this.fAttType[n8][n7] == this.fIDSymbol) {
                    n12 = this.fAttName[n8][n7];
                }
                if (n3 == this.fNOTATIONSymbol && this.fAttType[n8][n7] == this.fNOTATIONSymbol) {
                    n13 = this.fAttName[n8][n7];
                }
            }
            n11 = this.fNextAttDef[n8][n7];
        }
        if (bl2) {
            if (n12 != -1) {
                Object[] objectArray = new Object[]{this.fStringPool.toString(this.fElementType[n9][n10]), this.fStringPool.toString(n12), this.fStringPool.toString(n2)};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 86, 81, objectArray, 1);
                return -1;
            }
            if (n13 != -1) {
                Object[] objectArray = new Object[]{this.fStringPool.toString(this.fElementType[n9][n10]), this.fStringPool.toString(n13), this.fStringPool.toString(n2)};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 121, 143, objectArray, 1);
                return -1;
            }
        }
        n8 = this.fAttDefCount >> 8;
        n7 = this.fAttDefCount & 0xFF;
        this.ensureAttrCapacity(n8);
        this.fAttName[n8][n7] = n2;
        this.fAttType[n8][n7] = n3;
        this.fAttValidator[n8][n7] = this.getValidatorForAttType(n3);
        this.fEnumeration[n8][n7] = n4;
        this.fAttDefaultType[n8][n7] = n5;
        this.fAttDefIsExternal[n8][n7] = (byte)(bl ? 1 : 0);
        this.fAttValue[n8][n7] = n6;
        int n14 = -1;
        if (n6 != -1) {
            n14 = this.fAttlistHead[n9][n10];
            this.fAttlistHead[n9][n10] = this.fAttDefCount;
            if (n14 == -1) {
                this.fAttlistTail[n9][n10] = this.fAttDefCount;
            }
        } else {
            n14 = this.fAttlistTail[n9][n10];
            this.fAttlistTail[n9][n10] = this.fAttDefCount;
            if (n14 == -1) {
                this.fAttlistHead[n9][n10] = this.fAttDefCount;
            } else {
                this.fNextAttDef[n14 >> 8][n14 & 0xFF] = this.fAttDefCount;
                n14 = -1;
            }
        }
        this.fNextAttDef[n8][n7] = n14;
        return this.fAttDefCount++;
    }

    private AttributeValidator getValidatorForAttType(int n) {
        if (n == this.fCDATASymbol) {
            if (this.fAttValidatorCDATA == null) {
                this.fAttValidatorCDATA = new AttValidatorCDATA();
            }
            return this.fAttValidatorCDATA;
        }
        if (n == this.fIDSymbol) {
            if (this.fAttValidatorID == null) {
                this.fAttValidatorID = new AttValidatorID();
            }
            return this.fAttValidatorID;
        }
        if (n == this.fIDREFSymbol) {
            if (this.fAttValidatorIDREF == null) {
                this.fAttValidatorIDREF = new AttValidatorIDREF();
            }
            return this.fAttValidatorIDREF;
        }
        if (n == this.fIDREFSSymbol) {
            if (this.fAttValidatorIDREFS == null) {
                this.fAttValidatorIDREFS = new AttValidatorIDREFS();
            }
            return this.fAttValidatorIDREFS;
        }
        if (n == this.fENTITYSymbol) {
            if (this.fAttValidatorENTITY == null) {
                this.fAttValidatorENTITY = new AttValidatorENTITY();
            }
            return this.fAttValidatorENTITY;
        }
        if (n == this.fENTITIESSymbol) {
            if (this.fAttValidatorENTITIES == null) {
                this.fAttValidatorENTITIES = new AttValidatorENTITIES();
            }
            return this.fAttValidatorENTITIES;
        }
        if (n == this.fNMTOKENSymbol) {
            if (this.fAttValidatorNMTOKEN == null) {
                this.fAttValidatorNMTOKEN = new AttValidatorNMTOKEN();
            }
            return this.fAttValidatorNMTOKEN;
        }
        if (n == this.fNMTOKENSSymbol) {
            if (this.fAttValidatorNMTOKENS == null) {
                this.fAttValidatorNMTOKENS = new AttValidatorNMTOKENS();
            }
            return this.fAttValidatorNMTOKENS;
        }
        if (n == this.fNOTATIONSymbol) {
            if (this.fAttValidatorNOTATION == null) {
                this.fAttValidatorNOTATION = new AttValidatorNOTATION();
            }
            return this.fAttValidatorNOTATION;
        }
        if (n == this.fENUMERATIONSymbol) {
            if (this.fAttValidatorENUMERATION == null) {
                this.fAttValidatorENUMERATION = new AttValidatorENUMERATION();
            }
            return this.fAttValidatorENUMERATION;
        }
        throw new RuntimeException("getValidatorForAttType(" + this.fStringPool.toString(n) + ")");
    }

    private int getAttDef(int n, int n2) {
        int n3 = this.fStringPool.getDeclaration(n);
        if (n3 == -1) {
            return -1;
        }
        int n4 = n3 >> 8;
        int n5 = n3 & 0xFF;
        int n6 = this.fAttlistHead[n4][n5];
        while (n6 != -1) {
            n4 = n6 >> 8;
            n5 = n6 & 0xFF;
            if (this.fAttName[n4][n5] == n2 || this.fStringPool.equalNames(this.fAttName[n4][n5], n2)) {
                return n6;
            }
            n6 = this.fNextAttDef[n4][n5];
        }
        return -1;
    }

    private boolean getAttDefIsExternal(int n) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fAttDefIsExternal[n2][n3] != 0;
    }

    private int getAttName(int n) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fAttName[n2][n3];
    }

    private int getAttValue(int n) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fAttValue[n2][n3];
    }

    private AttributeValidator getAttributeValidator(int n) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fAttValidator[n2][n3];
    }

    private int getAttType(int n) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fAttType[n2][n3];
    }

    private int getAttDefaultType(int n) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fAttDefaultType[n2][n3];
    }

    private int getEnumeration(int n) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fEnumeration[n2][n3];
    }

    private int addDefaultAttributes(int n, XMLAttrList xMLAttrList, int n2, boolean bl, boolean bl2) throws Exception {
        int n3 = n >> 8;
        int n4 = n & 0xFF;
        int n5 = this.fAttlistHead[n3][n4];
        int n6 = n2;
        int n7 = -1;
        while (n5 != -1) {
            int n8;
            boolean bl3;
            int n9 = n5 >> 8;
            int n10 = n5 & 0xFF;
            int n11 = this.fAttName[n9][n10];
            int n12 = this.fAttType[n9][n10];
            int n13 = this.fAttDefaultType[n9][n10];
            int n14 = this.fAttValue[n9][n10];
            boolean bl4 = false;
            boolean bl5 = bl3 = n13 == this.fREQUIREDSymbol;
            if (n6 != -1) {
                int n15 = n8 = n12 != this.fCDATASymbol ? 0 : 1;
                if (n8 == 0 || bl3 || n14 != -1) {
                    int n16 = xMLAttrList.getFirstAttr(n6);
                    while (n16 != -1 && (n7 == -1 || n16 <= n7)) {
                        if (this.fStringPool.equalNames(xMLAttrList.getAttrName(n16), n11)) {
                            int n17;
                            if (bl && n13 == this.fFIXEDSymbol && (n17 = xMLAttrList.getAttValue(n16)) != n14 && !this.fStringPool.toString(n17).equals(this.fStringPool.toString(n14))) {
                                Object[] objectArray = new Object[]{this.fStringPool.toString(this.fElementType[n3][n4]), this.fStringPool.toString(n11), this.fStringPool.toString(n17), this.fStringPool.toString(n14)};
                                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 93, 87, objectArray, 1);
                            }
                            bl4 = true;
                            break;
                        }
                        n16 = xMLAttrList.getNextAttr(n16);
                    }
                }
            }
            if (!bl4) {
                if (bl3) {
                    if (bl) {
                        Object[] objectArray = new Object[]{this.fStringPool.toString(this.fElementType[n3][n4]), this.fStringPool.toString(n11)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 94, 88, objectArray, 1);
                    }
                } else if (n14 != -1) {
                    if (bl && bl2 && this.fAttDefIsExternal[n9][n10] != 0) {
                        Object[] objectArray = new Object[]{this.fStringPool.toString(this.fElementType[n3][n4]), this.fStringPool.toString(n11)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 95, 80, objectArray, 1);
                    }
                    if (n12 == this.fIDREFSymbol) {
                        this.addIdRef(n14);
                    } else if (n12 == this.fIDREFSSymbol) {
                        StringTokenizer stringTokenizer = new StringTokenizer(this.fStringPool.toString(n14));
                        while (stringTokenizer.hasMoreTokens()) {
                            String string = stringTokenizer.nextToken();
                            this.addIdRef(this.fStringPool.addSymbol(string));
                        }
                    }
                    if (n2 == -1) {
                        n2 = xMLAttrList.startAttrList();
                    }
                    n8 = xMLAttrList.addAttr(n11, n14, n12, false, false);
                    if (n7 == -1) {
                        n7 = n8;
                    }
                }
            }
            n5 = this.fNextAttDef[n9][n10];
        }
        return n2;
    }

    protected boolean addId(int n) {
        Integer n2 = new Integer(n);
        if (this.fIdDefs == null) {
            this.fIdDefs = new Hashtable();
        } else if (this.fIdDefs.containsKey(n2)) {
            return false;
        }
        if (this.fNullValue == null) {
            this.fNullValue = new Object();
        }
        this.fIdDefs.put(n2, this.fNullValue);
        return true;
    }

    protected void addIdRef(int n) {
        Integer n2 = new Integer(n);
        if (this.fIdDefs != null && this.fIdDefs.containsKey(n2)) {
            return;
        }
        if (this.fIdRefs == null) {
            this.fIdRefs = new Hashtable();
        } else if (this.fIdRefs.containsKey(n2)) {
            return;
        }
        if (this.fNullValue == null) {
            this.fNullValue = new Object();
        }
        this.fIdRefs.put(n2, this.fNullValue);
    }

    private void checkIdRefs() throws Exception {
        if (this.fIdRefs == null) {
            return;
        }
        Enumeration enumeration = this.fIdRefs.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (this.fIdDefs != null && this.fIdDefs.containsKey(n)) continue;
            Object[] objectArray = new Object[]{this.fStringPool.toString(n)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 81, 2, objectArray, 1);
        }
    }

    private void checkDeclaredElements() throws Exception {
        int n = 0;
        while (n < this.fElementCount) {
            int n2 = this.getContentSpecType(n);
            if (n2 == this.fMIXEDSymbol || n2 == this.fCHILDRENSymbol) {
                int n3 = n >> 8;
                int n4 = n & 0xFF;
                int n5 = this.fContentSpec[n3][n4];
                this.checkDeclaredElements(n, n5);
            }
            ++n;
        }
    }

    private void checkDeclaredElements(int n, int n2) throws Exception {
        int n3 = n2 >> 8;
        int n4 = n2 & 0xFF;
        byte by = this.fNodeType[n3][n4];
        int n5 = this.fNodeValue[n3][n4];
        switch (by) {
            case 0: {
                if (n5 == -1 || this.fStringPool.getDeclaration(n5) != -1) break;
                int n6 = n >> 8;
                int n7 = n & 0xFF;
                int n8 = this.fElementType[n6][n7];
                Object[] objectArray = new Object[]{this.fStringPool.toString(n8), this.fStringPool.toString(n5)};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 92, 83, objectArray, 0);
                return;
            }
            case 1: 
            case 2: 
            case 3: {
                this.checkDeclaredElements(n, n5);
                return;
            }
            case 4: 
            case 5: {
                this.checkDeclaredElements(n, n5);
                if (++n4 == 256) {
                    ++n3;
                    n4 = 0;
                }
                this.checkDeclaredElements(n, this.fNodeValue[n3][n4]);
                return;
            }
        }
    }

    public interface EventHandler {
        public void setValidating(boolean var1) throws Exception;

        public void startDTD(int var1, int var2, int var3) throws Exception;

        public void endDTD() throws Exception;

        public void elementDecl(int var1, XMLValidator.ContentSpec var2) throws Exception;

        public void attlistDecl(int var1, int var2, int var3, String var4, int var5, int var6) throws Exception;

        public void internalPEDecl(int var1, int var2) throws Exception;

        public void externalPEDecl(int var1, int var2, int var3) throws Exception;

        public void internalEntityDecl(int var1, int var2) throws Exception;

        public void externalEntityDecl(int var1, int var2, int var3) throws Exception;

        public void unparsedEntityDecl(int var1, int var2, int var3, int var4) throws Exception;

        public void notationDecl(int var1, int var2, int var3) throws Exception;

        public void commentInDTD(int var1) throws Exception;

        public void processingInstructionInDTD(int var1, int var2) throws Exception;

        public void startNamespaceDeclScope(int var1, int var2) throws Exception;

        public void endNamespaceDeclScope(int var1) throws Exception;
    }

    interface AttributeValidator {
        public int normalize(int var1, int var2, int var3, int var4, int var5) throws Exception;
    }

    final class AttValidatorCDATA
    implements AttributeValidator {
        public int normalize(int n, int n2, int n3, int n4, int n5) throws Exception {
            return n3;
        }

        AttValidatorCDATA() {
            DTDValidator.this = DTDValidator.this;
        }
    }

    final class AttValidatorID
    implements AttributeValidator {
        public int normalize(int n, int n2, int n3, int n4, int n5) throws Exception {
            String string = DTDValidator.this.fStringPool.toString(n3);
            String string2 = string.trim();
            if (DTDValidator.this.fValidating) {
                if (string2 != string) {
                    if (DTDValidator.this.invalidStandaloneAttDef(n, n2)) {
                        DTDValidator.this.reportRecoverableXMLError(123, 80, DTDValidator.this.fStringPool.toString(n2), string, string2);
                    }
                    n3 = DTDValidator.this.fStringPool.addSymbol(string2);
                } else {
                    n3 = DTDValidator.this.fStringPool.addSymbol(n3);
                }
                if (!XMLCharacterProperties.validName(string2)) {
                    DTDValidator.this.reportRecoverableXMLError(75, 76, DTDValidator.this.fStringPool.toString(n2), string2);
                }
                if (n != -1 && !DTDValidator.this.addId(n3)) {
                    DTDValidator.this.reportRecoverableXMLError(76, 76, DTDValidator.this.fStringPool.toString(n2), string2);
                }
            } else if (string2 != string) {
                n3 = DTDValidator.this.fStringPool.addSymbol(string2);
            }
            return n3;
        }

        AttValidatorID() {
            DTDValidator.this = DTDValidator.this;
        }
    }

    final class AttValidatorIDREF
    implements AttributeValidator {
        public int normalize(int n, int n2, int n3, int n4, int n5) throws Exception {
            String string = DTDValidator.this.fStringPool.toString(n3);
            String string2 = string.trim();
            if (DTDValidator.this.fValidating) {
                if (string2 != string) {
                    if (DTDValidator.this.invalidStandaloneAttDef(n, n2)) {
                        DTDValidator.this.reportRecoverableXMLError(123, 80, DTDValidator.this.fStringPool.toString(n2), string, string2);
                    }
                    n3 = DTDValidator.this.fStringPool.addSymbol(string2);
                } else {
                    n3 = DTDValidator.this.fStringPool.addSymbol(n3);
                }
                if (!XMLCharacterProperties.validName(string2)) {
                    DTDValidator.this.reportRecoverableXMLError(77, 2, DTDValidator.this.fStringPool.toString(n2), string2);
                }
                if (n != -1) {
                    DTDValidator.this.addIdRef(n3);
                }
            } else if (string2 != string) {
                n3 = DTDValidator.this.fStringPool.addSymbol(string2);
            }
            return n3;
        }

        AttValidatorIDREF() {
            DTDValidator.this = DTDValidator.this;
        }
    }

    final class AttValidatorIDREFS
    implements AttributeValidator {
        public int normalize(int n, int n2, int n3, int n4, int n5) throws Exception {
            String string;
            String string2 = DTDValidator.this.fStringPool.toString(n3);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            StringBuffer stringBuffer = new StringBuffer(string2.length());
            boolean bl = true;
            if (stringTokenizer.hasMoreTokens()) {
                while (true) {
                    string = stringTokenizer.nextToken();
                    if (DTDValidator.this.fValidating) {
                        if (!XMLCharacterProperties.validName(string)) {
                            bl = false;
                        }
                        if (n != -1) {
                            DTDValidator.this.addIdRef(DTDValidator.this.fStringPool.addSymbol(string));
                        }
                    }
                    stringBuffer.append(string);
                    if (!stringTokenizer.hasMoreTokens()) break;
                    stringBuffer.append(' ');
                }
            }
            string = stringBuffer.toString();
            if (DTDValidator.this.fValidating && (!bl || string.length() == 0)) {
                DTDValidator.this.reportRecoverableXMLError(4, 2, DTDValidator.this.fStringPool.toString(n2), string);
            }
            if (!string.equals(string2)) {
                n3 = DTDValidator.this.fStringPool.addString(string);
                if (DTDValidator.this.fValidating && DTDValidator.this.invalidStandaloneAttDef(n, n2)) {
                    DTDValidator.this.reportRecoverableXMLError(123, 80, DTDValidator.this.fStringPool.toString(n2), string2, string);
                }
            }
            return n3;
        }

        AttValidatorIDREFS() {
            DTDValidator.this = DTDValidator.this;
        }
    }

    final class AttValidatorENTITY
    implements AttributeValidator {
        public int normalize(int n, int n2, int n3, int n4, int n5) throws Exception {
            String string = DTDValidator.this.fStringPool.toString(n3);
            String string2 = string.trim();
            if (DTDValidator.this.fValidating) {
                if (string2 != string) {
                    if (DTDValidator.this.invalidStandaloneAttDef(n, n2)) {
                        DTDValidator.this.reportRecoverableXMLError(123, 80, DTDValidator.this.fStringPool.toString(n2), string, string2);
                    }
                    n3 = DTDValidator.this.fStringPool.addSymbol(string2);
                } else {
                    n3 = DTDValidator.this.fStringPool.addSymbol(n3);
                }
                int n6 = DTDValidator.this.fEntityPool.lookupEntity(n3);
                if (n6 == -1 || !DTDValidator.this.fEntityPool.isUnparsedEntity(n6)) {
                    DTDValidator.this.reportRecoverableXMLError(79, 77, DTDValidator.this.fStringPool.toString(n2), string2);
                }
            } else if (string2 != string) {
                n3 = DTDValidator.this.fStringPool.addSymbol(string2);
            }
            return n3;
        }

        AttValidatorENTITY() {
            DTDValidator.this = DTDValidator.this;
        }
    }

    final class AttValidatorENTITIES
    implements AttributeValidator {
        public int normalize(int n, int n2, int n3, int n4, int n5) throws Exception {
            String string;
            String string2 = DTDValidator.this.fStringPool.toString(n3);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            StringBuffer stringBuffer = new StringBuffer(string2.length());
            boolean bl = true;
            if (stringTokenizer.hasMoreTokens()) {
                while (true) {
                    int n6;
                    string = stringTokenizer.nextToken();
                    if (DTDValidator.this.fValidating && ((n6 = DTDValidator.this.fEntityPool.lookupEntity(DTDValidator.this.fStringPool.addSymbol(string))) == -1 || !DTDValidator.this.fEntityPool.isUnparsedEntity(n6))) {
                        bl = false;
                    }
                    stringBuffer.append(string);
                    if (!stringTokenizer.hasMoreTokens()) break;
                    stringBuffer.append(' ');
                }
            }
            string = stringBuffer.toString();
            if (DTDValidator.this.fValidating && (!bl || string.length() == 0)) {
                DTDValidator.this.reportRecoverableXMLError(80, 77, DTDValidator.this.fStringPool.toString(n2), string);
            }
            if (!string.equals(string2)) {
                n3 = DTDValidator.this.fStringPool.addString(string);
                if (DTDValidator.this.fValidating && DTDValidator.this.invalidStandaloneAttDef(n, n2)) {
                    DTDValidator.this.reportRecoverableXMLError(123, 80, DTDValidator.this.fStringPool.toString(n2), string2, string);
                }
            }
            return n3;
        }

        AttValidatorENTITIES() {
            DTDValidator.this = DTDValidator.this;
        }
    }

    final class AttValidatorNMTOKEN
    implements AttributeValidator {
        public int normalize(int n, int n2, int n3, int n4, int n5) throws Exception {
            String string = DTDValidator.this.fStringPool.toString(n3);
            String string2 = string.trim();
            if (DTDValidator.this.fValidating) {
                if (string2 != string) {
                    if (DTDValidator.this.invalidStandaloneAttDef(n, n2)) {
                        DTDValidator.this.reportRecoverableXMLError(123, 80, DTDValidator.this.fStringPool.toString(n2), string, string2);
                    }
                    n3 = DTDValidator.this.fStringPool.addSymbol(string2);
                } else {
                    n3 = DTDValidator.this.fStringPool.addSymbol(n3);
                }
                if (!XMLCharacterProperties.validNmtoken(string2)) {
                    DTDValidator.this.reportRecoverableXMLError(78, 3, DTDValidator.this.fStringPool.toString(n2), string2);
                }
            } else if (string2 != string) {
                n3 = DTDValidator.this.fStringPool.addSymbol(string2);
            }
            return n3;
        }

        AttValidatorNMTOKEN() {
            DTDValidator.this = DTDValidator.this;
        }
    }

    final class AttValidatorNMTOKENS
    implements AttributeValidator {
        public int normalize(int n, int n2, int n3, int n4, int n5) throws Exception {
            String string;
            String string2 = DTDValidator.this.fStringPool.toString(n3);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            StringBuffer stringBuffer = new StringBuffer(string2.length());
            boolean bl = true;
            if (stringTokenizer.hasMoreTokens()) {
                while (true) {
                    string = stringTokenizer.nextToken();
                    if (DTDValidator.this.fValidating && !XMLCharacterProperties.validNmtoken(string)) {
                        bl = false;
                    }
                    stringBuffer.append(string);
                    if (!stringTokenizer.hasMoreTokens()) break;
                    stringBuffer.append(' ');
                }
            }
            string = stringBuffer.toString();
            if (DTDValidator.this.fValidating && (!bl || string.length() == 0)) {
                DTDValidator.this.reportRecoverableXMLError(5, 3, DTDValidator.this.fStringPool.toString(n2), string);
            }
            if (!string.equals(string2)) {
                n3 = DTDValidator.this.fStringPool.addString(string);
                if (DTDValidator.this.fValidating && DTDValidator.this.invalidStandaloneAttDef(n, n2)) {
                    DTDValidator.this.reportRecoverableXMLError(123, 80, DTDValidator.this.fStringPool.toString(n2), string2, string);
                }
            }
            return n3;
        }

        AttValidatorNMTOKENS() {
            DTDValidator.this = DTDValidator.this;
        }
    }

    final class AttValidatorNOTATION
    implements AttributeValidator {
        public int normalize(int n, int n2, int n3, int n4, int n5) throws Exception {
            String string = DTDValidator.this.fStringPool.toString(n3);
            String string2 = string.trim();
            if (DTDValidator.this.fValidating) {
                if (string2 != string) {
                    if (DTDValidator.this.invalidStandaloneAttDef(n, n2)) {
                        DTDValidator.this.reportRecoverableXMLError(123, 80, DTDValidator.this.fStringPool.toString(n2), string, string2);
                    }
                    n3 = DTDValidator.this.fStringPool.addSymbol(string2);
                } else {
                    n3 = DTDValidator.this.fStringPool.addSymbol(n3);
                }
                if (!DTDValidator.this.fStringPool.stringInList(n5, n3)) {
                    DTDValidator.this.reportRecoverableXMLError(90, 84, DTDValidator.this.fStringPool.toString(n2), string2, DTDValidator.this.fStringPool.stringListAsString(n5));
                }
            } else if (string2 != string) {
                n3 = DTDValidator.this.fStringPool.addSymbol(string2);
            }
            return n3;
        }

        AttValidatorNOTATION() {
            DTDValidator.this = DTDValidator.this;
        }
    }

    final class AttValidatorENUMERATION
    implements AttributeValidator {
        public int normalize(int n, int n2, int n3, int n4, int n5) throws Exception {
            String string = DTDValidator.this.fStringPool.toString(n3);
            String string2 = string.trim();
            if (DTDValidator.this.fValidating) {
                if (string2 != string) {
                    if (DTDValidator.this.invalidStandaloneAttDef(n, n2)) {
                        DTDValidator.this.reportRecoverableXMLError(123, 80, DTDValidator.this.fStringPool.toString(n2), string, string2);
                    }
                    n3 = DTDValidator.this.fStringPool.addSymbol(string2);
                } else {
                    n3 = DTDValidator.this.fStringPool.addSymbol(n3);
                }
                if (!DTDValidator.this.fStringPool.stringInList(n5, n3)) {
                    DTDValidator.this.reportRecoverableXMLError(90, 86, DTDValidator.this.fStringPool.toString(n2), string2, DTDValidator.this.fStringPool.stringListAsString(n5));
                }
            } else if (string2 != string) {
                n3 = DTDValidator.this.fStringPool.addSymbol(string2);
            }
            return n3;
        }

        AttValidatorENUMERATION() {
            DTDValidator.this = DTDValidator.this;
        }
    }

    class ContentSpecImpl
    implements XMLValidator.ContentSpec {
        public StringPool fStringPool;
        public int fHandle;
        public int fType;

        public String toString() {
            if (this.fType == DTDValidator.this.fMIXEDSymbol || this.fType == DTDValidator.this.fCHILDRENSymbol) {
                return DTDValidator.this.getContentSpecNodeAsString(this.fHandle);
            }
            return this.fStringPool.toString(this.fType);
        }

        public int getType() {
            return this.fType;
        }

        public int getHandle() {
            return this.fHandle;
        }

        public void getNode(int n, XMLContentSpecNode xMLContentSpecNode) {
            DTDValidator.this.getContentSpecNode(n, xMLContentSpecNode);
        }

        ContentSpecImpl() {
            DTDValidator.this = DTDValidator.this;
        }
    }
}

