/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.dtd;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.framework.XMLContentSpecNode;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.dtd.XMLContentModel;

public final class ElementDeclPool {
    private static final int CHUNK_SHIFT = 5;
    private static final int CHUNK_SIZE = 32;
    private static final int CHUNK_MASK = 31;
    private static final int INITIAL_CHUNK_COUNT = 32;
    private StringPool fStringPool;
    private XMLErrorReporter fErrorReporter;
    private int fElementCount;
    private int[][] fElementType = new int[32][];
    private byte[][] fElementDeclIsExternal = new byte[32][];
    private int[][] fContentSpecType = new int[32][];
    private int[][] fContentSpec = new int[32][];
    private XMLContentModel[][] fContentModel = new XMLContentModel[32][];
    private int[][] fAttlistHead = new int[32][];
    private int[][] fAttlistTail = new int[32][];
    private int fNodeCount;
    private byte[][] fNodeType = new byte[32][];
    private int[][] fNodeValue = new int[32][];
    private int fAttDefCount;
    private int[][] fAttName = new int[32][];
    private int[][] fAttType = new int[32][];
    private int[][] fEnumeration = new int[32][];
    private int[][] fAttDefaultType = new int[32][];
    private int[][] fAttValue = new int[32][];
    private byte[][] fAttDefIsExternal = new byte[32][];
    private int[][] fNextAttDef = new int[32][];
    private static final int INITIAL_BUCKET_SIZE = 4;
    private static final int HASHTABLE_SIZE = 128;
    private int[][] fElementTypeHashtable = new int[128][];
    private int fIDSymbol = -1;
    private int fNotationSymbol = -1;
    private int fMIXEDSymbol = -1;
    private int fCHILDRENSymbol = -1;
    private Hashtable fIdDefs;
    private Hashtable fIdRefs;
    private Object fNullValue;

    public ElementDeclPool(StringPool stringPool, XMLErrorReporter xMLErrorReporter) {
        this.fStringPool = stringPool;
        this.fErrorReporter = xMLErrorReporter;
    }

    public void reset(StringPool stringPool) {
        this.fStringPool = stringPool;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fElementCount) {
            this.fContentModel[n][n2] = null;
            if (++n2 == 32) {
                ++n;
                n2 = 0;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < 128) {
            this.fElementTypeHashtable[n4] = null;
            ++n4;
        }
        this.fElementCount = 0;
        this.fNodeCount = 0;
        this.fAttDefCount = 0;
        this.fIDSymbol = -1;
        this.fNotationSymbol = -1;
        this.fMIXEDSymbol = -1;
        this.fCHILDRENSymbol = -1;
        if (this.fIdDefs != null) {
            this.fIdDefs.clear();
        }
        if (this.fIdRefs != null) {
            this.fIdRefs.clear();
        }
    }

    private boolean ensureElementCapacity(int n) {
        try {
            return this.fElementType[n][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byte[][] byArray = new byte[n * 2][];
            System.arraycopy(this.fElementDeclIsExternal, 0, byArray, 0, n);
            this.fElementDeclIsExternal = byArray;
            int[][] nArray = new int[n * 2][];
            System.arraycopy(this.fElementType, 0, nArray, 0, n);
            this.fElementType = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fContentSpecType, 0, nArray, 0, n);
            this.fContentSpecType = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fContentSpec, 0, nArray, 0, n);
            this.fContentSpec = nArray;
            XMLContentModel[][] xMLContentModelArray = new XMLContentModel[n * 2][];
            System.arraycopy(this.fContentModel, 0, xMLContentModelArray, 0, n);
            this.fContentModel = xMLContentModelArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fAttlistHead, 0, nArray, 0, n);
            this.fAttlistHead = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fAttlistTail, 0, nArray, 0, n);
            this.fAttlistTail = nArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fElementType[n] = new int[32];
        this.fElementDeclIsExternal[n] = new byte[32];
        this.fContentSpecType[n] = new int[32];
        this.fContentSpec[n] = new int[32];
        this.fContentModel[n] = new XMLContentModel[32];
        this.fAttlistHead[n] = new int[32];
        this.fAttlistTail[n] = new int[32];
        return true;
    }

    public int getElement(int n) {
        int n2 = (n = this.fStringPool.getFullNameForQName(n)) % 128;
        int[] nArray = this.fElementTypeHashtable[n2];
        if (nArray != null) {
            int n3 = 1;
            int n4 = 0;
            while (n4 < nArray[0]) {
                if (nArray[n3] == n) {
                    return nArray[n3 + 1];
                }
                n3 += 2;
                ++n4;
            }
        }
        return -1;
    }

    public int addElement(int n) {
        int n2;
        int n3;
        int n4 = this.fStringPool.getFullNameForQName(n);
        int n5 = n4 % 128;
        int[] nArray = this.fElementTypeHashtable[n5];
        if (nArray != null) {
            n3 = 1;
            n2 = 0;
            while (n2 < nArray[0]) {
                if (nArray[n3] == n4) {
                    return nArray[n3 + 1];
                }
                n3 += 2;
                ++n2;
            }
        }
        n3 = this.fElementCount >> 5;
        n2 = this.fElementCount & 0x1F;
        this.ensureElementCapacity(n3);
        this.fElementType[n3][n2] = n;
        this.fElementDeclIsExternal[n3][n2] = 0;
        this.fContentSpecType[n3][n2] = -1;
        this.fContentSpec[n3][n2] = -1;
        this.fContentModel[n3][n2] = null;
        this.fAttlistHead[n3][n2] = -1;
        this.fAttlistTail[n3][n2] = -1;
        if (nArray == null) {
            nArray = new int[9];
            nArray[0] = 1;
            nArray[1] = n4;
            nArray[2] = this.fElementCount;
            this.fElementTypeHashtable[n5] = nArray;
        } else {
            int n6 = nArray[0];
            int n7 = 1 + n6 * 2;
            if (n7 == nArray.length) {
                int n8 = n6 + 4;
                int[] nArray2 = new int[1 + n8 * 2];
                System.arraycopy(nArray, 0, nArray2, 0, n7);
                nArray = nArray2;
                this.fElementTypeHashtable[n5] = nArray;
            }
            nArray[n7++] = n4;
            nArray[n7++] = this.fElementCount;
            nArray[0] = ++n6;
        }
        return this.fElementCount++;
    }

    public int addElementDecl(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int n6 = this.fStringPool.getFullNameForQName(n);
        int n7 = n6 % 128;
        int[] nArray = this.fElementTypeHashtable[n7];
        if (nArray != null) {
            n5 = 1;
            n4 = 0;
            while (n4 < nArray[0]) {
                if (nArray[n5] == n6) {
                    int n8 = nArray[n5 + 1];
                    int n9 = n8 >> 5;
                    int n10 = n8 & 0x1F;
                    if (this.fContentSpecType[n9][n10] != -1) {
                        return -1;
                    }
                    this.fElementDeclIsExternal[n9][n10] = (byte)(bl ? 1 : 0);
                    this.fContentSpecType[n9][n10] = n2;
                    this.fContentSpec[n9][n10] = n3;
                    this.fContentModel[n9][n10] = null;
                    return n8;
                }
                n5 += 2;
                ++n4;
            }
        }
        n5 = this.fElementCount >> 5;
        n4 = this.fElementCount & 0x1F;
        this.ensureElementCapacity(n5);
        this.fElementType[n5][n4] = n;
        this.fElementDeclIsExternal[n5][n4] = (byte)(bl ? 1 : 0);
        this.fContentSpecType[n5][n4] = n2;
        this.fContentSpec[n5][n4] = n3;
        this.fContentModel[n5][n4] = null;
        this.fAttlistHead[n5][n4] = -1;
        this.fAttlistTail[n5][n4] = -1;
        if (nArray == null) {
            nArray = new int[9];
            nArray[0] = 1;
            nArray[1] = n6;
            nArray[2] = this.fElementCount;
            this.fElementTypeHashtable[n7] = nArray;
        } else {
            int n11 = nArray[0];
            int n12 = 1 + n11 * 2;
            if (n12 == nArray.length) {
                int n13 = n11 + 4;
                int[] nArray2 = new int[1 + n13 * 2];
                System.arraycopy(nArray, 0, nArray2, 0, n12);
                nArray = nArray2;
                this.fElementTypeHashtable[n7] = nArray;
            }
            nArray[n12++] = n6;
            nArray[n12++] = this.fElementCount;
            nArray[0] = ++n11;
        }
        return this.fElementCount++;
    }

    public int getElementType(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return -1;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fElementType[n2][n3];
    }

    public boolean getElementDeclIsExternal(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return false;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fElementDeclIsExternal[n2][n3] != 0;
    }

    public int getContentSpecType(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return -1;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fContentSpecType[n2][n3];
    }

    public int getContentSpec(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return -1;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fContentSpec[n2][n3];
    }

    public void setContentSpec(int n, int n2) {
        if (n < 0 || n >= this.fElementCount) {
            return;
        }
        int n3 = n >> 5;
        int n4 = n & 0x1F;
        this.fContentSpec[n3][n4] = n2;
    }

    public String getContentSpecAsString(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return null;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        int n4 = this.fContentSpecType[n2][n3];
        if (this.fMIXEDSymbol == -1) {
            this.fMIXEDSymbol = this.fStringPool.addSymbol("MIXED");
            this.fCHILDRENSymbol = this.fStringPool.addSymbol("CHILDREN");
        }
        if (n4 == this.fMIXEDSymbol || n4 == this.fCHILDRENSymbol) {
            return this.getContentSpecNodeAsString(this.fContentSpec[n2][n3]);
        }
        return this.fStringPool.toString(n4);
    }

    public XMLContentModel getContentModel(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return null;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fContentModel[n2][n3];
    }

    public void setContentModel(int n, XMLContentModel xMLContentModel) {
        if (n < 0 || n >= this.fElementCount) {
            return;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        this.fContentModel[n2][n3] = xMLContentModel;
    }

    private boolean ensureNodeCapacity(int n) {
        try {
            return this.fNodeType[n][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byte[][] byArray = new byte[n * 2][];
            System.arraycopy(this.fNodeType, 0, byArray, 0, n);
            this.fNodeType = byArray;
            int[][] nArray = new int[n * 2][];
            System.arraycopy(this.fNodeValue, 0, nArray, 0, n);
            this.fNodeValue = nArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fNodeType[n] = new byte[32];
        this.fNodeValue[n] = new int[32];
        return true;
    }

    private int addUniqueLeafNode(int n) throws Exception {
        int n2;
        int n3;
        block3: {
            if (n != -1) {
                n3 = this.fNodeCount >> 5;
                n2 = this.fNodeCount & 0x1F;
                while (true) {
                    byte by;
                    if (n2-- == 0) {
                        n2 = 31;
                        --n3;
                    }
                    if ((by = this.fNodeType[n3][n2]) != 0) continue;
                    int n4 = this.fNodeValue[n3][n2];
                    if (n4 == -1) break block3;
                    if (n4 == n) break;
                }
                return -1;
            }
        }
        n3 = this.fNodeCount >> 5;
        n2 = this.fNodeCount & 0x1F;
        this.ensureNodeCapacity(n3);
        this.fNodeType[n3][n2] = 0;
        this.fNodeValue[n3][n2] = n;
        return this.fNodeCount++;
    }

    public int addContentSpecNode(int n, int n2, int n3, boolean bl) throws Exception {
        if (bl) {
            return this.addUniqueLeafNode(n2);
        }
        int n4 = this.fNodeCount >> 5;
        int n5 = this.fNodeCount & 0x1F;
        this.ensureNodeCapacity(n4);
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.fNodeType[n4][n5] = (byte)n;
                this.fNodeValue[n4][n5] = n2;
                return this.fNodeCount++;
            }
            case 4: 
            case 5: {
                this.fNodeType[n4][n5] = (byte)n;
                this.fNodeValue[n4][n5] = n2;
                int n6 = this.fNodeCount++;
                if (++n5 == 32) {
                    this.ensureNodeCapacity(++n4);
                    n5 = 0;
                }
                this.fNodeType[n4][n5] = (byte)(n | 0x40);
                this.fNodeValue[n4][n5] = n3;
                ++this.fNodeCount;
                return n6;
            }
        }
        return -1;
    }

    public void getContentSpecNode(int n, XMLContentSpecNode xMLContentSpecNode) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        xMLContentSpecNode.type = this.fNodeType[n2][n3];
        xMLContentSpecNode.value = this.fNodeValue[n2][n3];
        if (xMLContentSpecNode.type == 4 || xMLContentSpecNode.type == 5) {
            if (++n3 == 32) {
                ++n2;
                n3 = 0;
            }
            xMLContentSpecNode.otherValue = this.fNodeValue[n2][n3];
            return;
        }
        xMLContentSpecNode.otherValue = -1;
    }

    private void appendContentSpecNode(int n, StringBuffer stringBuffer, boolean bl) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        byte by = this.fNodeType[n2][n3];
        int n4 = this.fNodeValue[n2][n3];
        switch (by) {
            case 0: {
                stringBuffer.append(n4 == -1 ? "#PCDATA" : this.fStringPool.toString(n4));
                return;
            }
            case 1: {
                this.appendContentSpecNode(n4, stringBuffer, false);
                stringBuffer.append('?');
                return;
            }
            case 2: {
                this.appendContentSpecNode(n4, stringBuffer, false);
                stringBuffer.append('*');
                return;
            }
            case 3: {
                this.appendContentSpecNode(n4, stringBuffer, false);
                stringBuffer.append('+');
                return;
            }
            case 4: 
            case 5: {
                int n5;
                int n6;
                byte by2;
                if (!bl) {
                    stringBuffer.append('(');
                }
                this.appendContentSpecNode(n4, stringBuffer, (by2 = this.fNodeType[n6 = n4 >> 5][n5 = n4 & 0x1F]) == by);
                stringBuffer.append(by == 4 ? (char)'|' : ',');
                if (++n3 == 32) {
                    ++n2;
                    n3 = 0;
                }
                this.appendContentSpecNode(this.fNodeValue[n2][n3], stringBuffer, false);
                if (!bl) {
                    stringBuffer.append(')');
                }
                return;
            }
        }
    }

    public String getContentSpecNodeAsString(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        byte by = this.fNodeType[n2][n3];
        int n4 = this.fNodeValue[n2][n3];
        StringBuffer stringBuffer = new StringBuffer();
        switch (by) {
            case 0: {
                stringBuffer.append("(" + (n4 == -1 ? "#PCDATA" : this.fStringPool.toString(n4)) + ")");
                break;
            }
            case 1: {
                n2 = n4 >> 5;
                n3 = n4 & 0x1F;
                if (this.fNodeType[n2][n3] == 0) {
                    n4 = this.fNodeValue[n2][n3];
                    stringBuffer.append("(" + (n4 == -1 ? "#PCDATA" : this.fStringPool.toString(n4)) + ")?");
                    break;
                }
                this.appendContentSpecNode(n, stringBuffer, false);
                break;
            }
            case 2: {
                n2 = n4 >> 5;
                n3 = n4 & 0x1F;
                if (this.fNodeType[n2][n3] == 0) {
                    n4 = this.fNodeValue[n2][n3];
                    stringBuffer.append("(" + (n4 == -1 ? "#PCDATA" : this.fStringPool.toString(n4)) + ")*");
                    break;
                }
                this.appendContentSpecNode(n, stringBuffer, false);
                break;
            }
            case 3: {
                n2 = n4 >> 5;
                n3 = n4 & 0x1F;
                if (this.fNodeType[n2][n3] == 0) {
                    n4 = this.fNodeValue[n2][n3];
                    stringBuffer.append("(" + (n4 == -1 ? "#PCDATA" : this.fStringPool.toString(n4)) + ")+");
                    break;
                }
                this.appendContentSpecNode(n, stringBuffer, false);
                break;
            }
            case 4: 
            case 5: {
                this.appendContentSpecNode(n, stringBuffer, false);
                break;
            }
            default: {
                return null;
            }
        }
        return stringBuffer.toString();
    }

    private boolean ensureAttrCapacity(int n) {
        try {
            return this.fAttName[n][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byte[][] byArray = new byte[n * 2][];
            System.arraycopy(this.fAttDefIsExternal, 0, byArray, 0, n);
            this.fAttDefIsExternal = byArray;
            int[][] nArray = new int[n * 2][];
            System.arraycopy(this.fAttName, 0, nArray, 0, n);
            this.fAttName = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fAttType, 0, nArray, 0, n);
            this.fAttType = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fEnumeration, 0, nArray, 0, n);
            this.fEnumeration = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fAttDefaultType, 0, nArray, 0, n);
            this.fAttDefaultType = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fAttValue, 0, nArray, 0, n);
            this.fAttValue = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fNextAttDef, 0, nArray, 0, n);
            this.fNextAttDef = nArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fAttDefIsExternal[n] = new byte[32];
        this.fAttName[n] = new int[32];
        this.fAttType[n] = new int[32];
        this.fEnumeration[n] = new int[32];
        this.fAttDefaultType[n] = new int[32];
        this.fAttValue[n] = new int[32];
        this.fNextAttDef[n] = new int[32];
        return true;
    }

    public int addAttDef(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3) throws Exception {
        int n7;
        int n8;
        int n9 = n >> 5;
        int n10 = n & 0x1F;
        int n11 = this.fAttlistHead[n9][n10];
        int n12 = -1;
        int n13 = -1;
        if (bl2 && this.fIDSymbol == -1) {
            this.fIDSymbol = this.fStringPool.addSymbol("ID");
            this.fNotationSymbol = this.fStringPool.addSymbol("NOTATION");
        }
        while (n11 != -1) {
            n8 = n11 >> 5;
            n7 = n11 & 0x1F;
            if (this.fStringPool.equalNames(this.fAttName[n8][n7], n2)) {
                if (bl3) {
                    Object[] objectArray = new Object[]{this.fStringPool.toString(this.fElementType[n9][n10]), this.fStringPool.toString(n2)};
                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 85, 85, objectArray, 0);
                }
                return -1;
            }
            if (bl2) {
                if (n3 == this.fIDSymbol && this.fAttType[n8][n7] == this.fIDSymbol) {
                    n12 = this.fAttName[n8][n7];
                }
                if (n3 == this.fNotationSymbol && this.fAttType[n8][n7] == this.fNotationSymbol) {
                    n13 = this.fAttName[n8][n7];
                }
            }
            n11 = this.fNextAttDef[n8][n7];
        }
        if (bl2) {
            if (n12 != -1) {
                Object[] objectArray = new Object[]{this.fStringPool.toString(this.fElementType[n9][n10]), this.fStringPool.toString(n12), this.fStringPool.toString(n2)};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 86, 81, objectArray, 1);
                return -1;
            }
            if (n13 != -1) {
                Object[] objectArray = new Object[]{this.fStringPool.toString(this.fElementType[n9][n10]), this.fStringPool.toString(n13), this.fStringPool.toString(n2)};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 121, 143, objectArray, 1);
                return -1;
            }
        }
        n8 = this.fAttDefCount >> 5;
        n7 = this.fAttDefCount & 0x1F;
        this.ensureAttrCapacity(n8);
        this.fAttName[n8][n7] = n2;
        this.fAttType[n8][n7] = n3;
        this.fEnumeration[n8][n7] = n4;
        this.fAttDefaultType[n8][n7] = n5;
        this.fAttDefIsExternal[n8][n7] = (byte)(bl ? 1 : 0);
        this.fAttValue[n8][n7] = n6;
        int n14 = -1;
        if (n6 != -1) {
            n14 = this.fAttlistHead[n9][n10];
            this.fAttlistHead[n9][n10] = this.fAttDefCount;
            if (n14 == -1) {
                this.fAttlistTail[n9][n10] = this.fAttDefCount;
            }
        } else {
            n14 = this.fAttlistTail[n9][n10];
            this.fAttlistTail[n9][n10] = this.fAttDefCount;
            if (n14 == -1) {
                this.fAttlistHead[n9][n10] = this.fAttDefCount;
            } else {
                this.fNextAttDef[n14 >> 5][n14 & 0x1F] = this.fAttDefCount;
                n14 = -1;
            }
        }
        this.fNextAttDef[n8][n7] = n14;
        return this.fAttDefCount++;
    }

    public int getAttDef(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.fElementCount) {
            if (this.fStringPool.equalNames(this.fElementType[n3][n4], n)) {
                int n6 = this.fAttlistHead[n3][n4];
                while (true) {
                    if (n6 == -1) {
                        return -1;
                    }
                    n3 = n6 >> 5;
                    n4 = n6 & 0x1F;
                    if (this.fStringPool.equalNames(this.fAttName[n3][n4], n2)) {
                        return n6;
                    }
                    n6 = this.fNextAttDef[n3][n4];
                }
            }
            if (++n4 == 32) {
                ++n3;
                n4 = 0;
            }
            ++n5;
        }
        return -1;
    }

    public boolean copyAtts(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        try {
            int n5 = 0;
            while (n5 < this.fElementCount) {
                if (this.fElementType[n3][n4] == n) {
                    int n6 = this.fAttlistHead[n3][n4];
                    while (n6 != -1) {
                        this.addAttDef(this.getElement(n2), this.getAttName(n6), this.getAttType(n6), this.getEnumeration(n6), this.getAttDefaultType(n6), this.getAttValue(n6), this.getAttDefIsExternal(n6), true, false);
                        n3 = n6 >> 5;
                        n4 = n6 & 0x1F;
                        n6 = this.fNextAttDef[n3][n4];
                    }
                    return true;
                }
                if (++n4 == 32) {
                    ++n3;
                    n4 = 0;
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean getAttDefIsExternal(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttDefIsExternal[n2][n3] != 0;
    }

    public int getAttName(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttName[n2][n3];
    }

    public int getAttValue(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttValue[n2][n3];
    }

    public int getAttType(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttType[n2][n3];
    }

    public int getAttDefaultType(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttDefaultType[n2][n3];
    }

    public int getEnumeration(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fEnumeration[n2][n3];
    }

    public int addDefaultAttributes(int n, XMLAttrList xMLAttrList, int n2, boolean bl, boolean bl2) throws Exception {
        int n3 = n >> 5;
        int n4 = n & 0x1F;
        int n5 = this.fAttlistHead[n3][n4];
        int n6 = n2;
        int n7 = -1;
        while (n5 != -1) {
            int n8;
            int n9 = n5 >> 5;
            int n10 = n5 & 0x1F;
            int n11 = this.fAttName[n9][n10];
            int n12 = this.fAttType[n9][n10];
            int n13 = this.fAttDefaultType[n9][n10];
            int n14 = this.fAttValue[n9][n10];
            boolean bl3 = false;
            boolean bl4 = n13 == this.fStringPool.addSymbol("#REQUIRED");
            this.fStringPool.addSymbol("#IMPLIED");
            if (n6 != -1) {
                boolean bl5;
                n8 = n12 != this.fStringPool.addSymbol("CDATA") ? 0 : 1;
                boolean bl6 = bl5 = n13 == this.fStringPool.addSymbol("#FIXED");
                if (n8 == 0 || bl4 || n14 != -1) {
                    int n15 = xMLAttrList.getFirstAttr(n6);
                    while (n15 != -1 && (n7 == -1 || n15 <= n7)) {
                        if (this.fStringPool.equalNames(xMLAttrList.getAttrName(n15), n11)) {
                            int n16;
                            if (bl && bl5 && (n16 = xMLAttrList.getAttValue(n15)) != n14 && !this.fStringPool.toString(n16).equals(this.fStringPool.toString(n14))) {
                                Object[] objectArray = new Object[]{this.fStringPool.toString(this.fElementType[n3][n4]), this.fStringPool.toString(n11), this.fStringPool.toString(n16), this.fStringPool.toString(n14)};
                                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 93, 87, objectArray, 1);
                            }
                            bl3 = true;
                            break;
                        }
                        n15 = xMLAttrList.getNextAttr(n15);
                    }
                }
            }
            if (!bl3) {
                if (bl4) {
                    if (bl) {
                        Object[] objectArray = new Object[]{this.fStringPool.toString(this.fElementType[n3][n4]), this.fStringPool.toString(n11)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 94, 88, objectArray, 1);
                    }
                } else if (n14 != -1) {
                    if (bl && bl2 && this.fAttDefIsExternal[n9][n10] != 0) {
                        Object[] objectArray = new Object[]{this.fStringPool.toString(this.fElementType[n3][n4]), this.fStringPool.toString(n11)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 95, 80, objectArray, 1);
                    }
                    if (n12 == this.fStringPool.addSymbol("IDREF")) {
                        this.addIdRef(n14);
                    } else if (n12 == this.fStringPool.addSymbol("IDREFS")) {
                        StringTokenizer stringTokenizer = new StringTokenizer(this.fStringPool.toString(n14));
                        while (stringTokenizer.hasMoreTokens()) {
                            String string = stringTokenizer.nextToken();
                            this.addIdRef(this.fStringPool.addSymbol(string));
                        }
                    }
                    if (n2 == -1) {
                        n2 = xMLAttrList.startAttrList();
                    }
                    n8 = xMLAttrList.addAttr(n11, n14, n12, false, false);
                    if (n7 == -1) {
                        n7 = n8;
                    }
                }
            }
            n5 = this.fNextAttDef[n9][n10];
        }
        return n2;
    }

    public boolean addId(int n) {
        Integer n2 = new Integer(n);
        if (this.fIdDefs == null) {
            this.fIdDefs = new Hashtable();
        } else if (this.fIdDefs.containsKey(n2)) {
            return false;
        }
        if (this.fNullValue == null) {
            this.fNullValue = new Object();
        }
        this.fIdDefs.put(n2, this.fNullValue);
        return true;
    }

    public void addIdRef(int n) {
        Integer n2 = new Integer(n);
        if (this.fIdDefs != null && this.fIdDefs.containsKey(n2)) {
            return;
        }
        if (this.fIdRefs == null) {
            this.fIdRefs = new Hashtable();
        } else if (this.fIdRefs.containsKey(n2)) {
            return;
        }
        if (this.fNullValue == null) {
            this.fNullValue = new Object();
        }
        this.fIdRefs.put(n2, this.fNullValue);
    }

    public void checkIdRefs() throws Exception {
        if (this.fIdRefs == null) {
            return;
        }
        Enumeration enumeration = this.fIdRefs.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (this.fIdDefs != null && this.fIdDefs.containsKey(n)) continue;
            Object[] objectArray = new Object[]{this.fStringPool.toString(n)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 81, 2, objectArray, 1);
        }
    }

    public void checkDeclaredElements() throws Exception {
        int n = 0;
        while (n < this.fElementCount) {
            int n2 = this.getContentSpecType(n);
            if (n2 == this.fStringPool.addSymbol("MIXED") || n2 == this.fStringPool.addSymbol("CHILDREN")) {
                int n3 = n >> 5;
                int n4 = n & 0x1F;
                int n5 = this.fContentSpec[n3][n4];
                this.checkDeclaredElements(n, n5);
            }
            ++n;
        }
    }

    private void checkDeclaredElements(int n, int n2) throws Exception {
        int n3 = n2 >> 5;
        int n4 = n2 & 0x1F;
        byte by = this.fNodeType[n3][n4];
        int n5 = this.fNodeValue[n3][n4];
        switch (by) {
            case 0: {
                if (n5 == -1 || this.getElement(n5) != -1) break;
                int n6 = n >> 5;
                int n7 = n & 0x1F;
                int n8 = this.fElementType[n6][n7];
                Object[] objectArray = new Object[]{this.fStringPool.toString(n8), this.fStringPool.toString(n5)};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 92, 83, objectArray, 0);
                return;
            }
            case 1: 
            case 2: 
            case 3: {
                this.checkDeclaredElements(n, n5);
                return;
            }
            case 4: 
            case 5: {
                this.checkDeclaredElements(n, n5);
                if (++n4 == 32) {
                    ++n3;
                    n4 = 0;
                }
                this.checkDeclaredElements(n, this.fNodeValue[n3][n4]);
                return;
            }
        }
    }
}

