/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.xml.serialize.BaseSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.HTMLdtd;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;

public class HTMLSerializer
extends BaseSerializer {
    private static boolean _xhtml;

    protected HTMLSerializer(boolean bl) {
        _xhtml = bl;
    }

    public HTMLSerializer() {
        this(false);
    }

    public HTMLSerializer(Writer writer, OutputFormat outputFormat) {
        this(false);
        if (outputFormat == null) {
            outputFormat = new OutputFormat("html", null, false);
        }
        this.init(writer, outputFormat);
    }

    public HTMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        this(false);
        if (outputFormat == null) {
            outputFormat = new OutputFormat("html", null, false);
        }
        try {
            this.init(outputStream, outputFormat);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
    }

    public void startDocument() {
    }

    public void startElement(String string, AttributeList attributeList) {
        boolean bl;
        ElementState elementState = this.getElementState();
        if (elementState == null) {
            if (!this._started) {
                this.startDocument(string);
            }
            bl = this._format.getPreserveSpace();
        } else {
            if (elementState.empty) {
                this.printText(">");
            }
            bl = elementState.preserveSpace;
            if (this._format.getIndenting() && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this.breakLine();
            }
        }
        if (_xhtml) {
            this.printText(String.valueOf('<') + string.toLowerCase());
        } else {
            this.printText(String.valueOf('<') + string);
        }
        this.indent();
        if (attributeList != null) {
            int n = 0;
            while (n < attributeList.getLength()) {
                this.printSpace();
                String string2 = attributeList.getName(n).toLowerCase();
                String string3 = attributeList.getValue(n);
                if (_xhtml) {
                    if (string3 == null) {
                        this.printText(String.valueOf(string2) + "=\"\"");
                    } else {
                        this.printText(String.valueOf(string2) + "=\"" + this.escape(string3) + '\"');
                    }
                } else if (string3 == null) {
                    this.printText(string2);
                } else if (HTMLdtd.isURI(string, string2)) {
                    this.printText(String.valueOf(string2) + "=\"" + this.escapeURI(string3) + '\"');
                } else {
                    this.printText(String.valueOf(string2) + "=\"" + this.escape(string3) + '\"');
                }
                ++n;
            }
        }
        if (HTMLdtd.isPreserveSpace(string)) {
            bl = true;
        }
        this.enterElementState(string, bl);
        if (string.equalsIgnoreCase("SCRIPT") || string.equalsIgnoreCase("STYLE")) {
            if (_xhtml) {
                this.getElementState().cdata = true;
                return;
            }
            this.getElementState().unescaped = true;
        }
    }

    public void endElement(String string) {
        this.unindent();
        ElementState elementState = this.getElementState();
        if (elementState.empty) {
            if (_xhtml) {
                this.printText(" />");
            } else {
                this.printText(">");
            }
        } else if (_xhtml) {
            this.printText("</" + string.toLowerCase() + ">");
        } else if (!HTMLdtd.isOnlyOpening(string)) {
            if (!string.equalsIgnoreCase("A") && this._format.getIndenting() && !elementState.preserveSpace && elementState.afterElement) {
                this.breakLine();
            }
            this.printText("</" + string + ">");
        }
        elementState = this.leaveElementState();
        if (elementState != null) {
            elementState.afterElement = true;
            elementState.empty = false;
            return;
        }
        this.flush();
    }

    protected void startDocument(String string) {
        this.leaveDTD();
        if (!this._started) {
            String string2 = this._format.getDoctypePublic();
            String string3 = this._format.getDoctypeSystem();
            if (string2 == null && string3 == null) {
                if (_xhtml) {
                    string2 = "-//W3C//DTD XHTML 1.0 Strict//EN";
                    string3 = "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";
                } else {
                    string2 = "-//W3C//DTD HTML 4.0//EN";
                    string3 = "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";
                }
            }
            if (!(string2 == null || _xhtml && string3 == null)) {
                this.printText("<!DOCTYPE HTML PUBLIC ");
                this.printDoctypeURL(string2);
                if (string3 != null) {
                    if (this._format.getIndenting()) {
                        this.breakLine();
                        this.printText("                      ");
                    }
                    this.printDoctypeURL(string3);
                }
                this.printText(">");
                this.breakLine();
            } else if (string3 != null) {
                this.printText("<!DOCTYPE HTML SYSTEM ");
                this.printDoctypeURL(string3);
                this.printText(">");
                this.breakLine();
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    protected void serializeElement(Element element) {
        boolean bl;
        String string = element.getTagName();
        ElementState elementState = this.getElementState();
        if (elementState == null) {
            if (!this._started) {
                this.startDocument(string);
            }
            bl = this._format.getPreserveSpace();
        } else {
            if (elementState.empty) {
                this.printText(">");
            }
            bl = elementState.preserveSpace;
            if (this._format.getIndenting() && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this.breakLine();
            }
        }
        if (_xhtml) {
            this.printText(String.valueOf('<') + string.toLowerCase());
        } else {
            this.printText(String.valueOf('<') + string);
        }
        this.indent();
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                String string2 = attr.getName().toLowerCase();
                String string3 = attr.getValue();
                if (attr.getSpecified()) {
                    this.printSpace();
                    if (_xhtml) {
                        if (string3 == null) {
                            this.printText(String.valueOf(string2) + "=\"\"");
                        } else {
                            this.printText(String.valueOf(string2) + "=\"" + this.escape(string3) + '\"');
                        }
                    } else if (string3 == null) {
                        this.printText(string2);
                    } else if (HTMLdtd.isURI(string, string2)) {
                        this.printText(String.valueOf(string2) + "=\"" + this.escapeURI(string3) + '\"');
                    } else {
                        this.printText(String.valueOf(string2) + "=\"" + this.escape(string3) + '\"');
                    }
                }
                ++n;
            }
        }
        if (HTMLdtd.isPreserveSpace(string)) {
            bl = true;
        }
        if (element.hasChildNodes() || !HTMLdtd.isEmptyTag(string)) {
            this.enterElementState(string, bl);
            if (string.equalsIgnoreCase("SCRIPT") || string.equalsIgnoreCase("STYLE")) {
                if (_xhtml) {
                    this.getElementState().cdata = true;
                } else {
                    this.getElementState().unescaped = true;
                }
            }
            Node node = element.getFirstChild();
            while (node != null) {
                this.serializeNode(node);
                node = node.getNextSibling();
            }
            this.endElement(string);
            return;
        }
        this.unindent();
        if (_xhtml) {
            this.printText(" />");
        } else {
            this.printText(">");
        }
        if (elementState != null) {
            elementState.afterElement = true;
            elementState.empty = false;
        }
    }

    protected void characters(String string, boolean bl, boolean bl2) {
        ElementState elementState = this.content();
        if (elementState != null && (elementState.tagName.equalsIgnoreCase("SCRIPT") || elementState.tagName.equalsIgnoreCase("STYLE"))) {
            if (_xhtml) {
                super.characters(string, true, false);
                return;
            }
            super.characters(string, false, true);
            return;
        }
        super.characters(string, bl, bl2);
    }

    protected String getEntityRef(char c) {
        return HTMLdtd.fromChar(c);
    }

    protected String escapeURI(String string) {
        int n = string.indexOf("\"");
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }
}

