/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.util.Vector;
import org.apache.xalan.xpath.Function;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XPathSupport;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FuncLoader
extends Function {
    private int m_funcID;
    private String m_funcName;
    private String test;

    public FuncLoader(String funcName, int funcID) {
        this.m_funcID = funcID;
        this.m_funcName = funcName;
    }

    public XObject execute(XPath path, XPathSupport execContext, Node context, int opPos, Vector args) throws SAXException {
        try {
            Class<?> function;
            if (this.m_funcName.indexOf(".") < 0) {
                String thisName = this.getClass().getName();
                int lastdot = thisName.lastIndexOf(".");
                String classname = String.valueOf(thisName.substring(0, lastdot + 1)) + this.m_funcName;
                function = Class.forName(classname);
            } else {
                function = Class.forName(this.m_funcName);
            }
            Function func = (Function)function.newInstance();
            path.installFunction(this.m_funcName, this.m_funcID, func);
            return func.execute(path, execContext, context, opPos, args);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            path.warn(9, new Object[]{this.m_funcName});
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            path.warn(9, new Object[]{this.m_funcName});
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            path.warn(9, new Object[]{this.m_funcName});
            return null;
        }
    }
}

