/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.util.Vector;
import org.apache.xalan.xpath.Function;
import org.apache.xalan.xpath.XNodeSet;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.XString;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FuncNormalizeSpace
extends Function {
    public XObject execute(XPath path, XPathSupport execContext, Node context, int opPos, Vector args) throws SAXException {
        XObject obj;
        int nArgs = args.size();
        if (nArgs > 0) {
            if (nArgs > 1) {
                path.error(context, 7);
            }
            obj = (XObject)args.elementAt(0);
        } else {
            obj = new XNodeSet(context);
        }
        String s1 = ((XObject)obj).str();
        return new XString(this.fixWhiteSpace(s1, true, true, false));
    }

    private static boolean isSpace(char ch) {
        return Character.isWhitespace(ch);
    }

    protected String fixWhiteSpace(String string, boolean trimHead, boolean trimTail, boolean doublePunctuationSpaces) {
        char[] buf = string.toCharArray();
        int len = buf.length;
        boolean edit = false;
        int s = 0;
        while (s < len) {
            if (FuncNormalizeSpace.isSpace(buf[s])) break;
            ++s;
        }
        int d = s;
        boolean pres = false;
        while (s < len) {
            char c = buf[s];
            if (FuncNormalizeSpace.isSpace(c)) {
                if (!pres) {
                    if (c != ' ') {
                        edit = true;
                    }
                    buf[d++] = 32;
                    if (doublePunctuationSpaces && s != 0) {
                        char prevChar = buf[s - 1];
                        if (prevChar != '.' && prevChar != '!' && prevChar != '?') {
                            pres = true;
                        }
                    } else {
                        pres = true;
                    }
                } else {
                    edit = true;
                    pres = true;
                }
            } else {
                buf[d++] = c;
                pres = false;
            }
            ++s;
        }
        if (trimTail && d >= 1 && buf[d - 1] == ' ') {
            edit = true;
            --d;
        }
        int start = 0;
        if (trimHead && d > 0 && buf[0] == ' ') {
            edit = true;
            ++start;
        }
        return edit ? new String(buf, start, d - start) : string;
    }
}

