/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.xalan.xpath.MutableNodeList;
import org.apache.xalan.xpath.MutableNodeListImpl;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.xml.XMLParserLiaisonDefault;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XNodeSet
extends XObject {
    public XNodeSet(NodeList val) {
        super(val);
    }

    public XNodeSet() {
        super(new MutableNodeListImpl());
    }

    public XNodeSet(Node n) {
        super(new MutableNodeListImpl());
        if (n != null) {
            ((MutableNodeList)this.m_obj).addNode(n);
        }
    }

    public int getType() {
        return 4;
    }

    private String getTypeString() {
        return "#NODESET";
    }

    double getNumberFromNode(Node n) {
        double result;
        String s = XMLParserLiaisonDefault.getNodeData(n);
        if (s == null) {
            result = 0.0;
        } else {
            try {
                NumberFormat formatter = NumberFormat.getNumberInstance();
                result = formatter.parse(s.trim()).doubleValue();
            }
            catch (ParseException parseException) {
                result = 0.0;
            }
        }
        return result;
    }

    public double num() {
        NodeList nl = this.nodeset();
        int nNodes = nl.getLength();
        double result = nNodes > 0 ? this.getNumberFromNode(nl.item(0)) : Double.NaN;
        return result;
    }

    public boolean bool() {
        return this.nodeset().getLength() > 0;
    }

    String getStringFromNode(Node n) {
        String result;
        short t = n.getNodeType();
        if (t == 8 || t == 7) {
            result = n.getNodeValue();
        } else {
            result = XMLParserLiaisonDefault.getNodeData(n);
            if (result == null) {
                result = "";
            }
        }
        return result;
    }

    public String str() {
        String result;
        NodeList nl = this.nodeset();
        int nNodes = nl.getLength();
        if (nNodes > 0) {
            Node n = nl.item(0);
            result = this.getStringFromNode(n);
        } else {
            result = "";
        }
        return result;
    }

    public DocumentFragment rtree(XPathSupport support) {
        DocumentFragment result = support.getDOMFactory().createDocumentFragment();
        NodeList nl = this.nodeset();
        int nNodes = nl.getLength();
        int i = 0;
        while (i < nNodes) {
            result.appendChild(nl.item(i).cloneNode(true));
            ++i;
        }
        return result;
    }

    public NodeList nodeset() {
        return (NodeList)this.m_obj;
    }

    public MutableNodeList mutableNodeset() {
        MutableNodeList mnl;
        if (this.m_obj instanceof MutableNodeList) {
            mnl = (MutableNodeList)this.m_obj;
        } else {
            mnl = new MutableNodeListImpl(this.nodeset());
            this.m_obj = mnl;
        }
        return mnl;
    }

    public boolean lessThan(XObject obj2) throws SAXException {
        boolean isLT = false;
        int type = obj2.getType();
        if (type == 4) {
            NodeList list1 = this.nodeset();
            NodeList list2 = ((XNodeSet)obj2).nodeset();
            int len1 = list1.getLength();
            int len2 = list2.getLength();
            int i = 0;
            while (i < len1) {
                String s1 = this.getStringFromNode(list1.item(i));
                int k = 0;
                while (k < len2) {
                    String s2 = this.getStringFromNode(list2.item(k));
                    if (s1.compareTo(s2) < 0) {
                        isLT = true;
                        break;
                    }
                    ++k;
                }
                ++i;
            }
        } else if (type == 1) {
            double num1 = this.bool() ? 1.0 : 0.0;
            double num2 = obj2.num();
            isLT = num1 < num2;
        } else if (type == 2) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            double num2 = obj2.num();
            int i = 0;
            while (i < len1) {
                double num1 = this.getNumberFromNode(list1.item(i));
                if (num1 < num2) {
                    isLT = true;
                    break;
                }
                ++i;
            }
        } else if (type == 5) {
            double num2 = obj2.num();
            if (num2 != Double.NaN) {
                NodeList list1 = this.nodeset();
                int len1 = list1.getLength();
                int i = 0;
                while (i < len1) {
                    double num1 = this.getNumberFromNode(list1.item(i));
                    if (num1 < num2) {
                        isLT = true;
                        break;
                    }
                    ++i;
                }
            } else {
                NodeList list1 = this.nodeset();
                int len1 = list1.getLength();
                String s2 = obj2.str();
                int i = 0;
                while (i < len1) {
                    String s1 = this.getStringFromNode(list1.item(i));
                    if (s1.compareTo(s2) < 0) {
                        isLT = true;
                        break;
                    }
                    ++i;
                }
            }
        } else if (type == 3) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            String s2 = obj2.str();
            int i = 0;
            while (i < len1) {
                String s1 = this.getStringFromNode(list1.item(i));
                if (s1.compareTo(s2) < 0) {
                    isLT = true;
                    break;
                }
                ++i;
            }
        } else {
            isLT = this.num() < obj2.num();
        }
        return isLT;
    }

    public boolean lessThanOrEqual(XObject obj2) throws SAXException {
        boolean isLTE = false;
        int type = obj2.getType();
        if (type == 4) {
            NodeList list1 = this.nodeset();
            NodeList list2 = ((XNodeSet)obj2).nodeset();
            int len1 = list1.getLength();
            int len2 = list2.getLength();
            int i = 0;
            while (i < len1) {
                String s1 = this.getStringFromNode(list1.item(i));
                int k = 0;
                while (k < len2) {
                    String s2 = this.getStringFromNode(list2.item(k));
                    if (s1.compareTo(s2) <= 0) {
                        isLTE = true;
                        break;
                    }
                    ++k;
                }
                ++i;
            }
        } else if (type == 1) {
            double num1 = this.bool() ? 1.0 : 0.0;
            double num2 = obj2.num();
            isLTE = num1 <= num2;
        } else if (type == 2) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            double num2 = obj2.num();
            int i = 0;
            while (i < len1) {
                double num1 = this.getNumberFromNode(list1.item(i));
                if (num1 <= num2) {
                    isLTE = true;
                    break;
                }
                ++i;
            }
        } else if (type == 5) {
            double num2 = obj2.num();
            if (num2 != Double.NaN) {
                NodeList list1 = this.nodeset();
                int len1 = list1.getLength();
                int i = 0;
                while (i < len1) {
                    double num1 = this.getNumberFromNode(list1.item(i));
                    if (num1 <= num2) {
                        isLTE = true;
                        break;
                    }
                    ++i;
                }
            } else {
                NodeList list1 = this.nodeset();
                int len1 = list1.getLength();
                String s2 = obj2.str();
                int i = 0;
                while (i < len1) {
                    String s1 = this.getStringFromNode(list1.item(i));
                    if (s1.compareTo(s2) <= 0) {
                        isLTE = true;
                        break;
                    }
                    ++i;
                }
            }
        } else if (type == 3) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            String s2 = obj2.str();
            int i = 0;
            while (i < len1) {
                String s1 = this.getStringFromNode(list1.item(i));
                if (s1.compareTo(s2) <= 0) {
                    isLTE = true;
                    break;
                }
                ++i;
            }
        } else {
            isLTE = this.num() <= obj2.num();
        }
        return isLTE;
    }

    public boolean greaterThan(XObject obj2) throws SAXException {
        boolean isGT = false;
        int type = obj2.getType();
        if (type == 4) {
            NodeList list1 = this.nodeset();
            NodeList list2 = ((XNodeSet)obj2).nodeset();
            int len1 = list1.getLength();
            int len2 = list2.getLength();
            int i = 0;
            while (i < len1) {
                String s1 = this.getStringFromNode(list1.item(i));
                int k = 0;
                while (k < len2) {
                    String s2 = this.getStringFromNode(list2.item(k));
                    if (s1.compareTo(s2) > 0) {
                        isGT = true;
                        break;
                    }
                    ++k;
                }
                ++i;
            }
        } else if (type == 1) {
            double num1 = this.bool() ? 1.0 : 0.0;
            double num2 = obj2.num();
            isGT = num1 > num2;
        } else if (type == 2) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            double num2 = obj2.num();
            int i = 0;
            while (i < len1) {
                double num1 = this.getNumberFromNode(list1.item(i));
                if (num1 > num2) {
                    isGT = true;
                    break;
                }
                ++i;
            }
        } else if (type == 5) {
            double num2 = obj2.num();
            if (num2 != Double.NaN) {
                NodeList list1 = this.nodeset();
                int len1 = list1.getLength();
                int i = 0;
                while (i < len1) {
                    double num1 = this.getNumberFromNode(list1.item(i));
                    if (num1 > num2) {
                        isGT = true;
                        break;
                    }
                    ++i;
                }
            } else {
                NodeList list1 = this.nodeset();
                int len1 = list1.getLength();
                String s2 = obj2.str();
                int i = 0;
                while (i < len1) {
                    String s1 = this.getStringFromNode(list1.item(i));
                    if (s1.compareTo(s2) > 0) {
                        isGT = true;
                        break;
                    }
                    ++i;
                }
            }
        } else if (type == 3) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            String s2 = obj2.str();
            int i = 0;
            while (i < len1) {
                String s1 = this.getStringFromNode(list1.item(i));
                if (s1.compareTo(s2) > 0) {
                    isGT = true;
                    break;
                }
                ++i;
            }
        } else {
            isGT = this.num() > obj2.num();
        }
        return isGT;
    }

    public boolean greaterThanOrEqual(XObject obj2) throws SAXException {
        boolean isGTE = false;
        int type = obj2.getType();
        if (type == 4) {
            NodeList list1 = this.nodeset();
            NodeList list2 = ((XNodeSet)obj2).nodeset();
            int len1 = list1.getLength();
            int len2 = list2.getLength();
            int i = 0;
            while (i < len1) {
                String s1 = this.getStringFromNode(list1.item(i));
                int k = 0;
                while (k < len2) {
                    String s2 = this.getStringFromNode(list2.item(k));
                    if (s1.compareTo(s2) >= 0) {
                        isGTE = true;
                        break;
                    }
                    ++k;
                }
                ++i;
            }
        } else if (type == 1) {
            double num1 = this.bool() ? 1.0 : 0.0;
            double num2 = obj2.num();
            isGTE = num1 >= num2;
        } else if (type == 2) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            double num2 = obj2.num();
            int i = 0;
            while (i < len1) {
                double num1 = this.getNumberFromNode(list1.item(i));
                if (num1 >= num2) {
                    isGTE = true;
                    break;
                }
                ++i;
            }
        } else if (type == 5) {
            double num2 = obj2.num();
            if (num2 != Double.NaN) {
                NodeList list1 = this.nodeset();
                int len1 = list1.getLength();
                int i = 0;
                while (i < len1) {
                    double num1 = this.getNumberFromNode(list1.item(i));
                    if (num1 >= num2) {
                        isGTE = true;
                        break;
                    }
                    ++i;
                }
            } else {
                NodeList list1 = this.nodeset();
                int len1 = list1.getLength();
                String s2 = obj2.str();
                int i = 0;
                while (i < len1) {
                    String s1 = this.getStringFromNode(list1.item(i));
                    if (s1.compareTo(s2) >= 0) {
                        isGTE = true;
                        break;
                    }
                    ++i;
                }
            }
        } else if (type == 3) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            String s2 = obj2.str();
            int i = 0;
            while (i < len1) {
                String s1 = this.getStringFromNode(list1.item(i));
                if (s1.compareTo(s2) >= 0) {
                    isGTE = true;
                    break;
                }
                ++i;
            }
        } else {
            isGTE = this.num() >= obj2.num();
        }
        return isGTE;
    }

    public boolean equals(XObject obj2) throws SAXException {
        boolean isEqual = false;
        int type = obj2.getType();
        if (type == 4) {
            NodeList list1 = this.nodeset();
            NodeList list2 = ((XNodeSet)obj2).nodeset();
            int len1 = list1.getLength();
            int len2 = list2.getLength();
            int i = 0;
            while (i < len1) {
                String s1 = this.getStringFromNode(list1.item(i));
                int k = 0;
                while (k < len2) {
                    String s2 = this.getStringFromNode(list2.item(k));
                    if (s2.equals(s1)) {
                        isEqual = true;
                        break;
                    }
                    ++k;
                }
                ++i;
            }
        } else if (type == 1) {
            isEqual = this.bool() == obj2.bool();
        } else if (type == 2) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            double num2 = obj2.num();
            int i = 0;
            while (i < len1) {
                double num1 = this.getNumberFromNode(list1.item(i));
                if (num1 == num2) {
                    isEqual = true;
                    break;
                }
                ++i;
            }
        } else if (type == 5) {
            double num2 = obj2.num();
            if (num2 != Double.NaN) {
                NodeList list1 = this.nodeset();
                int len1 = list1.getLength();
                int i = 0;
                while (i < len1) {
                    double num1 = this.getNumberFromNode(list1.item(i));
                    if (num1 == num2) {
                        isEqual = true;
                        break;
                    }
                    ++i;
                }
            } else {
                NodeList list1 = this.nodeset();
                int len1 = list1.getLength();
                String s2 = obj2.str();
                int i = 0;
                while (i < len1) {
                    String s1 = this.getStringFromNode(list1.item(i));
                    if (s1.equals(s2)) {
                        isEqual = true;
                        break;
                    }
                    ++i;
                }
            }
        } else if (type == 3) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            String s2 = obj2.str();
            int i = 0;
            while (i < len1) {
                String s1 = this.getStringFromNode(list1.item(i));
                if (s1.equals(s2)) {
                    isEqual = true;
                    break;
                }
                ++i;
            }
        } else {
            isEqual = super.equals(obj2);
        }
        return isEqual;
    }
}

