/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.io.Serializable;
import org.apache.xalan.xpath.MutableNodeList;
import org.apache.xalan.xpath.XPathException;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XObject
implements Serializable {
    protected Object m_obj;
    public static final int CLASS_NULL = -1;
    public static final int CLASS_UNKNOWN = 0;
    public static final int CLASS_BOOLEAN = 1;
    public static final int CLASS_NUMBER = 2;
    public static final int CLASS_STRING = 3;
    public static final int CLASS_NODESET = 4;
    public static final int CLASS_RTREEFRAG = 5;

    public XObject() {
    }

    public XObject(Object obj) {
        this.m_obj = obj;
    }

    public int getType() {
        return 0;
    }

    private String getTypeString() {
        return "#UNKNOWN";
    }

    public double num() throws SAXException {
        this.error(18, new Object[]{this.getTypeString()});
        return 0.0;
    }

    public boolean bool() throws SAXException {
        this.error(18, new Object[]{this.getTypeString()});
        return false;
    }

    public String str() {
        return this.m_obj.toString();
    }

    public String toString() {
        return this.str();
    }

    public DocumentFragment rtree(XPathSupport support) {
        DocumentFragment result = this.rtree();
        if (result == null) {
            result = support.getDOMFactory().createDocumentFragment();
            Text textNode = support.getDOMFactory().createTextNode(this.str());
            result.appendChild(textNode);
        }
        return result;
    }

    public DocumentFragment rtree() {
        return null;
    }

    public Object object() {
        return this.m_obj;
    }

    public NodeList nodeset() throws SAXException {
        this.error(19, new Object[]{this.getTypeString()});
        return null;
    }

    public MutableNodeList mutableNodeset() throws SAXException {
        this.error(20, new Object[]{this.getTypeString()});
        return (MutableNodeList)this.m_obj;
    }

    public Object castToType(int t, XPathSupport support) throws SAXException {
        Object result;
        switch (t) {
            case 3: {
                result = this.str();
                break;
            }
            case 2: {
                result = new Double(this.num());
                break;
            }
            case 4: {
                result = this.nodeset();
                break;
            }
            case 1: {
                result = new Boolean(this.bool());
                break;
            }
            case 0: {
                result = this.m_obj;
                break;
            }
            case 5: {
                result = this.rtree(support);
                break;
            }
            default: {
                this.error(21, new Object[]{this.getTypeString(), Integer.toString(t)});
                result = null;
            }
        }
        return result;
    }

    public boolean lessThan(XObject obj2) throws SAXException {
        if (obj2.getType() == 4) {
            return obj2.greaterThan(this);
        }
        return this.num() < obj2.num();
    }

    public boolean lessThanOrEqual(XObject obj2) throws SAXException {
        if (obj2.getType() == 4) {
            return obj2.greaterThanOrEqual(this);
        }
        return this.num() <= obj2.num();
    }

    public boolean greaterThan(XObject obj2) throws SAXException {
        if (obj2.getType() == 4) {
            return obj2.lessThan(this);
        }
        return this.num() > obj2.num();
    }

    public boolean greaterThanOrEqual(XObject obj2) throws SAXException {
        if (obj2.getType() == 4) {
            return obj2.lessThanOrEqual(this);
        }
        return this.num() >= obj2.num();
    }

    public boolean equals(XObject obj2) throws SAXException {
        if (obj2.getType() == 4) {
            return obj2.equals(this);
        }
        return this.m_obj.equals(obj2.m_obj);
    }

    protected void error(int msg) throws SAXException {
        this.error(msg, null);
    }

    protected void error(int msg, Object[] args) throws SAXException {
        String fmsg = XSLMessages.createXPATHMessage(msg, args);
        throw new XPathException(fmsg);
    }
}

