/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.dtm;

import java.io.IOException;
import org.apache.xalan.xpath.XLocator;
import org.apache.xalan.xpath.XPathEnvSupport;
import org.apache.xalan.xpath.XPathFactory;
import org.apache.xalan.xpath.dtm.DTM;
import org.apache.xalan.xpath.dtm.DTMNodeLocator;
import org.apache.xalan.xpath.dtm.DTMProxy;
import org.apache.xalan.xpath.xdom.XercesLiaison;
import org.apache.xalan.xpath.xml.DefaultErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DTMLiaison
extends XercesLiaison {
    private boolean m_doThreading = true;

    boolean getDoThreading() {
        return this.m_doThreading;
    }

    void setDoThreading(boolean b) {
        this.m_doThreading = b;
    }

    public DTMLiaison(ErrorHandler errorHandler) {
        super(errorHandler);
    }

    public DTMLiaison(XPathEnvSupport envSupport) {
        super(envSupport);
    }

    public DTMLiaison() {
    }

    public void checkNode(Node node) throws SAXException {
        if (!(node instanceof DTMProxy)) {
            throw new SAXException("DTMLiaison can not handle nodes of type" + node.getClass());
        }
    }

    public void parse(InputSource source) throws SAXException, IOException {
        if (this.m_docHandler == null) {
            DTM domParser;
            DTM parser = domParser = new DTM(this.getProblemListener());
            Thread parseThread = null;
            if (this.m_errorHandler != null) {
                parser.setErrorHandler(this.m_errorHandler);
            } else {
                String ident = source.getSystemId() == null ? "Input XSL" : source.getSystemId();
                parser.setErrorHandler(new DefaultErrorHandler(ident));
            }
            if (this.m_entityResolver != null) {
                parser.setEntityResolver(this.m_entityResolver);
            }
            if (this.m_locale != null) {
                parser.setLocale(this.m_locale);
            }
            if (this.m_doThreading) {
                parser.parse(source);
            } else {
                parser.setInputSource(source);
                parseThread = new Thread(parser);
                try {
                    parseThread.start();
                }
                catch (RuntimeException re) {
                    throw new SAXException(re.getMessage());
                }
            }
            this.m_document = parser.getDocument();
            if (source.getSystemId() != null && this.getSourceDocsTable() != null) {
                this.getSourceDocsTable().put(source.getSystemId(), this.m_document);
            }
        } else {
            super.parse(source);
        }
    }

    public boolean supportsSAX() {
        return true;
    }

    public String getNamespaceOfNode(Node n) {
        try {
            return ((DTMProxy)n).getNamespaceURI();
        }
        catch (ClassCastException classCastException) {
            return super.getNamespaceOfNode(n);
        }
    }

    public String getLocalNameOfNode(Node n) {
        try {
            return ((DTMProxy)n).getLocalName();
        }
        catch (ClassCastException classCastException) {
            return super.getLocalNameOfNode(n);
        }
    }

    public Node getParentOfNode(Node n) throws RuntimeException {
        try {
            return ((DTMProxy)n).getOwnerNode();
        }
        catch (ClassCastException classCastException) {
            return super.getParentOfNode(n);
        }
    }

    public Element getElementByID(String id, Document doc) {
        try {
            return ((DTMProxy)doc).getDTM().getIdentifier(id);
        }
        catch (ClassCastException classCastException) {
            return super.getElementByID(id, doc);
        }
    }

    public String getUnparsedEntityURI(String name, Document doc) {
        try {
            String url = null;
            DTMProxy docp = (DTMProxy)doc;
            DTM dtm = docp.dtm;
            int nameindex = dtm.getStringPool().addSymbol(name);
            int entityRefIndex = dtm.m_entities.get(nameindex);
            int[] entityRef = new int[4];
            dtm.m_entityNodes.readSlot(entityRefIndex, entityRef);
            if (entityRef[3] >> 16 != 0 && (url = dtm.getStringPool().toString(entityRef[3] & 0xFF)) == null) {
                url = dtm.getStringPool().toString(entityRef[2]);
            }
            return url;
        }
        catch (ClassCastException classCastException) {
            return super.getUnparsedEntityURI(name, doc);
        }
    }

    public XPathFactory getDefaultXPathFactory() {
        return DTMNodeLocator.factory();
    }

    public XLocator getXLocatorFromNode(Node node) {
        return DTMNodeLocator.getDefaultLocator();
    }

    public XLocator createXLocatorHandler() {
        return DTMNodeLocator.getDefaultLocator();
    }
}

