/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.dtm;

import org.apache.xalan.xpath.dtm.DTM;
import org.apache.xalan.xpath.dtm.DTMException;
import org.apache.xalan.xpath.dtm.DTMProxyMap;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DTMProxy
implements Node,
Document,
Text,
Element,
Attr,
ProcessingInstruction,
Comment {
    DTM dtm;
    int node;

    DTMProxy(DTM dtm, int node, int type) {
        this.dtm = dtm;
        this.node = node;
    }

    DTMProxy(DTM dtm, int node) {
        this.dtm = dtm;
        this.node = node;
    }

    DTMProxy(DTM dtm) {
        this(dtm, 0, 9);
    }

    public final DTM getDTM() {
        return this.dtm;
    }

    public final int getDTMNodeNumber() {
        return this.node;
    }

    public final boolean equals(Node node) {
        try {
            DTMProxy dtmp = (DTMProxy)node;
            return dtmp.node == this.node;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public final boolean equals(Object node) {
        try {
            DTMProxy dtmp = (DTMProxy)node;
            return dtmp.node == this.node;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public final boolean sameNodeAs(Node other) {
        if (!(other instanceof DTMProxy)) {
            return false;
        }
        DTMProxy that = (DTMProxy)other;
        return this.dtm == that.dtm && this.node == that.node;
    }

    public final String getNodeName() {
        return this.dtm.getNodeName(this.node);
    }

    public final String getTarget() {
        return this.dtm.getNodeName(this.node);
    }

    public final String getLocalName() {
        return this.dtm.getLocalName(this.node);
    }

    public final String getPrefix() {
        return this.dtm.getPrefix(this.node);
    }

    public final String getNamespaceURI() {
        return this.dtm.getNamespaceURI(this.node);
    }

    public final String getNodeValue() throws DOMException {
        if (this.getNodeType() == 2) {
            return this.dtm.getNodeValue(this.node + 1);
        }
        return this.dtm.getNodeValue(this.node);
    }

    public final void setNodeValue(String nodeValue) throws DOMException {
        throw new DTMException(7);
    }

    public final short getNodeType() {
        return (short)this.dtm.getNodeType(this.node);
    }

    public final Node getParentNode() {
        if (this.getNodeType() == 2) {
            return null;
        }
        int newnode = this.dtm.getParent(this.node);
        return newnode == -1 ? null : this.dtm.getNode(newnode);
    }

    public final Node getOwnerNode() {
        int newnode = this.dtm.getParent(this.node);
        return newnode == -1 ? null : this.dtm.getNode(newnode);
    }

    public final NodeList getChildNodes() {
        throw new DTMException(9);
    }

    public final Node getFirstChild() {
        int newnode = this.dtm.getFirstChild(this.node);
        return newnode == -1 ? null : this.dtm.getNode(newnode);
    }

    public final Node getLastChild() {
        int newnode = this.dtm.getLastChild(this.node);
        return newnode == -1 ? null : this.dtm.getNode(newnode);
    }

    public final Node getPreviousSibling() {
        int newnode = this.dtm.getPreviousSibling(this.node);
        return newnode == -1 ? null : this.dtm.getNode(newnode);
    }

    public final Node getNextSibling() {
        if (this.dtm.getNodeType(this.node) == 2) {
            return null;
        }
        int newnode = this.dtm.getNextSibling(this.node);
        return newnode == -1 ? null : this.dtm.getNode(newnode);
    }

    public final NamedNodeMap getAttributes() {
        return new DTMProxyMap(this.dtm, this.node);
    }

    public final Document getOwnerDocument() {
        return this.dtm.getDocument();
    }

    public final Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DTMException(7);
    }

    public final Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new DTMException(7);
    }

    public final Node removeChild(Node oldChild) throws DOMException {
        throw new DTMException(7);
    }

    public final Node appendChild(Node newChild) throws DOMException {
        throw new DTMException(7);
    }

    public final boolean hasChildNodes() {
        return this.dtm.getFirstChild(this.node) != -1;
    }

    public final Node cloneNode(boolean deep) {
        throw new DTMException(9);
    }

    public final DocumentType getDoctype() {
        return null;
    }

    public final DOMImplementation getImplementation() {
        throw new DTMException(9);
    }

    public final Element getDocumentElement() {
        throw new DTMException(9);
    }

    public final Element createElement(String tagName) throws DOMException {
        throw new DTMException(9);
    }

    public final DocumentFragment createDocumentFragment() {
        throw new DTMException(9);
    }

    public final Text createTextNode(String data) {
        throw new DTMException(9);
    }

    public final Comment createComment(String data) {
        throw new DTMException(9);
    }

    public final CDATASection createCDATASection(String data) throws DOMException {
        throw new DTMException(9);
    }

    public final ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        throw new DTMException(9);
    }

    public final Attr createAttribute(String name) throws DOMException {
        throw new DTMException(9);
    }

    public final EntityReference createEntityReference(String name) throws DOMException {
        throw new DTMException(9);
    }

    public final NodeList getElementsByTagName(String tagname) {
        throw new DTMException(9);
    }

    public final Text splitText(int offset) throws DOMException {
        throw new DTMException(9);
    }

    public final String getData() throws DOMException {
        return this.dtm.getNodeValue(this.node);
    }

    public final void setData(String data) throws DOMException {
        throw new DTMException(9);
    }

    public final int getLength() {
        return this.dtm.getNodeValue(this.node).length();
    }

    public final String substringData(int offset, int count) throws DOMException {
        throw new DTMException(9);
    }

    public final void appendData(String arg) throws DOMException {
        throw new DTMException(9);
    }

    public final void insertData(int offset, String arg) throws DOMException {
        throw new DTMException(9);
    }

    public final void deleteData(int offset, int count) throws DOMException {
        throw new DTMException(9);
    }

    public final void replaceData(int offset, int count, String arg) throws DOMException {
        throw new DTMException(9);
    }

    public final String getTagName() {
        return this.dtm.getNodeName(this.node);
    }

    public final String getAttribute(String name) {
        DTMProxyMap map = new DTMProxyMap(this.dtm, this.node);
        Node node = map.getNamedItem(name);
        return node == null ? null : node.getNodeValue();
    }

    public final void setAttribute(String name, String value) throws DOMException {
        throw new DTMException(9);
    }

    public final void removeAttribute(String name) throws DOMException {
        throw new DTMException(9);
    }

    public final Attr getAttributeNode(String name) {
        DTMProxyMap map = new DTMProxyMap(this.dtm, this.node);
        return (Attr)map.getNamedItem(name);
    }

    public final Attr setAttributeNode(Attr newAttr) throws DOMException {
        throw new DTMException(9);
    }

    public final Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        throw new DTMException(9);
    }

    public final void normalize() {
        throw new DTMException(9);
    }

    public final String getName() {
        return this.dtm.getNodeName(this.node);
    }

    public final boolean getSpecified() {
        return true;
    }

    public final String getValue() {
        return this.dtm.getNodeValue(this.node + 1);
    }

    public final void setValue(String value) {
        throw new DTMException(9);
    }
}

