/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import org.apache.xalan.xpath.xml.BoolStack;
import org.apache.xalan.xpath.xml.ElemDesc;
import org.apache.xalan.xpath.xml.FormatterToXML;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class FormatterToHTML
extends FormatterToXML {
    BoolStack m_isRawStack = new BoolStack();
    boolean m_inBlockElem = false;
    static String[] s_HTMLlat1 = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
    static String[] HTMLsymbol1 = new String[]{"Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "Mu", "Nu", "Xi", "Omicron", "Pi", "Rho", "Sigma", "Tau", "Upsilon", "Phi", "Chi", "Psi", "Omega", "alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "omicron", "pi", "rho", "sigmaf", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omega", "thetasym", "upsih", "piv"};
    static Hashtable m_elementFlags = new Hashtable();
    private static ElemDesc m_dummy;
    String m_currentElementName;
    static final int MASK1 = 65280;
    static final int MASK2 = 255;

    ElemDesc getElemDesc(String name) {
        Object obj;
        if (name != null && (obj = m_elementFlags.get(name)) != null) {
            return (ElemDesc)obj;
        }
        return m_dummy;
    }

    public FormatterToHTML() {
    }

    public FormatterToHTML(Writer writer) {
        super(writer);
        FormatterToXML.initEncodings();
    }

    public FormatterToHTML(FormatterToXML xmlListener) {
        super(xmlListener);
        this.m_doIndent = true;
    }

    protected void initAttrCharsMap() {
        super.initAttrCharsMap();
        this.m_attrCharsMap[10] = 83;
        this.m_attrCharsMap[60] = '\u0000';
        this.m_attrCharsMap[62] = '\u0000';
        this.m_charsMap[10] = 83;
        this.m_charsMap[13] = 83;
    }

    protected void initCharsMap() {
        this.initAttrCharsMap();
        int n = this.m_maxCharacter > '\u0100' ? 256 : (int)this.m_maxCharacter;
        int i = 0;
        while (i < n) {
            this.m_charsMap[i] = '\u0000';
            ++i;
        }
        this.m_charsMap[10] = 83;
        this.m_charsMap[60] = 83;
        this.m_charsMap[62] = 83;
        this.m_charsMap[38] = 83;
        int i2 = 0;
        while (i2 < 10) {
            this.m_charsMap[i2] = 83;
            ++i2;
        }
        this.m_charsMap[10] = 83;
        this.m_charsMap[13] = 83;
        n = 256;
        int i3 = 160;
        while (i3 < n) {
            this.m_charsMap[i3] = 83;
            ++i3;
        }
        int i4 = this.m_maxCharacter;
        while (i4 < 256) {
            this.m_charsMap[i4] = 83;
            ++i4;
        }
    }

    public void startDocument() throws SAXException {
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        this.m_shouldNotWriteXMLHeader = true;
        if (this.m_needToOutputDocTypeDecl && (this.m_doctypeSystem != null || this.m_doctypePublic != null)) {
            this.accum("<!DOCTYPE HTML");
            if (this.m_doctypePublic != null) {
                this.accum(" PUBLIC \"");
                this.accum(this.m_doctypePublic);
                this.accum("\"");
            }
            if (this.m_doctypeSystem != null) {
                if (this.m_doctypePublic == null) {
                    this.accum(" SYSTEM \"");
                } else {
                    this.accum(" \"");
                }
                this.accum(this.m_doctypeSystem);
                this.accum("\"");
            }
            this.accum(">");
            this.accum(this.m_lineSep);
        }
        this.m_needToOutputDocTypeDecl = false;
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        boolean savedDoIndent = this.m_doIndent;
        this.writeParentTagEnd();
        String nameUpper = name.toUpperCase();
        ElemDesc elemDesc = this.getElemDesc(nameUpper);
        boolean isBlockElement = elemDesc.is(8);
        if (this.m_ispreserve) {
            this.m_ispreserve = false;
        } else if (this.m_doIndent && this.m_currentElementName != null && (!this.m_inBlockElem || isBlockElement)) {
            this.m_startNewLine = true;
            this.indent(this.m_currentIndent);
        }
        this.m_inBlockElem = !isBlockElement;
        this.m_isRawStack.push(elemDesc.is(256));
        this.m_currentElementName = nameUpper;
        this.accum('<');
        this.accum(name);
        int nAttrs = atts.getLength();
        int i = 0;
        while (i < nAttrs) {
            this.processAttribute(atts.getName(i), elemDesc, atts.getValue(i));
            ++i;
        }
        this.openElementForChildren();
        this.m_currentIndent += this.indent;
        this.m_isprevtext = false;
        this.m_doIndent = savedDoIndent;
    }

    public void endElement(String name) throws SAXException {
        this.m_currentIndent -= this.indent;
        boolean hasChildNodes = this.childNodesWereAdded();
        this.m_isRawStack.pop();
        String nameUpper = name.toUpperCase();
        ElemDesc elemDesc = this.getElemDesc(nameUpper);
        boolean isBlockElement = elemDesc.is(8);
        boolean shouldIndent = false;
        if (this.m_ispreserve) {
            this.m_ispreserve = false;
        } else if (this.m_doIndent && (!this.m_inBlockElem || isBlockElement)) {
            this.m_startNewLine = true;
            shouldIndent = true;
        }
        boolean bl = this.m_inBlockElem = !isBlockElement;
        if (hasChildNodes) {
            if (shouldIndent) {
                this.indent(this.m_currentIndent);
            }
            this.accum("</");
            this.accum(name);
            this.accum('>');
            this.m_currentElementName = name;
        } else if (!elemDesc.is(2)) {
            this.accum('>');
            if (shouldIndent) {
                this.indent(this.m_currentIndent);
            }
            this.accum('<');
            this.accum('/');
            this.accum(name);
            this.accum('>');
        } else {
            this.accum('>');
        }
        if (elemDesc.is(0x200000)) {
            this.m_ispreserve = true;
        }
        this.m_isprevtext = false;
    }

    protected void processAttribute(String name, ElemDesc elemDesc, String value) throws SAXException {
        String nameUpper = name.toUpperCase();
        this.accum(' ');
        if (elemDesc.isAttrFlagSet(nameUpper, 4) && value.length() == 0 || value.equalsIgnoreCase(name)) {
            this.accum(name);
        } else {
            this.accum(name);
            this.accum('=');
            this.accum('\"');
            if (elemDesc.isAttrFlagSet(nameUpper, 2)) {
                this.writeAttrURI(value, this.m_encoding);
            } else {
                this.writeAttrString(value, this.m_encoding);
            }
            this.accum('\"');
        }
    }

    public void writeAttrURI(String string, String encoding) throws SAXException {
        char[] stringArray = string.toCharArray();
        int len = stringArray.length;
        int i = 0;
        while (i < len) {
            char ch = stringArray[i];
            if (ch < '\t' || ch > '\u007f' || ch == '\"') {
                int b1 = (ch & 0xFF00) >> 8;
                int b2 = ch & 0xFF;
                if (b1 != 0) {
                    this.accum("%");
                    this.accum(Integer.toHexString(b1));
                }
                this.accum("%");
                this.accum(Integer.toHexString(b2));
            } else {
                this.accum(ch);
            }
            ++i;
        }
    }

    public void writeAttrString(String string, String encoding) throws SAXException {
        char[] chars = string.toCharArray();
        int strLen = chars.length;
        int i = 0;
        while (i < strLen) {
            char ch = chars[i];
            if (ch < '\u0100' && this.m_attrCharsMap[ch] != 'S') {
                this.accum(ch);
            } else if (ch == '&' && i + 1 < strLen && string.charAt(i + 1) == '{') {
                this.accum(ch);
            } else if (!this.accumDefaultEntity(ch, i, chars, strLen, false)) {
                if (ch >= '\ud800' && ch < '\udc00') {
                    int next;
                    if (i + 1 >= string.length()) {
                        throw new SAXException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(ch) + " ?");
                    }
                    if ((next = string.charAt(++i)) < 56320 || next >= 57344) {
                        throw new SAXException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(ch) + " " + Integer.toHexString(next));
                    }
                    next = (ch - 55296 << 10) + next - 56320 + 65536;
                    this.accum("&#x");
                    this.accum(Integer.toHexString(next));
                    this.accum(";");
                } else if (ch >= '\u00a0' && ch <= '\u00ff') {
                    this.accum("&");
                    this.accum(s_HTMLlat1[ch - 160]);
                    this.accum(";");
                } else if (ch >= '\u0391' && ch <= '\u03d6') {
                    this.accum("&");
                    this.accum(HTMLsymbol1[ch - 913]);
                    this.accum(";");
                } else if (ch == '\u0192') {
                    this.accum("&fnof;");
                } else {
                    this.accum("&#x");
                    this.accum(Integer.toHexString(ch));
                    this.accum(";");
                }
            }
            ++i;
        }
    }

    private int copyEntityIntoBuf(String s, int pos) throws SAXException {
        int l = s.length();
        this.accum('&');
        int i = 0;
        while (i < l) {
            this.accum(s.charAt(i));
            ++i;
        }
        this.accum(';');
        return pos;
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        if (length == 0) {
            return;
        }
        if (this.m_inCData) {
            this.cdata(chars, start, length);
            return;
        }
        if (this.m_nextIsRaw) {
            this.m_nextIsRaw = false;
            this.charactersRaw(chars, start, length);
            return;
        }
        if (this.m_isRawStack.peek()) {
            try {
                this.writeParentTagEnd();
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                this.writeNormalizedChars(chars, start, length, false);
                return;
            }
            catch (IOException ioe) {
                throw new SAXException("IO error", ioe);
            }
        }
        this.writeParentTagEnd();
        this.m_ispreserve = true;
        int pos = 0;
        int end = start + length;
        int i = start;
        while (i < end) {
            char ch = chars[i];
            if (ch < '\u0100' && this.m_charsMap[ch] != 'S') {
                this.accum(ch);
            } else {
                if (ch == '\n' && i + 1 < end && chars[i + 1] == '\r') {
                    this.outputLineSep();
                    ++i;
                }
                if (ch == '\r' && i + 1 < end && chars[i + 1] == '\n') {
                    this.outputLineSep();
                    ++i;
                } else if (ch == '\r') {
                    this.outputLineSep();
                    ++i;
                } else if (ch == '\n') {
                    this.outputLineSep();
                } else if (ch == '<') {
                    pos = this.copyEntityIntoBuf("lt", pos);
                } else if (ch == '>') {
                    pos = this.copyEntityIntoBuf("gt", pos);
                } else if (ch == '&') {
                    pos = this.copyEntityIntoBuf("amp", pos);
                } else if (ch >= '\t' && ch <= '~') {
                    this.accum(ch);
                } else if (ch >= '\u00a0' && ch <= '\u00ff') {
                    pos = this.copyEntityIntoBuf(s_HTMLlat1[ch - 160], pos);
                } else if (ch >= '\u0391' && ch <= '\u03d6') {
                    pos = this.copyEntityIntoBuf(HTMLsymbol1[ch - 913], pos);
                } else if (ch == '\u0192') {
                    pos = this.copyEntityIntoBuf("fnof", pos);
                } else if (this.m_isUTF8 && ch >= '\ud800' && ch < '\udc00') {
                    int next;
                    if (i + 1 >= length) {
                        throw new SAXException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(ch) + " ?");
                    }
                    if ((next = chars[++i]) < 56320 || next >= 57344) {
                        throw new SAXException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(ch) + " " + Integer.toHexString(next));
                    }
                    next = (ch - 55296 << 10) + next - 56320 + 65536;
                    this.accum('&');
                    this.accum('#');
                    String intStr = Integer.toString(next);
                    int nIntStr = intStr.length();
                    int k = 0;
                    while (k < nIntStr) {
                        this.accum(intStr.charAt(k));
                        ++k;
                    }
                    this.accum(';');
                } else if (ch >= '\u007f' && ch <= this.m_maxCharacter) {
                    this.accum(ch);
                } else {
                    this.accum('&');
                    this.accum('#');
                    String intStr = Integer.toString(ch);
                    int nIntStr = intStr.length();
                    int k = 0;
                    while (k < nIntStr) {
                        this.accum(intStr.charAt(k));
                        ++k;
                    }
                    this.accum(';');
                }
            }
            ++i;
        }
        this.m_isprevtext = true;
    }

    public void cdata(char[] ch, int start, int length) throws SAXException {
        if (this.m_currentElementName != null && (this.m_currentElementName.equalsIgnoreCase("SCRIPT") || this.m_currentElementName.equalsIgnoreCase("STYLE"))) {
            try {
                this.writeParentTagEnd();
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                this.writeNormalizedChars(ch, start, length, true);
            }
            catch (IOException ioe) {
                throw new SAXException("IO error", ioe);
            }
        } else {
            super.cdata(ch, start, length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (target.equals("xslt-next-is-raw") && data.equals("formatter-to-dom")) {
            this.m_nextIsRaw = true;
        } else {
            this.writeParentTagEnd();
            if (this.shouldIndent()) {
                this.indent(this.m_currentIndent);
            }
            this.accum("<?" + target);
            if (data.length() > 0 && !Character.isSpaceChar(data.charAt(0))) {
                this.accum(" ");
            }
            this.accum(String.valueOf(data) + ">");
            this.m_startNewLine = true;
        }
    }

    public void entityReference(String name) throws SAXException {
        this.accum("&");
        this.accum(name);
        this.accum(";");
    }

    static {
        m_elementFlags.put("BASEFONT", new ElemDesc(2));
        m_elementFlags.put("FRAME", new ElemDesc(10));
        m_elementFlags.put("FRAMESET", new ElemDesc(8));
        m_elementFlags.put("NOFRAMES", new ElemDesc(8));
        m_elementFlags.put("ISINDEX", new ElemDesc(10));
        m_elementFlags.put("APPLET", new ElemDesc(0x200000));
        m_elementFlags.put("CENTER", new ElemDesc(8));
        m_elementFlags.put("DIR", new ElemDesc(8));
        m_elementFlags.put("MENU", new ElemDesc(8));
        m_elementFlags.put("TT", new ElemDesc(4096));
        m_elementFlags.put("I", new ElemDesc(4096));
        m_elementFlags.put("B", new ElemDesc(4096));
        m_elementFlags.put("BIG", new ElemDesc(4096));
        m_elementFlags.put("SMALL", new ElemDesc(4096));
        m_elementFlags.put("EM", new ElemDesc(8192));
        m_elementFlags.put("STRONG", new ElemDesc(8192));
        m_elementFlags.put("DFN", new ElemDesc(8192));
        m_elementFlags.put("CODE", new ElemDesc(8192));
        m_elementFlags.put("SAMP", new ElemDesc(8192));
        m_elementFlags.put("KBD", new ElemDesc(8192));
        m_elementFlags.put("VAR", new ElemDesc(8192));
        m_elementFlags.put("CITE", new ElemDesc(8192));
        m_elementFlags.put("ABBR", new ElemDesc(8192));
        m_elementFlags.put("ACRONYM", new ElemDesc(8192));
        m_elementFlags.put("SUP", new ElemDesc(98304));
        m_elementFlags.put("SUB", new ElemDesc(98304));
        m_elementFlags.put("SPAN", new ElemDesc(98304));
        m_elementFlags.put("BDO", new ElemDesc(98304));
        m_elementFlags.put("BR", new ElemDesc(98314));
        m_elementFlags.put("BODY", new ElemDesc(8));
        m_elementFlags.put("ADDRESS", new ElemDesc(56));
        m_elementFlags.put("DIV", new ElemDesc(56));
        m_elementFlags.put("A", new ElemDesc(32768));
        m_elementFlags.put("MAP", new ElemDesc(98312));
        m_elementFlags.put("AREA", new ElemDesc(10));
        m_elementFlags.put("LINK", new ElemDesc(131082));
        m_elementFlags.put("IMG", new ElemDesc(2195458));
        m_elementFlags.put("OBJECT", new ElemDesc(2326528));
        m_elementFlags.put("PARAM", new ElemDesc(2));
        m_elementFlags.put("HR", new ElemDesc(58));
        m_elementFlags.put("P", new ElemDesc(56));
        m_elementFlags.put("H1", new ElemDesc(262152));
        m_elementFlags.put("H2", new ElemDesc(262152));
        m_elementFlags.put("H3", new ElemDesc(262152));
        m_elementFlags.put("H4", new ElemDesc(262152));
        m_elementFlags.put("H5", new ElemDesc(262152));
        m_elementFlags.put("H6", new ElemDesc(262152));
        m_elementFlags.put("PRE", new ElemDesc(0x100008));
        m_elementFlags.put("Q", new ElemDesc(98304));
        m_elementFlags.put("BLOCKQUOTE", new ElemDesc(56));
        m_elementFlags.put("INS", new ElemDesc(0));
        m_elementFlags.put("DEL", new ElemDesc(0));
        m_elementFlags.put("DL", new ElemDesc(56));
        m_elementFlags.put("DT", new ElemDesc(8));
        m_elementFlags.put("DD", new ElemDesc(8));
        m_elementFlags.put("OL", new ElemDesc(524296));
        m_elementFlags.put("UL", new ElemDesc(524296));
        m_elementFlags.put("LI", new ElemDesc(8));
        m_elementFlags.put("FORM", new ElemDesc(8));
        m_elementFlags.put("LABEL", new ElemDesc(16384));
        m_elementFlags.put("INPUT", new ElemDesc(18434));
        m_elementFlags.put("SELECT", new ElemDesc(18432));
        m_elementFlags.put("OPTGROUP", new ElemDesc(0));
        m_elementFlags.put("OPTION", new ElemDesc(0));
        m_elementFlags.put("TEXTAREA", new ElemDesc(18432));
        m_elementFlags.put("FIELDSET", new ElemDesc(24));
        m_elementFlags.put("LEGEND", new ElemDesc(0));
        m_elementFlags.put("BUTTON", new ElemDesc(18432));
        m_elementFlags.put("TABLE", new ElemDesc(56));
        m_elementFlags.put("CAPTION", new ElemDesc(8));
        m_elementFlags.put("THEAD", new ElemDesc(8));
        m_elementFlags.put("TFOOT", new ElemDesc(8));
        m_elementFlags.put("TBODY", new ElemDesc(8));
        m_elementFlags.put("COLGROUP", new ElemDesc(8));
        m_elementFlags.put("COL", new ElemDesc(10));
        m_elementFlags.put("TR", new ElemDesc(8));
        m_elementFlags.put("TH", new ElemDesc(0));
        m_elementFlags.put("TD", new ElemDesc(0));
        m_elementFlags.put("HEAD", new ElemDesc(8));
        m_elementFlags.put("TITLE", new ElemDesc(8));
        m_elementFlags.put("BASE", new ElemDesc(10));
        m_elementFlags.put("META", new ElemDesc(131082));
        m_elementFlags.put("STYLE", new ElemDesc(131336));
        m_elementFlags.put("SCRIPT", new ElemDesc(229632));
        m_elementFlags.put("NOSCRIPT", new ElemDesc(56));
        m_elementFlags.put("HTML", new ElemDesc(8));
        ElemDesc elemDesc = (ElemDesc)m_elementFlags.get("BASE");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("BLOCKQUOTE");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("Q");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INS");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("DEL");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("A");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NAME", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INPUT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("CHECKED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SELECT");
        elemDesc.setAttr("READONLY", 4);
        elemDesc.setAttr("MULTIPLE", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTGROUP");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTION");
        elemDesc.setAttr("SELECTED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("TEXTAREA");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("BUTTON");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SCRIPT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("FOR", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("IMG");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("OBJECT");
        elemDesc.setAttr("CLASSID", 2);
        elemDesc.setAttr("CODEBASE", 2);
        elemDesc.setAttr("DATA", 2);
        elemDesc.setAttr("ARCHIVE", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("FORM");
        elemDesc.setAttr("ACTION", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("HEAD");
        elemDesc.setAttr("PROFILE", 2);
        m_dummy = new ElemDesc(0);
    }
}

