/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

public class IntVector {
    private int m_blocksize;
    private int[] m_map;
    private int m_firstFree;
    private int m_mapSize;

    public IntVector() {
        this.m_mapSize = this.m_blocksize = 32;
        this.m_map = new int[this.m_blocksize];
    }

    public IntVector(int blocksize) {
        this.m_blocksize = blocksize;
        this.m_mapSize = blocksize;
        this.m_map = new int[blocksize];
    }

    public final int size() {
        return this.m_firstFree;
    }

    public final void addElement(int value) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] newMap = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        this.m_map[this.m_firstFree] = value;
        ++this.m_firstFree;
    }

    public final void insertElementAt(int value, int at) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] newMap = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        if (at <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, at, this.m_map, at + 1, this.m_firstFree - at);
        }
        this.m_map[at] = value;
        ++this.m_firstFree;
    }

    public final void removeAllElements() {
        int i = 0;
        while (i < this.m_firstFree) {
            this.m_map[i] = Integer.MIN_VALUE;
            ++i;
        }
        this.m_firstFree = 0;
    }

    public final boolean removeElement(int s) {
        int i = 0;
        while (i < this.m_firstFree) {
            if (this.m_map[i] == s) {
                if (i > this.m_firstFree) {
                    System.arraycopy(this.m_map, i + 1, this.m_map, i - 1, this.m_firstFree - i);
                } else {
                    this.m_map[i] = Integer.MIN_VALUE;
                }
                --this.m_firstFree;
                return true;
            }
            ++i;
        }
        return false;
    }

    public final void removeElementAt(int i) {
        if (i > this.m_firstFree) {
            System.arraycopy(this.m_map, i + 1, this.m_map, i, this.m_firstFree);
        } else {
            this.m_map[i] = Integer.MIN_VALUE;
        }
        --this.m_firstFree;
    }

    public final void setElementAt(int node, int index) {
        this.m_map[index] = node;
    }

    public final int elementAt(int i) {
        return this.m_map[i];
    }

    public final boolean contains(int s) {
        int i = 0;
        while (i < this.m_firstFree) {
            if (this.m_map[i] == s) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final int indexOf(int elem, int index) {
        int i = index;
        while (i < this.m_firstFree) {
            if (this.m_map[i] == elem) {
                return i;
            }
            ++i;
        }
        return Integer.MIN_VALUE;
    }

    public final int indexOf(int elem) {
        int i = 0;
        while (i < this.m_firstFree) {
            if (this.m_map[i] == elem) {
                return i;
            }
            ++i;
        }
        return Integer.MIN_VALUE;
    }

    public final int lastIndexOf(int elem) {
        int i = this.m_firstFree - 1;
        while (i >= 0) {
            if (this.m_map[i] == elem) {
                return i;
            }
            --i;
        }
        return Integer.MIN_VALUE;
    }
}

