/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import org.w3c.dom.Node;

public class NodeVector {
    private int m_blocksize;
    private Node[] m_map;
    private int m_firstFree;
    private int m_mapSize;

    public NodeVector() {
        this.m_mapSize = this.m_blocksize = 32;
        this.m_map = new Node[this.m_blocksize];
    }

    public NodeVector(int blocksize) {
        this.m_blocksize = blocksize;
        this.m_mapSize = blocksize;
        this.m_map = new Node[blocksize];
    }

    public final int size() {
        return this.m_firstFree;
    }

    public final void addElement(Node value) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] newMap = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        this.m_map[this.m_firstFree] = value;
        ++this.m_firstFree;
    }

    public final void insertElementAt(Node value, int at) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] newMap = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        if (at <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, at, this.m_map, at + 1, this.m_firstFree - at);
        }
        this.m_map[at] = value;
        ++this.m_firstFree;
    }

    public final void removeAllElements() {
        int i = 0;
        while (i < this.m_firstFree) {
            this.m_map[i] = null;
            ++i;
        }
        this.m_firstFree = 0;
    }

    public final boolean removeElement(Node s) {
        int i = 0;
        while (i < this.m_firstFree) {
            Node node = this.m_map[i];
            if (node != null && node.equals(s)) {
                if (i > this.m_firstFree) {
                    System.arraycopy(this.m_map, i + 1, this.m_map, i - 1, this.m_firstFree - i);
                } else {
                    this.m_map[i] = null;
                }
                --this.m_firstFree;
                return true;
            }
            ++i;
        }
        return false;
    }

    public final void removeElementAt(int i) {
        if (i > this.m_firstFree) {
            System.arraycopy(this.m_map, i + 1, this.m_map, i - 1, this.m_firstFree - i);
        } else {
            this.m_map[i] = null;
        }
    }

    public final void setElementAt(Node node, int index) {
        this.m_map[index] = node;
    }

    public final Node elementAt(int i) {
        return this.m_map[i];
    }

    public final boolean contains(Node s) {
        int i = 0;
        while (i < this.m_firstFree) {
            Node node = this.m_map[i];
            if (node != null && node.equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final int indexOf(Node elem, int index) {
        int i = index;
        while (i < this.m_firstFree) {
            Node node = this.m_map[i];
            if (node != null && node.equals(elem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final int indexOf(Node elem) {
        int i = 0;
        while (i < this.m_firstFree) {
            Node node = this.m_map[i];
            if (node != null && node.equals(elem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

