/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import java.text.MessageFormat;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.xalan.xpath.xml.XSLResourceBundle;

public class XSLMessages {
    private Locale fLocale = Locale.getDefault();
    private ResourceBundle fResourceBundle;
    private static final String XSLT_ERROR_RESOURCES = "org.apache.xalan.xslt.res.XSLTErrorResources";
    private static final String XPATH_ERROR_RESOURCES = "org.apache.xalan.xpath.res.XPATHErrorResources";
    private static String BAD_CODE = "BAD_CODE";
    private static String FORMAT_FAILED = "FORMAT_FAILED";

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public static final String createXPATHWarning(int errorCode, Object[] args) {
        XSLResourceBundle fResourceBundle = (XSLResourceBundle)XSLMessages.loadResourceBundle(XPATH_ERROR_RESOURCES);
        if (fResourceBundle != null) {
            String msgKey = fResourceBundle.getWarningKey(errorCode);
            return XSLMessages.createXPATHMsg(fResourceBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createXPATHMessage(int errorCode, Object[] args) {
        XSLResourceBundle fResourceBundle = (XSLResourceBundle)XSLMessages.loadResourceBundle(XPATH_ERROR_RESOURCES);
        if (fResourceBundle != null) {
            String msgKey = fResourceBundle.getMessageKey(errorCode);
            return XSLMessages.createXPATHMsg(fResourceBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createXPATHMsg(XSLResourceBundle fResourceBundle, String msgKey, Object[] args) {
        String fmsg = null;
        boolean throwex = false;
        String msg = null;
        if (msgKey != null) {
            msg = fResourceBundle.getString(msgKey);
        }
        if (msg == null) {
            msg = fResourceBundle.getString("BAD_CODE");
            throwex = true;
        }
        if (args != null) {
            try {
                int n = args.length;
                int i = 0;
                while (i < n) {
                    if (args[i] == null) {
                        args[i] = "";
                    }
                    ++i;
                }
                fmsg = MessageFormat.format(msg, args);
            }
            catch (Exception exception) {
                fmsg = fResourceBundle.getString("FORMAT_FAILED");
                fmsg = String.valueOf(fmsg) + " " + msg;
            }
        } else {
            fmsg = msg;
        }
        if (throwex) {
            throw new RuntimeException(fmsg);
        }
        return fmsg;
    }

    public static final String createWarning(int errorCode, Object[] args) {
        XSLResourceBundle fResourceBundle = (XSLResourceBundle)XSLMessages.loadResourceBundle(XSLT_ERROR_RESOURCES);
        if (fResourceBundle != null) {
            String msgKey = fResourceBundle.getWarningKey(errorCode);
            return XSLMessages.createMsg(fResourceBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createMessage(int errorCode, Object[] args) {
        XSLResourceBundle fResourceBundle = null;
        fResourceBundle = (XSLResourceBundle)XSLMessages.loadResourceBundle(XSLT_ERROR_RESOURCES);
        if (fResourceBundle != null) {
            String msgKey = fResourceBundle.getMessageKey(errorCode);
            return XSLMessages.createMsg(fResourceBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createMsg(XSLResourceBundle fResourceBundle, String msgKey, Object[] args) {
        String fmsg = null;
        boolean throwex = false;
        String msg = null;
        if (msgKey != null) {
            msg = fResourceBundle.getString(msgKey);
        }
        if (msg == null) {
            msg = fResourceBundle.getString(BAD_CODE);
            throwex = true;
        }
        if (args != null) {
            try {
                int n = args.length;
                int i = 0;
                while (i < n) {
                    if (args[i] == null) {
                        args[i] = "";
                    }
                    ++i;
                }
                fmsg = MessageFormat.format(msg, args);
            }
            catch (Exception exception) {
                fmsg = fResourceBundle.getString(FORMAT_FAILED);
                fmsg = String.valueOf(fmsg) + " " + msg;
            }
        } else {
            fmsg = msg;
        }
        if (throwex) {
            throw new RuntimeException(fmsg);
        }
        return fmsg;
    }

    public String createMessage(String bundleName, int errorCode, Object[] args) throws Exception {
        boolean throwex = false;
        String fmsg = null;
        XSLResourceBundle aResourceBundle = null;
        aResourceBundle = (XSLResourceBundle)XSLMessages.loadResourceBundle(bundleName);
        String msgKey = aResourceBundle.getMessageKey(errorCode);
        String msg = null;
        if (msgKey != null) {
            msg = aResourceBundle.getString(msgKey);
        }
        if (msg == null) {
            msg = aResourceBundle.getString(BAD_CODE);
            throwex = true;
        }
        if (args != null) {
            try {
                int n = args.length;
                int i = 0;
                while (i < n) {
                    if (args[i] == null) {
                        args[i] = "";
                    }
                    ++i;
                }
                fmsg = MessageFormat.format(msg, args);
            }
            catch (Exception exception) {
                fmsg = aResourceBundle.getString(FORMAT_FAILED);
                fmsg = String.valueOf(fmsg) + " " + msg;
            }
        } else {
            fmsg = msg;
        }
        if (throwex) {
            throw new RuntimeException(fmsg);
        }
        return fmsg;
    }

    public static final ListResourceBundle loadResourceBundle(String className) throws MissingResourceException {
        Locale locale = Locale.getDefault();
        String suffix = XSLMessages.getResourceSuffix(locale);
        try {
            return (ListResourceBundle)ResourceBundle.getBundle(className, locale);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                return (ListResourceBundle)ResourceBundle.getBundle(XSLT_ERROR_RESOURCES, new Locale("en", "US"));
            }
            catch (MissingResourceException missingResourceException2) {
                throw new MissingResourceException("Could not load any resource bundles." + className, className, "");
            }
        }
    }

    private static final String getResourceSuffix(Locale locale) {
        String suffix = "_" + locale.getLanguage();
        String country = locale.getCountry();
        if (country.equals("TW")) {
            suffix = String.valueOf(suffix) + "_" + country;
        }
        return suffix;
    }
}

