/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.xml.PrefixResolver;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.apache.xalan.xslt.AVTPart;
import org.apache.xalan.xslt.AVTPartSimple;
import org.apache.xalan.xslt.AVTPartXPath;
import org.apache.xalan.xslt.Stylesheet;
import org.apache.xalan.xslt.XSLTEngineImpl;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class AVT
implements Serializable {
    String m_simpleString;
    Vector m_parts;
    String m_name;
    String m_type;

    public AVT(String name, String type, String stringedValue, PrefixResolver namespaceContext, Stylesheet stylesheet, XSLTEngineImpl execContext) throws SAXException {
        block23: {
            int nTokens;
            StringTokenizer tokenizer;
            block22: {
                this.m_name = name;
                this.m_type = type;
                tokenizer = new StringTokenizer(stringedValue, "{}\"'", true);
                nTokens = tokenizer.countTokens();
                if (nTokens >= 2) break block22;
                this.m_simpleString = stringedValue;
                break block23;
            }
            this.m_parts = new Vector(nTokens + 1);
            StringBuffer buffer = new StringBuffer(32);
            StringBuffer exprBuffer = new StringBuffer(32);
            String t = null;
            String lookahead = null;
            String error = null;
            while (tokenizer.hasMoreTokens()) {
                block25: {
                    block24: {
                        if (lookahead != null) {
                            t = lookahead;
                            lookahead = null;
                        } else {
                            t = tokenizer.nextToken();
                        }
                        if (t.length() != 1) break block24;
                        switch (t.charAt(0)) {
                            case '\"': 
                            case '\'': {
                                buffer.append(t);
                                break;
                            }
                            case '{': {
                                lookahead = tokenizer.nextToken();
                                if (lookahead.equals("{")) {
                                    buffer.append(lookahead);
                                    lookahead = null;
                                    break;
                                }
                                if (buffer.length() > 0) {
                                    this.m_parts.addElement(new AVTPartSimple(buffer.toString()));
                                    buffer.setLength(0);
                                }
                                exprBuffer.setLength(0);
                                exprBuffer.append(lookahead);
                                while (lookahead != null && !lookahead.equals("}")) {
                                    lookahead = tokenizer.nextToken();
                                    if (lookahead.length() == 1) {
                                        switch (lookahead.charAt(0)) {
                                            case '\"': 
                                            case '\'': {
                                                exprBuffer.append(lookahead);
                                                String quote = lookahead;
                                                lookahead = tokenizer.nextToken();
                                                while (!lookahead.equals(quote)) {
                                                    exprBuffer.append(lookahead);
                                                    lookahead = tokenizer.nextToken();
                                                }
                                                exprBuffer.append(lookahead);
                                                break;
                                            }
                                            case '{': {
                                                error = XSLMessages.createMessage(1, null);
                                                break;
                                            }
                                            case '}': {
                                                buffer.setLength(0);
                                                XPath xpath = stylesheet.createXPath(exprBuffer.toString(), namespaceContext);
                                                this.m_parts.addElement(new AVTPartXPath(xpath));
                                                lookahead = null;
                                                break;
                                            }
                                            default: {
                                                exprBuffer.append(lookahead);
                                                break;
                                            }
                                        }
                                        continue;
                                    }
                                    exprBuffer.append(lookahead);
                                }
                                if (error != null) {
                                    break;
                                }
                                break block25;
                            }
                            case '}': {
                                lookahead = tokenizer.nextToken();
                                if (lookahead.equals("}")) {
                                    buffer.append(lookahead);
                                    lookahead = null;
                                    break;
                                }
                                execContext.warn(1);
                                buffer.append("}");
                                break;
                            }
                            default: {
                                buffer.append(t);
                                break;
                            }
                        }
                        break block25;
                    }
                    buffer.append(t);
                }
                if (error == null) continue;
                execContext.warn(14, new Object[]{error});
                break;
            }
            if (buffer.length() > 0) {
                this.m_parts.addElement(new AVTPartSimple(buffer.toString()));
                buffer.setLength(0);
            }
        }
        if (this.m_parts == null && this.m_simpleString == null) {
            this.m_simpleString = "";
        }
    }

    String evaluate(XPathSupport execContext, Node context, PrefixResolver nsNode, StringBuffer buf) throws SAXException {
        if (this.m_simpleString != null) {
            return this.m_simpleString;
        }
        if (this.m_parts != null) {
            buf.setLength(0);
            int n = this.m_parts.size();
            int i = 0;
            while (i < n) {
                AVTPart part = (AVTPart)this.m_parts.elementAt(i);
                part.evaluate(execContext, buf, context, nsNode);
                ++i;
            }
            return buf.toString();
        }
        return "";
    }
}

