/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.dtm.DTM;
import org.apache.xalan.xpath.dtm.DTMProxy;
import org.apache.xalan.xpath.xml.QName;
import org.apache.xalan.xpath.xml.XMLParserLiaison;
import org.apache.xalan.xslt.AVT;
import org.apache.xalan.xslt.DecimalToRoman;
import org.apache.xalan.xslt.ElemTemplateElement;
import org.apache.xalan.xslt.Stylesheet;
import org.apache.xalan.xslt.XSLProcessorException;
import org.apache.xalan.xslt.XSLTEngineImpl;
import org.apache.xalan.xslt.res.XSLTResourceBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class ElemNumber
extends ElemTemplateElement {
    public XPath m_countMatchPattern;
    public XPath m_fromMatchPattern;
    public XPath m_valueExpr;
    public int m_level = 1;
    public AVT m_format_avt;
    public AVT m_lang_avt;
    public AVT m_lettervalue_avt;
    public AVT m_groupingSeparator_avt;
    public AVT m_groupingSize_avt;
    private XSLTResourceBundle thisBundle;
    private static final DecimalToRoman[] m_romanConvertTable = new DecimalToRoman[]{new DecimalToRoman(1000L, "M", 900L, "CM"), new DecimalToRoman(500L, "D", 400L, "CD"), new DecimalToRoman(100L, "C", 90L, "XC"), new DecimalToRoman(50L, "L", 40L, "XL"), new DecimalToRoman(10L, "X", 9L, "IX"), new DecimalToRoman(5L, "V", 4L, "IV"), new DecimalToRoman(1L, "I", 1L, "I")};
    private static char[] m_alphaCountTable = null;

    public int getXSLToken() {
        return 35;
    }

    public ElemNumber(XSLTEngineImpl processor, Stylesheet stylesheetTree, String name, AttributeList atts, int lineNumber, int columnNumber) throws SAXException {
        super(processor, stylesheetTree, name, atts, lineNumber, columnNumber);
        int nAttrs = atts.getLength();
        int i = 0;
        while (i < nAttrs) {
            String aname = atts.getName(i);
            if (aname.equals("level")) {
                String levelValue = atts.getValue(i);
                if (levelValue != null) {
                    if (levelValue.equals("multiple")) {
                        this.m_level = 2;
                    } else if (levelValue.equals("any")) {
                        this.m_level = 3;
                    } else if (levelValue.equals("single")) {
                        this.m_level = 1;
                    } else {
                        this.error(11, new Object[]{levelValue});
                    }
                }
            } else if (aname.equals("count")) {
                this.m_countMatchPattern = this.m_stylesheet.createMatchPattern(atts.getValue(i), this);
            } else if (aname.equals("from")) {
                this.m_fromMatchPattern = this.m_stylesheet.createMatchPattern(atts.getValue(i), this);
            } else if (aname.equals("value")) {
                this.m_valueExpr = this.m_stylesheet.createXPath(atts.getValue(i), this);
            } else if (aname.equals("format")) {
                this.m_format_avt = new AVT(aname, atts.getType(i), atts.getValue(i), this, this.m_stylesheet, processor);
            } else if (aname.equals("lang")) {
                this.m_lang_avt = new AVT(aname, atts.getType(i), atts.getValue(i), this, this.m_stylesheet, processor);
            } else if (aname.equals("letter-value")) {
                this.m_lettervalue_avt = new AVT(aname, atts.getType(i), atts.getValue(i), this, this.m_stylesheet, processor);
            } else if (aname.equals("grouping-separator")) {
                this.m_groupingSeparator_avt = new AVT(aname, atts.getType(i), atts.getValue(i), this, this.m_stylesheet, processor);
            } else if (aname.equals("grouping-size")) {
                this.m_groupingSize_avt = new AVT(aname, atts.getType(i), atts.getValue(i), this, this.m_stylesheet, processor);
            } else if (!this.isAttrOK(aname, atts, i)) {
                processor.error(2, new Object[]{name, aname});
            }
            ++i;
        }
        try {
            this.thisBundle = XSLTResourceBundle.loadResourceBundle("org.apache.xalan.xslt.res.XSLTResources", this.getLocale(processor, processor.getSourceNode()));
            char[] alphabet = (char[])this.thisBundle.getObject("alphabet");
            m_alphaCountTable = alphabet;
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void execute(XSLTEngineImpl processor, Node sourceTree, Node sourceNode, QName mode) throws XSLProcessorException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        super.execute(processor, sourceTree, sourceNode, mode);
        String countString = this.getCountString(processor, sourceTree, sourceNode);
        processor.m_resultTreeHandler.characters(countString.toCharArray(), 0, countString.length());
    }

    public Node appendChild(Node newChild) throws DOMException {
        this.error(4, new Object[]{((ElemTemplateElement)newChild).m_elemName, this.m_elemName});
        return null;
    }

    /*
     * Unable to fully structure code
     */
    Node findAncestor(XPathSupport execContext, XPath fromMatchPattern, XPath countMatchPattern, Node context, Element namespaceContext) throws SAXException {
        try {
            contextp = (DTMProxy)context;
            dtm = contextp.getDTM();
            contextIndex = contextp.getDTMNodeNumber();
            while (contextIndex != -1) {
                if (fromMatchPattern != null && fromMatchPattern.getMatchScore(execContext, dtm, contextIndex) != -Infinity) {
                    context = null;
                    break;
                }
                if (countMatchPattern != null && countMatchPattern.getMatchScore(execContext, dtm, contextIndex) != -Infinity) break;
                contextIndex = dtm.getParent(contextIndex);
            }
            return dtm.getNode(contextIndex);
        }
        catch (ClassCastException v0) {
            ** while (context != null)
        }
lbl-1000:
        // 1 sources

        {
            if (fromMatchPattern != null && fromMatchPattern.getMatchScore(execContext, context) != -Infinity) {
                context = null;
                break;
            }
            if (countMatchPattern != null && countMatchPattern.getMatchScore(execContext, context) != -Infinity) break;
            context = execContext.getParentOfNode(context);
            continue;
        }
lbl21:
        // 3 sources

        return context;
    }

    int findAncestor(XPathSupport execContext, XPath fromMatchPattern, XPath countMatchPattern, DTM dtm, int contextIndex, Element namespaceContext) throws SAXException {
        while (contextIndex != -1) {
            if (fromMatchPattern != null && fromMatchPattern.getMatchScore(execContext, dtm, contextIndex) != Double.NEGATIVE_INFINITY) {
                contextIndex = -1;
                break;
            }
            if (countMatchPattern != null && countMatchPattern.getMatchScore(execContext, dtm, contextIndex) != Double.NEGATIVE_INFINITY) break;
            contextIndex = dtm.getParent(contextIndex);
        }
        return contextIndex;
    }

    /*
     * Unable to fully structure code
     */
    Node findPrecedingOrAncestorOrSelf(XPathSupport execContext, XPath fromMatchPattern, XPath countMatchPattern, Node context, Element namespaceContext) throws SAXException {
        try {
            dtmp = (DTMProxy)context;
            dtmpPos = dtmp.getDTMNodeNumber();
            dtm = dtmp.getDTM();
            contextNode = dtm.getPrecedingOrAncestorOrSelf(dtmpPos);
            while (contextNode != -1) {
                if (fromMatchPattern != null && fromMatchPattern.getMatchScore(execContext, dtm, contextNode) != -Infinity) {
                    context = null;
                    break;
                }
                if (countMatchPattern != null && countMatchPattern.getMatchScore(execContext, dtm, contextNode) != -Infinity) break;
                contextNode = dtm.getPrecedingOrAncestorOrSelf(contextNode);
            }
            return dtm.getNode(contextNode);
        }
        catch (ClassCastException v0) {
            ** while (context != null)
        }
lbl-1000:
        // 1 sources

        {
            if (fromMatchPattern != null && fromMatchPattern.getMatchScore(execContext, context) != -Infinity) {
                context = null;
                break;
            }
            if (countMatchPattern != null && countMatchPattern.getMatchScore(execContext, context) != -Infinity) break;
            prevSibling = context.getPreviousSibling();
            context = prevSibling == null ? execContext.getParentOfNode(context) : prevSibling;
            continue;
        }
lbl23:
        // 3 sources

        return context;
    }

    XPath getCountMatchPattern(Node contextNode) throws SAXException {
        XPath countMatchPattern = this.m_countMatchPattern;
        if (countMatchPattern == null) {
            switch (contextNode.getNodeType()) {
                case 1: {
                    countMatchPattern = this.m_stylesheet.createMatchPattern(contextNode.getNodeName(), this);
                    break;
                }
                case 2: {
                    countMatchPattern = this.m_stylesheet.createMatchPattern("@" + contextNode.getNodeName(), this);
                    break;
                }
                case 3: 
                case 4: {
                    countMatchPattern = this.m_stylesheet.createMatchPattern("text()", this);
                    break;
                }
                case 8: {
                    countMatchPattern = this.m_stylesheet.createMatchPattern("comment()", this);
                    break;
                }
                case 9: {
                    countMatchPattern = this.m_stylesheet.createMatchPattern("/", this);
                    break;
                }
                case 7: {
                    countMatchPattern = this.m_stylesheet.createMatchPattern("pi(" + contextNode.getNodeName() + ")", this);
                    break;
                }
            }
            this.m_countMatchPattern = countMatchPattern;
        }
        return countMatchPattern;
    }

    String getCountString(XSLTEngineImpl processor, Node sourceTree, Node sourceNode) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        XMLParserLiaison execContext = processor.getXMLProcessorLiaison();
        int[] list = null;
        if (this.m_valueExpr != null) {
            XObject countObj = this.m_valueExpr.execute((XPathSupport)execContext, sourceNode, this);
            int count = (int)countObj.num();
            list = new int[]{count};
        } else {
            XPath countMatchPattern = this.getCountMatchPattern(sourceNode);
            if (this.m_level == 3 || this.m_level == 1) {
                list = new int[1];
                if (this.m_level == 1) {
                    Node target = this.findAncestor(execContext, this.m_fromMatchPattern, countMatchPattern, sourceNode, this);
                    if (target == null) {
                        target = execContext.getParentOfNode(sourceNode);
                    }
                    if (target != null) {
                        list[0] = this.getSiblingNumber(execContext, countMatchPattern, target);
                    } else {
                        processor.warn(2, new Object[]{sourceNode.getNodeName()});
                    }
                } else {
                    Node from = null;
                    if (this.m_fromMatchPattern != null) {
                        from = this.findPrecedingOrAncestorOrSelf(execContext, null, this.m_fromMatchPattern, sourceNode, this);
                        if (from == null) {
                            from = sourceNode;
                        }
                    } else {
                        from = sourceNode.getOwnerDocument();
                    }
                    Document fromPos = from != sourceNode ? this.getNextInTree(from, from) : from;
                    list[0] = this.getNumberInTree(execContext, countMatchPattern, fromPos, from, sourceNode, 0);
                }
            } else {
                list = this.getAncestorNumbers(execContext, this.m_fromMatchPattern, countMatchPattern, sourceNode);
            }
        }
        return list != null ? this.formatNumberList(processor, list, sourceNode) : "";
    }

    /*
     * Unable to fully structure code
     */
    Node getNextInTree(Node pos, Node from) {
        try {
            posp = (DTMProxy)pos;
            fromp = (DTMProxy)from;
            dtm = posp.getDTM();
            next = dtm.getNextNode(fromp.getDTMNodeNumber(), posp.getDTMNodeNumber());
            return next >= 0 ? dtm.getNode(next) : null;
        }
        catch (ClassCastException v0) {
            nextNode = null;
            nextNode = pos.getFirstChild();
            ** while (nextNode == null)
        }
lbl-1000:
        // 1 sources

        {
            nextNode = pos.getNextSibling();
            if (nextNode == null && (pos = pos.getParentNode()).equals(from)) break;
            continue;
        }
lbl14:
        // 2 sources

        return nextNode;
    }

    int getNumberInTree(XPathSupport execContext, XPath countMatchPattern, Node pos, Node from, Node target, int countFrom) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        int count;
        block7: {
            count = countFrom;
            if (pos == null) break block7;
            try {
                DTMProxy posp = (DTMProxy)pos;
                DTMProxy fromp = (DTMProxy)from;
                DTMProxy targetp = (DTMProxy)target;
                DTM dtm = posp.getDTM();
                int fromIndex = fromp.getDTMNodeNumber();
                int targetIndex = targetp.getDTMNodeNumber();
                int posIndex = posp.getDTMNodeNumber();
                while (posIndex != -1) {
                    if (countMatchPattern == null || countMatchPattern.getMatchScore(execContext, dtm, posIndex) != Double.NEGATIVE_INFINITY) {
                        ++count;
                    }
                    if (posIndex != targetIndex) {
                        posIndex = dtm.getNextNode(fromIndex, posIndex);
                        continue;
                    }
                    break;
                }
            }
            catch (ClassCastException classCastException) {
                do {
                    if (countMatchPattern == null || countMatchPattern.getMatchScore(execContext, pos) != Double.NEGATIVE_INFINITY) {
                        ++count;
                    }
                    if (pos.equals(target)) break;
                } while ((pos = this.getNextInTree(pos, from)) != null);
            }
        }
        return count;
    }

    /*
     * Unable to fully structure code
     */
    int getSiblingNumber(XPathSupport execContext, XPath countMatchPattern, Node target) throws SAXException {
        block8: {
            number = 0;
            try {
                targetp = (DTMProxy)target;
                dtm = targetp.getDTM();
                targetIndex = targetp.getDTMNodeNumber();
                parentNode = dtm.getParent(targetIndex);
                posIndex = dtm.getFirstChild(parentNode);
                while (posIndex != -1) {
                    if (posIndex == targetIndex) {
                        ++number;
                        break block8;
                    }
                    if (countMatchPattern == null || countMatchPattern.getMatchScore(execContext, dtm.getNode(posIndex)) != -Infinity) {
                        ++number;
                    }
                    posIndex = dtm.getNextSibling(posIndex);
                }
                break block8;
            }
            catch (ClassCastException v0) {
                number = 0;
                startNode = execContext.getParentOfNode(target);
                child = startNode.getFirstChild();
                ** while (child != null)
            }
lbl-1000:
            // 1 sources

            {
                if (child.equals(target)) {
                    ++number;
                    break;
                }
                if (countMatchPattern == null || countMatchPattern.getMatchScore(execContext, child) != -Infinity) {
                    ++number;
                }
                child = child.getNextSibling();
                continue;
            }
        }
        return number;
    }

    int getSiblingNumber(XPathSupport execContext, XPath countMatchPattern, DTM dtm, int targetIndex) throws SAXException {
        int number = 0;
        int parentNode = dtm.getParent(targetIndex);
        int posIndex = dtm.getFirstChild(parentNode);
        while (posIndex != -1) {
            if (posIndex == targetIndex) {
                ++number;
                break;
            }
            if (countMatchPattern == null || countMatchPattern.getMatchScore(execContext, dtm, posIndex) != Double.NEGATIVE_INFINITY) {
                ++number;
            }
            posIndex = dtm.getNextSibling(posIndex);
        }
        return number;
    }

    public int countMatchingAncestors(XPathSupport execContext, XPath patterns, Node node) throws SAXException {
        int count = 0;
        while (node != null) {
            if (patterns != null) {
                if (patterns.getMatchScore(execContext, node) != Double.NEGATIVE_INFINITY) {
                    ++count;
                }
            } else {
                ++count;
            }
            node = execContext.getParentOfNode(node);
        }
        return count;
    }

    public int countMatchingAncestors(XPathSupport execContext, XPath patterns, DTM dtm, int node) throws SAXException {
        int count = 0;
        while (node != -1) {
            if (patterns != null) {
                if (patterns.getMatchScore(execContext, dtm, node) != Double.NEGATIVE_INFINITY) {
                    ++count;
                }
            } else {
                ++count;
            }
            node = dtm.getParent(node);
        }
        return count;
    }

    /*
     * Unable to fully structure code
     */
    public int[] getAncestorNumbers(XPathSupport execContext, XPath fromMatchPattern, XPath countMatchPattern, Node node) throws SAXException {
        block14: {
            counts = null;
            try {
                nodep = (DTMProxy)node;
                nodeIndex = nodep.getDTMNodeNumber();
                dtm = nodep.getDTM();
                nMatchingAncestors = this.countMatchingAncestors(execContext, countMatchPattern, dtm, nodeIndex);
                if (nMatchingAncestors <= 0) break block14;
                counts = new int[nMatchingAncestors];
                countIndex = counts.length - 1;
                while (nodeIndex != -1 && countIndex != -1) {
                    countIt = false;
                    if (countMatchPattern != null) {
                        if (countMatchPattern.getMatchScore(execContext, dtm, nodeIndex) != -Infinity) {
                            countIt = true;
                        }
                    } else {
                        countIt = true;
                    }
                    if (countIt) {
                        targetIndex = this.findAncestor(execContext, fromMatchPattern, countMatchPattern, dtm, nodeIndex, this);
                        if (targetIndex == -1) {
                            targetIndex = nodeIndex;
                        }
                        counts[countIndex] = this.getSiblingNumber(execContext, countMatchPattern, dtm, targetIndex);
                        --countIndex;
                    }
                    nodeIndex = dtm.getParent(nodeIndex);
                }
                break block14;
            }
            catch (ClassCastException v0) {
                nMatchingAncestors = this.countMatchingAncestors(execContext, countMatchPattern, node);
                if (nMatchingAncestors <= 0) break block14;
                counts = new int[nMatchingAncestors];
                countIndex = counts.length - 1;
                ** while (node != null)
            }
lbl-1000:
            // 1 sources

            {
                countIt = false;
                if (countMatchPattern != null) {
                    if (countMatchPattern.getMatchScore(execContext, node) != -Infinity) {
                        countIt = true;
                    }
                } else {
                    countIt = true;
                }
                if (countIt) {
                    target = this.findAncestor(execContext, fromMatchPattern, countMatchPattern, node, this);
                    if (target == null) {
                        target = node;
                    }
                    counts[countIndex] = this.getSiblingNumber(execContext, countMatchPattern, target);
                    --countIndex;
                }
                node = execContext.getParentOfNode(node);
                continue;
            }
        }
        return counts;
    }

    Locale getLocale(XSLTEngineImpl processor, Node contextNode) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        Locale locale = null;
        if (this.m_lang_avt != null) {
            String langValue = this.m_lang_avt.evaluate(processor.getExecContext(), contextNode, this, new StringBuffer());
            if (langValue != null && (locale = new Locale(langValue.toUpperCase(), "")) == null) {
                processor.warn(null, contextNode, 5, new Object[]{langValue});
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return locale;
    }

    DecimalFormat getNumberFormatter(XSLTEngineImpl processor, Node contextNode) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        DecimalFormat formatter;
        block2: {
            String nDigitsPerGroupValue;
            Locale locale = this.getLocale(processor, contextNode);
            formatter = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            String digitGroupSepValue = this.m_groupingSeparator_avt != null ? this.m_groupingSeparator_avt.evaluate(processor.getExecContext(), contextNode, this, new StringBuffer()) : null;
            String string = nDigitsPerGroupValue = this.m_groupingSize_avt != null ? this.m_groupingSize_avt.evaluate(processor.getExecContext(), contextNode, this, new StringBuffer()) : null;
            if (digitGroupSepValue == null || nDigitsPerGroupValue == null) break block2;
            try {
                formatter.setGroupingSize(Integer.valueOf(nDigitsPerGroupValue));
                formatter.getDecimalFormatSymbols().setGroupingSeparator(digitGroupSepValue.charAt(0));
                ((NumberFormat)formatter).setGroupingUsed(true);
            }
            catch (NumberFormatException numberFormatException) {
                ((NumberFormat)formatter).setGroupingUsed(false);
            }
        }
        return formatter;
    }

    /*
     * Unable to fully structure code
     */
    String formatNumberList(XSLTEngineImpl processor, int[] list, Node contextNode) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        block10: {
            formattedNumber = "";
            nNumbers = list.length;
            numberType = '1';
            numberWidth = 1;
            sepString = "";
            lastSepString = null;
            v0 = formatValue = this.m_format_avt != null ? this.m_format_avt.evaluate(processor.getExecContext(), contextNode, this, new StringBuffer()) : null;
            if (formatValue == null) {
                formatValue = "1";
            }
            formatTokenizer = new NumberFormatStringTokenizer(formatValue);
            i = 0;
            break block10;
            {
                formatToken = formatTokenizer.nextToken();
                if (Character.isLetterOrDigit(formatToken.charAt(formatToken.length() - 1))) {
                    numberWidth = formatToken.length();
                    numberType = formatToken.charAt(numberWidth - 1);
                    break;
                }
                sepString = formatToken;
                formattedNumber = String.valueOf(formattedNumber) + sepString;
                if (formatTokenizer.hasMoreTokens()) {
                    while (formatTokenizer.hasMoreTokens()) {
                        formatToken = formatTokenizer.nextToken();
                        if (!Character.isLetterOrDigit(formatToken.charAt(0))) {
                            lastSepString = String.valueOf(sepString) + formatToken;
                            continue;
                        }
                        numberWidth = formatToken.length();
                        numberType = formatToken.charAt(numberWidth - 1);
                        break block0;
                    }
                    break;
                }
lbl30:
                // 3 sources

                while (true) {
                    if (formatTokenizer.hasMoreTokens()) continue block0;
                    break;
                }
            }
            formattedNumber = String.valueOf(formattedNumber) + this.getFormattedNumber(processor, contextNode, numberType, numberWidth, list[i]);
            ++i;
        }
        ** while (i < nNumbers)
lbl36:
        // 1 sources

        if (lastSepString == null) {
            lastSepString = "";
        }
        while (formatTokenizer.hasMoreTokens()) {
            formatToken = formatTokenizer.nextToken();
            lastSepString = Character.isLetterOrDigit(formatToken.charAt(0)) == false ? String.valueOf(lastSepString) + formatToken : "";
        }
        if (lastSepString != null) {
            formattedNumber = String.valueOf(formattedNumber) + lastSepString;
        }
        return formattedNumber;
    }

    private String getFormattedNumber(XSLTEngineImpl processor, Node contextNode, char numberType, int numberWidth, int listElement) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        DecimalFormat formatter = this.getNumberFormatter(processor, contextNode);
        String padString = formatter.format(0L);
        String formattedNumber = "";
        String letterVal = this.m_lettervalue_avt != null ? this.m_lettervalue_avt.evaluate(processor.getExecContext(), contextNode, this, new StringBuffer()) : null;
        switch (numberType) {
            case 'A': {
                formattedNumber = String.valueOf(formattedNumber) + this.int2alphaCount(listElement, m_alphaCountTable);
                break;
            }
            case 'a': {
                formattedNumber = String.valueOf(formattedNumber) + this.int2alphaCount(listElement, m_alphaCountTable).toLowerCase(this.getLocale(processor, contextNode));
                break;
            }
            case 'I': {
                formattedNumber = String.valueOf(formattedNumber) + this.long2roman(listElement, true);
                break;
            }
            case 'i': {
                formattedNumber = String.valueOf(formattedNumber) + this.long2roman(listElement, true).toLowerCase(this.getLocale(processor, contextNode));
                break;
            }
            case '\u3042': {
                this.thisBundle = XSLTResourceBundle.loadResourceBundle("org.apache.xalan.xslt.res.XSLTResources", new Locale("ja", "JP", "HA"));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber = String.valueOf(formattedNumber) + this.tradAlphaCount(listElement);
                    break;
                }
                formattedNumber = String.valueOf(formattedNumber) + this.int2singlealphaCount(listElement, (char[])this.thisBundle.getObject("alphabet"));
                break;
            }
            case '\u3044': {
                this.thisBundle = XSLTResourceBundle.loadResourceBundle("org.apache.xalan.xslt.res.XSLTResources", new Locale("ja", "JP", "HI"));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber = String.valueOf(formattedNumber) + this.tradAlphaCount(listElement);
                    break;
                }
                formattedNumber = String.valueOf(formattedNumber) + this.int2singlealphaCount(listElement, (char[])this.thisBundle.getObject("alphabet"));
                break;
            }
            case '\u30a2': {
                this.thisBundle = XSLTResourceBundle.loadResourceBundle("org.apache.xalan.xslt.res.XSLTResources", new Locale("ja", "JP", "A"));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber = String.valueOf(formattedNumber) + this.tradAlphaCount(listElement);
                    break;
                }
                formattedNumber = String.valueOf(formattedNumber) + this.int2singlealphaCount(listElement, (char[])this.thisBundle.getObject("alphabet"));
                break;
            }
            case '\u30a4': {
                this.thisBundle = XSLTResourceBundle.loadResourceBundle("org.apache.xalan.xslt.res.XSLTResources", new Locale("ja", "JP", "I"));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber = String.valueOf(formattedNumber) + this.tradAlphaCount(listElement);
                    break;
                }
                formattedNumber = String.valueOf(formattedNumber) + this.int2singlealphaCount(listElement, (char[])this.thisBundle.getObject("alphabet"));
                break;
            }
            case '\u4e00': {
                this.thisBundle = XSLTResourceBundle.loadResourceBundle("org.apache.xalan.xslt.res.XSLTResources", new Locale("zh", "CN"));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber = String.valueOf(formattedNumber) + this.tradAlphaCount(listElement);
                    break;
                }
                formattedNumber = String.valueOf(formattedNumber) + this.int2alphaCount(listElement, (char[])this.thisBundle.getObject("alphabet"));
                break;
            }
            case '\u58f9': {
                this.thisBundle = XSLTResourceBundle.loadResourceBundle("org.apache.xalan.xslt.res.XSLTResources", new Locale("zh", "TW"));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber = String.valueOf(formattedNumber) + this.tradAlphaCount(listElement);
                    break;
                }
                formattedNumber = String.valueOf(formattedNumber) + this.int2alphaCount(listElement, (char[])this.thisBundle.getObject("alphabet"));
                break;
            }
            case '\u0e51': {
                this.thisBundle = XSLTResourceBundle.loadResourceBundle("org.apache.xalan.xslt.res.XSLTResources", new Locale("th", ""));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber = String.valueOf(formattedNumber) + this.tradAlphaCount(listElement);
                    break;
                }
                formattedNumber = String.valueOf(formattedNumber) + this.int2alphaCount(listElement, (char[])this.thisBundle.getObject("alphabet"));
                break;
            }
            case '\u05d0': {
                this.thisBundle = XSLTResourceBundle.loadResourceBundle("org.apache.xalan.xslt.res.XSLTResources", new Locale("he", ""));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber = String.valueOf(formattedNumber) + this.tradAlphaCount(listElement);
                    break;
                }
                formattedNumber = String.valueOf(formattedNumber) + this.int2alphaCount(listElement, (char[])this.thisBundle.getObject("alphabet"));
                break;
            }
            case '\u10d0': {
                this.thisBundle = XSLTResourceBundle.loadResourceBundle("org.apache.xalan.xslt.res.XSLTResources", new Locale("ka", ""));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber = String.valueOf(formattedNumber) + this.tradAlphaCount(listElement);
                    break;
                }
                formattedNumber = String.valueOf(formattedNumber) + this.int2alphaCount(listElement, (char[])this.thisBundle.getObject("alphabet"));
                break;
            }
            case '\u03b1': {
                this.thisBundle = XSLTResourceBundle.loadResourceBundle("org.apache.xalan.xslt.res.XSLTResources", new Locale("el", ""));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber = String.valueOf(formattedNumber) + this.tradAlphaCount(listElement);
                    break;
                }
                formattedNumber = String.valueOf(formattedNumber) + this.int2alphaCount(listElement, (char[])this.thisBundle.getObject("alphabet"));
                break;
            }
            case '\u0430': {
                this.thisBundle = XSLTResourceBundle.loadResourceBundle("org.apache.xalan.xslt.res.XSLTResources", new Locale("cy", ""));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber = String.valueOf(formattedNumber) + this.tradAlphaCount(listElement);
                    break;
                }
                formattedNumber = String.valueOf(formattedNumber) + this.int2alphaCount(listElement, (char[])this.thisBundle.getObject("alphabet"));
                break;
            }
            default: {
                String numString = formatter.format(listElement);
                int nPadding = numberWidth - numString.length();
                int k = 0;
                while (k < nPadding) {
                    formattedNumber = String.valueOf(formattedNumber) + padString;
                    ++k;
                }
                formattedNumber = String.valueOf(formattedNumber) + numString;
            }
        }
        return formattedNumber;
    }

    protected String int2singlealphaCount(int val, char[] table) {
        int radix = table.length;
        if (val > radix) {
            return "#E(" + val + ")";
        }
        return new Character(table[val - 1]).toString();
    }

    protected String int2alphaCount(int val, char[] aTable) {
        int radix = aTable.length;
        char[] table = new char[aTable.length];
        int i = 0;
        while (i < aTable.length - 1) {
            table[i + 1] = aTable[i];
            ++i;
        }
        table[0] = aTable[i];
        char[] buf = new char[100];
        int charPos = buf.length - 1;
        int lookupIndex = 1;
        int correction = 0;
        while ((lookupIndex = (val + (correction = lookupIndex == 0 || correction != 0 && lookupIndex == radix - 1 ? radix - 1 : 0)) % radix) != 0 || (val /= radix) != 0) {
            buf[charPos--] = table[lookupIndex];
            if (val > 0) continue;
        }
        return new String(buf, charPos + 1, buf.length - charPos - 1);
    }

    protected String tradAlphaCount(int val) {
        char[] table = null;
        int lookupIndex = 1;
        char[] buf = new char[100];
        int charPos = 0;
        int[] groups = (int[])this.thisBundle.getObject("numberGroups");
        String[] tables = (String[])this.thisBundle.getObject("tables");
        String numbering = this.thisBundle.getString("numbering");
        if (numbering.equals("multiplicative-additive")) {
            String mult_order = this.thisBundle.getString("multiplierOrder");
            int[] multiplier = (int[])this.thisBundle.getObject("multiplier");
            char[] zeroChar = (char[])this.thisBundle.getObject("zero");
            int i = 0;
            while (i < multiplier.length && val < multiplier[i]) {
                ++i;
            }
            while (i < multiplier.length) {
                if (val < multiplier[i]) {
                    if (zeroChar.length == 0) {
                        ++i;
                    } else {
                        if (buf[charPos - 1] != zeroChar[0]) {
                            buf[charPos++] = zeroChar[0];
                        }
                        ++i;
                    }
                } else if (val >= multiplier[i]) {
                    int mult = val / multiplier[i];
                    val %= multiplier[i];
                    for (int k = 0; k < groups.length; ++k) {
                        lookupIndex = 1;
                        if (mult / groups[k] <= 0) {
                            continue;
                        }
                        char[] THEletters = (char[])this.thisBundle.getObject(tables[k]);
                        table = new char[THEletters.length + 1];
                        int j = 0;
                        while (j < THEletters.length) {
                            table[j + 1] = THEletters[j];
                            ++j;
                        }
                        table[0] = THEletters[j - 1];
                        lookupIndex = mult / groups[k];
                        if (lookupIndex == 0 && mult == 0) break;
                        char multiplierChar = ((char[])this.thisBundle.getObject("multiplierChar"))[i];
                        if (lookupIndex < table.length) {
                            if (mult_order.equals("precedes")) {
                                buf[charPos++] = multiplierChar;
                                buf[charPos++] = table[lookupIndex];
                                break;
                            }
                            if (lookupIndex != 1 || i != multiplier.length - 1) {
                                buf[charPos++] = table[lookupIndex];
                            }
                            buf[charPos++] = multiplierChar;
                            break;
                        }
                        return "#error";
                    }
                    ++i;
                }
                if (i < multiplier.length) continue;
            }
        }
        int count = 0;
        while (count < groups.length) {
            if (val / groups[count] <= 0) {
                ++count;
                continue;
            }
            char[] theletters = (char[])this.thisBundle.getObject(tables[count]);
            table = new char[theletters.length + 1];
            int j = 0;
            while (j < theletters.length) {
                table[j + 1] = theletters[j];
                ++j;
            }
            table[0] = theletters[j - 1];
            lookupIndex = val / groups[count];
            if (lookupIndex == 0 && (val %= groups[count]) == 0) break;
            if (lookupIndex >= table.length) {
                return "#error";
            }
            buf[charPos++] = table[lookupIndex];
            ++count;
        }
        String s = new String(buf, 0, charPos);
        return new String(buf, 0, charPos);
    }

    protected String long2roman(long val, boolean prefixesAreOK) {
        if (val <= 0L) {
            return "#E(" + val + ")";
        }
        String roman = "";
        int place = 0;
        if (val <= 3999L) {
            while (true) {
                if (val >= ElemNumber.m_romanConvertTable[place].m_postValue) {
                    roman = String.valueOf(roman) + ElemNumber.m_romanConvertTable[place].m_postLetter;
                    val -= ElemNumber.m_romanConvertTable[place].m_postValue;
                    continue;
                }
                if (prefixesAreOK && val >= ElemNumber.m_romanConvertTable[place].m_preValue) {
                    roman = String.valueOf(roman) + ElemNumber.m_romanConvertTable[place].m_preLetter;
                    val -= ElemNumber.m_romanConvertTable[place].m_preValue;
                }
                ++place;
                if (val <= 0L) break;
            }
        } else {
            roman = "#error";
        }
        return roman;
    }

    class NumberFormatStringTokenizer {
        private int currentPosition;
        private int maxPosition;
        private String str;

        public NumberFormatStringTokenizer(String str) {
            ElemNumber.this = ElemNumber.this;
            this.str = str;
            this.maxPosition = str.length();
        }

        public void reset() {
            this.currentPosition = 0;
        }

        public String nextToken() {
            if (this.currentPosition >= this.maxPosition) {
                throw new NoSuchElementException();
            }
            int start = this.currentPosition;
            while (this.currentPosition < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            if (start == this.currentPosition && !Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            return this.str.substring(start, this.currentPosition);
        }

        public boolean hasMoreTokens() {
            return this.currentPosition < this.maxPosition;
        }

        public int countTokens() {
            int count = 0;
            int currpos = this.currentPosition;
            while (currpos < this.maxPosition) {
                int start = currpos;
                while (currpos < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(currpos))) {
                    ++currpos;
                }
                if (start == currpos && !Character.isLetterOrDigit(this.str.charAt(currpos))) {
                    ++currpos;
                }
                ++count;
            }
            return count;
        }
    }
}

