/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt.trace;

import java.io.PrintWriter;
import org.apache.xalan.xslt.ElemTemplate;
import org.apache.xalan.xslt.ElemTemplateElement;
import org.apache.xalan.xslt.ElemTextLiteral;
import org.apache.xalan.xslt.trace.GenerateEvent;
import org.apache.xalan.xslt.trace.SelectionEvent;
import org.apache.xalan.xslt.trace.TraceListener;
import org.apache.xalan.xslt.trace.TracerEvent;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PrintTraceListener
implements TraceListener {
    PrintWriter m_pw;
    public boolean m_traceTemplates = false;
    public boolean m_traceElements = false;
    public boolean m_traceGeneration = false;
    public boolean m_traceSelection = false;

    public PrintTraceListener(PrintWriter pw) {
        this.m_pw = pw;
    }

    public void trace(TracerEvent ev) {
        switch (ev.m_styleNode.getXSLToken()) {
            case 78: {
                if (!this.m_traceElements) break;
                this.m_pw.print("Line #" + ev.m_styleNode.m_lineNumber + ", " + "Column #" + ev.m_styleNode.m_columnNumber + " -- " + ev.m_styleNode.m_elemName + ": ");
                ElemTextLiteral etl = (ElemTextLiteral)ev.m_styleNode;
                String chars = new String(etl.m_ch, etl.m_start, etl.m_length);
                this.m_pw.println("    " + chars.trim());
                break;
            }
            case 19: {
                if (!this.m_traceTemplates && !this.m_traceElements) break;
                ElemTemplate et = (ElemTemplate)ev.m_styleNode;
                this.m_pw.print("Line #" + et.m_lineNumber + ", " + "Column #" + et.m_columnNumber + ": " + et.m_elemName + " ");
                if (et.m_matchPattern != null) {
                    this.m_pw.print("match='" + et.m_matchPattern.m_currentPattern + "' ");
                }
                if (et.m_name != null) {
                    this.m_pw.print("name='" + et.m_name + "' ");
                }
                this.m_pw.println();
                break;
            }
            default: {
                if (!this.m_traceElements) break;
                this.m_pw.println("Line #" + ev.m_styleNode.m_lineNumber + ", " + "Column #" + ev.m_styleNode.m_columnNumber + ": " + ev.m_styleNode.m_elemName);
            }
        }
    }

    public void selected(SelectionEvent ev) throws SAXException {
        if (this.m_traceSelection) {
            ElemTemplateElement ete = ev.m_styleNode;
            if (ev.m_styleNode.m_lineNumber == 0) {
                ElemTemplateElement parent = (ElemTemplateElement)ete.getParentNode();
                if (parent == ete.m_stylesheet.m_stylesheetRoot.m_defaultRootRule) {
                    this.m_pw.print("(default root rule) ");
                } else if (parent == ete.m_stylesheet.m_stylesheetRoot.m_defaultTextRule) {
                    this.m_pw.print("(default text rule) ");
                } else if (parent == ete.m_stylesheet.m_stylesheetRoot.m_defaultRule) {
                    this.m_pw.print("(default rule) ");
                }
                this.m_pw.print(String.valueOf(ete.m_elemName) + ", " + ev.m_attributeName + "='" + ev.m_xpath.m_currentPattern + "': ");
            } else {
                this.m_pw.print("Line #" + ev.m_styleNode.m_lineNumber + ", " + "Column #" + ev.m_styleNode.m_columnNumber + ": " + ete.m_elemName + ", " + ev.m_attributeName + "='" + ev.m_xpath.m_currentPattern + "': ");
            }
            if (ev.m_selection.getType() == 4) {
                this.m_pw.println();
                NodeList nl = ev.m_selection.nodeset();
                int n = nl.getLength();
                if (n == 0) {
                    this.m_pw.println("     [empty node list]");
                } else {
                    int i = 0;
                    while (i < n) {
                        this.m_pw.println("     " + nl.item(i));
                        ++i;
                    }
                }
            } else {
                this.m_pw.println(ev.m_selection.str());
            }
        }
    }

    public void generated(GenerateEvent ev) {
        if (this.m_traceGeneration) {
            switch (ev.m_eventtype) {
                case 1: {
                    this.m_pw.println("STARTDOCUMENT");
                    break;
                }
                case 2: {
                    this.m_pw.println("ENDDOCUMENT");
                    break;
                }
                case 3: {
                    this.m_pw.println("STARTELEMENT: " + ev.m_name);
                    break;
                }
                case 4: {
                    this.m_pw.println("ENDELEMENT: " + ev.m_name);
                    break;
                }
                case 5: {
                    String chars = new String(ev.m_characters, ev.m_start, ev.m_length);
                    this.m_pw.println("CHARACTERS: " + chars);
                    break;
                }
                case 10: {
                    String chars = new String(ev.m_characters, ev.m_start, ev.m_length);
                    this.m_pw.println("CDATA: " + chars);
                    break;
                }
                case 8: {
                    this.m_pw.println("COMMENT: " + ev.m_data);
                    break;
                }
                case 7: {
                    this.m_pw.println("PI: " + ev.m_name + ", " + ev.m_data);
                    break;
                }
                case 9: {
                    this.m_pw.println("ENTITYREF: " + ev.m_name);
                    break;
                }
                case 6: {
                    this.m_pw.println("IGNORABLEWHITESPACE");
                    break;
                }
            }
        }
    }
}

