/*
 * $Header: /home/cvs/jakarta-taglibs/jspspec/src/org/apache/taglibs/jspspec/FooTag.java,v 1.1 2000/04/10 00:57:15 craigmcc Exp $
 * $Revision: 1.1 $
 * $Date: 2000/04/10 00:57:15 $
 *
 * ====================================================================
 * 
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */ 

package org.apache.taglibs.jspspec;


import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;


/**
 * Example tag from Section A.1.1 of the JSP Specification, version 1.1.
 * This tag has three mandatory attributes that are translation-time only,
 * with their values set automatically by the JSP container.
 *
 * @author Craig R. McClanahan
 */

public class FooTag extends TagSupport {


    // ----------------------------------------------------------- Constructors


    /**
     * Construct a new tag instance.
     */
    public FooTag() {

	super();

	// Perform any required additional initialization

    }


    // ----------------------------------------------------- Instance Variables


    /**
     * The first attribute of this tag.
     */
    private String att1 = null;


    /**
     * The second attribute of this tag.
     */
    private String att2 = null;


    /**
     * The third attribute of this tag.
     */
    private String att3 = null;


    // ------------------------------------------------------------- Properties


    /**
     * Return the first attribute of this tag.
     */
    public String getAtt1() {

	return (this.att1);

    }


    /**
     * Set the first attribute of this tag.
     *
     * @param value The new attribute value
     */
    public void setAtt1(String value) {

	this.att1 = value;

    }


    /**
     * Return the second attribute of this tag.
     */
    public String getAtt2() {

	return (this.att2);

    }


    /**
     * Set the second attribute of this tag.
     *
     * @param value The new attribute value
     */
    public void setAtt2(String value) {

	this.att2 = value;

    }


    /**
     * Return the third attribute of this tag.
     */
    public String getAtt3() {

	return (this.att3);

    }


    /**
     * Set the third attribute of this tag.
     *
     * @param value The new attribute value
     */
    public void setAtt3(String value) {

	this.att3 = value;

    }


    // --------------------------------------------------------- Public Methods


    /**
     * Process the start tag, and return SKIP_BODY to tell the JSP page
     * to skip body evaluation.
     *
     * @exception JspException if a JSP exception has occurred
     */
    public int doStartTag() throws JspException {

	// At this point, the properties for each of our attributes
	// have been set, and the tag can do whatever it likes with them.

	return EVAL_BODY_INCLUDE;

    }


}
