#!/bin/sh
#
# $Id: catalina.sh,v 1.1 2000/02/13 07:09:30 craigmcc Exp $

# Shell script to start and stop the server

# There are other, simpler commands to startup the runner. The two
# commented commands good replacements. The first works well with
# Java Platform 1.1 based runtimes. The second works well with
# Java2 Platform based runtimes.

#jre -cp runner.jar:servlet.jar:classes org.apache.tomcat.shell.Startup $*
#java -cp runner.jar:servlet.jar:classes org.apache.tomcat.shell.Startup $*

if [ -f $HOME/.catalinarc ] ; then
  . $HOME/.catalinarc
fi

if [ "$CATALINA_HOME" = "" ] ; then
  # try to find catalina
  if [ -d ${HOME}/opt/catalina/conf ] ; then
    CATALINA_HOME=${HOME}/opt/catalina
  fi

  if [ -d /opt/catalina/conf ] ; then
    CATALINA_HOME=/opt/catalina
  fi

  ## resolve links - $0 may be a link to ant's home
  PRG=$0
  progname=`basename $0`

  while [ -h "$PRG" ] ; do
    ls=`ls -ld "$PRG"`
    link=`expr "$ls" : '.*-> \(.*\)$'`
    if expr "$link" : '.*/.*' > /dev/null; then
	PRG="$link"
    else
	PRG="`dirname $PRG`/$link"
    fi
  done

  CATALINA_HOME=`dirname "$PRG"`/..
  echo CATALINA_HOME is $CATALINA_HOME

fi

if [ -z "$JAVA_HOME" ] ;  then
  JAVACMD=`which java`
  if [ -z "$JAVACMD" ] ; then
    echo "Cannot find JAVA. Please set your PATH."
    exit 1
  fi
  JAVA_BINDIR=`dirname $JAVACMD`
  JAVA_HOME=$JAVA_BINDIR/..
fi

if [ "$JAVACMD" = "" ] ; then
   # it may be defined in env - including flags!!
   JAVACMD=$JAVA_HOME/bin/java
fi


oldCP=$CLASSPATH

CLASSPATH=.
for i in ${CATALINA_HOME}/lib/* ; do
  CLASSPATH=${CLASSPATH}:$i
done

CLASSPATH=${CLASSPATH}:${JAVA_HOME}/lib/tools.jar
echo XXX $CLASSPATH


# Backdoor classpath setting for development purposes when all classes
# are compiled into a /classes dir and are not yet jarred.
if [ -d ${CATALINA_HOME}/classes ]; then
    CLASSPATH=${CATALINA_HOME}/classes:${CLASSPATH}
fi

if [ "$oldCP" != "" ]; then
    CLASSPATH=${CLASSPATH}:${oldCP}
fi

# Add Tomcat build classes
CLASSPATH=${CLASSPATH}:../tomcat/classes

export CLASSPATH

if [ ! -f server.xml ] ; then
   if [ "$2" = "" ] ; then
     # Probably we are in a wrong directory, use catalina_home
     # If arguments are passed besides start/stop, probably a -f was used,
     # or the user knows what he's doing
     echo cd ${CATALINA_HOME}
     cd ${CATALINA_HOME}
   fi
fi

# We start the server up in the background for a couple of reasons:
#   1) It frees up your command window
#   2) You should use `stop` option instead of ^C to bring down the server
if [ "$1" = "start" ] ; then
  shift
  echo Using classpath: ${CLASSPATH}
  $JAVACMD org.apache.tomcat.startup.Catalina "$@" &
#   $JAVACMD org.apache.tomcat.shell.Startup "$@" &

elif [ "$1" = "stop" ] ; then
  shift
  echo Using classpath: ${CLASSPATH}
  $JAVACMD org.apache.tomcat.startup.Catalina -stop "$@"
#   $JAVACMD org.apache.tomcat.shell.Shutdown "$@"

elif [ "$1" = "run" ] ; then
  shift
  echo Using classpath: ${CLASSPATH}
  $JAVACMD org.apache.tomcat.startup.Catalina "$@"
#  $JAVACMD org.apache.tomcat.shell.Startup "$@"
  # no &

## Call it with source catalina.sh to set the env for catalina
elif [ "$1" = "env" ] ; then
  shift
  echo Setting classpath to: ${CLASSPATH}
  oldCP=$CLASSPATH

else
  echo "Usage:"
  echo "catalina (start|env|run|stop)"
  echo "	start - start catalina in the background"
  echo "	run   - start catalina in the foreground"
  echo "	stop  - stop catalina"
  echo "	env  -	set CLASSPATH and CATALINA_HOME env. variables"

  exit 0
fi


if [ "$oldCP" != "" ]; then
    CLASSPATH=${oldCP}
    export CLASSPATH
else
    unset CLASSPATH
fi
