/*
 * $Header: /home/cvs/jakarta-tomcat/proposals/catalina/src/share/org/apache/tomcat/startup/Catalina.java,v 1.1 2000/02/13 07:09:31 craigmcc Exp $
 * $Revision: 1.1 $
 * $Date: 2000/02/13 07:09:31 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */ 


package org.apache.tomcat.startup;


import java.io.File;
import java.io.IOException;
import org.apache.tomcat.util.xml.XmlAction;
import org.apache.tomcat.util.xml.XmlMapper;


/**
 * Startup/Shutdown shell program for Catalina.  The following command line
 * options are recognized:
 * <ul>
 * <li><b>-config {pathname}</b> - Set the pathname of the configuration file
 *     to be processed [conf/server.xml].
 * <li><b>-help</b> - Display usage information.
 * <li><b>-stop</b> - Stop the currently running instance of Catalina.
 * </u>
 *
 * @author Craig R. McClanahan
 * @version $Revision: 1.1 $ $Date: 2000/02/13 07:09:31 $
 */

public final class Catalina {


    // ----------------------------------------------------- Instance Variables


    /**
     * Pathname to the server configuration file.
     */
    private String configFile = "conf/server.xml";


    // ----------------------------------------------------------- Main Program


    /**
     * The application main program.
     *
     * @param args Command line arguments
     */
    public static void main(String args[]) {

	try {
	    Catalina catalina = new Catalina();
	    if (catalina.arguments(args))
		catalina.execute();
	} catch (Exception e) {
	    e.printStackTrace();
	}

    }


    // -------------------------------------------------------- Private Methods


    /**
     * Process the specified command line arguments, and return
     * <code>true</code> if we should continue processing; otherwise
     * return <code>false</code>.
     *
     * @param args Command line arguments to process
     */
    private boolean arguments(String args[]) {

	boolean isConfig = false;

	for (int i = 0; i < args.length; i++) {
	    if (isConfig) {
		configFile = args[i];
		isConfig = false;
	    } else if (args[i].equals("-help")) {
		usage();
		return (false);
	    } else {
		usage();
	    }
	}

	return (true);

    }


    /**
     * Create and configure the XmlMapper we will be using.
     */
    private XmlMapper createMapper() {

	// Initialize the mapper
	XmlMapper mapper = new XmlMapper();
	mapper.setDebug(999);

	// Configure the actions we will be using

	;	// FIXME -- Adapter or Connector or something!

	mapper.addRule("Engine", mapper.objectCreate("org.apache.tomcat.core.StandardEngine", "className"));
	mapper.addRule("Engine", mapper.setProperties());

	mapper.addRule("Engine/Host", mapper.objectCreate("org.apache.tomcat.core.StandardHost", "className"));
	mapper.addRule("Engine/Host", mapper.setProperties());
	mapper.addRule("Engine/Host", mapper.addChild("addChild", "org.apache.tomcat.Container"));

	mapper.addRule("Engine/Host/Context", mapper.objectCreate("org.apache.tomcat.core.StandardContext", "className"));
	mapper.addRule("Engine/Host/Context", mapper.setProperties());
	mapper.addRule("Engine/Host/Context", mapper.addChild("addChild", "org.apache.tomcat.Container"));
	;	// FIXME -- Process web.xml as well!!!

	mapper.addRule("Engine/Host/Context/Loader", mapper.objectCreate("org.apache.tomcat.core.StandardLoader", "className"));
	mapper.addRule("Engine/Host/Context/Loader", mapper.setProperties());
	mapper.addRule("Engine/Host/Context/Loader", mapper.addChild("setLoader", "org.apache.tomcat.Loader"));

	mapper.addRule("Engine/Host/Context/Logger", mapper.objectCreate(null, "className"));
	mapper.addRule("Engine/Host/Context/Logger", mapper.setProperties());
	mapper.addRule("Engine/Host/Context/Logger", mapper.addChild("setLogger", "org.apache.tomcat.Logger"));

	mapper.addRule("Engine/Host/Context/Manager", mapper.objectCreate("org.apache.tomcat.session.StandardManager", "className"));
	mapper.addRule("Engine/Host/Context/Manager", mapper.setProperties());
	mapper.addRule("Engine/Host/Context/Manager", mapper.addChild("setManager", "org.apache.tomcat.Manager"));

	mapper.addRule("Engine/Host/Context/Realm", mapper.objectCreate(null, "className"));
	mapper.addRule("Engine/Host/Context/Realm", mapper.setProperties());
	mapper.addRule("Engine/Host/Context/Realm", mapper.addChild("setRealm", "org.apache.tomcat.Realm"));

	mapper.addRule("Engine/Host/Context/Resources", mapper.objectCreate("org.apache.tomcat.core.StandardResources", "className"));
	mapper.addRule("Engine/Host/Context/Resources", mapper.setProperties());
	mapper.addRule("Engine/Host/Context/Resources", mapper.addChild("setResources", "org.apache.tomcat.Resources"));

	mapper.addRule("Engine/Host/Context/Valve", mapper.objectCreate(null, "className"));
	mapper.addRule("Engine/Host/Context/Valve", mapper.setProperties());
	mapper.addRule("Engine/Host/Context/Valve", mapper.addChild("addValve", "org.apache.tomcat.Valve"));

	mapper.addRule("Engine/Host/Loader", mapper.objectCreate("org.apache.tomcat.core.StandardLoader", "className"));
	mapper.addRule("Engine/Host/Loader", mapper.setProperties());
	mapper.addRule("Engine/Host/Loader", mapper.addChild("setLoader", "org.apache.tomcat.Loader"));

	mapper.addRule("Engine/Host/Logger", mapper.objectCreate(null, "className"));
	mapper.addRule("Engine/Host/Logger", mapper.setProperties());
	mapper.addRule("Engine/Host/Logger", mapper.addChild("setLogger", "org.apache.tomcat.Logger"));

	mapper.addRule("Engine/Host/Manager", mapper.objectCreate("org.apache.tomcat.session.StandardManager", "className"));
	mapper.addRule("Engine/Host/Manager", mapper.setProperties());
	mapper.addRule("Engine/Host/Manager", mapper.addChild("setManager", "org.apache.tomcat.Manager"));

	mapper.addRule("Engine/Host/Realm", mapper.objectCreate(null, "className"));
	mapper.addRule("Engine/Host/Realm", mapper.setProperties());
	mapper.addRule("Engine/Host/Realm", mapper.addChild("setRealm", "org.apache.tomcat.Realm"));

	mapper.addRule("Engine/Host/Resources", mapper.objectCreate("org.apache.tomcat.core.StandardResources", "className"));
	mapper.addRule("Engine/Host/Resources", mapper.setProperties());
	mapper.addRule("Engine/Host/Resources", mapper.addChild("setResources", "org.apache.tomcat.Resources"));

	mapper.addRule("Engine/Host/Valve", mapper.objectCreate(null, "className"));
	mapper.addRule("Engine/Host/Valve", mapper.setProperties());
	mapper.addRule("Engine/Host/Valve", mapper.addChild("addValve", "org.apache.tomcat.Valve"));

	mapper.addRule("Engine/Loader", mapper.objectCreate("org.apache.tomcat.core.StandardLoader", "className"));
	mapper.addRule("Engine/Loader", mapper.setProperties());
	mapper.addRule("Engine/Loader", mapper.addChild("setLoader", "org.apache.tomcat.Loader"));

	mapper.addRule("Engine/Logger", mapper.objectCreate(null, "className"));
	mapper.addRule("Engine/Logger", mapper.setProperties());
	mapper.addRule("Engine/Logger", mapper.addChild("setLogger", "org.apache.tomcat.Logger"));

	mapper.addRule("Engine/Manager", mapper.objectCreate("org.apache.tomcat.session.StandardManager", "className"));
	mapper.addRule("Engine/Manager", mapper.setProperties());
	mapper.addRule("Engine/Manager", mapper.addChild("setManager", "org.apache.tomcat.Manager"));

	mapper.addRule("Engine/Realm", mapper.objectCreate(null, "className"));
	mapper.addRule("Engine/Realm", mapper.setProperties());
	mapper.addRule("Engine/Realm", mapper.addChild("setRealm", "org.apache.tomcat.Realm"));

	mapper.addRule("Engine/Resources", mapper.objectCreate("org.apache.tomcat.core.StandardResources", "className"));
	mapper.addRule("Engine/Resources", mapper.setProperties());
	mapper.addRule("Engine/Resources", mapper.addChild("setResources", "org.apache.tomcat.Resources"));

	mapper.addRule("Engine/Valve", mapper.objectCreate(null, "className"));
	mapper.addRule("Engine/Valve", mapper.setProperties());
	mapper.addRule("Engine/Valve", mapper.addChild("addValve", "org.apache.tomcat.Valve"));

	return (mapper);

	// FIXME - When do we call start() on all of these objects?

    }


    /**
     * Execute the processing that has been configured from the command line.
     */
    private void execute() throws Exception {

	// Configure the XmlMapper we will be using
	XmlMapper mapper = createMapper();

	// Process the configuration file
	File file = new File(configFile);
	mapper.readXml(file, null);

	// Start or stop
	;	// FIXME

    }


    /**
     * Print usage information for this application.
     */
    private void usage() {

	System.err.println("usage: java org.apache.tomcat.startup.Catalina" +
			   " [ -config {pathname} | -help | -stop ]");

    }


    // --------------------------------------------------------- Static Methods



}


// ------------------------------------------------------------ Private Classes


