/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocImpl;
import com.sun.tools.javadoc.Env;
import com.sun.tools.javadoc.Res;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.tools.java.ClassFile;

class PackageDocImpl
extends DocImpl
implements PackageDoc {
    private static Map packageMap = new HashMap();
    private final String name;
    private String docPath;
    private final List classes;
    boolean isIncluded = false;

    private PackageDocImpl(Env env, String string) {
        super(env, null);
        this.name = string;
        this.classes = new ArrayList();
        this.fetchDocumentation(env);
        packageMap.put(string, this);
    }

    void addAllClassesTo(List list) {
        Iterator iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            ClassDocImpl classDocImpl = (ClassDocImpl)iterator.next();
            if (!classDocImpl.isIncluded) continue;
            list.add(classDocImpl);
        }
    }

    void addClass(ClassDocImpl classDocImpl) {
        this.classes.add(classDocImpl);
    }

    public ClassDoc[] allClasses() {
        ArrayList<ClassDocImpl> arrayList = new ArrayList<ClassDocImpl>();
        Iterator iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            ClassDocImpl classDocImpl = (ClassDocImpl)iterator.next();
            if (!classDocImpl.isIncluded) continue;
            arrayList.add(classDocImpl);
        }
        return arrayList.toArray(new ClassDoc[arrayList.size()]);
    }

    String documentation() {
        block4: {
            if (this.documentation != null) break block4;
            if (this.docPath == null) {
                this.documentation = "";
            } else {
                try {
                    this.documentation = this.readHTMLDocumentation(new FileInputStream(this.docPath), this.docPath);
                }
                catch (IOException iOException) {
                    this.documentation = "";
                    Res.error("javadoc.File_Read_Error", this.docPath);
                }
            }
        }
        return this.documentation;
    }

    public ClassDoc[] errors() {
        ArrayList<ClassDocImpl> arrayList = new ArrayList<ClassDocImpl>();
        Iterator iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            ClassDocImpl classDocImpl = (ClassDocImpl)iterator.next();
            if (!classDocImpl.isIncluded || !classDocImpl.isError()) continue;
            arrayList.add(classDocImpl);
        }
        return arrayList.toArray(new ClassDoc[arrayList.size()]);
    }

    public ClassDoc[] exceptions() {
        ArrayList<ClassDocImpl> arrayList = new ArrayList<ClassDocImpl>();
        Iterator iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            ClassDocImpl classDocImpl = (ClassDocImpl)iterator.next();
            if (!classDocImpl.isIncluded || !classDocImpl.isException()) continue;
            arrayList.add(classDocImpl);
        }
        return arrayList.toArray(new ClassDoc[arrayList.size()]);
    }

    private void fetchDocumentation(Env env) {
        String string = this.name.replace('.', File.separatorChar);
        String string2 = String.valueOf(string) + File.separatorChar + "package.html";
        try {
            ClassFile classFile = env.getSourceClassFile(string2);
            if (classFile == null) {
                this.documentation = "";
            } else if (classFile.isZipped()) {
                this.documentation = this.readHTMLDocumentation(classFile.getInputStream(), string2);
            } else {
                this.docPath = classFile.getPath();
            }
        }
        catch (IOException iOException) {
            this.documentation = "";
            Res.error("javadoc.File_Read_Error", string2);
        }
    }

    public ClassDoc findClass(String string) {
        Iterator iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            ClassDoc classDoc = (ClassDoc)iterator.next();
            if (!classDoc.name().equals(string)) continue;
            return classDoc;
        }
        return null;
    }

    static PackageDocImpl getPackageDocImpl(Env env, String string) {
        PackageDocImpl packageDocImpl = (PackageDocImpl)packageMap.get(string);
        if (packageDocImpl == null) {
            packageDocImpl = new PackageDocImpl(env, string);
        }
        return packageDocImpl;
    }

    public ClassDoc[] interfaces() {
        ArrayList<ClassDocImpl> arrayList = new ArrayList<ClassDocImpl>();
        Iterator iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            ClassDocImpl classDocImpl = (ClassDocImpl)iterator.next();
            if (!classDocImpl.isIncluded || !classDocImpl.isInterface()) continue;
            arrayList.add(classDocImpl);
        }
        return arrayList.toArray(new ClassDoc[arrayList.size()]);
    }

    public boolean isIncluded() {
        return this.isIncluded;
    }

    static PackageDocImpl lookup(String string) {
        return (PackageDocImpl)packageMap.get(string);
    }

    public String name() {
        return this.name;
    }

    public ClassDoc[] ordinaryClasses() {
        ArrayList<ClassDocImpl> arrayList = new ArrayList<ClassDocImpl>();
        Iterator iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            ClassDocImpl classDocImpl = (ClassDocImpl)iterator.next();
            if (!classDocImpl.isIncluded || !classDocImpl.isOrdinaryClass()) continue;
            arrayList.add(classDocImpl);
        }
        return arrayList.toArray(new ClassDoc[arrayList.size()]);
    }

    public String toString() {
        return this.name;
    }
}

