/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import com.sun.tools.javah.JavahEnvironment;
import com.sun.tools.javah.Mangle;
import com.sun.tools.javah.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;
import sun.tools.tree.Expression;

public abstract class Gen
implements Constants {
    protected JavahEnvironment env;
    protected String outDir;
    protected String outFile;
    protected String[] classes;
    protected String classpath;
    protected boolean force = false;

    protected String baseFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer(Mangle.mangle(string, 1));
        if (this.outDir != null) {
            stringBuffer.insert(0, this.outDir);
        }
        return stringBuffer.toString();
    }

    protected String cppGuardBegin() {
        return "#ifdef __cplusplus\nextern \"C\" {\n#endif";
    }

    protected String cppGuardEnd() {
        return "#ifdef __cplusplus\n}\n#endif";
    }

    protected String defineForStatic(String string, MemberDefinition memberDefinition) {
        String string2 = Mangle.mangle(string, 1);
        String string3 = Mangle.mangle(memberDefinition.getName().toString(), 2);
        if (!memberDefinition.isStatic()) {
            Util.bug("tried.to.define.non.static");
        }
        if (memberDefinition.isFinal()) {
            Object object;
            Object object2 = null;
            try {
                object = (Expression)memberDefinition.getValue(this.getEnvironment());
                if (object != null) {
                    object2 = ((Expression)object).getValue();
                }
            }
            catch (ClassNotFound classNotFound) {}
            if (object2 != null) {
                object = null;
                if (object2 instanceof Integer) {
                    object = String.valueOf(object2.toString()) + "L";
                } else if (object2 instanceof Long) {
                    object = String.valueOf(object2.toString()) + "LL";
                } else if (object2 instanceof Float) {
                    float f = ((Float)object2).floatValue();
                    object = Float.isInfinite(f) ? String.valueOf(f < 0.0f ? "-" : "") + "Inff" : String.valueOf(object2.toString()) + "f";
                } else if (object2 instanceof Double) {
                    double d = (Double)object2;
                    object = Double.isInfinite(d) ? String.valueOf(d < 0.0 ? "-" : "") + "InfD" : String.valueOf(object2.toString()) + "D";
                }
                if (object != null) {
                    StringBuffer stringBuffer = new StringBuffer("#undef ");
                    stringBuffer.append(string2);
                    stringBuffer.append("_");
                    stringBuffer.append(string3);
                    stringBuffer.append("\n#define ");
                    stringBuffer.append(string2);
                    stringBuffer.append("_");
                    stringBuffer.append(string3);
                    stringBuffer.append(" ");
                    stringBuffer.append((String)object);
                    return stringBuffer.toString();
                }
            }
        }
        if (memberDefinition.getType() != Type.tString || memberDefinition.getType() == Type.tString && !memberDefinition.isFinal()) {
            return "/* Inaccessible static: " + string3 + " */";
        }
        return null;
    }

    public JavahEnvironment getEnvironment() {
        return this.env;
    }

    protected String getFileName(String string) {
        return String.valueOf(this.baseFileName(string)) + this.getFileSuffix();
    }

    protected String getFileSuffix() {
        return ".h";
    }

    protected abstract String getIncludes();

    protected String guardBegin(String string) {
        return "/* Header for class " + string + " */\n\n" + "#ifndef _Included_" + string + "\n" + "#define _Included_" + string;
    }

    protected String guardEnd(String string) {
        return "#endif";
    }

    public void run() throws IOException, ClassNotFoundException {
        int n = 0;
        if (this.outFile != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
            this.writeFileTop(byteArrayOutputStream);
            n = 0;
            while (n < this.classes.length) {
                this.write(byteArrayOutputStream, this.classes[n]);
                ++n;
            }
            this.writeIfChanged(byteArrayOutputStream.toByteArray(), this.outFile);
        } else {
            n = 0;
            while (n < this.classes.length) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
                this.writeFileTop(byteArrayOutputStream);
                String string = this.classes[n];
                this.write(byteArrayOutputStream, string);
                this.writeIfChanged(byteArrayOutputStream.toByteArray(), this.getFileName(string));
                ++n;
            }
        }
    }

    public void setClasses(String[] stringArray) {
        this.classes = stringArray;
    }

    public void setClasspath(String string) {
        this.env = new JavahEnvironment(string);
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void setOutDir(String string) {
        if (string != null) {
            this.outDir = String.valueOf(string) + System.getProperty("file.separator");
            File file = new File(string);
            if (!file.exists() && !file.mkdirs()) {
                Util.error("cant.create.dir", file.toString());
            }
        }
    }

    public void setOutFile(String string) {
        this.outFile = string;
    }

    protected PrintWriter wrapWriter(OutputStream outputStream) {
        try {
            return new PrintWriter((Writer)new OutputStreamWriter(outputStream, "ISO8859_1"), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Util.bug("encoding.iso8859_1.not.found");
            return null;
        }
    }

    protected abstract void write(OutputStream var1, String var2) throws ClassNotFoundException;

    protected void writeFileTop(OutputStream outputStream) {
        PrintWriter printWriter = this.wrapWriter(outputStream);
        printWriter.println("/* DO NOT EDIT THIS FILE - it is machine generated */\n" + this.getIncludes());
    }

    private void writeIfChanged(byte[] byArray, String string) throws IOException {
        File file = new File(string);
        boolean bl = false;
        String string2 = "[No need to update file ";
        if (this.force) {
            bl = true;
            string2 = "[Forcefully writing file ";
        } else if (!file.exists()) {
            bl = true;
            string2 = "[Creating file ";
        } else {
            int n = (int)file.length();
            if (byArray.length != n) {
                bl = true;
                string2 = "[Overwriting file ";
            } else {
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray2 = new byte[n];
                if (fileInputStream.read(byArray2) != n) {
                    fileInputStream.close();
                    Util.error("not.enough.bytes", Integer.toString(n), file.toString());
                }
                fileInputStream.close();
                while (--n >= 0) {
                    if (byArray2[n] == byArray[n]) continue;
                    bl = true;
                    string2 = "[Overwriting file ";
                }
            }
        }
        if (Util.verbose) {
            Util.log(String.valueOf(string2) + string + "]");
        }
        if (bl) {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ((OutputStream)fileOutputStream).write(byArray);
            ((OutputStream)fileOutputStream).close();
        }
    }
}

