/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.io.FileNotFoundException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;
import sun.security.provider.PolicyParser;
import sun.security.tools.CancelButtonListener;
import sun.security.tools.ErrorOKButtonListener;
import sun.security.tools.FileMenuListener;
import sun.security.tools.MainWindowListener;
import sun.security.tools.PolicyEntry;
import sun.security.tools.PolicyListListener;
import sun.security.tools.PolicyTool;
import sun.security.tools.StatusOKButtonListener;
import sun.security.tools.ToolDialog;
import sun.security.tools.ToolWindowListener;

class ToolWindow
extends Frame {
    public static final Insets TOP_PADDING = new Insets(25, 0, 0, 0);
    public static final Insets BOTTOM_PADDING = new Insets(0, 0, 25, 0);
    public static final Insets LR_PADDING = new Insets(0, 10, 0, 10);
    public final String NEW_POLICY_FILE = "New";
    public final String OPEN_POLICY_FILE = "Open";
    public final String SAVE_POLICY_FILE = "Save";
    public final String SAVE_AS_POLICY_FILE = "Save As";
    public final String VIEW_WARNINGS = "View Warning Log";
    public final String QUIT = "Exit";
    public final String ADD_POLICY_ENTRY = "Add Policy Entry";
    public final String EDIT_POLICY_ENTRY = "Edit Policy Entry";
    public final String REMOVE_POLICY_ENTRY = "Remove Policy Entry";
    public final String CHANGE_KEYSTORE = "Change KeyStore";
    public final String ADD_PUBKEY_ALIAS = "Add Public Key Alias";
    public final String REMOVE_PUBKEY_ALIAS = "Remove Public Key Alias";
    public final int MW_FILENAME_LABEL = 0;
    public final int MW_FILENAME_TEXTFIELD = 1;
    public final int MW_KEYSTORE_LABEL = 2;
    public final int MW_KEYSTORE_TEXTFIELD = 3;
    public final int MW_PANEL = 4;
    public final int MW_ADD_BUTTON = 0;
    public final int MW_EDIT_BUTTON = 1;
    public final int MW_REMOVE_BUTTON = 2;
    public final int MW_POLICY_LIST = 5;
    private PolicyTool tool;

    ToolWindow(PolicyTool policyTool) {
        this.tool = policyTool;
    }

    void addNewComponent(Container container, Component component, int n, int n2, int n3, int n4, int n5, double d, double d2, int n6) {
        this.addNewComponent(container, component, n, n2, n3, n4, n5, d, d2, n6, null);
    }

    void addNewComponent(Container container, Component component, int n, int n2, int n3, int n4, int n5, double d, double d2, int n6, Insets insets) {
        container.add(component, n);
        GridBagLayout gridBagLayout = (GridBagLayout)container.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.gridwidth = n4;
        gridBagConstraints.gridheight = n5;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.fill = n6;
        if (insets != null) {
            gridBagConstraints.insets = insets;
        }
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    void displayErrorDialog(Window window, Exception exception) {
        this.displayErrorDialog(window, exception.toString());
    }

    void displayErrorDialog(Window window, String string) {
        ToolDialog toolDialog = new ToolDialog("Error", this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        ((Component)toolDialog).setBounds(point.x + 50, point.y + 50, 600, 100);
        toolDialog.setLayout(new GridBagLayout());
        Label label = new Label(string);
        this.addNewComponent(toolDialog, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        Button button = new Button("OK");
        button.addActionListener(new ErrorOKButtonListener(toolDialog));
        this.addNewComponent(toolDialog, button, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        toolDialog.pack();
        ((Component)toolDialog).setVisible(true);
    }

    void displayStatusDialog(Window window, String string) {
        ToolDialog toolDialog = new ToolDialog("Status", this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        ((Component)toolDialog).setBounds(point.x + 50, point.y + 50, 500, 100);
        toolDialog.setLayout(new GridBagLayout());
        Label label = new Label(string);
        this.addNewComponent(toolDialog, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        Button button = new Button("OK");
        button.addActionListener(new StatusOKButtonListener(toolDialog));
        this.addNewComponent(toolDialog, button, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        toolDialog.pack();
        ((Component)toolDialog).setVisible(true);
    }

    void displayToolWindow(String[] stringArray) {
        this.setTitle("Policy Tool");
        this.setResizable(true);
        this.addWindowListener(new ToolWindowListener(this));
        ((Component)this).setBounds(135, 80, 500, 500);
        this.setLayout(new GridBagLayout());
        this.initWindow();
        ((Component)this).setVisible(true);
        if (this.tool.newWarning) {
            this.displayStatusDialog(this, "Errors have occurred while opening the policy configuration.  View the Warning Log for more information.");
        }
    }

    void displayWarningLog(Window window) {
        ToolDialog toolDialog = new ToolDialog("Warning", this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        ((Component)toolDialog).setBounds(point.x + 50, point.y + 50, 500, 100);
        toolDialog.setLayout(new GridBagLayout());
        TextArea textArea = new TextArea();
        textArea.setEditable(false);
        int n = 0;
        while (n < this.tool.warnings.size()) {
            textArea.append((String)this.tool.warnings.elementAt(n));
            textArea.append("\n");
            ++n;
        }
        this.addNewComponent(toolDialog, textArea, 0, 0, 0, 1, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        Button button = new Button("OK");
        button.addActionListener(new CancelButtonListener(toolDialog));
        this.addNewComponent(toolDialog, button, 1, 0, 1, 1, 1, 0.0, 0.0, 3, LR_PADDING);
        toolDialog.pack();
        ((Component)toolDialog).setVisible(true);
    }

    void initPolicyList(List list) {
        this.addNewComponent(this, list, 5, 0, 3, 2, 1, 1.0, 1.0, 1);
    }

    private void initWindow() {
        Object object;
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        menu.add("New");
        menu.add("Open");
        menu.add("Save");
        menu.add("Save As");
        menu.add("View Warning Log");
        menu.add("Exit");
        menu.addActionListener(new FileMenuListener(this.tool, this));
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        menu = new Menu("Edit");
        menu.add("Add Policy Entry");
        menu.add("Edit Policy Entry");
        menu.add("Remove Policy Entry");
        menu.add("Change KeyStore");
        menu.addActionListener(new MainWindowListener(this.tool, this));
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        Label label = new Label("Policy File:");
        this.addNewComponent(this, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1, TOP_PADDING);
        TextField textField = new TextField(50);
        textField.setEditable(false);
        this.addNewComponent(this, textField, 1, 1, 0, 1, 1, 0.0, 0.0, 1, TOP_PADDING);
        label = new Label("Keystore:");
        this.addNewComponent(this, label, 2, 0, 1, 1, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        textField = new TextField(50);
        textField.setEditable(false);
        this.addNewComponent(this, textField, 3, 1, 1, 1, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        Button button = new Button("Add Policy Entry");
        button.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(panel, button, 0, 0, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        button = new Button("Edit Policy Entry");
        button.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(panel, button, 1, 1, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        button = new Button("Remove Policy Entry");
        button.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(panel, button, 2, 2, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        this.addNewComponent(this, panel, 4, 0, 2, 2, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        String string = this.tool.getPolicyFileName();
        if (string == null) {
            object = AccessController.doPrivileged(new GetPropertyAction("user.home"));
            string = String.valueOf(object) + "/.java.policy";
        }
        try {
            this.tool.openPolicy(string);
            object = new List(40, false);
            ((List)object).addActionListener(new PolicyListListener(this.tool, this));
            PolicyEntry[] policyEntryArray = this.tool.getEntry();
            if (policyEntryArray != null) {
                int n = 0;
                while (n < policyEntryArray.length) {
                    ((List)object).add(policyEntryArray[n].codebaseToString());
                    ++n;
                }
            }
            TextField textField2 = (TextField)this.getComponent(1);
            textField2.setText(string);
            TextField textField3 = (TextField)this.getComponent(3);
            if (this.tool.getKeyStoreType() != null && this.tool.getKeyStoreType().length() > 0) {
                textField3.setText(String.valueOf(this.tool.getKeyStoreName()) + ", " + this.tool.getKeyStoreType());
            } else {
                textField3.setText(this.tool.getKeyStoreName());
            }
            this.initPolicyList((List)object);
        }
        catch (PolicyParser.ParsingException parsingException) {
            List list = new List(40, false);
            this.initPolicyList(list);
            ((Component)this).setVisible(true);
            this.displayErrorDialog(null, "Error parsing policy file " + string + parsingException.getMessage());
            System.exit(1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = new List(40, false);
            ((List)object).addActionListener(new PolicyListListener(this.tool, this));
            this.initPolicyList((List)object);
            this.tool.modified = false;
            ((Component)this).setVisible(true);
            this.displayErrorDialog(null, "Could not find Policy File: " + string);
        }
        catch (Exception exception) {
            object = new List(40, false);
            ((List)object).addActionListener(new PolicyListListener(this.tool, this));
            this.initPolicyList((List)object);
            this.tool.modified = false;
        }
    }

    void replacePolicyList(List list) {
        List list2 = (List)this.getComponent(5);
        list2.removeAll();
        String[] stringArray = list.getItems();
        int n = 0;
        while (n < stringArray.length) {
            list2.add(stringArray[n]);
            ++n;
        }
    }
}

