/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.moo.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.moo.Logger;
import org.apache.tools.moo.TestResult;
import org.apache.tools.moo.Testable;
import org.apache.tools.moo.URLHelper;
import org.apache.tools.moo.servlet.MapManager;

public abstract class GenericClientTest
implements Testable {
    protected Logger out = Logger.getLogger();

    private void doHeaders(Hashtable hashtable, HttpURLConnection httpURLConnection) {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2 = (String)enumeration.nextElement();
                if (!(string2 != null & (string = (String)hashtable.get(string2)) != null)) continue;
                httpURLConnection.setRequestProperty(string2, string);
            }
        }
    }

    public String doQueryString(Hashtable hashtable) {
        if (hashtable == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            Object v = hashtable.get(string2);
            boolean bl = v instanceof String;
            boolean bl2 = v instanceof Vector;
            if (bl) {
                string = (String)v;
                stringBuffer.append(URLEncoder.encode(string2));
                stringBuffer.append("=");
                stringBuffer.append(URLEncoder.encode(string));
                continue;
            }
            if (!bl2) continue;
            Enumeration enumeration2 = ((Vector)v).elements();
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                stringBuffer.append(URLEncoder.encode(string2));
                stringBuffer.append("=");
                stringBuffer.append(URLEncoder.encode(string));
            }
        }
        return stringBuffer.toString();
    }

    public HttpURLConnection getConnection() throws Exception {
        return this.getConnection(null, null, null, null);
    }

    public HttpURLConnection getConnection(String string) throws Exception {
        return this.getConnection(null, null, null, string);
    }

    public HttpURLConnection getConnection(Hashtable hashtable) throws Exception {
        return this.getConnection(hashtable, null, null, null);
    }

    public HttpURLConnection getConnection(Hashtable hashtable, String string, String string2, String string3) throws Exception {
        HttpURLConnection httpURLConnection = null;
        MapManager mapManager = new MapManager();
        String string4 = this.getClass().getName();
        String string5 = mapManager.get(string4);
        if (string5 == null) {
            throw new NullPointerException("bad resource: " + string4 + ".  Can't map client test to server test");
        }
        String string6 = String.valueOf(string2 != null ? "/" + string2 : "") + (string != null ? "?" + string : "");
        String string7 = String.valueOf(string5) + string6;
        URL uRL = URLHelper.getURL(string7);
        String string8 = uRL.getHost();
        String string9 = String.valueOf(uRL.getPort());
        String string10 = uRL.getProtocol();
        String string11 = uRL.getFile();
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        }
        catch (IOException iOException) {
            this.out.println("Could not retrieve file " + string11 + " on " + string8 + " on port number " + string9 + " via " + string10 + " protocol");
            throw iOException;
        }
        if (string3 != null) {
            try {
                httpURLConnection.setRequestMethod(string3);
            }
            catch (ProtocolException protocolException) {
                this.out.println("Method: " + string3 + " not valid for " + string10);
                throw protocolException;
            }
        }
        this.doHeaders(hashtable, httpURLConnection);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setUseCaches(false);
        HttpURLConnection.setFollowRedirects(false);
        try {
            httpURLConnection.connect();
        }
        catch (IOException iOException) {
            this.out.println("Could not establish a connection to file " + string11 + " on " + string8 + " on port number " + string9 + " via " + string10 + " protocol");
            throw iOException;
        }
        return httpURLConnection;
    }

    public abstract String getDescription();

    public TestResult getTestResult(HttpURLConnection httpURLConnection) throws Exception {
        TestResult testResult = new TestResult();
        Properties properties = new Properties();
        properties.load(httpURLConnection.getInputStream());
        httpURLConnection.disconnect();
        String string = properties.getProperty("Status", "false");
        testResult.setStatus(Boolean.valueOf(string));
        testResult.setMessage(properties.getProperty("Message", ""));
        return testResult;
    }

    public TestResult getTestResult(TestResult testResult, Exception exception) {
        if (testResult == null) {
            testResult = new TestResult();
        }
        testResult.setStatus(false);
        testResult.setMessage(String.valueOf(this.getClass().getName()) + " exception: " + exception);
        return testResult;
    }

    protected TestResult runAnotherTest(String string) throws ClassNotFoundException, ClassCastException {
        Class<?> clazz = Class.forName(string);
        try {
            Testable testable = (Testable)clazz.newInstance();
            return testable.runTest();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace(new PrintStream(Logger.getLogger().getOutputStream()));
            return new TestResult(false, illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace(new PrintStream(Logger.getLogger().getOutputStream()));
            return new TestResult(false, instantiationException.toString());
        }
    }

    public abstract TestResult runTest();

    public void setStream(OutputStream outputStream) {
    }
}

