/*
 * $Header: /home/cvs/jakarta-tools/moo/src/share/org/apache/tools/moo/jsp/NegativeJspCheckTest.java,v 1.4 2000/01/12 08:05:50 shemnon Exp $ 
 * $Date: 2000/01/12 08:05:50 $ 
 * $Revision: 1.4 $
 * 
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */
package org.apache.tools.moo.jsp;

import org.apache.tools.moo.jsp.Constants;
import org.apache.tools.moo.Testable;
import org.apache.tools.moo.TestResult;
import org.apache.tools.moo.URLHelper;
import java.net.URL;
import java.net.URLEncoder;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.io.File;
import java.io.InputStream;
import java.io.FileOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Properties;


/**
 * NegetiveJspCheckTest is the base class for all compatibility client tests
 * that need to probe HTTP header for appropriate error status.
 */

public abstract class NegativeJspCheckTest
extends JspCheckTest {

    // HTTP error code that you expect.
    int errorCode;

    public int getErrorCode() {
        return errorCode;
    }

    // To be invoked by the actual clients.
    public void setErrorCode(int code) {
        this.errorCode = code;
    }

    // This method overrides the getTestResult of the super class.
    // Will check the error code with the expected error code.

    public TestResult getTestResult(HttpURLConnection connection)
    throws Exception {
    	
    	

        TestResult testResult = new TestResult();

        //handle HTTP codes here
        int code = connection.getResponseCode();
        
        
        if (this.useCookie == true)
            saveCookies(connection);
             
        //Thread.currentThread().dumpStack();

        //http response in 400s signifies Client Request Incomplete/Doc Not found
        //http response in 500s signifies servlet error

        out.println("HTTP code" + code);

        if (code != getErrorCode()) {
            testResult.setStatus(false);
            testResult.setMessage("CODE_MISMATCH " + getErrorCode() + "/" + code);
        }
        else { //assume request was OK

            testResult.setStatus(true);
            testResult.setMessage("PASSED");
        }

        // Disconnet.
        connection.disconnect();

        return testResult;
    }
}





