/**
 * TagExtraInfo for the define action
 */


package tags;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

public class DefineExtraInfo extends TagExtraInfo {

    public boolean isValid(TagData data) {
	if (data == null) {
	    return false;
	}
	if ((data.getAttribute("startValue") != null) &&
	    (data.getAttributeString("life").equals("at_end"))) {
	    return false;
	}
	if ((data.getAttribute("endValue") != null) &&
	    (data.getAttributeString("life").equals("nested"))) {
	    return false;
	}
	if ((data.getAttribute("initBodyValue") != null) &&
	    (data.getAttributeString("life").equals("at_end"))) {
	    return false;
	}
	if ((data.getAttribute("afterBodyIncrement") != null) &&
	    (data.getAttributeString("life").equals("at_end"))) {
	    return false;
	}
	return true;
    }

    public VariableInfo[] getVariableInfo(TagData data) {
	String id = data.getId();
	if (id == null) {
	    throw new Error("should not happen...");
	}
	String life = data.getAttributeString("life");
	String scope = data.getAttributeString("scope");
	String declare = data.getAttributeString("declare");
	if (declare == null) {
	    declare = "true";
	}

	VariableInfo back[] = {
	    new VariableInfo(id,
			     "java.lang.Integer",
			     declare.equals("true"), lifeInt(life))};
	return back;
    }

    // private fields

    private int lifeInt(String s) {
        if (s.equals("nested")) {
            return VariableInfo.NESTED;
        } else if (s.equals("at_begin")) {
            return VariableInfo.AT_BEGIN;
        } else if (s.equals("at_end")) {
            return VariableInfo.AT_END;
	}
	return -1;
    }
}
