/**
 * Return the content of the body using one of several different
 * mechanisms.
 *
 * Uses one attribute: "how" which may be "reader", "string" and "writeout"
 */

package tags;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.*;

public class Verbatim extends BodyTagSupport {

    // ================ Attributes ==================

    public void setHow(String s) {
	how = s;
    }

    public String getHow() {
	return how;
    }

    // ================== Actions ====================

    public int doEndTag() {
	BodyContent bd = getBodyContent();
	JspWriter w = getPreviousOut();

	try {
	    if (how.equals("reader")) {
		Reader r = bd.getReader();
		int b = r.read();
		while (b != -1) {
		    w.write(b);
		    b = r.read();
		}
		r.close();
	    } else if (how.equals("string")) {
		w.print(bd.getString());
	    } else if (how.equals("writeout")) {
		bd.writeOut(w);
	    } else {
		throw new Error("Inconsistent state!");
	    }
	} catch (IOException ex) {
	    throw new Error("caught IO excepiton");
	}

	bd.clearBody();

	return EVAL_PAGE;
    }

    // private data

    protected String how = null;
}
