/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import org.apache.naming.resources.RecyclableNamingEnumeration;

public class ResourceAttributes
implements Attributes {
    public static final String CREATION_DATE = "creationdate";
    public static final String ALTERNATE_CREATION_DATE = "creation-date";
    public static final String LAST_MODIFIED = "getlastmodified";
    public static final String ALTERNATE_LAST_MODIFIED = "last-modified";
    public static final String NAME = "displayname";
    public static final String TYPE = "resourcetype";
    public static final String ALTERNATE_TYPE = "content-type";
    public static final String SOURCE = "source";
    public static final String CONTENT_TYPE = "getcontenttype";
    public static final String CONTENT_LANGUAGE = "getcontentlanguage";
    public static final String CONTENT_LENGTH = "getcontentlength";
    public static final String ALTERNATE_CONTENT_LENGTH = "content-length";
    public static final String ETAG = "getetag";
    public static final String COLLECTION_TYPE = "<collection/>";
    protected static final SimpleDateFormat format;
    protected static final SimpleDateFormat[] formats;
    protected boolean collection = false;
    protected long contentLength = -1L;
    protected long creation = -1L;
    protected Date creationDate = null;
    protected long lastModified = -1L;
    protected Date lastModifiedDate = null;
    protected String name = null;
    protected Attributes attributes = null;

    public ResourceAttributes() {
    }

    public ResourceAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public boolean isCollection() {
        if (this.attributes != null) {
            return this.getResourceType().equals(COLLECTION_TYPE);
        }
        return this.collection;
    }

    public void setCollection(boolean collection) {
        this.collection = collection;
        if (this.attributes != null) {
            String value = "";
            if (collection) {
                value = COLLECTION_TYPE;
            }
            this.attributes.put(TYPE, value);
        }
    }

    public long getContentLength() {
        Attribute attribute;
        if (this.contentLength != -1L) {
            return this.contentLength;
        }
        if (this.attributes != null && (attribute = this.attributes.get(CONTENT_LENGTH)) != null) {
            try {
                Object value = attribute.get();
                if (value instanceof Long) {
                    this.contentLength = (Long)value;
                } else {
                    try {
                        this.contentLength = Long.parseLong(value.toString());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
        if (this.attributes != null) {
            this.attributes.put(CONTENT_LENGTH, new Long(contentLength));
        }
    }

    public long getCreation() {
        block11: {
            Attribute attribute;
            if (this.creation != -1L) {
                return this.creation;
            }
            if (this.creationDate != null) {
                return this.creationDate.getTime();
            }
            if (this.attributes != null && (attribute = this.attributes.get(CREATION_DATE)) != null) {
                try {
                    Object value = attribute.get();
                    if (value instanceof Long) {
                        this.creation = (Long)value;
                        break block11;
                    }
                    if (value instanceof Date) {
                        this.creation = ((Date)value).getTime();
                        this.creationDate = (Date)value;
                        break block11;
                    }
                    String creationDateValue = value.toString();
                    Date result = null;
                    int i = 0;
                    while (result == null && i < formats.length) {
                        try {
                            result = formats[i].parse(creationDateValue);
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (result != null) {
                        this.creation = result.getTime();
                        this.creationDate = result;
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        return this.creation;
    }

    public void setCreation(long creation) {
        this.creation = creation;
        this.creationDate = null;
        if (this.attributes != null) {
            this.attributes.put(CREATION_DATE, new Date(creation));
        }
    }

    public Date getCreationDate() {
        block11: {
            Attribute attribute;
            if (this.creationDate != null) {
                return this.creationDate;
            }
            if (this.creation != -1L) {
                this.creationDate = new Date(this.creation);
                return this.creationDate;
            }
            if (this.attributes != null && (attribute = this.attributes.get(CREATION_DATE)) != null) {
                try {
                    Object value = attribute.get();
                    if (value instanceof Long) {
                        this.creation = (Long)value;
                        this.creationDate = new Date(this.creation);
                        break block11;
                    }
                    if (value instanceof Date) {
                        this.creation = ((Date)value).getTime();
                        this.creationDate = (Date)value;
                        break block11;
                    }
                    String creationDateValue = value.toString();
                    Date result = null;
                    int i = 0;
                    while (result == null && i < formats.length) {
                        try {
                            result = formats[i].parse(creationDateValue);
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (result != null) {
                        this.creation = result.getTime();
                        this.creationDate = result;
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creation = creationDate.getTime();
        this.creationDate = creationDate;
        if (this.attributes != null) {
            this.attributes.put(CREATION_DATE, creationDate);
        }
    }

    public long getLastModified() {
        block11: {
            Attribute attribute;
            if (this.lastModified != -1L) {
                return this.lastModified;
            }
            if (this.lastModifiedDate != null) {
                return this.lastModifiedDate.getTime();
            }
            if (this.attributes != null && (attribute = this.attributes.get(LAST_MODIFIED)) != null) {
                try {
                    Object value = attribute.get();
                    if (value instanceof Long) {
                        this.lastModified = (Long)value;
                        break block11;
                    }
                    if (value instanceof Date) {
                        this.lastModified = ((Date)value).getTime();
                        this.lastModifiedDate = (Date)value;
                        break block11;
                    }
                    String lastModifiedDateValue = value.toString();
                    Date result = null;
                    int i = 0;
                    while (result == null && i < formats.length) {
                        try {
                            result = formats[i].parse(lastModifiedDateValue);
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (result != null) {
                        this.lastModified = result.getTime();
                        this.lastModifiedDate = result;
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
        this.lastModifiedDate = null;
        if (this.attributes != null) {
            this.attributes.put(LAST_MODIFIED, new Date(lastModified));
        }
    }

    public void setLastModified(Date lastModified) {
        this.setLastModifiedDate(lastModified);
    }

    public Date getLastModifiedDate() {
        block11: {
            Attribute attribute;
            if (this.lastModifiedDate != null) {
                return this.lastModifiedDate;
            }
            if (this.lastModified != -1L) {
                this.lastModifiedDate = new Date(this.lastModified);
                return this.lastModifiedDate;
            }
            if (this.attributes != null && (attribute = this.attributes.get(LAST_MODIFIED)) != null) {
                try {
                    Object value = attribute.get();
                    if (value instanceof Long) {
                        this.lastModified = (Long)value;
                        this.lastModifiedDate = new Date(this.lastModified);
                        break block11;
                    }
                    if (value instanceof Date) {
                        this.lastModified = ((Date)value).getTime();
                        this.lastModifiedDate = (Date)value;
                        break block11;
                    }
                    String lastModifiedDateValue = value.toString();
                    Date result = null;
                    int i = 0;
                    while (result == null && i < formats.length) {
                        try {
                            result = formats[i].parse(lastModifiedDateValue);
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (result != null) {
                        this.lastModified = result.getTime();
                        this.lastModifiedDate = result;
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModified = lastModifiedDate.getTime();
        this.lastModifiedDate = lastModifiedDate;
        if (this.attributes != null) {
            this.attributes.put(LAST_MODIFIED, lastModifiedDate);
        }
    }

    public String getName() {
        Attribute attribute;
        if (this.name != null) {
            return this.name;
        }
        if (this.attributes != null && (attribute = this.attributes.get(NAME)) != null) {
            try {
                this.name = attribute.get().toString();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.attributes != null) {
            this.attributes.put(NAME, name);
        }
    }

    public String getResourceType() {
        Attribute attribute;
        String result = null;
        if (this.attributes != null && (attribute = this.attributes.get(TYPE)) != null) {
            try {
                result = attribute.get().toString();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (result == null) {
            result = this.collection ? COLLECTION_TYPE : "";
        }
        return result;
    }

    public void setResourceType(String resourceType) {
        this.collection = resourceType.equals(COLLECTION_TYPE);
        if (this.attributes != null) {
            this.attributes.put(TYPE, resourceType);
        }
    }

    public Attribute get(String attrID) {
        if (this.attributes == null) {
            if (attrID.equals(CREATION_DATE)) {
                return new BasicAttribute(CREATION_DATE, this.getCreationDate());
            }
            if (attrID.equals(ALTERNATE_CREATION_DATE)) {
                return new BasicAttribute(ALTERNATE_CREATION_DATE, this.getCreationDate());
            }
            if (attrID.equals(LAST_MODIFIED)) {
                return new BasicAttribute(LAST_MODIFIED, this.getLastModifiedDate());
            }
            if (attrID.equals(ALTERNATE_LAST_MODIFIED)) {
                return new BasicAttribute(ALTERNATE_LAST_MODIFIED, this.getLastModifiedDate());
            }
            if (attrID.equals(NAME)) {
                return new BasicAttribute(NAME, this.getName());
            }
            if (attrID.equals(TYPE)) {
                return new BasicAttribute(TYPE, this.getResourceType());
            }
            if (attrID.equals(ALTERNATE_TYPE)) {
                return new BasicAttribute(ALTERNATE_TYPE, this.getResourceType());
            }
            if (attrID.equals(CONTENT_LENGTH)) {
                return new BasicAttribute(CONTENT_LENGTH, new Long(this.getContentLength()));
            }
            if (attrID.equals(ALTERNATE_CONTENT_LENGTH)) {
                return new BasicAttribute(ALTERNATE_CONTENT_LENGTH, new Long(this.getContentLength()));
            }
        } else {
            return this.attributes.get(attrID);
        }
        return null;
    }

    public Attribute put(Attribute attribute) {
        if (this.attributes == null) {
            try {
                return this.put(attribute.getID(), attribute.get());
            }
            catch (NamingException e) {
                return null;
            }
        }
        return this.attributes.put(attribute);
    }

    public Attribute put(String attrID, Object val) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.put(attrID, val);
    }

    public Attribute remove(String attrID) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(attrID);
    }

    public NamingEnumeration getAll() {
        if (this.attributes == null) {
            Vector<BasicAttribute> attributes = new Vector<BasicAttribute>();
            attributes.addElement(new BasicAttribute(CREATION_DATE, this.getCreationDate()));
            attributes.addElement(new BasicAttribute(LAST_MODIFIED, this.getLastModifiedDate()));
            attributes.addElement(new BasicAttribute(NAME, this.getName()));
            attributes.addElement(new BasicAttribute(TYPE, this.getResourceType()));
            attributes.addElement(new BasicAttribute(CONTENT_LENGTH, new Long(this.getContentLength())));
            return new RecyclableNamingEnumeration(attributes);
        }
        return this.attributes.getAll();
    }

    public NamingEnumeration getIDs() {
        if (this.attributes == null) {
            Vector<String> attributeIDs = new Vector<String>();
            attributeIDs.addElement(CREATION_DATE);
            attributeIDs.addElement(LAST_MODIFIED);
            attributeIDs.addElement(NAME);
            attributeIDs.addElement(TYPE);
            attributeIDs.addElement(CONTENT_LENGTH);
            return new RecyclableNamingEnumeration(attributeIDs);
        }
        return this.attributes.getIDs();
    }

    public int size() {
        if (this.attributes == null) {
            return 5;
        }
        return this.attributes.size();
    }

    public Object clone() {
        return this;
    }

    public boolean isCaseIgnored() {
        return false;
    }

    static {
        CREATION_DATE = CREATION_DATE;
        ALTERNATE_CREATION_DATE = ALTERNATE_CREATION_DATE;
        LAST_MODIFIED = LAST_MODIFIED;
        ALTERNATE_LAST_MODIFIED = ALTERNATE_LAST_MODIFIED;
        NAME = NAME;
        TYPE = TYPE;
        ALTERNATE_TYPE = ALTERNATE_TYPE;
        SOURCE = SOURCE;
        CONTENT_TYPE = CONTENT_TYPE;
        CONTENT_LANGUAGE = CONTENT_LANGUAGE;
        CONTENT_LENGTH = CONTENT_LENGTH;
        ALTERNATE_CONTENT_LENGTH = ALTERNATE_CONTENT_LENGTH;
        ETAG = ETAG;
        COLLECTION_TYPE = COLLECTION_TYPE;
        format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    }
}

