/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.connector.http.DefaultHeaders;
import org.apache.catalina.connector.http.HttpConnector;
import org.apache.catalina.connector.http.HttpHeader;
import org.apache.catalina.connector.http.HttpRequestImpl;
import org.apache.catalina.connector.http.HttpRequestLine;
import org.apache.catalina.connector.http.HttpResponseImpl;
import org.apache.catalina.connector.http.SocketInputStream;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.util.StringParser;

final class HttpProcessor
implements Lifecycle,
Runnable {
    private boolean available = false;
    private HttpConnector connector = null;
    private int debug = 0;
    private int id = 0;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private static final String match = ";jsessionid=";
    private static final char[] SESSION_ID;
    private StringParser parser = new StringParser();
    private String proxyName = null;
    private int proxyPort = 0;
    private HttpRequestImpl request = null;
    private HttpResponseImpl response = null;
    private int serverPort = 0;
    protected StringManager sm = StringManager.getManager("org.apache.catalina.connector.http");
    private Socket socket = null;
    private boolean started = false;
    private boolean stopped = false;
    private Thread thread = null;
    private String threadName = null;
    private Object threadSync = new Object();
    private boolean keepAlive = false;
    private boolean http11 = true;
    private boolean sendAck = false;
    private static final byte[] ack;
    private static final byte[] CRLF;
    private HttpRequestLine requestLine = new HttpRequestLine();
    private int status = 0;

    public HttpProcessor(HttpConnector connector, int id) {
        this.connector = connector;
        this.debug = connector.getDebug();
        this.id = id;
        this.proxyName = connector.getProxyName();
        this.proxyPort = connector.getProxyPort();
        this.request = (HttpRequestImpl)connector.createRequest();
        this.response = (HttpResponseImpl)connector.createResponse();
        this.serverPort = connector.getPort();
        this.threadName = "HttpProcessor[" + connector.getPort() + "][" + id + "]";
    }

    public String toString() {
        return this.threadName;
    }

    synchronized void assign(Socket socket) {
        while (this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.socket = socket;
        this.available = true;
        this.notifyAll();
        if (this.debug >= 1 && socket != null) {
            this.log(" An incoming request is being assigned");
        }
    }

    private synchronized Socket await() {
        while (!this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Socket socket = this.socket;
        this.available = false;
        this.notifyAll();
        if (this.debug >= 1 && socket != null) {
            this.log("  The incoming request has been awaited");
        }
        return socket;
    }

    private void log(String message) {
        Logger logger = this.connector.getContainer().getLogger();
        if (logger != null) {
            logger.log(this.threadName + " " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = this.connector.getContainer().getLogger();
        if (logger != null) {
            logger.log(this.threadName + " " + message, throwable);
        }
    }

    private void parseAcceptLanguage(String value) {
        int start;
        TreeMap<Double, ArrayList<Locale>> locales = new TreeMap<Double, ArrayList<Locale>>();
        int white = value.indexOf(32);
        if (white < 0) {
            white = value.indexOf(9);
        }
        if (white >= 0) {
            StringBuffer sb = new StringBuffer();
            int len = value.length();
            int i = 0;
            while (i < len) {
                char ch = value.charAt(i);
                if (ch != ' ' && ch != '\t') {
                    sb.append(ch);
                }
                ++i;
            }
            value = sb.toString();
        }
        this.parser.setString(value);
        int length = this.parser.getLength();
        while ((start = this.parser.getIndex()) < length) {
            int end = this.parser.findChar(',');
            String entry = this.parser.extract(start, end).trim();
            this.parser.advance();
            double quality = 1.0;
            int semi = entry.indexOf(";q=");
            if (semi >= 0) {
                try {
                    quality = Double.parseDouble(entry.substring(semi + 3));
                }
                catch (NumberFormatException e) {
                    quality = 0.0;
                }
                entry = entry.substring(0, semi);
            }
            if (quality < 5.0E-5 || "*".equals(entry)) continue;
            String language = null;
            String country = null;
            String variant = null;
            int dash = entry.indexOf(45);
            if (dash < 0) {
                language = entry;
                country = "";
                variant = "";
            } else {
                language = entry.substring(0, dash);
                country = entry.substring(dash + 1);
                int vDash = country.indexOf(45);
                if (vDash > 0) {
                    String cTemp = country.substring(0, vDash);
                    variant = country.substring(vDash + 1);
                    country = cTemp;
                } else {
                    variant = "";
                }
            }
            Locale locale = new Locale(language, country, variant);
            Double key = new Double(-quality);
            ArrayList<Locale> values = (ArrayList<Locale>)locales.get(key);
            if (values == null) {
                values = new ArrayList<Locale>();
                locales.put(key, values);
            }
            values.add(locale);
        }
        Iterator keys = locales.keySet().iterator();
        while (keys.hasNext()) {
            Double key = (Double)keys.next();
            ArrayList list = (ArrayList)locales.get(key);
            Iterator values = list.iterator();
            while (values.hasNext()) {
                Locale locale = (Locale)values.next();
                if (this.debug >= 1) {
                    this.log(" Adding locale '" + locale + "'");
                }
                this.request.addLocale(locale);
            }
        }
    }

    private void parseConnection(Socket socket) throws IOException, ServletException {
        if (this.debug >= 2) {
            this.log("  parseConnection: address=" + socket.getInetAddress() + ", port=" + this.connector.getPort());
        }
        this.request.setInet(socket.getInetAddress());
        if (this.proxyPort != 0) {
            this.request.setServerPort(this.proxyPort);
        } else {
            this.request.setServerPort(this.serverPort);
        }
        this.request.setSocket(socket);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseHeaders(SocketInputStream input) throws IOException, ServletException {
        while (true) {
            HttpHeader header = this.request.allocateHeader();
            input.readHeader(header);
            if (header.nameEnd == 0) {
                if (header.valueEnd != 0) throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.colon"));
                return;
            }
            String value = new String(header.value, 0, header.valueEnd);
            if (this.debug >= 1) {
                this.log(" Header " + new String(header.name, 0, header.nameEnd) + " = " + value);
            }
            if (header.equals(DefaultHeaders.AUTHORIZATION_NAME)) {
                this.request.setAuthorization(value);
            } else if (header.equals(DefaultHeaders.ACCEPT_LANGUAGE_NAME)) {
                this.parseAcceptLanguage(value);
            } else if (header.equals(DefaultHeaders.COOKIE_NAME)) {
                Cookie[] cookies = RequestUtil.parseCookieHeader(value);
                int i = 0;
                while (i < cookies.length) {
                    if (cookies[i].getName().equals("JSESSIONID") && !this.request.isRequestedSessionIdFromCookie()) {
                        this.request.setRequestedSessionId(cookies[i].getValue());
                        this.request.setRequestedSessionCookie(true);
                        this.request.setRequestedSessionURL(false);
                        if (this.debug >= 1) {
                            this.log(" Requested cookie session id is " + ((HttpServletRequest)this.request.getRequest()).getRequestedSessionId());
                        }
                    }
                    if (this.debug >= 1) {
                        this.log(" Adding cookie " + cookies[i].getName() + "=" + cookies[i].getValue());
                    }
                    this.request.addCookie(cookies[i]);
                    ++i;
                }
            } else if (header.equals(DefaultHeaders.CONTENT_LENGTH_NAME)) {
                int n = -1;
                try {
                    n = Integer.parseInt(value);
                }
                catch (Exception e) {
                    throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.contentLength"));
                }
                this.request.setContentLength(n);
            } else if (header.equals(DefaultHeaders.CONTENT_TYPE_NAME)) {
                this.request.setContentType(value);
            } else if (header.equals(DefaultHeaders.HOST_NAME)) {
                int n = value.indexOf(58);
                if (n < 0) {
                    if (this.connector.getScheme().equals("http")) {
                        this.request.setServerPort(80);
                    } else if (this.connector.getScheme().equals("https")) {
                        this.request.setServerPort(443);
                    }
                    if (this.proxyName != null) {
                        this.request.setServerName(this.proxyName);
                    } else {
                        this.request.setServerName(value);
                    }
                } else {
                    if (this.proxyName != null) {
                        this.request.setServerName(this.proxyName);
                    } else {
                        this.request.setServerName(value.substring(0, n).trim());
                    }
                    if (this.proxyPort != 0) {
                        this.request.setServerPort(this.proxyPort);
                    } else {
                        int port = 80;
                        try {
                            port = Integer.parseInt(value.substring(n + 1).trim());
                        }
                        catch (Exception e) {
                            throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.portNumber"));
                        }
                        this.request.setServerPort(port);
                    }
                }
            } else if (header.equals(DefaultHeaders.CONNECTION_NAME)) {
                if (header.valueEquals(DefaultHeaders.CONNECTION_CLOSE_VALUE)) {
                    this.keepAlive = false;
                    this.response.setHeader("Connection", "close");
                }
            } else if (header.equals(DefaultHeaders.EXPECT_NAME)) {
                if (!header.valueEquals(DefaultHeaders.EXPECT_100_VALUE)) throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.unknownExpectation"));
                this.sendAck = true;
            } else if (header.equals(DefaultHeaders.TRANSFER_ENCODING_NAME)) {
                // empty if block
            }
            this.request.nextHeader();
        }
    }

    private void parseRequest(SocketInputStream input, OutputStream output) throws IOException, ServletException {
        int semicolon;
        int pos;
        input.readRequestLine(this.requestLine);
        this.status = 1;
        String method = new String(this.requestLine.method, 0, this.requestLine.methodEnd);
        String uri = null;
        String protocol = new String(this.requestLine.protocol, 0, this.requestLine.protocolEnd);
        if (protocol.length() == 0) {
            protocol = "HTTP/0.9";
        }
        if (protocol.equals("HTTP/1.1")) {
            this.http11 = true;
            this.sendAck = false;
        } else {
            this.http11 = false;
            this.sendAck = false;
            this.keepAlive = false;
        }
        if (method.length() < 1) {
            throw new ServletException(this.sm.getString("httpProcessor.parseRequest.method"));
        }
        if (this.requestLine.uriEnd < 1) {
            throw new ServletException(this.sm.getString("httpProcessor.parseRequest.uri"));
        }
        int question = this.requestLine.indexOf("?");
        if (question >= 0) {
            this.request.setQueryString(new String(this.requestLine.uri, question + 1, this.requestLine.uriEnd - question - 1));
            if (this.debug >= 1) {
                this.log(" Query string is " + ((HttpServletRequest)this.request.getRequest()).getQueryString());
            }
            uri = new String(this.requestLine.uri, 0, question);
        } else {
            this.request.setQueryString(null);
            uri = new String(this.requestLine.uri, 0, this.requestLine.uriEnd);
        }
        if (!uri.startsWith("/") && (pos = uri.indexOf("://")) != -1) {
            uri = (pos = uri.indexOf(47, pos + 3)) == -1 ? "" : uri.substring(pos);
        }
        if ((semicolon = uri.indexOf(match)) >= 0) {
            String rest = uri.substring(semicolon + match.length());
            int semicolon2 = rest.indexOf(59);
            if (semicolon2 >= 0) {
                this.request.setRequestedSessionId(rest.substring(0, semicolon2));
                rest = rest.substring(semicolon2);
            } else {
                this.request.setRequestedSessionId(rest);
                rest = "";
            }
            this.request.setRequestedSessionURL(true);
            uri = uri.substring(0, semicolon) + rest;
            if (this.debug >= 1) {
                this.log(" Requested URL session id is " + ((HttpServletRequest)this.request.getRequest()).getRequestedSessionId());
            }
        } else {
            this.request.setRequestedSessionId(null);
            this.request.setRequestedSessionURL(false);
        }
        String normalizedUri = this.normalize(uri);
        if (this.debug >= 1) {
            this.log("Normalized: '" + uri + "' to '" + normalizedUri + "'");
        }
        this.request.setMethod(method);
        this.request.setProtocol(protocol);
        if (normalizedUri != null) {
            this.request.setRequestURI(normalizedUri);
        } else {
            this.request.setRequestURI(uri);
        }
        this.request.setSecure(this.connector.getSecure());
        this.request.setScheme(this.connector.getScheme());
        if (normalizedUri == null) {
            this.log(" Invalid request URI: '" + uri + "'");
            throw new ServletException("Invalid URI: " + uri + "'");
        }
        if (this.debug >= 1) {
            this.log(" Request is '" + method + "' for '" + uri + "' with protocol '" + protocol + "'");
        }
    }

    protected String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.startsWith("/%7E") || normalized.startsWith("/%7e")) {
            normalized = "/~" + normalized.substring(4);
        }
        if (normalized.indexOf("%25") >= 0 || normalized.indexOf("%2F") >= 0 || normalized.indexOf("%2E") >= 0 || normalized.indexOf("%5C") >= 0 || normalized.indexOf("%2f") >= 0 || normalized.indexOf("%2e") >= 0 || normalized.indexOf("%5c") >= 0) {
            return null;
        }
        if (normalized.equals("/.")) {
            return "/";
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        if (normalized.indexOf("/...") >= 0) {
            return null;
        }
        return normalized;
    }

    private void ackRequest(OutputStream output) throws IOException {
        if (this.sendAck) {
            output.write(ack);
        }
    }

    private void process(Socket socket) {
        boolean ok = true;
        boolean finishResponse = true;
        SocketInputStream input = null;
        OutputStream output = null;
        try {
            input = new SocketInputStream(socket.getInputStream(), this.connector.getBufferSize());
        }
        catch (Exception e) {
            this.log("process.create", e);
            ok = false;
        }
        this.keepAlive = true;
        while (!this.stopped && ok && this.keepAlive) {
            finishResponse = true;
            try {
                this.request.setStream(input);
                this.request.setResponse(this.response);
                output = socket.getOutputStream();
                this.response.setStream(output);
                this.response.setRequest(this.request);
                ((HttpServletResponse)this.response.getResponse()).setHeader("Server", "Apache Tomcat/4.0.5 (HTTP/1.1 Connector)");
            }
            catch (Exception e) {
                this.log("process.create", e);
                ok = false;
            }
            try {
                if (ok) {
                    this.parseConnection(socket);
                    this.parseRequest(input, output);
                    if (!this.request.getRequest().getProtocol().startsWith("HTTP/0")) {
                        this.parseHeaders(input);
                    }
                    if (this.http11) {
                        this.ackRequest(output);
                        if (this.connector.isChunkingAllowed()) {
                            this.response.setAllowChunking(true);
                        }
                    }
                }
            }
            catch (EOFException e) {
                ok = false;
                finishResponse = false;
            }
            catch (ServletException e) {
                ok = false;
                try {
                    ((HttpServletResponse)this.response.getResponse()).sendError(400);
                }
                catch (Exception f) {}
            }
            catch (InterruptedIOException e) {
                if (this.debug > 1) {
                    try {
                        this.log("process.parse", e);
                        ((HttpServletResponse)this.response.getResponse()).sendError(400);
                    }
                    catch (Exception f) {
                        // empty catch block
                    }
                }
                ok = false;
            }
            catch (Exception e) {
                try {
                    this.log("process.parse", e);
                    ((HttpServletResponse)this.response.getResponse()).sendError(400);
                }
                catch (Exception f) {
                    // empty catch block
                }
                ok = false;
            }
            try {
                this.response.addDateHeader("Date", System.currentTimeMillis());
                if (ok) {
                    this.connector.getContainer().invoke(this.request, this.response);
                }
            }
            catch (ServletException e) {
                this.log("process.invoke", e);
                try {
                    ((HttpServletResponse)this.response.getResponse()).sendError(500);
                }
                catch (Exception f) {
                    // empty catch block
                }
                ok = false;
            }
            catch (InterruptedIOException e) {
                ok = false;
            }
            catch (Throwable e) {
                this.log("process.invoke", e);
                try {
                    ((HttpServletResponse)this.response.getResponse()).sendError(500);
                }
                catch (Exception f) {
                    // empty catch block
                }
                ok = false;
            }
            try {
                if (finishResponse) {
                    this.response.finishResponse();
                    this.request.finishRequest();
                    if (output != null) {
                        output.flush();
                    }
                }
            }
            catch (IOException e) {
                ok = false;
            }
            catch (Exception e) {
                this.log("process.finish", e);
            }
            if ("close".equals(this.response.getHeader("Connection"))) {
                this.keepAlive = false;
            }
            this.status = 0;
            this.request.recycle();
            this.response.recycle();
        }
        try {
            this.shutdownInput(input);
            socket.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        socket = null;
    }

    protected void shutdownInput(InputStream input) throws IOException {
        try {
            int available = input.available();
            if (available > 0) {
                input.skip(available);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stopped) {
            Socket socket = this.await();
            if (socket == null) continue;
            try {
                this.process(socket);
            }
            catch (Throwable t) {
                this.log("process", t);
            }
            this.connector.recycle(this);
        }
        Object object = this.threadSync;
        synchronized (object) {
            this.threadSync.notifyAll();
        }
    }

    private void threadStart() {
        this.log(this.sm.getString("httpProcessor.starting"));
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
        if (this.debug >= 1) {
            this.log(" Background thread has been started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadStop() {
        this.log(this.sm.getString("httpProcessor.stopping"));
        this.stopped = true;
        this.assign(null);
        if (this.status != 0) {
            Object object = this.threadSync;
            synchronized (object) {
                try {
                    this.threadSync.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.thread = null;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("httpProcessor.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("httpProcessor.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.threadStop();
    }

    static {
        match = match;
        SESSION_ID = match.toCharArray();
        ack = new String("HTTP/1.1 100 Continue\r\n\r\n").getBytes();
        CRLF = new String("\r\n").getBytes();
    }
}

