/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.HashMap;
import javax.naming.directory.DirContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ResourceParams;
import org.apache.catalina.util.StringManager;

public class DefaultContext {
    private String[] applicationListeners = new String[0];
    private ApplicationParameter[] applicationParameters = new ApplicationParameter[0];
    private boolean cookies = true;
    private boolean crossContext = true;
    private HashMap ejbs = new HashMap();
    private HashMap envs = new HashMap();
    private static final String info = "org.apache.catalina.core.DefaultContext/1.0";
    private String[] instanceListeners = new String[0];
    private String mapperClass = "org.apache.catalina.core.StandardContextMapper";
    private HashMap parameters = new HashMap();
    private boolean reloadable = false;
    private HashMap resourceEnvRefs = new HashMap();
    private HashMap resources = new HashMap();
    private HashMap resourceParams = new HashMap();
    private String[] wrapperLifecycles = new String[0];
    private String[] wrapperListeners = new String[0];
    private String wrapperClass = "org.apache.catalina.core.StandardWrapper";
    private boolean useNaming = true;
    DirContext dirContext = null;
    protected String name = "defaultContext";
    protected Container parent = null;
    protected Loader loader = null;
    protected Manager manager = null;
    protected static StringManager sm;

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean useNaming) {
        this.useNaming = useNaming;
    }

    public boolean getCookies() {
        return this.cookies;
    }

    public void setCookies(boolean cookies) {
        boolean oldCookies = this.cookies;
        this.cookies = cookies;
    }

    public boolean getCrossContext() {
        return this.crossContext;
    }

    public void setCrossContext(boolean crossContext) {
        boolean oldCrossContext = this.crossContext;
        this.crossContext = crossContext;
    }

    public String getInfo() {
        return info;
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
    }

    public String getWrapperClass() {
        return this.wrapperClass;
    }

    public void setWrapperClass(String wrapperClass) {
        this.wrapperClass = wrapperClass;
    }

    public void setResources(DirContext resources) {
        this.dirContext = resources;
    }

    public DirContext getResources() {
        return this.dirContext;
    }

    public Loader getLoader() {
        return this.loader;
    }

    public void setLoader(Loader loader) {
        this.loader = loader;
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container container) {
        this.parent = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationListener(String listener) {
        String[] stringArray = this.applicationListeners;
        synchronized (stringArray) {
            String[] results = new String[this.applicationListeners.length + 1];
            int i = 0;
            while (i < this.applicationListeners.length) {
                results[i] = this.applicationListeners[i];
                ++i;
            }
            results[this.applicationListeners.length] = listener;
            this.applicationListeners = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationParameter(ApplicationParameter parameter) {
        ApplicationParameter[] applicationParameterArray = this.applicationParameters;
        synchronized (applicationParameterArray) {
            ApplicationParameter[] results = new ApplicationParameter[this.applicationParameters.length + 1];
            System.arraycopy(this.applicationParameters, 0, results, 0, this.applicationParameters.length);
            results[this.applicationParameters.length] = parameter;
            this.applicationParameters = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEjb(ContextEjb ejb) {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            this.ejbs.put(ejb.getName(), ejb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEnvironment(ContextEnvironment environment) {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            this.envs.put(environment.getName(), environment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceParams(ResourceParams resourceParameters) {
        HashMap hashMap = this.resourceParams;
        synchronized (hashMap) {
            this.resourceParams.put(resourceParameters.getName(), resourceParameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceListener(String listener) {
        String[] stringArray = this.instanceListeners;
        synchronized (stringArray) {
            String[] results = new String[this.instanceListeners.length + 1];
            int i = 0;
            while (i < this.instanceListeners.length) {
                results[i] = this.instanceListeners[i];
                ++i;
            }
            results[this.instanceListeners.length] = listener;
            this.instanceListeners = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.required"));
        }
        if (this.parameters.get(name) != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.duplicate", name));
        }
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(ContextResource resource) {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            this.resources.put(resource.getName(), resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceEnvRef(String name, String type) {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            this.resourceEnvRefs.put(name, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWrapperLifecycle(String listener) {
        String[] stringArray = this.wrapperLifecycles;
        synchronized (stringArray) {
            String[] results = new String[this.wrapperLifecycles.length + 1];
            int i = 0;
            while (i < this.wrapperLifecycles.length) {
                results[i] = this.wrapperLifecycles[i];
                ++i;
            }
            results[this.wrapperLifecycles.length] = listener;
            this.wrapperLifecycles = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWrapperListener(String listener) {
        String[] stringArray = this.wrapperListeners;
        synchronized (stringArray) {
            String[] results = new String[this.wrapperListeners.length + 1];
            int i = 0;
            while (i < this.wrapperListeners.length) {
                results[i] = this.wrapperListeners[i];
                ++i;
            }
            results[this.wrapperListeners.length] = listener;
            this.wrapperListeners = results;
        }
    }

    public String[] findApplicationListeners() {
        return this.applicationListeners;
    }

    public ApplicationParameter[] findApplicationParameters() {
        return this.applicationParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb findEjb(String name) {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            ContextEjb contextEjb = (ContextEjb)this.ejbs.get(name);
            return contextEjb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb[] findEjbs() {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            ContextEjb[] results = new ContextEjb[this.ejbs.size()];
            ContextEjb[] contextEjbArray = this.ejbs.values().toArray(results);
            return contextEjbArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment findEnvironment(String name) {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            ContextEnvironment contextEnvironment = (ContextEnvironment)this.envs.get(name);
            return contextEnvironment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment[] findEnvironments() {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            ContextEnvironment[] results = new ContextEnvironment[this.envs.size()];
            ContextEnvironment[] contextEnvironmentArray = this.envs.values().toArray(results);
            return contextEnvironmentArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceParams[] findResourceParams() {
        HashMap hashMap = this.resourceParams;
        synchronized (hashMap) {
            ResourceParams[] results = new ResourceParams[this.resourceParams.size()];
            ResourceParams[] resourceParamsArray = this.resourceParams.values().toArray(results);
            return resourceParamsArray;
        }
    }

    public String[] findInstanceListeners() {
        return this.instanceListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            String string = (String)this.parameters.get(name);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findParameters() {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            String[] results = new String[this.parameters.size()];
            String[] stringArray = this.parameters.keySet().toArray(results);
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource findResource(String name) {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            ContextResource contextResource = (ContextResource)this.resources.get(name);
            return contextResource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findResourceEnvRef(String name) {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            String string = (String)this.resourceEnvRefs.get(name);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findResourceEnvRefs() {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            String[] results = new String[this.resourceEnvRefs.size()];
            String[] stringArray = this.resourceEnvRefs.keySet().toArray(results);
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource[] findResources() {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            ContextResource[] results = new ContextResource[this.resources.size()];
            ContextResource[] contextResourceArray = this.resources.values().toArray(results);
            return contextResourceArray;
        }
    }

    public String[] findWrapperLifecycles() {
        return this.wrapperLifecycles;
    }

    public String[] findWrapperListeners() {
        return this.wrapperListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationListener(String listener) {
        String[] stringArray = this.applicationListeners;
        synchronized (stringArray) {
            int n = -1;
            int i = 0;
            while (i < this.applicationListeners.length) {
                if (this.applicationListeners[i].equals(listener)) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.applicationListeners.length - 1];
            int i2 = 0;
            while (i2 < this.applicationListeners.length) {
                if (i2 != n) {
                    results[j++] = this.applicationListeners[i2];
                }
                ++i2;
            }
            this.applicationListeners = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationParameter(String name) {
        ApplicationParameter[] applicationParameterArray = this.applicationParameters;
        synchronized (applicationParameterArray) {
            int n = -1;
            int i = 0;
            while (i < this.applicationParameters.length) {
                if (name.equals(this.applicationParameters[i].getName())) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            ApplicationParameter[] results = new ApplicationParameter[this.applicationParameters.length - 1];
            int i2 = 0;
            while (i2 < this.applicationParameters.length) {
                if (i2 != n) {
                    results[j++] = this.applicationParameters[i2];
                }
                ++i2;
            }
            this.applicationParameters = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEjb(String name) {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            this.ejbs.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEnvironment(String name) {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            this.envs.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(String listener) {
        String[] stringArray = this.instanceListeners;
        synchronized (stringArray) {
            int n = -1;
            int i = 0;
            while (i < this.instanceListeners.length) {
                if (this.instanceListeners[i].equals(listener)) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.instanceListeners.length - 1];
            int i2 = 0;
            while (i2 < this.instanceListeners.length) {
                if (i2 != n) {
                    results[j++] = this.instanceListeners[i2];
                }
                ++i2;
            }
            this.instanceListeners = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(String name) {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            this.resources.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceEnvRef(String name) {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            this.resourceEnvRefs.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWrapperLifecycle(String listener) {
        String[] stringArray = this.wrapperLifecycles;
        synchronized (stringArray) {
            int n = -1;
            int i = 0;
            while (i < this.wrapperLifecycles.length) {
                if (this.wrapperLifecycles[i].equals(listener)) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.wrapperLifecycles.length - 1];
            int i2 = 0;
            while (i2 < this.wrapperLifecycles.length) {
                if (i2 != n) {
                    results[j++] = this.wrapperLifecycles[i2];
                }
                ++i2;
            }
            this.wrapperLifecycles = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWrapperListener(String listener) {
        String[] stringArray = this.wrapperListeners;
        synchronized (stringArray) {
            int n = -1;
            int i = 0;
            while (i < this.wrapperListeners.length) {
                if (this.wrapperListeners[i].equals(listener)) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.wrapperListeners.length - 1];
            int i2 = 0;
            while (i2 < this.wrapperListeners.length) {
                if (i2 != n) {
                    results[j++] = this.wrapperListeners[i2];
                }
                ++i2;
            }
            this.wrapperListeners = results;
        }
    }

    public void importDefaultContext(Context context) {
        int i;
        if (context instanceof StandardContext) {
            ((StandardContext)context).setUseNaming(this.isUseNaming());
        }
        context.setCookies(this.getCookies());
        context.setCrossContext(this.getCrossContext());
        context.setReloadable(this.getReloadable());
        String[] listeners = this.findApplicationListeners();
        int i2 = 0;
        while (i2 < listeners.length) {
            context.addApplicationListener(listeners[i2]);
            ++i2;
        }
        listeners = this.findInstanceListeners();
        int i3 = 0;
        while (i3 < listeners.length) {
            context.addInstanceListener(listeners[i3]);
            ++i3;
        }
        String[] wrapper = this.findWrapperListeners();
        int i4 = 0;
        while (i4 < wrapper.length) {
            context.addWrapperListener(wrapper[i4]);
            ++i4;
        }
        wrapper = this.findWrapperLifecycles();
        int i5 = 0;
        while (i5 < wrapper.length) {
            context.addWrapperLifecycle(wrapper[i5]);
            ++i5;
        }
        String[] parameters = this.findParameters();
        int i6 = 0;
        while (i6 < parameters.length) {
            context.addParameter(parameters[i6], this.findParameter(parameters[i6]));
            ++i6;
        }
        ApplicationParameter[] appParam = this.findApplicationParameters();
        int i7 = 0;
        while (i7 < appParam.length) {
            context.addApplicationParameter(appParam[i7]);
            ++i7;
        }
        ContextEjb[] contextEjb = this.findEjbs();
        int i8 = 0;
        while (i8 < contextEjb.length) {
            context.addEjb(contextEjb[i8]);
            ++i8;
        }
        ContextEnvironment[] contextEnv = this.findEnvironments();
        int i9 = 0;
        while (i9 < contextEnv.length) {
            context.addEnvironment(contextEnv[i9]);
            ++i9;
        }
        if (context instanceof StandardContext) {
            ResourceParams[] resourceParams = this.findResourceParams();
            i = 0;
            while (i < resourceParams.length) {
                ((StandardContext)context).addResourceParams(resourceParams[i]);
                ++i;
            }
        }
        ContextResource[] resources = this.findResources();
        i = 0;
        while (i < resources.length) {
            context.addResource(resources[i]);
            ++i;
        }
        String[] envRefs = this.findResourceEnvRefs();
        int i10 = 0;
        while (i10 < envRefs.length) {
            context.addResourceEnvRef(envRefs[i10], this.findResourceEnvRef(envRefs[i10]));
            ++i10;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("DefaultContext[");
        sb.append("]");
        return sb.toString();
    }

    static {
        info = info;
        sm = StringManager.getManager("org.apache.catalina.core");
    }
}

