/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSessionContext;
import org.apache.catalina.session.StandardSessionFacade;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.StringManager;

class StandardSession
implements HttpSession,
Session,
Serializable {
    private static final String NOT_SERIALIZED = "___NOT_SERIALIZABLE_EXCEPTION___";
    private HashMap attributes = new HashMap();
    private transient String authType = null;
    private long creationTime = 0L;
    private transient int debug = 0;
    private transient boolean expiring = false;
    private transient StandardSessionFacade facade = null;
    private String id = null;
    private static final String info = "StandardSession/1.0";
    private long lastAccessedTime = this.creationTime;
    private transient ArrayList listeners = new ArrayList();
    private Manager manager = null;
    private int maxInactiveInterval = -1;
    private boolean isNew = false;
    private boolean isValid = false;
    private transient HashMap notes = new HashMap();
    private transient Principal principal = null;
    private static StringManager sm;
    private static HttpSessionContext sessionContext;
    private transient PropertyChangeSupport support = new PropertyChangeSupport(this);
    private long thisAccessedTime = this.creationTime;

    public StandardSession(Manager manager) {
        this.manager = manager;
        if (manager instanceof ManagerBase) {
            this.debug = ((ManagerBase)manager).getDebug();
        }
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        String oldAuthType = this.authType;
        this.authType = authType;
        this.support.firePropertyChange("authType", oldAuthType, this.authType);
    }

    public void setCreationTime(long time) {
        this.creationTime = time;
        this.lastAccessedTime = time;
        this.thisAccessedTime = time;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (this.id != null && this.manager != null) {
            this.manager.remove(this);
        }
        this.id = id;
        if (this.manager != null) {
            this.manager.add(this);
        }
        this.fireSessionEvent("createSession", null);
        StandardContext context = (StandardContext)this.manager.getContainer();
        Object[] listeners = context.getApplicationListeners();
        if (listeners != null) {
            HttpSessionEvent event = new HttpSessionEvent(this.getSession());
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] instanceof HttpSessionListener) {
                    HttpSessionListener listener = (HttpSessionListener)listeners[i];
                    try {
                        context.fireContainerEvent("beforeSessionCreated", listener);
                        listener.sessionCreated(event);
                        context.fireContainerEvent("afterSessionCreated", listener);
                    }
                    catch (Throwable t) {
                        context.fireContainerEvent("afterSessionCreated", listener);
                        this.log(sm.getString("standardSession.sessionEvent"), t);
                    }
                }
                ++i;
            }
        }
    }

    public String getInfo() {
        return info;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public int getMaxInactiveInterval() {
        if (!this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.getMaxInactiveInterval.ise"));
        }
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        Principal oldPrincipal = this.principal;
        this.principal = principal;
        this.support.firePropertyChange("principal", oldPrincipal, this.principal);
    }

    public HttpSession getSession() {
        if (this.facade == null) {
            this.facade = new StandardSessionFacade(this);
        }
        return this.facade;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public void access() {
        this.isNew = false;
        this.lastAccessedTime = this.thisAccessedTime;
        this.thisAccessedTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(SessionListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    public void expire() {
        if (this.expiring) {
            return;
        }
        this.expiring = true;
        this.setValid(false);
        if (this.manager != null) {
            this.manager.remove(this);
        }
        String[] keys = this.keys();
        int i = 0;
        while (i < keys.length) {
            this.removeAttribute(keys[i]);
            ++i;
        }
        this.fireSessionEvent("destroySession", null);
        StandardContext context = (StandardContext)this.manager.getContainer();
        Object[] listeners = context.getApplicationListeners();
        if (listeners != null) {
            HttpSessionEvent event = new HttpSessionEvent(this.getSession());
            int i2 = 0;
            while (i2 < listeners.length) {
                int j = listeners.length - 1 - i2;
                if (listeners[j] instanceof HttpSessionListener) {
                    HttpSessionListener listener = (HttpSessionListener)listeners[j];
                    try {
                        context.fireContainerEvent("beforeSessionDestroyed", listener);
                        listener.sessionDestroyed(event);
                        context.fireContainerEvent("afterSessionDestroyed", listener);
                    }
                    catch (Throwable t) {
                        context.fireContainerEvent("afterSessionDestroyed", listener);
                        this.log(sm.getString("standardSession.sessionEvent"), t);
                    }
                }
                ++i2;
            }
        }
        this.expiring = false;
        if (this.manager != null && this.manager instanceof ManagerBase) {
            this.recycle();
        }
    }

    public void passivate() {
        HttpSessionEvent event = null;
        String[] keys = this.keys();
        int i = 0;
        while (i < keys.length) {
            Object attribute = this.getAttribute(keys[i]);
            if (attribute instanceof HttpSessionActivationListener) {
                if (event == null) {
                    event = new HttpSessionEvent((HttpSession)this);
                }
                ((HttpSessionActivationListener)attribute).sessionWillPassivate(event);
            }
            ++i;
        }
    }

    public void activate() {
        HttpSessionEvent event = null;
        String[] keys = this.keys();
        int i = 0;
        while (i < keys.length) {
            Object attribute = this.getAttribute(keys[i]);
            if (attribute instanceof HttpSessionActivationListener) {
                if (event == null) {
                    event = new HttpSessionEvent((HttpSession)this);
                }
                ((HttpSessionActivationListener)attribute).sessionDidActivate(event);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNote(String name) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            Object v = this.notes.get(name);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getNoteNames() {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            Iterator iterator = this.notes.keySet().iterator();
            return iterator;
        }
    }

    public void recycle() {
        this.attributes.clear();
        this.setAuthType(null);
        this.creationTime = 0L;
        this.expiring = false;
        this.id = null;
        this.lastAccessedTime = 0L;
        this.manager = null;
        this.maxInactiveInterval = -1;
        this.notes.clear();
        this.setPrincipal(null);
        this.isNew = false;
        this.isValid = false;
        if (this.manager != null && this.manager instanceof ManagerBase) {
            ((ManagerBase)this.manager).recycle(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNote(String name) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            this.notes.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(SessionListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNote(String name, Object value) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            this.notes.put(name, value);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StandardSession[");
        sb.append(this.id);
        sb.append("]");
        return sb.toString();
    }

    void readObjectData(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.readObject(stream);
    }

    void writeObjectData(ObjectOutputStream stream) throws IOException {
        this.writeObject(stream);
    }

    public long getCreationTime() {
        if (!this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.getCreationTime.ise"));
        }
        return this.creationTime;
    }

    public ServletContext getServletContext() {
        if (this.manager == null) {
            return null;
        }
        Context context = (Context)this.manager.getContainer();
        if (context == null) {
            return null;
        }
        return context.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        if (sessionContext == null) {
            sessionContext = new StandardSessionContext();
        }
        return sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        if (!this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.getAttribute.ise"));
        }
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            Object v = this.attributes.get(name);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        if (!this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.getAttributeNames.ise"));
        }
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            Enumerator enumerator = new Enumerator(this.attributes.keySet());
            return enumerator;
        }
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        if (!this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.getValueNames.ise"));
        }
        return this.keys();
    }

    public void invalidate() {
        if (!this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.invalidate.ise"));
        }
        this.expire();
    }

    public boolean isNew() {
        if (!this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.isNew.ise"));
        }
        return this.isNew;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        StandardContext context;
        Object[] listeners;
        if (!this.expiring && !this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.removeAttribute.ise"));
        }
        Object value = null;
        boolean found = false;
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            found = this.attributes.containsKey(name);
            if (!found) {
                return;
            }
            value = this.attributes.get(name);
            this.attributes.remove(name);
        }
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, value);
        if (value != null && value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueUnbound(event);
        }
        if ((listeners = (context = (StandardContext)this.manager.getContainer()).getApplicationListeners()) == null) {
            return;
        }
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof HttpSessionAttributeListener) {
                HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
                try {
                    context.fireContainerEvent("beforeSessionAttributeRemoved", listener);
                    listener.attributeRemoved(event);
                    context.fireContainerEvent("afterSessionAttributeRemoved", listener);
                }
                catch (Throwable t) {
                    context.fireContainerEvent("afterSessionAttributeRemoved", listener);
                    this.log(sm.getString("standardSession.attributeEvent"), t);
                }
            }
            ++i;
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        StandardContext context;
        Object[] listeners;
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (!this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.setAttribute.ise"));
        }
        if (this.manager != null && this.manager.getDistributable() && !(value instanceof Serializable)) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.iae"));
        }
        Object unbound = null;
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            unbound = this.attributes.get(name);
            this.attributes.put(name, value);
        }
        if (unbound != null && unbound instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)unbound).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
        }
        HttpSessionBindingEvent event = null;
        event = unbound != null ? new HttpSessionBindingEvent((HttpSession)this, name, unbound) : new HttpSessionBindingEvent((HttpSession)this, name, value);
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(event);
        }
        if ((listeners = (context = (StandardContext)this.manager.getContainer()).getApplicationListeners()) == null) {
            return;
        }
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof HttpSessionAttributeListener) {
                HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
                try {
                    if (unbound != null) {
                        context.fireContainerEvent("beforeSessionAttributeReplaced", listener);
                        listener.attributeReplaced(event);
                        context.fireContainerEvent("afterSessionAttributeReplaced", listener);
                    } else {
                        context.fireContainerEvent("beforeSessionAttributeAdded", listener);
                        listener.attributeAdded(event);
                        context.fireContainerEvent("afterSessionAttributeAdded", listener);
                    }
                }
                catch (Throwable t) {
                    if (unbound != null) {
                        context.fireContainerEvent("afterSessionAttributeReplaced", listener);
                    } else {
                        context.fireContainerEvent("afterSessionAttributeAdded", listener);
                    }
                    this.log(sm.getString("standardSession.attributeEvent"), t);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.authType = null;
        this.creationTime = (Long)stream.readObject();
        this.lastAccessedTime = (Long)stream.readObject();
        this.maxInactiveInterval = (Integer)stream.readObject();
        this.isNew = (Boolean)stream.readObject();
        this.isValid = (Boolean)stream.readObject();
        this.thisAccessedTime = (Long)stream.readObject();
        this.principal = null;
        this.setId((String)stream.readObject());
        if (this.debug >= 2) {
            this.log("readObject() loading session " + this.id);
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        int n = (Integer)stream.readObject();
        boolean isValidSave = this.isValid;
        this.isValid = true;
        int i = 0;
        while (i < n) {
            String name = (String)stream.readObject();
            Object value = stream.readObject();
            if (!(value instanceof String) || !value.equals(NOT_SERIALIZED)) {
                if (this.debug >= 2) {
                    this.log("  loading attribute '" + name + "' with value '" + value + "'");
                }
                HashMap hashMap = this.attributes;
                synchronized (hashMap) {
                    this.attributes.put(name, value);
                }
            }
            ++i;
        }
        this.isValid = isValidSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(new Long(this.creationTime));
        stream.writeObject(new Long(this.lastAccessedTime));
        stream.writeObject(new Integer(this.maxInactiveInterval));
        stream.writeObject(new Boolean(this.isNew));
        stream.writeObject(new Boolean(this.isValid));
        stream.writeObject(new Long(this.thisAccessedTime));
        stream.writeObject(this.id);
        if (this.debug >= 2) {
            this.log("writeObject() storing session " + this.id);
        }
        String[] keys = this.keys();
        ArrayList<String> saveNames = new ArrayList<String>();
        ArrayList saveValues = new ArrayList();
        int i = 0;
        while (i < keys.length) {
            Object value = null;
            HashMap hashMap = this.attributes;
            synchronized (hashMap) {
                value = this.attributes.get(keys[i]);
            }
            if (value != null && value instanceof Serializable) {
                saveNames.add(keys[i]);
                saveValues.add(value);
            }
            ++i;
        }
        int n = saveNames.size();
        stream.writeObject(new Integer(n));
        int i2 = 0;
        while (i2 < n) {
            block10: {
                stream.writeObject((String)saveNames.get(i2));
                try {
                    stream.writeObject(saveValues.get(i2));
                    if (this.debug >= 2) {
                        this.log("  storing attribute '" + saveNames.get(i2) + "' with value '" + saveValues.get(i2) + "'");
                    }
                }
                catch (NotSerializableException e) {
                    this.log(sm.getString("standardSession.notSerializable", saveNames.get(i2), this.id), e);
                    stream.writeObject(NOT_SERIALIZED);
                    if (this.debug < 2) break block10;
                    this.log("  storing attribute '" + saveNames.get(i2) + "' with value NOT_SERIALIZED");
                }
            }
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionEvent(String type, Object data) {
        if (this.listeners.size() < 1) {
            return;
        }
        SessionEvent event = new SessionEvent(this, type, data);
        SessionListener[] list = new SessionListener[]{};
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            list = this.listeners.toArray(list);
        }
        int i = 0;
        while (i < list.length) {
            list[i].sessionEvent(event);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] keys() {
        String[] results = new String[]{};
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            String[] stringArray = this.attributes.keySet().toArray(results);
            return stringArray;
        }
    }

    private void log(String message) {
        if (this.manager != null && this.manager instanceof ManagerBase) {
            ((ManagerBase)this.manager).log(message);
        } else {
            System.out.println("StandardSession: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        if (this.manager != null && this.manager instanceof ManagerBase) {
            ((ManagerBase)this.manager).log(message, throwable);
        } else {
            System.out.println("StandardSession: " + message);
            throwable.printStackTrace(System.out);
        }
    }

    static {
        NOT_SERIALIZED = NOT_SERIALIZED;
        info = info;
        sm = StringManager.getManager("org.apache.catalina.session");
        sessionContext = null;
    }
}

