/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.security.Security;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.util.xml.XmlMapper;

public class CatalinaService
extends Catalina {
    protected boolean arguments(String[] args) {
        boolean isConfig = false;
        if (args.length < 1) {
            this.usage();
            return false;
        }
        int i = 0;
        while (i < args.length) {
            if (isConfig) {
                this.configFile = args[i];
                isConfig = false;
            } else if (args[i].equals("-config")) {
                isConfig = true;
            } else if (args[i].equals("-debug")) {
                this.debug = true;
            } else if (args[i].equals("-nonaming")) {
                this.useNaming = false;
            } else {
                if (args[i].equals("-help")) {
                    this.usage();
                    return false;
                }
                if (args[i].equals("start")) {
                    this.starting = true;
                    this.stopping = false;
                } else if (args[i].equals("stop")) {
                    this.starting = false;
                    this.stopping = true;
                } else {
                    this.usage();
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected void execute() throws Exception {
        if (this.starting) {
            this.load();
            this.start();
        } else if (this.stopping) {
            this.stop();
        }
    }

    public void load() {
        block10: {
            XmlMapper mapper = this.createStartMapper();
            File file = this.configFile();
            try {
                mapper.readXml(file, (Object)this);
            }
            catch (InvocationTargetException e) {
                System.out.println("Catalina.start: InvocationTargetException");
                e.getTargetException().printStackTrace(System.out);
            }
            catch (Exception e) {
                System.out.println("Catalina.start: " + e);
                e.printStackTrace(System.out);
                System.exit(1);
            }
            if (!this.useNaming) {
                System.setProperty("catalina.useNaming", "false");
            } else {
                System.setProperty("catalina.useNaming", "true");
                String value = "org.apache.naming";
                String oldValue = System.getProperty("java.naming.factory.url.pkgs");
                if (oldValue != null) {
                    value = value + ":" + oldValue;
                }
                System.setProperty("java.naming.factory.url.pkgs", value);
                System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            }
            if (System.getSecurityManager() != null) {
                String access = Security.getProperty("package.access");
                access = access != null && access.length() > 0 ? access + "," : "sun.,";
                Security.setProperty("package.access", access + "org.apache.catalina.,org.apache.jasper.");
                String definition = Security.getProperty("package.definition");
                definition = definition != null && definition.length() > 0 ? definition + "," : "sun.,";
                Security.setProperty("package.definition", definition + "java.,org.apache.catalina.,org.apache.jasper.");
            }
            if (this.server instanceof Lifecycle) {
                try {
                    this.server.initialize();
                }
                catch (LifecycleException e) {
                    System.out.println("Catalina.start: " + e);
                    e.printStackTrace(System.out);
                    if (e.getThrowable() == null) break block10;
                    System.out.println("----- Root Cause -----");
                    e.getThrowable().printStackTrace(System.out);
                }
            }
        }
    }

    public void start() {
        block3: {
            if (this.server instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.server)).start();
                }
                catch (LifecycleException e) {
                    System.out.println("Catalina.start: " + e);
                    e.printStackTrace(System.out);
                    if (e.getThrowable() == null) break block3;
                    System.out.println("----- Root Cause -----");
                    e.getThrowable().printStackTrace(System.out);
                }
            }
        }
    }

    public void stop() {
        block3: {
            if (this.server instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.server)).stop();
                }
                catch (LifecycleException e) {
                    System.out.println("Catalina.stop: " + e);
                    e.printStackTrace(System.out);
                    if (e.getThrowable() == null) break block3;
                    System.out.println("----- Root Cause -----");
                    e.getThrowable().printStackTrace(System.out);
                }
            }
        }
        System.out.println("Stop server complete");
    }
}

