/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspEngineInfo;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import org.apache.jasper.logging.Logger;
import org.apache.jasper.runtime.PageContextImpl;
import org.apache.jasper.util.SimplePool;

public class JspFactoryImpl
extends JspFactory {
    private SimplePool pool = new SimplePool(100);
    private static final boolean usePool = true;
    Logger.Helper loghelper = new Logger.Helper("JASPER_LOG", "JspFactoryImpl");
    static JspEngineInfo info;

    public PageContext getPageContext(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoflush) {
        if (System.getSecurityManager() != null) {
            PrivilegedGetPageContext dp = new PrivilegedGetPageContext(this, servlet, request, response, errorPageURL, needsSession, bufferSize, autoflush);
            return (PageContext)AccessController.doPrivileged(dp);
        }
        return this.internalGetPageContext(servlet, request, response, errorPageURL, needsSession, bufferSize, autoflush);
    }

    protected PageContext internalGetPageContext(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoflush) {
        try {
            PageContextImpl pc = (PageContextImpl)((Object)this.pool.get());
            if (pc == null) {
                pc = new PageContextImpl(this);
            }
            pc.initialize(servlet, request, response, errorPageURL, needsSession, bufferSize, autoflush);
            return pc;
        }
        catch (Throwable ex) {
            this.loghelper.log("Exception initializing page context", ex);
            return null;
        }
    }

    public void releasePageContext(PageContext pc) {
        if (pc == null) {
            return;
        }
        if (System.getSecurityManager() != null) {
            PrivilegedReleasePageContext dp = new PrivilegedReleasePageContext(this, pc);
            AccessController.doPrivileged(dp);
        } else {
            this.internalReleasePageContext(pc);
        }
    }

    private void internalReleasePageContext(PageContext pc) {
        pc.release();
        this.pool.put(pc);
    }

    public JspEngineInfo getEngineInfo() {
        return info;
    }

    static {
        usePool = true;
        info = new SunJspEngineInfo();
    }

    static class SunJspEngineInfo
    extends JspEngineInfo {
        static final String SpecificationVersion = "1.2";

        SunJspEngineInfo() {
        }

        public String getSpecificationVersion() {
            return SpecificationVersion;
        }

        static {
            SpecificationVersion = SpecificationVersion;
        }
    }

    protected class PrivilegedReleasePageContext
    implements PrivilegedAction {
        private JspFactoryImpl factory;
        private PageContext pageContext;

        PrivilegedReleasePageContext(JspFactoryImpl factory, PageContext pageContext) {
            this.factory = factory;
            this.pageContext = pageContext;
        }

        public Object run() {
            this.factory.internalReleasePageContext(this.pageContext);
            return null;
        }
    }

    protected class PrivilegedGetPageContext
    implements PrivilegedAction {
        private JspFactoryImpl factory;
        private Servlet servlet;
        private ServletRequest request;
        private ServletResponse response;
        private String errorPageURL;
        private boolean needsSession;
        private int bufferSize;
        private boolean autoflush;

        PrivilegedGetPageContext(JspFactoryImpl factory, Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoflush) {
            this.factory = factory;
            this.servlet = servlet;
            this.request = request;
            this.response = response;
            this.errorPageURL = errorPageURL;
            this.needsSession = needsSession;
            this.bufferSize = bufferSize;
            this.autoflush = autoflush;
        }

        public Object run() {
            return this.factory.internalGetPageContext(this.servlet, this.request, this.response, this.errorPageURL, this.needsSession, this.bufferSize, this.autoflush);
        }
    }
}

