/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;

public class IdentityOutputFilter
implements OutputFilter {
    protected static final String ENCODING_NAME = "identity";
    protected static final ByteChunk ENCODING;
    protected long contentLength = -1L;
    protected long remaining = 0L;
    protected OutputBuffer buffer;

    public long getContentLength() {
        return this.contentLength;
    }

    public long getRemaining() {
        return this.remaining;
    }

    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        int result = -1;
        if (this.contentLength >= 0L) {
            if (this.remaining > 0L) {
                result = chunk.getLength();
                if ((long)result > this.remaining) {
                    chunk.setBytes(chunk.getBytes(), chunk.getStart(), (int)this.remaining);
                    result = (int)this.remaining;
                    this.remaining = 0L;
                } else {
                    this.remaining -= (long)result;
                }
                this.buffer.doWrite(chunk, res);
            } else {
                chunk.recycle();
                result = -1;
            }
        } else {
            this.buffer.doWrite(chunk, res);
            result = chunk.getLength();
        }
        return result;
    }

    public void setResponse(Response response) {
        this.remaining = this.contentLength = (long)response.getContentLength();
    }

    public void setBuffer(OutputBuffer buffer) {
        this.buffer = buffer;
    }

    public long end() throws IOException {
        if (this.remaining > 0L) {
            return this.remaining;
        }
        return 0L;
    }

    public void recycle() {
        this.contentLength = -1L;
        this.remaining = 0L;
    }

    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    static {
        ENCODING_NAME = ENCODING_NAME;
        ENCODING = new ByteChunk();
        ENCODING.setBytes(ENCODING_NAME.getBytes(), 0, ENCODING_NAME.length());
    }
}

