/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Deployer;
import org.apache.catalina.Host;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.warp.WarpConnection;
import org.apache.catalina.connector.warp.WarpConnector;
import org.apache.catalina.connector.warp.WarpHost;
import org.apache.catalina.connector.warp.WarpLogger;
import org.apache.catalina.connector.warp.WarpPacket;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;

public class WarpConfigurationHandler {
    private static final String DEFAULT_SERVLET = "org.apache.catalina.servlets.DefaultServlet";

    public boolean handle(WarpConnection connection, WarpPacket packet) throws IOException {
        WarpLogger logger = new WarpLogger(this);
        logger.setContainer(connection.getConnector().getContainer());
        packet.setType(1);
        packet.writeUnsignedShort(0);
        packet.writeUnsignedShort(10);
        packet.writeInteger(connection.getConnector().uniqueId);
        connection.send(packet);
        block8: while (true) {
            connection.recv(packet);
            switch (packet.getType()) {
                case 5: {
                    String appl = packet.readString();
                    String host = packet.readString();
                    int port = packet.readUnsignedShort();
                    String path = packet.readString();
                    Context context = null;
                    packet.reset();
                    try {
                        context = this.deploy(connection, logger, appl, host, path);
                    }
                    catch (Exception e) {
                        logger.log(e);
                    }
                    if (context == null) {
                        String msg = "Error deploying web application \"" + appl + "\" under <http://" + host + ":" + port + path + ">";
                        logger.log(msg);
                        packet.setType(0);
                        packet.writeString(msg);
                        connection.send(packet);
                        continue block8;
                    }
                    int k = connection.getConnector().applicationId(context);
                    packet.setType(6);
                    packet.writeInteger(k);
                    packet.writeString(context.getDocBase());
                    connection.send(packet);
                    continue block8;
                }
                case 7: {
                    SecurityConstraint[] scon;
                    FilterMap[] fmap;
                    int id = packet.readInteger();
                    Context context = connection.getConnector().applicationContext(id);
                    if (context == null) {
                        String msg = "Invalid application ID for mappings " + id;
                        logger.log(msg);
                        packet.reset();
                        packet.setType(0);
                        packet.writeString(msg);
                        connection.send(packet);
                        continue block8;
                    }
                    String[] smap = context.findServletMappings();
                    if (smap != null) {
                        int x = 0;
                        while (x < smap.length) {
                            String servlet;
                            Container c = context.findChild(context.findServletMapping(smap[x]));
                            packet.reset();
                            packet.setType(9);
                            packet.writeString(smap[x]);
                            if (c instanceof Wrapper && DEFAULT_SERVLET.equals(servlet = ((Wrapper)c).getServletClass())) {
                                packet.setType(8);
                            }
                            connection.send(packet);
                            ++x;
                        }
                    }
                    if ((fmap = context.findFilterMaps()) != null) {
                        logger.log("Filter mappings (" + fmap.length + ")");
                        int x = 0;
                        while (x < fmap.length) {
                            String map = fmap[x].getURLPattern();
                            if (map != null) {
                                packet.reset();
                                packet.setType(9);
                                packet.writeString(map);
                                connection.send(packet);
                            }
                            ++x;
                        }
                    }
                    if ((scon = context.findConstraints()) != null) {
                        int x = 0;
                        while (x < scon.length) {
                            SecurityCollection[] col = scon[x].findCollections();
                            if (col != null) {
                                int y = 0;
                                while (y < col.length) {
                                    String[] patt = col[y].findPatterns();
                                    if (patt != null) {
                                        int q = 0;
                                        while (q < patt.length) {
                                            packet.reset();
                                            packet.setType(9);
                                            packet.writeString(patt[q]);
                                            connection.send(packet);
                                            ++q;
                                        }
                                    }
                                    ++y;
                                }
                            }
                            ++x;
                        }
                    }
                    packet.reset();
                    packet.setType(10);
                    connection.send(packet);
                    continue block8;
                }
                case 14: {
                    return true;
                }
                case 254: {
                    return false;
                }
            }
            break;
        }
        String msg = "Invalid packet with type " + packet.getType();
        logger.log(msg);
        packet.reset();
        packet.setType(255);
        packet.writeString(msg);
        connection.send(packet);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context deploy(WarpConnection connection, WarpLogger logger, String applName, String hostName, String applPath) throws IOException {
        WarpConnector warpConnector = connection.getConnector();
        synchronized (warpConnector) {
            Context appl;
            block9: {
                File file;
                Deployer deployer;
                block10: {
                    Container container = connection.getConnector().getContainer();
                    Object host = (Host)container.findChild(hostName.toLowerCase());
                    if (host == null) {
                        WarpHost whost = new WarpHost();
                        whost.setName(hostName);
                        whost.setParent(container);
                        whost.setAppBase(connection.getConnector().getAppBase());
                        whost.setDebug(connection.getConnector().getDebug());
                        container.addChild((Container)whost);
                        host = whost;
                    }
                    if (applPath.endsWith("/")) {
                        applPath = applPath.substring(0, applPath.length() - 1);
                    }
                    if ((appl = (Context)host.findChild(applPath)) != null) break block9;
                    deployer = (Deployer)host;
                    file = new File(applName);
                    if (!file.isAbsolute() && !(file = new File(host.getAppBase() + File.separator + applName)).isAbsolute()) {
                        file = new File(System.getProperty("catalina.base"), host.getAppBase() + File.separator + applName);
                    }
                    if (file.exists()) break block10;
                    logger.log("Cannot find \"" + file.getPath() + "\" for appl. \"" + applName + "\" host \"" + host.getName() + "\"");
                    Context context = null;
                    return context;
                }
                String path = file.getCanonicalPath();
                URL url = new URL("file", null, path);
                if (path.toLowerCase().endsWith(".war")) {
                    url = new URL("jar:" + url.toString() + "!/");
                }
                deployer.install(applPath, url);
                StandardContext context = null;
                context = (StandardContext)deployer.findDeployedApp(applPath);
                context.setDebug(connection.getConnector().getDebug());
                StandardContext standardContext = context;
                return standardContext;
            }
            Context context = appl;
            return context;
        }
    }

    static {
        DEFAULT_SERVLET = DEFAULT_SERVLET;
    }
}

