/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http10;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Stack;
import java.util.Vector;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Service;
import org.apache.catalina.connector.http10.HttpProcessor;
import org.apache.catalina.connector.http10.HttpRequestImpl;
import org.apache.catalina.connector.http10.HttpResponseImpl;
import org.apache.catalina.net.DefaultServerSocketFactory;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class HttpConnector
implements Connector,
Lifecycle,
Runnable {
    private int acceptCount = 10;
    private String address = null;
    private int bufferSize = 2048;
    protected Container container = null;
    private Vector created = new Vector();
    private int curProcessors = 0;
    private int debug = 0;
    private boolean enableLookups = false;
    private ServerSocketFactory factory = null;
    private static final String info = "org.apache.catalina.connector.http10.HttpConnector/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private int connectionTimeout = 30000;
    protected int minProcessors = 5;
    private int maxProcessors = 20;
    private int port = 8080;
    private Stack processors = new Stack();
    private String proxyName = null;
    private int proxyPort = 0;
    private int redirectPort = 443;
    private String scheme = "http";
    private boolean secure = false;
    private ServerSocket serverSocket = null;
    private Service service = null;
    private StringManager sm = StringManager.getManager("org.apache.catalina.connector.http10");
    private boolean initialized = false;
    private boolean started = false;
    private boolean stopped = false;
    private Thread thread = null;
    private String threadName = null;
    private Object threadSync = new Object();

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public void setAcceptCount(int count) {
        this.acceptCount = count;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isAvailable() {
        return this.started;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public int getCurProcessors() {
        return this.curProcessors;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSocketFactory getFactory() {
        if (this.factory == null) {
            HttpConnector httpConnector = this;
            synchronized (httpConnector) {
                this.factory = new DefaultServerSocketFactory();
            }
        }
        return this.factory;
    }

    public void setFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    public String getInfo() {
        return info;
    }

    public int getMinProcessors() {
        return this.minProcessors;
    }

    public void setMinProcessors(int minProcessors) {
        this.minProcessors = minProcessors;
    }

    public int getMaxProcessors() {
        return this.maxProcessors;
    }

    public void setMaxProcessors(int maxProcessors) {
        this.maxProcessors = maxProcessors;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String proxyName) {
        this.proxyName = proxyName;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Request createRequest() {
        HttpRequestImpl request = new HttpRequestImpl();
        request.setConnector(this);
        return request;
    }

    public Response createResponse() {
        HttpResponseImpl response = new HttpResponseImpl();
        response.setConnector(this);
        return response;
    }

    void recycle(HttpProcessor processor) {
        this.processors.push(processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpProcessor createProcessor() {
        Stack stack = this.processors;
        synchronized (stack) {
            block8: {
                block7: {
                    block6: {
                        if (this.processors.size() <= 0) break block6;
                        HttpProcessor httpProcessor = (HttpProcessor)this.processors.pop();
                        return httpProcessor;
                    }
                    if (this.maxProcessors <= 0 || this.curProcessors >= this.maxProcessors) break block7;
                    HttpProcessor httpProcessor = this.newProcessor();
                    return httpProcessor;
                }
                if (this.maxProcessors >= 0) break block8;
                HttpProcessor httpProcessor = this.newProcessor();
                return httpProcessor;
            }
            HttpProcessor httpProcessor = null;
            return httpProcessor;
        }
    }

    private void log(String message) {
        Logger logger = this.container.getLogger();
        String localName = this.threadName;
        if (localName == null) {
            localName = "HttpConnector";
        }
        if (logger != null) {
            logger.log(localName + " " + message);
        } else {
            System.out.println(localName + " " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        String localName = this.threadName;
        if (localName == null) {
            localName = "HttpConnector";
        }
        if (logger != null) {
            logger.log(localName + " " + message, throwable);
        } else {
            System.out.println(localName + " " + message);
            throwable.printStackTrace(System.out);
        }
    }

    private HttpProcessor newProcessor() {
        HttpProcessor processor;
        if ((processor = new HttpProcessor(this, this.curProcessors++)) instanceof Lifecycle) {
            try {
                processor.start();
            }
            catch (LifecycleException e) {
                this.log("newProcessor", e);
                return null;
            }
        }
        this.created.addElement(processor);
        return processor;
    }

    private ServerSocket open() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        ServerSocketFactory factory = this.getFactory();
        if (this.address == null) {
            this.log(this.sm.getString("httpConnector.allAddresses"));
            return factory.createSocket(this.port, this.acceptCount);
        }
        InetAddress[] addresses = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
        int i = 0;
        while (i < addresses.length) {
            if (addresses[i].getHostAddress().equals(this.address)) break;
            ++i;
        }
        if (i < addresses.length) {
            this.log(this.sm.getString("httpConnector.anAddress", this.address));
            return factory.createSocket(this.port, this.acceptCount, addresses[i]);
        }
        this.log(this.sm.getString("httpConnector.noAddress", this.address));
        return factory.createSocket(this.port, this.acceptCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stopped) {
            Socket socket;
            block10: {
                socket = null;
                try {
                    socket = this.serverSocket.accept();
                    if (this.connectionTimeout <= 0) break block10;
                    socket.setSoTimeout(this.connectionTimeout);
                }
                catch (AccessControlException ace) {
                    this.log("socket accept security exception: " + ace.getMessage());
                    continue;
                }
                catch (IOException e) {
                    if (!this.started || this.stopped) break;
                    this.log("accept: ", e);
                    break;
                }
            }
            HttpProcessor processor = this.createProcessor();
            if (processor == null) {
                try {
                    this.log(this.sm.getString("httpConnector.noProcessor"));
                    socket.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            processor.assign(socket);
        }
        Object object = this.threadSync;
        synchronized (object) {
            this.threadSync.notifyAll();
        }
    }

    private void threadStart() {
        this.log(this.sm.getString("httpConnector.starting"));
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadStop() {
        this.log(this.sm.getString("httpConnector.stopping"));
        this.stopped = true;
        Object object = this.threadSync;
        synchronized (object) {
            try {
                this.threadSync.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.thread = null;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void initialize() throws LifecycleException {
        if (this.initialized) {
            throw new LifecycleException(this.sm.getString("httpConnector.alreadyInitialized"));
        }
        this.initialized = true;
        Exception eRethrow = null;
        try {
            this.serverSocket = this.open();
        }
        catch (IOException ioe) {
            this.log("httpConnector, io problem: ", ioe);
            eRethrow = ioe;
        }
        catch (KeyStoreException kse) {
            this.log("httpConnector, keystore problem: ", kse);
            eRethrow = kse;
        }
        catch (NoSuchAlgorithmException nsae) {
            this.log("httpConnector, keystore algorithm problem: ", nsae);
            eRethrow = nsae;
        }
        catch (CertificateException ce) {
            this.log("httpConnector, certificate problem: ", ce);
            eRethrow = ce;
        }
        catch (UnrecoverableKeyException uke) {
            this.log("httpConnector, unrecoverable key: ", uke);
            eRethrow = uke;
        }
        catch (KeyManagementException kme) {
            this.log("httpConnector, key management problem: ", kme);
            eRethrow = kme;
        }
        if (eRethrow != null) {
            throw new LifecycleException(this.threadName + ".open", eRethrow);
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("httpConnector.alreadyStarted"));
        }
        this.threadName = "HttpConnector[" + this.port + "]";
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
        while (this.curProcessors < this.minProcessors) {
            if (this.maxProcessors > 0 && this.curProcessors >= this.maxProcessors) break;
            HttpProcessor processor = this.newProcessor();
            this.recycle(processor);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("httpConnector.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        int i = this.created.size() - 1;
        while (i >= 0) {
            HttpProcessor processor = (HttpProcessor)this.created.elementAt(i);
            if (processor instanceof Lifecycle) {
                try {
                    processor.stop();
                }
                catch (LifecycleException e) {
                    this.log("HttpConnector.stop", e);
                }
            }
            --i;
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
        }
        this.threadStop();
    }

    static {
        info = info;
    }
}

