/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.directory.DirContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.ResourceParams;
import org.apache.catalina.util.StringManager;
import org.apache.naming.ContextAccessController;

public class StandardDefaultContext
implements DefaultContext,
LifecycleListener {
    private Hashtable contexts = new Hashtable();
    private String[] applicationListeners = new String[0];
    private ApplicationParameter[] applicationParameters = new ApplicationParameter[0];
    private boolean cookies = true;
    private boolean crossContext = true;
    private static final String info = "org.apache.catalina.core.DefaultContext/1.0";
    private String[] instanceListeners = new String[0];
    private String mapperClass = "org.apache.catalina.core.StandardContextMapper";
    private NamingResources namingResources = new NamingResources();
    private HashMap parameters = new HashMap();
    private boolean reloadable = false;
    private boolean swallowOutput = false;
    private String[] wrapperLifecycles = new String[0];
    private String[] wrapperListeners = new String[0];
    private String wrapperClass = "org.apache.catalina.core.StandardWrapper";
    private boolean useNaming = true;
    DirContext dirContext = null;
    protected String name = "defaultContext";
    protected Container parent = null;
    protected Loader loader = null;
    protected Manager manager = null;
    protected static StringManager sm;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public StandardDefaultContext() {
        this.namingResources.setContainer(this);
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean useNaming) {
        this.useNaming = useNaming;
    }

    public boolean getCookies() {
        return this.cookies;
    }

    public void setCookies(boolean cookies) {
        boolean oldCookies = this.cookies;
        this.cookies = cookies;
    }

    public boolean getCrossContext() {
        return this.crossContext;
    }

    public void setCrossContext(boolean crossContext) {
        boolean oldCrossContext = this.crossContext;
        this.crossContext = crossContext;
    }

    public String getInfo() {
        return info;
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
    }

    public boolean getSwallowOutput() {
        return this.swallowOutput;
    }

    public void setSwallowOutput(boolean swallowOutput) {
        boolean oldSwallowOutput = this.swallowOutput;
        this.swallowOutput = swallowOutput;
    }

    public String getWrapperClass() {
        return this.wrapperClass;
    }

    public void setWrapperClass(String wrapperClass) {
        this.wrapperClass = wrapperClass;
    }

    public void setResources(DirContext resources) {
        this.dirContext = resources;
    }

    public DirContext getResources() {
        return this.dirContext;
    }

    public Loader getLoader() {
        return this.loader;
    }

    public void setLoader(Loader loader) {
        Loader oldLoader = this.loader;
        this.loader = loader;
        this.support.firePropertyChange("loader", oldLoader, this.loader);
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        Manager oldManager = this.manager;
        this.manager = manager;
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container container) {
        Container oldParent = this.parent;
        this.parent = container;
        this.support.firePropertyChange("parent", oldParent, this.parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationListener(String listener) {
        String[] stringArray = this.applicationListeners;
        synchronized (stringArray) {
            String[] results = new String[this.applicationListeners.length + 1];
            int i = 0;
            while (i < this.applicationListeners.length) {
                results[i] = this.applicationListeners[i];
                ++i;
            }
            results[this.applicationListeners.length] = listener;
            this.applicationListeners = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationParameter(ApplicationParameter parameter) {
        ApplicationParameter[] applicationParameterArray = this.applicationParameters;
        synchronized (applicationParameterArray) {
            ApplicationParameter[] results = new ApplicationParameter[this.applicationParameters.length + 1];
            System.arraycopy(this.applicationParameters, 0, results, 0, this.applicationParameters.length);
            results[this.applicationParameters.length] = parameter;
            this.applicationParameters = results;
        }
    }

    public void addEjb(ContextEjb ejb) {
        this.namingResources.addEjb(ejb);
    }

    public void addEnvironment(ContextEnvironment environment) {
        this.namingResources.addEnvironment(environment);
    }

    public void addResourceParams(ResourceParams resourceParameters) {
        this.namingResources.addResourceParams(resourceParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceListener(String listener) {
        String[] stringArray = this.instanceListeners;
        synchronized (stringArray) {
            String[] results = new String[this.instanceListeners.length + 1];
            int i = 0;
            while (i < this.instanceListeners.length) {
                results[i] = this.instanceListeners[i];
                ++i;
            }
            results[this.instanceListeners.length] = listener;
            this.instanceListeners = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.required"));
        }
        if (this.parameters.get(name) != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.duplicate", name));
        }
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.put(name, value);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void addResource(ContextResource resource) {
        this.namingResources.addResource(resource);
    }

    public void addResourceEnvRef(String name, String type) {
        this.namingResources.addResourceEnvRef(name, type);
    }

    public void addResourceLink(ContextResourceLink resourceLink) {
        this.namingResources.addResourceLink(resourceLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWrapperLifecycle(String listener) {
        String[] stringArray = this.wrapperLifecycles;
        synchronized (stringArray) {
            String[] results = new String[this.wrapperLifecycles.length + 1];
            int i = 0;
            while (i < this.wrapperLifecycles.length) {
                results[i] = this.wrapperLifecycles[i];
                ++i;
            }
            results[this.wrapperLifecycles.length] = listener;
            this.wrapperLifecycles = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWrapperListener(String listener) {
        String[] stringArray = this.wrapperListeners;
        synchronized (stringArray) {
            String[] results = new String[this.wrapperListeners.length + 1];
            int i = 0;
            while (i < this.wrapperListeners.length) {
                results[i] = this.wrapperListeners[i];
                ++i;
            }
            results[this.wrapperListeners.length] = listener;
            this.wrapperListeners = results;
        }
    }

    public String[] findApplicationListeners() {
        return this.applicationListeners;
    }

    public ApplicationParameter[] findApplicationParameters() {
        return this.applicationParameters;
    }

    public ContextEjb findEjb(String name) {
        return this.namingResources.findEjb(name);
    }

    public ContextEjb[] findEjbs() {
        return this.namingResources.findEjbs();
    }

    public ContextEnvironment findEnvironment(String name) {
        return this.namingResources.findEnvironment(name);
    }

    public ContextEnvironment[] findEnvironments() {
        return this.namingResources.findEnvironments();
    }

    public ResourceParams[] findResourceParams() {
        return this.namingResources.findResourceParams();
    }

    public String[] findInstanceListeners() {
        return this.instanceListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            String string = (String)this.parameters.get(name);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findParameters() {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            String[] results = new String[this.parameters.size()];
            String[] stringArray = this.parameters.keySet().toArray(results);
            return stringArray;
        }
    }

    public ContextResource findResource(String name) {
        return this.namingResources.findResource(name);
    }

    public String findResourceEnvRef(String name) {
        return this.namingResources.findResourceEnvRef(name);
    }

    public String[] findResourceEnvRefs() {
        return this.namingResources.findResourceEnvRefs();
    }

    public ContextResourceLink findResourceLink(String name) {
        return this.namingResources.findResourceLink(name);
    }

    public ContextResourceLink[] findResourceLinks() {
        return this.namingResources.findResourceLinks();
    }

    public ContextResource[] findResources() {
        return this.namingResources.findResources();
    }

    public String[] findWrapperLifecycles() {
        return this.wrapperLifecycles;
    }

    public String[] findWrapperListeners() {
        return this.wrapperListeners;
    }

    public NamingResources getNamingResources() {
        return this.namingResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationListener(String listener) {
        String[] stringArray = this.applicationListeners;
        synchronized (stringArray) {
            int n = -1;
            int i = 0;
            while (i < this.applicationListeners.length) {
                if (this.applicationListeners[i].equals(listener)) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.applicationListeners.length - 1];
            int i2 = 0;
            while (i2 < this.applicationListeners.length) {
                if (i2 != n) {
                    results[j++] = this.applicationListeners[i2];
                }
                ++i2;
            }
            this.applicationListeners = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationParameter(String name) {
        ApplicationParameter[] applicationParameterArray = this.applicationParameters;
        synchronized (applicationParameterArray) {
            int n = -1;
            int i = 0;
            while (i < this.applicationParameters.length) {
                if (name.equals(this.applicationParameters[i].getName())) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            ApplicationParameter[] results = new ApplicationParameter[this.applicationParameters.length - 1];
            int i2 = 0;
            while (i2 < this.applicationParameters.length) {
                if (i2 != n) {
                    results[j++] = this.applicationParameters[i2];
                }
                ++i2;
            }
            this.applicationParameters = results;
        }
    }

    public void removeEjb(String name) {
        this.namingResources.removeEjb(name);
    }

    public void removeEnvironment(String name) {
        this.namingResources.removeEnvironment(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(String listener) {
        String[] stringArray = this.instanceListeners;
        synchronized (stringArray) {
            int n = -1;
            int i = 0;
            while (i < this.instanceListeners.length) {
                if (this.instanceListeners[i].equals(listener)) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.instanceListeners.length - 1];
            int i2 = 0;
            while (i2 < this.instanceListeners.length) {
                if (i2 != n) {
                    results[j++] = this.instanceListeners[i2];
                }
                ++i2;
            }
            this.instanceListeners = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.remove(name);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void removeResource(String name) {
        this.namingResources.removeResource(name);
    }

    public void removeResourceEnvRef(String name) {
        this.namingResources.removeResourceEnvRef(name);
    }

    public void removeResourceLink(String name) {
        this.namingResources.removeResourceLink(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWrapperLifecycle(String listener) {
        String[] stringArray = this.wrapperLifecycles;
        synchronized (stringArray) {
            int n = -1;
            int i = 0;
            while (i < this.wrapperLifecycles.length) {
                if (this.wrapperLifecycles[i].equals(listener)) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.wrapperLifecycles.length - 1];
            int i2 = 0;
            while (i2 < this.wrapperLifecycles.length) {
                if (i2 != n) {
                    results[j++] = this.wrapperLifecycles[i2];
                }
                ++i2;
            }
            this.wrapperLifecycles = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWrapperListener(String listener) {
        String[] stringArray = this.wrapperListeners;
        synchronized (stringArray) {
            int n = -1;
            int i = 0;
            while (i < this.wrapperListeners.length) {
                if (this.wrapperListeners[i].equals(listener)) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.wrapperListeners.length - 1];
            int i2 = 0;
            while (i2 < this.wrapperListeners.length) {
                if (i2 != n) {
                    results[j++] = this.wrapperListeners[i2];
                }
                ++i2;
            }
            this.wrapperListeners = results;
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        StandardContext context = null;
        NamingContextListener listener = null;
        if (event.getLifecycle() instanceof StandardContext) {
            context = (StandardContext)event.getLifecycle();
            LifecycleListener[] listeners = context.findLifecycleListeners();
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] instanceof NamingContextListener) {
                    listener = (NamingContextListener)listeners[i];
                    break;
                }
                ++i;
            }
        }
        if (listener == null) {
            return;
        }
        if (event.getType().equals("after_start")) {
            this.contexts.put(context, context);
            NamingResources contextResources = context.getNamingResources();
            ContextAccessController.setWritable((Object)listener.getName(), (Object)context);
            ContextEjb[] contextEjb = this.findEjbs();
            int i = 0;
            while (i < contextEjb.length) {
                ContextEjb contextEntry = contextEjb[i];
                if (contextResources.exists(contextEntry.getName())) {
                    listener.removeEjb(contextEntry.getName());
                }
                listener.addEjb(contextEntry);
                ++i;
            }
            ContextEnvironment[] contextEnv = this.findEnvironments();
            int i2 = 0;
            while (i2 < contextEnv.length) {
                ContextEnvironment contextEntry = contextEnv[i2];
                if (contextResources.exists(contextEntry.getName())) {
                    listener.removeEnvironment(contextEntry.getName());
                }
                listener.addEnvironment(contextEntry);
                ++i2;
            }
            ContextResource[] resources = this.findResources();
            int i3 = 0;
            while (i3 < resources.length) {
                ContextResource contextEntry = resources[i3];
                if (contextResources.exists(contextEntry.getName())) {
                    listener.removeResource(contextEntry.getName());
                }
                listener.addResource(contextEntry);
                ++i3;
            }
            String[] envRefs = this.findResourceEnvRefs();
            int i4 = 0;
            while (i4 < envRefs.length) {
                if (contextResources.exists(envRefs[i4])) {
                    listener.removeResourceEnvRef(envRefs[i4]);
                }
                listener.addResourceEnvRef(envRefs[i4], this.findResourceEnvRef(envRefs[i4]));
                ++i4;
            }
            ContextAccessController.setReadOnly((Object)listener.getName());
            this.namingResources.addPropertyChangeListener(listener);
        } else if (event.getType().equals("before_stop")) {
            this.contexts.remove(context);
            this.namingResources.removePropertyChangeListener(listener);
            context.removeLifecycleListener(this);
        }
    }

    public void importDefaultContext(Context context) {
        if (context instanceof StandardContext) {
            ((StandardContext)context).setUseNaming(this.isUseNaming());
            ((StandardContext)context).setSwallowOutput(this.getSwallowOutput());
            if (!this.contexts.containsKey(context)) {
                ((StandardContext)context).addLifecycleListener(this);
            }
        }
        context.setCookies(this.getCookies());
        context.setCrossContext(this.getCrossContext());
        context.setReloadable(this.getReloadable());
        String[] listeners = this.findApplicationListeners();
        int i = 0;
        while (i < listeners.length) {
            context.addApplicationListener(listeners[i]);
            ++i;
        }
        listeners = this.findInstanceListeners();
        int i2 = 0;
        while (i2 < listeners.length) {
            context.addInstanceListener(listeners[i2]);
            ++i2;
        }
        String[] wrapper = this.findWrapperListeners();
        int i3 = 0;
        while (i3 < wrapper.length) {
            context.addWrapperListener(wrapper[i3]);
            ++i3;
        }
        wrapper = this.findWrapperLifecycles();
        int i4 = 0;
        while (i4 < wrapper.length) {
            context.addWrapperLifecycle(wrapper[i4]);
            ++i4;
        }
        String[] parameters = this.findParameters();
        int i5 = 0;
        while (i5 < parameters.length) {
            context.addParameter(parameters[i5], this.findParameter(parameters[i5]));
            ++i5;
        }
        ApplicationParameter[] appParam = this.findApplicationParameters();
        int i6 = 0;
        while (i6 < appParam.length) {
            context.addApplicationParameter(appParam[i6]);
            ++i6;
        }
        if (!(context instanceof StandardContext)) {
            ContextEjb[] contextEjb = this.findEjbs();
            int i7 = 0;
            while (i7 < contextEjb.length) {
                context.addEjb(contextEjb[i7]);
                ++i7;
            }
            ContextEnvironment[] contextEnv = this.findEnvironments();
            int i8 = 0;
            while (i8 < contextEnv.length) {
                context.addEnvironment(contextEnv[i8]);
                ++i8;
            }
            ContextResource[] resources = this.findResources();
            int i9 = 0;
            while (i9 < resources.length) {
                context.addResource(resources[i9]);
                ++i9;
            }
            String[] envRefs = this.findResourceEnvRefs();
            int i10 = 0;
            while (i10 < envRefs.length) {
                context.addResourceEnvRef(envRefs[i10], this.findResourceEnvRef(envRefs[i10]));
                ++i10;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("DefaultContext[");
        sb.append("]");
        return sb.toString();
    }

    static {
        info = info;
        sm = StringManager.getManager("org.apache.catalina.core");
    }
}

